/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.font.GlyphJustificationInfo;

class TextJustifier {
    private GlyphJustificationInfo[] info;
    private int start;
    private int limit;
    static boolean DEBUG = false;
    public static final int MAX_PRIORITY = 3;

    TextJustifier(GlyphJustificationInfo[] info, int start, int limit) {
        this.info = info;
        this.start = start;
        this.limit = limit;
        if (DEBUG) {
            System.out.println("start: " + start + ", limit: " + limit);
            for (int i = start; i < limit; ++i) {
                GlyphJustificationInfo gji = info[i];
                System.out.println("w: " + gji.weight + ", gp: " + gji.growPriority + ", gll: " + gji.growLeftLimit + ", grl: " + gji.growRightLimit);
            }
        }
    }

    public float[] justify(float delta) {
        boolean grow;
        float[] deltas = new float[this.info.length * 2];
        boolean bl = grow = delta > 0.0f;
        if (DEBUG) {
            System.out.println("delta: " + delta);
        }
        int fallbackPriority = -1;
        int p = 0;
        while (delta != 0.0f) {
            boolean lastPass;
            boolean bl2 = lastPass = p > 3;
            if (lastPass) {
                p = fallbackPriority;
            }
            float weight = 0.0f;
            float gslimit = 0.0f;
            float absorbweight = 0.0f;
            for (int i = this.start; i < this.limit; ++i) {
                GlyphJustificationInfo gi = this.info[i];
                if ((grow ? gi.growPriority : gi.shrinkPriority) != p) continue;
                if (fallbackPriority == -1) {
                    fallbackPriority = p;
                }
                if (i != this.start) {
                    weight += gi.weight;
                    if (grow) {
                        gslimit += gi.growLeftLimit;
                        if (gi.growAbsorb) {
                            absorbweight += gi.weight;
                        }
                    } else {
                        gslimit += gi.shrinkLeftLimit;
                        if (gi.shrinkAbsorb) {
                            absorbweight += gi.weight;
                        }
                    }
                }
                if (i + 1 == this.limit) continue;
                weight += gi.weight;
                if (grow) {
                    gslimit += gi.growRightLimit;
                    if (!gi.growAbsorb) continue;
                    absorbweight += gi.weight;
                    continue;
                }
                gslimit += gi.shrinkRightLimit;
                if (!gi.shrinkAbsorb) continue;
                absorbweight += gi.weight;
            }
            if (!grow) {
                gslimit = -gslimit;
            }
            boolean hitLimit = weight == 0.0f || !lastPass && delta < 0.0f == delta < gslimit;
            boolean absorbing = hitLimit && absorbweight > 0.0f;
            float weightedDelta = delta / weight;
            float weightedAbsorb = 0.0f;
            if (hitLimit && absorbweight > 0.0f) {
                weightedAbsorb = (delta - gslimit) / absorbweight;
            }
            if (DEBUG) {
                System.out.println("pass: " + p + ", d: " + delta + ", l: " + gslimit + ", w: " + weight + ", aw: " + absorbweight + ", wd: " + weightedDelta + ", wa: " + weightedAbsorb + ", hit: " + (hitLimit ? "y" : "n"));
            }
            int n = this.start * 2;
            for (int i = this.start; i < this.limit; ++i) {
                GlyphJustificationInfo gi = this.info[i];
                if ((grow ? gi.growPriority : gi.shrinkPriority) == p) {
                    float d;
                    if (i != this.start) {
                        if (hitLimit) {
                            float f = d = grow ? gi.growLeftLimit : -gi.shrinkLeftLimit;
                            if (absorbing) {
                                d += gi.weight * weightedAbsorb;
                            }
                        } else {
                            d = gi.weight * weightedDelta;
                        }
                        int n2 = n;
                        deltas[n2] = deltas[n2] + d;
                    }
                    ++n;
                    if (i + 1 != this.limit) {
                        if (hitLimit) {
                            float f = d = grow ? gi.growRightLimit : -gi.shrinkRightLimit;
                            if (absorbing) {
                                d += gi.weight * weightedAbsorb;
                            }
                        } else {
                            d = gi.weight * weightedDelta;
                        }
                        int n3 = n;
                        deltas[n3] = deltas[n3] + d;
                    }
                    ++n;
                    continue;
                }
                n += 2;
            }
            delta = !lastPass && hitLimit && !absorbing ? (delta -= gslimit) : 0.0f;
            ++p;
        }
        if (DEBUG) {
            float total = 0.0f;
            for (int i = 0; i < deltas.length; ++i) {
                total += deltas[i];
                System.out.print(deltas[i] + ", ");
                if (i % 20 != 9) continue;
                System.out.println();
            }
            System.out.println("\ntotal: " + total);
            System.out.println();
        }
        return deltas;
    }
}

