/*
 * Copyright (c) 2011, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package javafx.scene.control;

/**
Builder class for javafx.scene.control.Tab
@see javafx.scene.control.Tab
@deprecated This class is deprecated and will be removed in the next version
* @since JavaFX 2.0
*/
@javax.annotation.Generated("Generated by javafx.builder.processor.BuilderProcessor")
@Deprecated
public class TabBuilder<B extends javafx.scene.control.TabBuilder<B>> implements javafx.util.Builder<javafx.scene.control.Tab> {
    protected TabBuilder() {
    }

    /** Creates a new instance of TabBuilder. */
    @SuppressWarnings({"deprecation", "rawtypes", "unchecked"})
    public static javafx.scene.control.TabBuilder<?> create() {
        return new javafx.scene.control.TabBuilder();
    }

    private int __set;
    private void __set(int i) {
        __set |= 1 << i;
    }
    public void applyTo(javafx.scene.control.Tab x) {
        int set = __set;
        while (set != 0) {
            int i = Integer.numberOfTrailingZeros(set);
            set &= ~(1 << i);
            switch (i) {
                case 0: x.setClosable(this.closable); break;
                case 1: x.setContent(this.content); break;
                case 2: x.setContextMenu(this.contextMenu); break;
                case 3: x.setDisable(this.disable); break;
                case 4: x.setGraphic(this.graphic); break;
                case 5: x.setId(this.id); break;
                case 6: x.setOnClosed(this.onClosed); break;
                case 7: x.setOnSelectionChanged(this.onSelectionChanged); break;
                case 8: x.setStyle(this.style); break;
                case 9: x.getStyleClass().addAll(this.styleClass); break;
                case 10: x.setText(this.text); break;
                case 11: x.setTooltip(this.tooltip); break;
                case 12: x.setUserData(this.userData); break;
            }
        }
    }

    private boolean closable;
    /**
    Set the value of the {@link javafx.scene.control.Tab#isClosable() closable} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B closable(boolean x) {
        this.closable = x;
        __set(0);
        return (B) this;
    }

    private javafx.scene.Node content;
    /**
    Set the value of the {@link javafx.scene.control.Tab#getContent() content} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B content(javafx.scene.Node x) {
        this.content = x;
        __set(1);
        return (B) this;
    }

    private javafx.scene.control.ContextMenu contextMenu;
    /**
    Set the value of the {@link javafx.scene.control.Tab#getContextMenu() contextMenu} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B contextMenu(javafx.scene.control.ContextMenu x) {
        this.contextMenu = x;
        __set(2);
        return (B) this;
    }

    private boolean disable;
    /**
    Set the value of the {@link javafx.scene.control.Tab#isDisable() disable} property for the instance constructed by this builder.
    * @since JavaFX 2.2
    */
    @SuppressWarnings("unchecked")
    public B disable(boolean x) {
        this.disable = x;
        __set(3);
        return (B) this;
    }

    private javafx.scene.Node graphic;
    /**
    Set the value of the {@link javafx.scene.control.Tab#getGraphic() graphic} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B graphic(javafx.scene.Node x) {
        this.graphic = x;
        __set(4);
        return (B) this;
    }

    private java.lang.String id;
    /**
    Set the value of the {@link javafx.scene.control.Tab#getId() id} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B id(java.lang.String x) {
        this.id = x;
        __set(5);
        return (B) this;
    }

    private javafx.event.EventHandler<javafx.event.Event> onClosed;
    /**
    Set the value of the {@link javafx.scene.control.Tab#getOnClosed() onClosed} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B onClosed(javafx.event.EventHandler<javafx.event.Event> x) {
        this.onClosed = x;
        __set(6);
        return (B) this;
    }

    private javafx.event.EventHandler<javafx.event.Event> onSelectionChanged;
    /**
    Set the value of the {@link javafx.scene.control.Tab#getOnSelectionChanged() onSelectionChanged} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B onSelectionChanged(javafx.event.EventHandler<javafx.event.Event> x) {
        this.onSelectionChanged = x;
        __set(7);
        return (B) this;
    }

    private java.lang.String style;
    /**
    Set the value of the {@link javafx.scene.control.Tab#getStyle() style} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B style(java.lang.String x) {
        this.style = x;
        __set(8);
        return (B) this;
    }

    private java.util.Collection<? extends java.lang.String> styleClass;
    /**
    Add the given items to the List of items in the {@link javafx.scene.control.Tab#getStyleClass() styleClass} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B styleClass(java.util.Collection<? extends java.lang.String> x) {
        this.styleClass = x;
        __set(9);
        return (B) this;
    }

    /**
    Add the given items to the List of items in the {@link javafx.scene.control.Tab#getStyleClass() styleClass} property for the instance constructed by this builder.
    */
    public B styleClass(java.lang.String... x) {
        return styleClass(java.util.Arrays.asList(x));
    }

    private java.lang.String text;
    /**
    Set the value of the {@link javafx.scene.control.Tab#getText() text} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B text(java.lang.String x) {
        this.text = x;
        __set(10);
        return (B) this;
    }

    private javafx.scene.control.Tooltip tooltip;
    /**
    Set the value of the {@link javafx.scene.control.Tab#getTooltip() tooltip} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B tooltip(javafx.scene.control.Tooltip x) {
        this.tooltip = x;
        __set(11);
        return (B) this;
    }

    private java.lang.Object userData;
    /**
    Set the value of the {@link javafx.scene.control.Tab#getUserData() userData} property for the instance constructed by this builder.
    * @since JavaFX 2.2
    */
    @SuppressWarnings("unchecked")
    public B userData(java.lang.Object x) {
        this.userData = x;
        __set(12);
        return (B) this;
    }

    /**
    Make an instance of {@link javafx.scene.control.Tab} based on the properties set on this builder.
    */
    public javafx.scene.control.Tab build() {
        javafx.scene.control.Tab x = new javafx.scene.control.Tab();
        applyTo(x);
        return x;
    }
}
