/*
 * Copyright (c) 2002-2019 Balabit
 * Copyright (c) 1998-2019 Balázs Scheidler
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 */
#ifndef TIMEUTILS_FORMAT_H_INCLUDED
#define TIMEUTILS_FORMAT_H_INCLUDED

#include "unixtime.h"
#include "wallclocktime.h"

/* timestamp formats */
#define TS_FMT_BSD   0
#define TS_FMT_ISO   1
#define TS_FMT_FULL  2
#define TS_FMT_UNIX  3

void format_unix_time(const UnixTime *stamp, GString *target,
                      gint ts_format, glong zone_offset, gint frac_digits);
void append_format_unix_time(const UnixTime *stamp, GString *target,
                             gint ts_format, glong zone_offset, gint frac_digits);
void format_wall_clock_time(const WallClockTime *stamp, GString *target,
                            gint ts_format, glong zone_offset, gint frac_digits);
void append_format_wall_clock_time(const WallClockTime *stamp, GString *target,
                                   gint ts_format, gint frac_digits);
gint format_zone_info(gchar *buf, size_t buflen, glong gmtoff);

#endif
