#ifndef _EFL_BOOLEAN_MODEL_EO_H_
#define _EFL_BOOLEAN_MODEL_EO_H_

#ifndef _EFL_BOOLEAN_MODEL_EO_CLASS_TYPE
#define _EFL_BOOLEAN_MODEL_EO_CLASS_TYPE

typedef Eo Efl_Boolean_Model;

#endif

#ifndef _EFL_BOOLEAN_MODEL_EO_TYPES
#define _EFL_BOOLEAN_MODEL_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Efl boolean model class
 *
 * @ingroup Efl_Boolean_Model
 */
#define EFL_BOOLEAN_MODEL_CLASS efl_boolean_model_class_get()

EWAPI const Efl_Class *efl_boolean_model_class_get(void);

/**
 * @brief Add a new named boolean property with a defined default value.
 *
 * @param[in] obj The object.
 * @param[in] name
 * @param[in] default_value
 *
 * @ingroup Efl_Boolean_Model
 */
EOAPI void efl_boolean_model_boolean_add(Eo *obj, const char *name, Eina_Bool default_value);

/**
 * @brief Delete an existing named boolean property
 *
 * @param[in] obj The object.
 * @param[in] name
 *
 * @ingroup Efl_Boolean_Model
 */
EOAPI void efl_boolean_model_boolean_del(Eo *obj, const char *name);
#endif /* EFL_BETA_API_SUPPORT */

#endif
