/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.awt.Component;
import java.io.File;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.history.PopupMenuExportURLs;
import org.zaproxy.zap.model.Context;

public class PopupMenuExportContextURLs
extends PopupMenuExportURLs {
    private static final long serialVersionUID = -4426560452505908380L;
    private static Logger LOG = Logger.getLogger(PopupMenuExportURLs.class);

    public PopupMenuExportContextURLs(String menuItem, Extension extension) {
        super(menuItem, extension);
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        Context ctx;
        return "ContextTree".equals(invoker.getName()) && (ctx = View.getSingleton().getSiteTreePanel().getSelectedContext()) != null;
    }

    @Override
    protected void performAction() {
        Context ctx = this.extension.getView().getSiteTreePanel().getSelectedContext();
        if (ctx == null) {
            View.getSingleton().showWarningDialog(Constant.messages.getString("exportUrls.popup.context.error"));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No context selected, when trying to export URLs for a context.");
            }
            return;
        }
        File file = super.getOutputFile();
        if (file == null) {
            return;
        }
        super.writeURLs(file, this.getOutputSet(ctx));
    }

    private SortedSet<String> getOutputSet(Context ctx) {
        TreeSet<String> outputSet = new TreeSet<String>();
        for (SiteNode node : ctx.getNodesInContextFromSiteTree()) {
            outputSet.add(node.getHistoryReference().getURI().toString());
        }
        return outputSet;
    }
}

