"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var Menu = electron_1.remote.Menu;
var eventType_1 = require("../../lib/eventType");
var locale = require("../../locale/locale");
var config_1 = require("../../settings/config");
var textMenu;
var copyContext = '';
var defaultMenu = Menu.buildFromTemplate([
    {
        click: function () { return electron_1.clipboard.writeText(copyContext); },
        label: locale.getText('menuCopy'),
    },
]);
var textMenuTemplate = [
    {
        label: locale.getText('menuCut'),
        role: 'cut',
    },
    {
        label: locale.getText('menuCopy'),
        role: 'copy',
    },
    {
        label: locale.getText('menuPaste'),
        role: 'paste',
    },
    {
        type: 'separator',
    },
    {
        label: locale.getText('menuSelectAll'),
        role: 'selectall',
    },
];
var createTextMenu = function () {
    var template = textMenuTemplate.slice();
    textMenu = Menu.buildFromTemplate(template);
};
var imageMenu = Menu.buildFromTemplate([
    {
        click: function () { return savePicture(imageMenu.image || '', imageMenu.timestamp); },
        label: locale.getText('menuSavePictureAs'),
    },
]);
window.addEventListener('contextmenu', function (event) {
    var element = event.target;
    copyContext = '';
    if (element.nodeName === 'TEXTAREA' || element.nodeName === 'INPUT') {
        event.preventDefault();
        createTextMenu();
        textMenu.popup({ window: electron_1.remote.getCurrentWindow() });
    }
    else if (element.classList.contains('image-element') || element.classList.contains('detail-view-image')) {
        event.preventDefault();
        var elementSource = element.src;
        var parentElement = element.closest('.message-body');
        var timeElement = parentElement.getElementsByTagName('time')[0];
        if (timeElement) {
            var imageTimestamp = timeElement.dataset['timestamp'];
            imageMenu.timestamp = imageTimestamp;
        }
        imageMenu.image = elementSource;
        imageMenu.popup({ window: electron_1.remote.getCurrentWindow() });
    }
    else if (element.nodeName === 'A') {
        event.preventDefault();
        var elementHref = element.href;
        copyContext = elementHref.replace(/^mailto:/, '');
        defaultMenu.popup({ window: electron_1.remote.getCurrentWindow() });
    }
    else if (element.classList.contains('text')) {
        event.preventDefault();
        copyContext = (window.getSelection() || '').toString() || element.innerText.trim();
        defaultMenu.popup({ window: electron_1.remote.getCurrentWindow() });
    }
    else {
        var parentNode = element.parentNode;
        while (parentNode && parentNode !== document && !parentNode.classList.contains('text')) {
            parentNode = parentNode.parentNode;
        }
        if (parentNode !== document) {
            event.preventDefault();
            copyContext = (window.getSelection() || '').toString() || parentNode.innerText.trim();
            defaultMenu.popup({ window: electron_1.remote.getCurrentWindow() });
        }
    }
}, false);
var savePicture = function (url, timestamp) { return __awaiter(_this, void 0, void 0, function () {
    var response, arrayBuffer;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4, fetch(url, {
                    headers: {
                        'User-Agent': config_1.config.userAgent,
                    },
                })];
            case 1:
                response = _a.sent();
                return [4, response.arrayBuffer()];
            case 2:
                arrayBuffer = _a.sent();
                return [2, electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.ACTION.SAVE_PICTURE, new Uint8Array(arrayBuffer), timestamp)];
        }
    });
}); };
//# sourceMappingURL=context.js.map