
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * FileStatus.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_0;

import org.virtualbox_6_0.jaxws.*;
import javax.xml.ws.*;

/**
File statuses.
Interface ID: <tt>{8C86468B-B97B-4080-8914-E29F5B0ABD2C}</tt>
*/
public enum FileStatus
{

/**
File is in an undefined state.
*/
    Undefined(0),

/**
Guest file is opening.
*/
    Opening(10),

/**
Guest file has been successfully opened.
*/
    Open(100),

/**
Guest file closing.
*/
    Closing(150),

/**
Guest file has been closed.
*/
    Closed(200),

/**
Service/OS is stopping, guest file was closed.
*/
    Down(600),

/**
Something went wrong.
*/
    Error(800);

    private final int value;

    FileStatus(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static FileStatus fromValue(long v)
    {
        for (FileStatus c: FileStatus.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static FileStatus fromValue(String v)
    {
        return valueOf(FileStatus.class, v);
    }
}

