/*
 * Decompiled with CFR 0.152.
 */
package sbt.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sbt.internal.io.ErrorHandling$;
import sbt.io.IO$;
import sbt.io.OpenFile;
import sbt.io.Using;
import sbt.io.WrapUsing;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;

public final class Using$ {
    public static Using$ MODULE$;
    private final Using<OutputStream, BufferedOutputStream> bufferedOutputStream;
    private final Using<InputStream, BufferedInputStream> bufferedInputStream;
    private final OpenFile<BufferedInputStream> fileInputStream;
    private final Using<URL, BufferedInputStream> urlInputStream;
    private final OpenFile<FileChannel> fileOutputChannel;
    private final OpenFile<FileChannel> fileInputChannel;
    private final OpenFile<ZipFile> zipFile;
    private final Using<Tuple2<InputStream, Charset>, InputStreamReader> streamReader;
    private final Using<InputStream, GZIPInputStream> gzipInputStream;
    private final Using<InputStream, ZipInputStream> zipInputStream;
    private final Using<OutputStream, ZipOutputStream> zipOutputStream;
    private final Using<OutputStream, GZIPOutputStream> gzipOutputStream;
    private final Using<OutputStream, JarOutputStream> jarOutputStream;
    private final Using<InputStream, JarInputStream> jarInputStream;

    static {
        new Using$();
    }

    public <Source, T extends AutoCloseable> Using<Source, T> wrap(Function1<Source, T> openF, Manifest<Source> srcMf, Manifest<T> targetMf) {
        return this.wrap(openF, this.closeCloseable(), srcMf, targetMf);
    }

    public <Source, T> Using<Source, T> wrap(Function1<Source, T> openF, Function1<T, BoxedUnit> closeF, Manifest<Source> srcMf, Manifest<T> targetMf) {
        return new WrapUsing<Source, T>(openF, closeF, srcMf, targetMf){
            private final Function1 openF$3;
            private final Function1 closeF$3;

            public T openImpl(Source source) {
                return (T)this.openF$3.apply(source);
            }

            public void close(T t) {
                this.closeF$3.apply(t);
            }
            {
                this.openF$3 = openF$3;
                this.closeF$3 = closeF$3;
                super(srcMf$1, targetMf$1);
            }
        };
    }

    public <Source, T extends AutoCloseable> Using<Source, T> resource(Function1<Source, T> openF) {
        return this.resource(openF, this.closeCloseable());
    }

    public <Source, T> Using<Source, T> resource(Function1<Source, T> openF, Function1<T, BoxedUnit> closeF) {
        return new Using<Source, T>(openF, closeF){
            private final Function1 openF$2;
            private final Function1 closeF$2;

            public T open(Source s) {
                return (T)this.openF$2.apply(s);
            }

            public void close(T s) {
                this.closeF$2.apply(s);
            }
            {
                this.openF$2 = openF$2;
                this.closeF$2 = closeF$2;
            }
        };
    }

    public <T extends AutoCloseable> OpenFile<T> file(Function1<File, T> openF) {
        return this.file(openF, this.closeCloseable());
    }

    public <T> OpenFile<T> file(Function1<File, T> openF, Function1<T, BoxedUnit> closeF) {
        return new OpenFile<T>(openF, closeF){
            private final Function1 openF$1;
            private final Function1 closeF$1;

            public final T open(File file) {
                return (T)OpenFile.open$(this, file);
            }

            public T openImpl(File file) {
                return (T)this.openF$1.apply((Object)file);
            }

            public void close(T t) {
                this.closeF$1.apply(t);
            }
            {
                this.openF$1 = openF$1;
                this.closeF$1 = closeF$1;
                OpenFile.$init$(this);
            }
        };
    }

    private <T extends AutoCloseable> Function1<T, BoxedUnit> closeCloseable() {
        return (Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        };
    }

    public Using<OutputStream, BufferedOutputStream> bufferedOutputStream() {
        return this.bufferedOutputStream;
    }

    public Using<InputStream, BufferedInputStream> bufferedInputStream() {
        return this.bufferedInputStream;
    }

    public OpenFile<BufferedOutputStream> fileOutputStream(boolean append) {
        return this.file((Function1 & Serializable & scala.Serializable)f -> new BufferedOutputStream(new FileOutputStream((File)f, append)));
    }

    public boolean fileOutputStream$default$1() {
        return false;
    }

    public OpenFile<BufferedInputStream> fileInputStream() {
        return this.fileInputStream;
    }

    public Using<URL, BufferedInputStream> urlInputStream() {
        return this.urlInputStream;
    }

    public OpenFile<FileChannel> fileOutputChannel() {
        return this.fileOutputChannel;
    }

    public OpenFile<FileChannel> fileInputChannel() {
        return this.fileInputChannel;
    }

    public OpenFile<BufferedWriter> fileWriter(Charset charset, boolean append) {
        return this.file((Function1 & Serializable & scala.Serializable)f -> new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)f, append), charset)));
    }

    public Charset fileWriter$default$1() {
        return IO$.MODULE$.utf8();
    }

    public boolean fileWriter$default$2() {
        return false;
    }

    public OpenFile<BufferedReader> fileReader(Charset charset) {
        return this.file((Function1 & Serializable & scala.Serializable)f -> new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)f), charset)));
    }

    public Using<URL, BufferedReader> urlReader(Charset charset) {
        return this.resource((Function1 & Serializable & scala.Serializable)u -> new BufferedReader(new InputStreamReader(u.openStream(), charset)));
    }

    public OpenFile<JarFile> jarFile(boolean verify) {
        return this.file((Function1 & Serializable & scala.Serializable)f -> new JarFile((File)f, verify), (Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
    }

    public OpenFile<ZipFile> zipFile() {
        return this.zipFile;
    }

    public Using<Tuple2<InputStream, Charset>, InputStreamReader> streamReader() {
        return this.streamReader;
    }

    public Using<InputStream, GZIPInputStream> gzipInputStream() {
        return this.gzipInputStream;
    }

    public Using<InputStream, ZipInputStream> zipInputStream() {
        return this.zipInputStream;
    }

    public Using<OutputStream, ZipOutputStream> zipOutputStream() {
        return this.zipOutputStream;
    }

    public Using<OutputStream, GZIPOutputStream> gzipOutputStream() {
        return this.gzipOutputStream;
    }

    public Using<OutputStream, JarOutputStream> jarOutputStream() {
        return this.jarOutputStream;
    }

    public Using<InputStream, JarInputStream> jarInputStream() {
        return this.jarInputStream;
    }

    public Using<ZipEntry, InputStream> zipEntry(ZipFile zip) {
        return this.resource((Function1 & Serializable & scala.Serializable)entry -> (InputStream)ErrorHandling$.MODULE$.translate((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Error opening ").append(entry.getName()).append(" in ").append(zip).append(": ").toString(), (Function0 & Serializable & scala.Serializable)() -> zip.getInputStream((ZipEntry)entry)));
    }

    private Using$() {
        MODULE$ = this;
        this.bufferedOutputStream = this.wrap((Function1 & Serializable & scala.Serializable)out -> new BufferedOutputStream((OutputStream)out), ManifestFactory$.MODULE$.classType(OutputStream.class), ManifestFactory$.MODULE$.classType(BufferedOutputStream.class));
        this.bufferedInputStream = this.wrap((Function1 & Serializable & scala.Serializable)in -> new BufferedInputStream((InputStream)in), ManifestFactory$.MODULE$.classType(InputStream.class), ManifestFactory$.MODULE$.classType(BufferedInputStream.class));
        this.fileInputStream = this.file((Function1 & Serializable & scala.Serializable)f -> new BufferedInputStream(new FileInputStream((File)f)));
        this.urlInputStream = this.resource((Function1 & Serializable & scala.Serializable)u -> (BufferedInputStream)ErrorHandling$.MODULE$.translate((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Error opening ").append(u).append(": ").toString(), (Function0 & Serializable & scala.Serializable)() -> new BufferedInputStream(u.openStream())));
        this.fileOutputChannel = this.file((Function1 & Serializable & scala.Serializable)f -> new FileOutputStream((File)f).getChannel());
        this.fileInputChannel = this.file((Function1 & Serializable & scala.Serializable)f -> new FileInputStream((File)f).getChannel());
        this.zipFile = this.file((Function1 & Serializable & scala.Serializable)f -> new ZipFile((File)f), (Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        this.streamReader = this.wrap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputStream in = (InputStream)tuple2._1();
            Charset charset = (Charset)tuple2._2();
            InputStreamReader inputStreamReader = new InputStreamReader(in, charset);
            return inputStreamReader;
        }, ManifestFactory$.MODULE$.classType(Tuple2.class, ManifestFactory$.MODULE$.classType(InputStream.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(Charset.class)})), ManifestFactory$.MODULE$.classType(InputStreamReader.class));
        this.gzipInputStream = this.wrap((Function1 & Serializable & scala.Serializable)in -> new GZIPInputStream((InputStream)in, 8192), ManifestFactory$.MODULE$.classType(InputStream.class), ManifestFactory$.MODULE$.classType(GZIPInputStream.class));
        this.zipInputStream = this.wrap((Function1 & Serializable & scala.Serializable)in -> new ZipInputStream((InputStream)in), ManifestFactory$.MODULE$.classType(InputStream.class), ManifestFactory$.MODULE$.classType(ZipInputStream.class));
        this.zipOutputStream = this.wrap((Function1 & Serializable & scala.Serializable)out -> new ZipOutputStream((OutputStream)out), ManifestFactory$.MODULE$.classType(OutputStream.class), ManifestFactory$.MODULE$.classType(ZipOutputStream.class));
        this.gzipOutputStream = this.wrap((Function1 & Serializable & scala.Serializable)out -> new GZIPOutputStream((OutputStream)out, 8192), (Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.finish();
            return BoxedUnit.UNIT;
        }, ManifestFactory$.MODULE$.classType(OutputStream.class), ManifestFactory$.MODULE$.classType(GZIPOutputStream.class));
        this.jarOutputStream = this.wrap((Function1 & Serializable & scala.Serializable)out -> new JarOutputStream((OutputStream)out), ManifestFactory$.MODULE$.classType(OutputStream.class), ManifestFactory$.MODULE$.classType(JarOutputStream.class));
        this.jarInputStream = this.wrap((Function1 & Serializable & scala.Serializable)in -> new JarInputStream((InputStream)in), ManifestFactory$.MODULE$.classType(InputStream.class), ManifestFactory$.MODULE$.classType(JarInputStream.class));
    }
}

