/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels.code;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.ByteArrayInputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodeOutputPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodePanel;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbImageOutputCell;

public class IpnbImagePanel
extends IpnbCodeOutputPanel<IpnbImageOutputCell> {
    private static final Logger LOG = Logger.getInstance(IpnbImagePanel.class);

    public IpnbImagePanel(@NotNull IpnbImageOutputCell cell, @Nullable IpnbCodePanel ipnbCodePanel) {
        if (cell == null) {
            IpnbImagePanel.$$$reportNull$$$0(0);
        }
        super(cell, null, ipnbCodePanel);
    }

    @Override
    protected JComponent createViewPanel() {
        String png = ((IpnbImageOutputCell)this.myCell).getBase64String();
        ResizableIconLabel label = new ResizableIconLabel();
        if (!StringUtil.isEmptyOrSpaces((String)png)) {
            try {
                byte[] btDataFile = Base64.getMimeDecoder().decode(png);
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(btDataFile));
                label.setIcon(new ImageIcon(image));
            }
            catch (Exception e) {
                LOG.error("Couldn't parse image. " + e.getMessage());
            }
        }
        label.setBackground(IpnbEditorUtil.getBackground());
        label.setOpaque(true);
        return label;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbImagePanel", "<init>"));
    }

    static class ResizableIconLabel
    extends JBLabel {
        ResizableIconLabel() {
        }

        public void paintComponent(Graphics g) {
            Icon icon = this.getIcon();
            if (icon instanceof ImageIcon) {
                Image image = ((ImageIcon)icon).getImage();
                if (this.getWidth() < image.getWidth(null)) {
                    g.drawImage(image, 0, 0, this.getWidth(), this.getHeight(), (ImageObserver)((Object)this));
                    image.flush();
                } else {
                    super.paintComponent(g);
                }
            }
        }
    }
}

