/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionResult {
    private final LookupElement myLookupElement;
    private final PrefixMatcher myMatcher;
    private final CompletionSorter mySorter;

    protected CompletionResult(LookupElement lookupElement, PrefixMatcher matcher, CompletionSorter sorter) {
        this.myLookupElement = lookupElement;
        this.myMatcher = matcher;
        this.mySorter = sorter;
    }

    @Nullable
    public static CompletionResult wrap(LookupElement lookupElement, PrefixMatcher matcher, CompletionSorter sorter) {
        if (matcher.prefixMatches(lookupElement)) {
            return new CompletionResult(lookupElement, matcher, sorter);
        }
        return null;
    }

    public PrefixMatcher getPrefixMatcher() {
        return this.myMatcher;
    }

    public CompletionSorter getSorter() {
        return this.mySorter;
    }

    public LookupElement getLookupElement() {
        return this.myLookupElement;
    }

    @NotNull
    public CompletionResult withLookupElement(@NotNull LookupElement element) {
        if (element == null) {
            CompletionResult.$$$reportNull$$$0(0);
        }
        if (!this.myMatcher.prefixMatches(element)) {
            throw new AssertionError((Object)"The new element doesn't match the prefix");
        }
        CompletionResult completionResult = new CompletionResult(element, this.myMatcher, this.mySorter);
        if (completionResult == null) {
            CompletionResult.$$$reportNull$$$0(1);
        }
        return completionResult;
    }

    public boolean isStartMatch() {
        return this.myMatcher.isStartMatch(this.myLookupElement);
    }

    public String toString() {
        return this.myLookupElement.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withLookupElement";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

