/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.cvsclient.command.CvsFile;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.ICvsFilesVisitor;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.util.BugLog;

final class CvsFiles
implements ICvsFiles {
    private final List<CvsFile> cvsFiles = new ArrayList<CvsFile>();
    private CvsFile currentCvsDirectory;

    CvsFiles() {
    }

    @Override
    public void visit(ICvsFilesVisitor visitor) {
        BugLog.getInstance().assertNotNull(visitor);
        for (CvsFile cvsFile : this.cvsFiles) {
            if (cvsFile.isDirectory()) {
                visitor.handleDirectory((DirectoryObject)cvsFile.getFileObject());
                continue;
            }
            visitor.handleFile((FileObject)cvsFile.getFileObject(), cvsFile.getEntry(), cvsFile.exists());
        }
    }

    public void clear() {
        this.cvsFiles.clear();
        this.currentCvsDirectory = null;
    }

    public void add(CvsFile cvsFile) {
        if (this.currentCvsDirectory == null) {
            BugLog.getInstance().assertTrue(cvsFile.isDirectory(), "The first cvsFile must be a directory.");
            this.currentCvsDirectory = cvsFile;
        } else if (cvsFile.isDirectory()) {
            if (this.currentCvsDirectory.getFileObject().getPath().equals(cvsFile.getFileObject().getPath())) {
                return;
            }
            this.currentCvsDirectory = cvsFile;
        }
        this.cvsFiles.add(cvsFile);
    }
}

