/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl.livePreview;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.find.impl.livePreview.SelectionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchResults
implements DocumentListener {
    private final List<SearchResultsListener> myListeners;
    @Nullable
    private FindResult myCursor;
    @NotNull
    private List<FindResult> myOccurrences;
    private final Set<RangeMarker> myExcluded;
    @NotNull
    private final Editor myEditor;
    private final Project myProject;
    private FindModel myFindModel;
    private int myMatchesLimit;
    private boolean myNotFoundState;
    private boolean myDisposed;
    private int myStamp;
    private int myLastUpdatedStamp;
    private long myDocumentTimestamp;
    private final Stack<Pair<FindModel, FindResult>> myCursorPositions;
    private final SelectionManager mySelectionManager;

    public int getStamp() {
        return ++this.myStamp;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            SearchResults.$$$reportNull$$$0(0);
        }
        this.myCursorPositions.clear();
    }

    public SearchResults(@NotNull Editor editor, Project project) {
        if (editor == null) {
            SearchResults.$$$reportNull$$$0(1);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myOccurrences = new ArrayList<FindResult>();
        this.myExcluded = new HashSet<RangeMarker>();
        this.myMatchesLimit = 100;
        this.myLastUpdatedStamp = -1;
        this.myCursorPositions = new Stack();
        this.myEditor = editor;
        this.myProject = project;
        this.myEditor.getDocument().addDocumentListener((DocumentListener)this);
        this.mySelectionManager = new SelectionManager(this);
    }

    public void setNotFoundState(boolean isForward) {
        this.myNotFoundState = true;
        FindModel findModel = new FindModel();
        findModel.copyFrom(this.myFindModel);
        findModel.setForward(isForward);
        FindUtil.processNotFound(this.myEditor, findModel.getStringToFind(), findModel, this.getProject());
    }

    public int getMatchesCount() {
        return this.myOccurrences.size();
    }

    public boolean hasMatches() {
        return !this.getOccurrences().isEmpty();
    }

    public FindModel getFindModel() {
        return this.myFindModel;
    }

    public boolean isExcluded(FindResult occurrence) {
        for (RangeMarker rangeMarker : this.myExcluded) {
            if (!TextRange.areSegmentsEqual((Segment)rangeMarker, (Segment)occurrence)) continue;
            return true;
        }
        return false;
    }

    public void exclude(FindResult occurrence) {
        boolean include = false;
        for (RangeMarker rangeMarker : this.myExcluded) {
            if (!TextRange.areSegmentsEqual((Segment)rangeMarker, (Segment)occurrence)) continue;
            this.myExcluded.remove(rangeMarker);
            rangeMarker.dispose();
            include = true;
            break;
        }
        if (!include) {
            this.myExcluded.add(this.myEditor.getDocument().createRangeMarker(occurrence.getStartOffset(), occurrence.getEndOffset(), true));
        }
        this.notifyChanged();
    }

    public Set<RangeMarker> getExcluded() {
        return this.myExcluded;
    }

    public void addListener(SearchResultsListener srl) {
        this.myListeners.add(srl);
    }

    public void removeListener(SearchResultsListener srl) {
        this.myListeners.remove(srl);
    }

    public int getMatchesLimit() {
        return this.myMatchesLimit;
    }

    public void setMatchesLimit(int matchesLimit) {
        this.myMatchesLimit = matchesLimit;
    }

    @Nullable
    public FindResult getCursor() {
        return this.myCursor;
    }

    @NotNull
    public List<FindResult> getOccurrences() {
        List<FindResult> list2 = this.myOccurrences;
        if (list2 == null) {
            SearchResults.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            SearchResults.$$$reportNull$$$0(3);
        }
        return editor;
    }

    public void clear() {
        this.searchCompleted(new ArrayList<FindResult>(), this.getEditor(), null, false, null, this.getStamp());
    }

    ActionCallback updateThreadSafe(@NotNull FindModel findModel, boolean toChangeSelection, @Nullable TextRange next, int stamp) {
        if (findModel == null) {
            SearchResults.$$$reportNull$$$0(4);
        }
        if (this.myDisposed) {
            return ActionCallback.DONE;
        }
        ActionCallback result2 = new ActionCallback();
        Editor editor = this.getEditor();
        this.updatePreviousFindModel(findModel);
        FutureResult startsRef = new FutureResult();
        FutureResult endsRef = new FutureResult();
        SearchResults.getSelection(editor, (FutureResult<int[]>)startsRef, (FutureResult<int[]>)endsRef);
        ArrayList results = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            Project project = this.getProject();
            if (this.myDisposed || project != null && project.isDisposed()) {
                return;
            }
            int[] starts = new int[]{};
            int[] ends = new int[]{};
            try {
                starts = (int[])startsRef.get();
                ends = (int[])endsRef.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
            if (starts.length == 0 || findModel.isGlobal()) {
                this.findInRange(new TextRange(0, Integer.MAX_VALUE), editor, findModel, results);
            } else {
                for (int i = 0; i < starts.length; ++i) {
                    this.findInRange(new TextRange(starts[i], ends[i]), editor, findModel, results);
                }
            }
            long documentTimeStamp = editor.getDocument().getModificationStamp();
            Runnable searchCompletedRunnable = () -> {
                if (editor.getDocument().getModificationStamp() == documentTimeStamp) {
                    this.searchCompleted(results, editor, findModel, toChangeSelection, next, stamp);
                    result2.setDone();
                } else {
                    result2.setRejected();
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                searchCompletedRunnable.run();
            } else {
                UIUtil.invokeLaterIfNeeded((Runnable)searchCompletedRunnable);
            }
        });
        return result2;
    }

    private void updatePreviousFindModel(@NotNull FindModel model) {
        FindModel prev2;
        if (model == null) {
            SearchResults.$$$reportNull$$$0(5);
        }
        if ((prev2 = FindManager.getInstance((Project)this.getProject()).getPreviousFindModel()) == null) {
            prev2 = new FindModel();
        }
        if (!model.getStringToFind().isEmpty()) {
            prev2.copyFrom(model);
            FindManager.getInstance((Project)this.getProject()).setPreviousFindModel(prev2);
        }
    }

    private static void getSelection(Editor editor, FutureResult<int[]> starts, FutureResult<int[]> ends) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            SelectionModel selection = editor.getSelectionModel();
            starts.set((Object)selection.getBlockSelectionStarts());
            ends.set((Object)selection.getBlockSelectionEnds());
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    SelectionModel selection = editor.getSelectionModel();
                    starts.set((Object)selection.getBlockSelectionStarts());
                    ends.set((Object)selection.getBlockSelectionEnds());
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void findInRange(@NotNull TextRange range2, @NotNull Editor editor, @NotNull FindModel findModel, @NotNull List<? super FindResult> results) {
        if (range2 == null) {
            SearchResults.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            SearchResults.$$$reportNull$$$0(7);
        }
        if (findModel == null) {
            SearchResults.$$$reportNull$$$0(8);
        }
        if (results == null) {
            SearchResults.$$$reportNull$$$0(9);
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        CharSequence charSequence = editor.getDocument().getImmutableCharSequence();
        int offset = range2.getStartOffset();
        int maxOffset = Math.min(range2.getEndOffset(), charSequence.length());
        FindManager findManager = FindManager.getInstance((Project)this.getProject());
        while (true) {
            FindResult result2;
            try {
                CharSequence bombedCharSequence = StringUtil.newBombedCharSequence((CharSequence)charSequence, (long)3000L);
                result2 = findManager.findString(bombedCharSequence, offset, findModel, virtualFile);
                ((StringUtil.BombedCharSequence)bombedCharSequence).defuse();
            }
            catch (ProcessCanceledException | PatternSyntaxException e) {
                result2 = null;
            }
            if (result2 == null) return;
            if (!result2.isStringFound()) {
                return;
            }
            int newOffset = result2.getEndOffset();
            if (result2.getEndOffset() > maxOffset) {
                return;
            }
            if (offset == newOffset) {
                if (offset >= maxOffset - 1) {
                    results.add((FindResult)result2);
                    return;
                }
                ++offset;
            } else {
                offset = newOffset;
                if (offset == result2.getStartOffset()) {
                    ++offset;
                }
            }
            results.add((FindResult)result2);
        }
    }

    public void dispose() {
        this.myDisposed = true;
        this.myEditor.getDocument().removeDocumentListener((DocumentListener)this);
    }

    private void searchCompleted(@NotNull List<FindResult> occurrences, @NotNull Editor editor, @Nullable FindModel findModel, boolean toChangeSelection, @Nullable TextRange next, int stamp) {
        if (occurrences == null) {
            SearchResults.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            SearchResults.$$$reportNull$$$0(11);
        }
        if (stamp < this.myLastUpdatedStamp) {
            return;
        }
        this.myLastUpdatedStamp = stamp;
        if (editor != this.getEditor() || this.myDisposed || editor.isDisposed()) {
            return;
        }
        this.myOccurrences = occurrences;
        FindResult oldCursorRange = this.myCursor;
        Collections.sort(this.myOccurrences, Comparator.comparingInt(TextRange::getStartOffset));
        this.myFindModel = findModel;
        this.myDocumentTimestamp = this.myEditor.getDocument().getModificationStamp();
        this.updateCursor((TextRange)oldCursorRange, next);
        this.updateExcluded();
        this.notifyChanged();
        if (oldCursorRange == null || this.myCursor == null || !this.myCursor.equals((Object)oldCursorRange)) {
            if (toChangeSelection) {
                this.mySelectionManager.updateSelection(true, true);
            }
            this.notifyCursorMoved();
        }
        this.dumpIfNeeded();
    }

    private void dumpIfNeeded() {
        for (SearchResultsListener listener2 : this.myListeners) {
            listener2.updateFinished();
        }
    }

    private void updateExcluded() {
        HashSet<RangeMarker> invalid = new HashSet<RangeMarker>();
        for (RangeMarker marker : this.myExcluded) {
            if (marker.isValid()) continue;
            invalid.add(marker);
            marker.dispose();
        }
        this.myExcluded.removeAll(invalid);
    }

    private void updateCursor(@Nullable TextRange oldCursorRange, @Nullable TextRange next) {
        boolean justReplaced = next != null;
        boolean toPush = true;
        if ((justReplaced || (toPush = !this.repairCursorFromStack())) && (justReplaced || !this.tryToRepairOldCursor(oldCursorRange))) {
            if (this.myFindModel != null) {
                if (oldCursorRange != null && !this.myFindModel.isGlobal()) {
                    this.myCursor = this.firstOccurrenceAfterOffset(oldCursorRange.getEndOffset());
                } else if (justReplaced) {
                    this.nextOccurrence(false, next, false, true, false);
                } else {
                    this.myCursor = oldCursorRange == null ? this.firstOccurrenceAtOrAfterCaret() : this.firstOccurrenceAfterCaret();
                }
            } else {
                this.myCursor = null;
            }
        }
        if (!justReplaced && this.myCursor == null && this.hasMatches()) {
            this.nextOccurrence(true, oldCursorRange, false, false, false);
        }
        if (toPush && this.myCursor != null) {
            this.push();
        }
    }

    private boolean repairCursorFromStack() {
        if (this.myCursorPositions.size() >= 2) {
            FindResult newCursor;
            Pair oldPosition = (Pair)this.myCursorPositions.get(this.myCursorPositions.size() - 2);
            if (((FindModel)oldPosition.first).equals((Object)this.myFindModel) && (newCursor = this.findOccurrenceEqualTo((FindResult)oldPosition.second)) != null) {
                this.myCursorPositions.pop();
                this.myCursor = newCursor;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private FindResult findOccurrenceEqualTo(FindResult occurrence) {
        for (FindResult findResult : this.myOccurrences) {
            if (!findResult.equals((Object)occurrence)) continue;
            return findResult;
        }
        return null;
    }

    @Nullable
    private FindResult firstOccurrenceAtOrAfterCaret() {
        int offset = this.getEditor().getCaretModel().getOffset();
        for (FindResult occurrence : this.myOccurrences) {
            if (offset > occurrence.getEndOffset() || offset < occurrence.getStartOffset()) continue;
            return occurrence;
        }
        int selectionStartOffset = this.getEditor().getSelectionModel().getSelectionStart();
        int selectionEndOffset = this.getEditor().getSelectionModel().getSelectionEnd();
        for (FindResult occurrence : this.myOccurrences) {
            if (selectionEndOffset < occurrence.getEndOffset() || selectionStartOffset > occurrence.getStartOffset()) continue;
            return occurrence;
        }
        return this.firstOccurrenceAfterCaret();
    }

    private void notifyChanged() {
        for (SearchResultsListener listener2 : this.myListeners) {
            listener2.searchResultsUpdated(this);
        }
    }

    static boolean insideVisibleArea(Editor e, TextRange r) {
        int startOffset = r.getStartOffset();
        if (startOffset > e.getDocument().getTextLength()) {
            return false;
        }
        Rectangle visibleArea = e.getScrollingModel().getVisibleArea();
        Point point = e.logicalPositionToXY(e.offsetToLogicalPosition(startOffset));
        return visibleArea.contains(point);
    }

    @Nullable
    private FindResult firstOccurrenceBeforeCaret() {
        int offset = this.getEditor().getCaretModel().getOffset();
        return this.firstOccurrenceBeforeOffset(offset);
    }

    @Nullable
    private FindResult firstOccurrenceBeforeOffset(int offset) {
        for (int i = this.getOccurrences().size() - 1; i >= 0; --i) {
            if (this.getOccurrences().get(i).getEndOffset() >= offset) continue;
            return this.getOccurrences().get(i);
        }
        return null;
    }

    @Nullable
    private FindResult firstOccurrenceAfterCaret() {
        int caret = this.myEditor.getCaretModel().getOffset();
        return this.firstOccurrenceAfterOffset(caret);
    }

    @Nullable
    private FindResult firstOccurrenceAfterOffset(int offset) {
        FindResult afterCaret = null;
        for (FindResult occurrence : this.getOccurrences()) {
            if (occurrence.getStartOffset() < offset || occurrence.getEndOffset() <= offset || afterCaret != null && occurrence.getStartOffset() >= afterCaret.getStartOffset()) continue;
            afterCaret = occurrence;
        }
        return afterCaret;
    }

    private boolean tryToRepairOldCursor(@Nullable TextRange oldCursorRange) {
        if (oldCursorRange == null) {
            return false;
        }
        FindResult mayBeOldCursor = null;
        for (FindResult searchResult : this.getOccurrences()) {
            if (searchResult.intersects(oldCursorRange)) {
                mayBeOldCursor = searchResult;
            }
            if (searchResult.getStartOffset() != oldCursorRange.getStartOffset()) continue;
            break;
        }
        if (mayBeOldCursor != null) {
            this.myCursor = mayBeOldCursor;
            return true;
        }
        return false;
    }

    @Nullable
    private FindResult prevOccurrence(TextRange range2) {
        for (int i = this.getOccurrences().size() - 1; i >= 0; --i) {
            FindResult occurrence = this.getOccurrences().get(i);
            if (occurrence.getEndOffset() > range2.getStartOffset()) continue;
            return occurrence;
        }
        return null;
    }

    @Nullable
    private FindResult nextOccurrence(TextRange range2) {
        for (FindResult occurrence : this.getOccurrences()) {
            if (occurrence.getStartOffset() < range2.getEndOffset()) continue;
            return occurrence;
        }
        return null;
    }

    public void prevOccurrence(boolean findSelected) {
        if (findSelected) {
            this.myCursor = this.mySelectionManager.removeCurrentSelection() ? this.firstOccurrenceAtOrAfterCaret() : null;
            this.notifyCursorMoved();
        } else {
            if (this.myFindModel == null) {
                return;
            }
            boolean processFromTheBeginning = false;
            if (this.myNotFoundState) {
                this.myNotFoundState = false;
                processFromTheBeginning = true;
            }
            FindResult next = null;
            if (!this.myFindModel.isGlobal()) {
                if (this.myCursor != null) {
                    next = this.prevOccurrence((TextRange)this.myCursor);
                }
            } else {
                next = this.firstOccurrenceBeforeCaret();
            }
            if (next == null) {
                if (processFromTheBeginning) {
                    if (this.hasMatches()) {
                        next = this.getOccurrences().get(this.getOccurrences().size() - 1);
                    }
                } else {
                    this.setNotFoundState(false);
                }
            }
            this.moveCursorTo(next, false);
        }
        this.push();
    }

    private void push() {
        this.myCursorPositions.push((Object)Pair.create((Object)this.myFindModel, (Object)this.myCursor));
    }

    public void nextOccurrence(boolean retainOldSelection) {
        if (this.myFindModel == null) {
            return;
        }
        this.nextOccurrence(false, (TextRange)this.myCursor, true, false, retainOldSelection);
        this.push();
    }

    private void nextOccurrence(boolean processFromTheBeginning, TextRange cursor, boolean toNotify, boolean justReplaced, boolean retainOldSelection) {
        FindResult next;
        if (this.myNotFoundState) {
            this.myNotFoundState = false;
            processFromTheBeginning = true;
        }
        if ((next = (!this.myFindModel.isGlobal() || justReplaced) && cursor != null ? this.nextOccurrence(cursor) : this.firstOccurrenceAfterCaret()) == null) {
            if (processFromTheBeginning) {
                if (this.hasMatches()) {
                    next = this.getOccurrences().get(0);
                }
            } else {
                this.setNotFoundState(true);
            }
        }
        if (toNotify) {
            this.moveCursorTo(next, retainOldSelection);
        } else {
            this.myCursor = next;
        }
    }

    public void moveCursorTo(FindResult next, boolean retainOldSelection) {
        if (next != null && !this.mySelectionManager.isSelected(next)) {
            boolean bl = this.myCursor != null && this.mySelectionManager.isSelected(this.myCursor);
            this.myCursor = next;
            this.mySelectionManager.updateSelection(!(retainOldSelection &= bl), false);
            this.notifyCursorMoved();
        }
    }

    private void notifyCursorMoved() {
        for (SearchResultsListener listener2 : this.myListeners) {
            listener2.cursorMoved();
        }
    }

    public boolean isUpToDate() {
        return this.myDocumentTimestamp == this.myEditor.getDocument().getModificationStamp();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/livePreview/SearchResults";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/livePreview/SearchResults";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrences";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateThreadSafe";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updatePreviousFindModel";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findInRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "searchCompleted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface SearchResultsListener {
        public void searchResultsUpdated(@NotNull SearchResults var1);

        public void cursorMoved();

        public void updateFinished();
    }

    public static enum Direction {
        UP,
        DOWN;

    }
}

