/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.banner;

import java.io.File;
import java.util.Optional;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javax.inject.Inject;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.io.FileType;
import org.pdfsam.ui.RecentWorkspacesService;
import org.pdfsam.ui.banner.WorkspaceMenuItem;
import org.pdfsam.ui.io.FileChoosers;
import org.pdfsam.ui.io.RememberingLatestFileChooserWrapper;
import org.pdfsam.ui.workspace.LoadWorkspaceEvent;
import org.pdfsam.ui.workspace.SaveWorkspaceEvent;
import org.pdfsam.ui.workspace.WorkspaceLoadedEvent;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;

class WorkspaceMenu
extends Menu {
    private RecentWorkspacesService service;
    private Menu recent;
    private Optional<File> latestWorkspace = Optional.empty();

    @Inject
    public WorkspaceMenu(RecentWorkspacesService service) {
        super(DefaultI18nContext.getInstance().i18n("_Workspace"));
        this.service = service;
        this.setId("workspaceMenu");
        MenuItem load = new MenuItem(DefaultI18nContext.getInstance().i18n("_Load"));
        load.setId("loadWorkspace");
        load.setOnAction(e -> this.loadWorkspace());
        MenuItem save = new MenuItem(DefaultI18nContext.getInstance().i18n("_Save"));
        save.setOnAction(e -> this.saveWorkspace());
        save.setId("saveWorkspace");
        this.recent = new Menu(DefaultI18nContext.getInstance().i18n("Recen_ts"));
        this.recent.setId("recentWorkspace");
        service.getRecentlyUsedWorkspaces().stream().map(WorkspaceMenuItem::new).forEach(arg_0 -> this.recent.getItems().add(arg_0));
        MenuItem clear = new MenuItem(DefaultI18nContext.getInstance().i18n("_Clear recents"));
        clear.setOnAction(e -> this.clearWorkspaces());
        clear.setId("clearWorkspaces");
        this.getItems().addAll((Object[])new MenuItem[]{load, save, new SeparatorMenuItem(), this.recent, clear});
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    public void saveWorkspace() {
        RememberingLatestFileChooserWrapper fileChooser = FileChoosers.getFileChooser((String)DefaultI18nContext.getInstance().i18n("Select the workspace file to save"), (FileType[])new FileType[]{FileType.JSON});
        this.latestWorkspace.ifPresentOrElse(f -> {
            fileChooser.setInitialDirectory(f.getParentFile());
            fileChooser.setInitialFileName(f.getName());
        }, () -> fileChooser.setInitialFileName("PDFsam_workspace.json"));
        File chosenFile = fileChooser.showDialog(RememberingLatestFileChooserWrapper.OpenType.SAVE);
        if (chosenFile != null) {
            this.latestWorkspace = Optional.of(chosenFile);
            StaticStudio.eventStudio().broadcast((Object)new SaveWorkspaceEvent(chosenFile));
        }
    }

    public void loadWorkspace() {
        RememberingLatestFileChooserWrapper fileChooser = FileChoosers.getFileChooser((String)DefaultI18nContext.getInstance().i18n("Select the workspace to load"), (FileType[])new FileType[]{FileType.JSON});
        this.latestWorkspace.ifPresent(f -> {
            fileChooser.setInitialDirectory(f.getParentFile());
            fileChooser.setInitialFileName(f.getName());
        });
        File chosenFile = fileChooser.showDialog(RememberingLatestFileChooserWrapper.OpenType.OPEN);
        if (chosenFile != null) {
            StaticStudio.eventStudio().broadcast((Object)new LoadWorkspaceEvent(chosenFile));
        }
    }

    public void clearWorkspaces() {
        this.service.clear();
        this.recent.getItems().clear();
    }

    @EventListener
    public void onWorkspaceLoaded(WorkspaceLoadedEvent e) {
        this.recent.getItems().clear();
        this.service.getRecentlyUsedWorkspaces().stream().map(WorkspaceMenuItem::new).forEach(arg_0 -> this.recent.getItems().add(arg_0));
        this.latestWorkspace = Optional.of(e.workspace());
    }
}

