/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.annotation;

import java.util.Objects;
import java.util.Optional;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.graphics.color.PDColor;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.sejda.sambox.pdmodel.interactive.annotation.PDBorderStyleDictionary;

public class PDAnnotationLine
extends PDAnnotationMarkup {
    public static final String IT_LINE_ARROW = "LineArrow";
    public static final String IT_LINE_DIMENSION = "LineDimension";
    public static final String LE_SQUARE = "Square";
    public static final String LE_CIRCLE = "Circle";
    public static final String LE_DIAMOND = "Diamond";
    public static final String LE_OPEN_ARROW = "OpenArrow";
    public static final String LE_CLOSED_ARROW = "ClosedArrow";
    public static final String LE_NONE = "None";
    public static final String LE_BUTT = "Butt";
    public static final String LE_R_OPEN_ARROW = "ROpenArrow";
    public static final String LE_R_CLOSED_ARROW = "RClosedArrow";
    public static final String LE_SLASH = "Slash";
    public static final String SUB_TYPE = "Line";

    public PDAnnotationLine() {
        this.getCOSObject().setName(COSName.SUBTYPE, SUB_TYPE);
        this.setLine(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
    }

    public PDAnnotationLine(COSDictionary field) {
        super(field);
    }

    public void setLine(float[] l) {
        COSArray newL = new COSArray();
        newL.setFloatArray(l);
        this.getCOSObject().setItem(COSName.L, (COSBase)newL);
    }

    public float[] getLine() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.L, COSArray.class)).map(COSArray::toFloatArray).orElse(null);
    }

    public void setStartPointEndingStyle(String style) {
        COSArray array;
        if (style == null) {
            style = LE_NONE;
        }
        if ((array = this.getCOSObject().getDictionaryObject(COSName.LE, COSArray.class)) == null || array.size() == 0) {
            array = new COSArray();
            array.add(COSName.getPDFName(style));
            array.add(COSName.getPDFName(LE_NONE));
            this.getCOSObject().setItem(COSName.LE, (COSBase)array);
        } else {
            array.set(0, COSName.getPDFName(style));
        }
    }

    public String getStartPointEndingStyle() {
        COSArray array = this.getCOSObject().getDictionaryObject(COSName.LE, COSArray.class);
        if (Objects.nonNull(array)) {
            return array.getName(0);
        }
        return LE_NONE;
    }

    public void setEndPointEndingStyle(String style) {
        COSArray array;
        if (style == null) {
            style = LE_NONE;
        }
        if ((array = this.getCOSObject().getDictionaryObject(COSName.LE, COSArray.class)) == null || array.size() < 2) {
            array = new COSArray();
            array.add(COSName.getPDFName(LE_NONE));
            array.add(COSName.getPDFName(style));
            this.getCOSObject().setItem(COSName.LE, (COSBase)array);
        } else {
            array.set(1, COSName.getPDFName(style));
        }
    }

    public String getEndPointEndingStyle() {
        COSArray array = this.getCOSObject().getDictionaryObject(COSName.LE, COSArray.class);
        if (Objects.nonNull(array) && array.size() >= 2) {
            return array.getName(1);
        }
        return LE_NONE;
    }

    public void setInteriorColor(PDColor ic) {
        this.getCOSObject().setItem(COSName.IC, (COSBase)ic.toComponentsCOSArray());
    }

    public PDColor getInteriorColor() {
        return this.getColor(COSName.IC);
    }

    public void setCaption(boolean cap) {
        this.getCOSObject().setBoolean(COSName.CAP, cap);
    }

    public boolean getCaption() {
        return this.getCOSObject().getBoolean(COSName.CAP, false);
    }

    @Override
    public void setBorderStyle(PDBorderStyleDictionary bs) {
        this.getCOSObject().setItem(COSName.BS, (COSObjectable)bs);
    }

    @Override
    public PDBorderStyleDictionary getBorderStyle() {
        COSDictionary bs = this.getCOSObject().getDictionaryObject(COSName.BS, COSDictionary.class);
        if (Objects.nonNull(bs)) {
            return new PDBorderStyleDictionary(bs);
        }
        return null;
    }

    public float getLeaderLineLength() {
        return this.getCOSObject().getFloat(COSName.LL, 0.0f);
    }

    public void setLeaderLineLength(float leaderLineLength) {
        this.getCOSObject().setFloat(COSName.LL, leaderLineLength);
    }

    public float getLeaderLineExtensionLength() {
        return this.getCOSObject().getFloat(COSName.LLE, 0.0f);
    }

    public void setLeaderLineExtensionLength(float leaderLineExtensionLength) {
        this.getCOSObject().setFloat(COSName.LLE, leaderLineExtensionLength);
    }

    public float getLeaderLineOffsetLength() {
        return this.getCOSObject().getFloat(COSName.LLO, 0.0f);
    }

    public void setLeaderLineOffsetLength(float leaderLineOffsetLength) {
        this.getCOSObject().setFloat(COSName.LLO, leaderLineOffsetLength);
    }

    public String getCaptionPositioning() {
        return this.getCOSObject().getNameAsString(COSName.CP);
    }

    public void setCaptionPositioning(String captionPositioning) {
        this.getCOSObject().setName(COSName.CP, captionPositioning);
    }

    public void setCaptionHorizontalOffset(float offset) {
        COSArray array = (COSArray)this.getCOSObject().getDictionaryObject(COSName.CO);
        if (array == null) {
            array = new COSArray();
            array.setFloatArray(new float[]{offset, 0.0f});
            this.getCOSObject().setItem(COSName.CO, (COSBase)array);
        } else {
            array.set(0, new COSFloat(offset));
        }
    }

    public float getCaptionHorizontalOffset() {
        COSArray array = this.getCOSObject().getDictionaryObject(COSName.CO, COSArray.class);
        if (Objects.nonNull(array)) {
            return array.toFloatArray()[0];
        }
        return 0.0f;
    }

    public void setCaptionVerticalOffset(float offset) {
        COSArray array = this.getCOSObject().getDictionaryObject(COSName.CO, COSArray.class);
        if (array == null) {
            array = new COSArray();
            array.setFloatArray(new float[]{0.0f, offset});
            this.getCOSObject().setItem(COSName.CO, (COSBase)array);
        } else {
            array.set(1, new COSFloat(offset));
        }
    }

    public float getCaptionVerticalOffset() {
        COSArray array = this.getCOSObject().getDictionaryObject(COSName.CO, COSArray.class);
        if (array != null) {
            return array.toFloatArray()[1];
        }
        return 0.0f;
    }
}

