/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.languagetool.Experimental;

@Experimental
public class RuleLoggerMessage {
    private final String ruleId;
    private final String language;
    private final Date timestamp;
    private String message;

    public RuleLoggerMessage(@NotNull String ruleId, @NotNull String language, @NotNull String message) {
        this.ruleId = Objects.requireNonNull(ruleId);
        this.language = Objects.requireNonNull(language);
        this.timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTime();
        this.message = Objects.requireNonNull(message);
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getLanguage() {
        return this.language;
    }

    public Date getTimestamp() {
        return (Date)this.timestamp.clone();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

