"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "IndexPatterns", {
  enumerable: true,
  get: function get() {
    return _index.IndexPatterns;
  }
});
Object.defineProperty(exports, "validateIndexPattern", {
  enumerable: true,
  get: function get() {
    return _index.validateIndexPattern;
  }
});
exports.ui = exports.fixtures = exports.constants = exports.IndexPatternsService = void 0;

var _chrome = _interopRequireDefault(require("ui/chrome"));

var _fixtures = require("ui/index_patterns/fixtures");

var _index = require("ui/index_patterns/index");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var config = _chrome.default.getUiSettingsClient();

var savedObjectsClient = _chrome.default.getSavedObjectsClient();
/**
 * Index Patterns Service
 *
 * The `setup` method of this service returns the public contract for
 * index patterns. Right now these APIs are simply imported from `ui/public`
 * and re-exported here. Once the index patterns code actually moves to
 * this plugin, the imports above can simply be updated to point to their
 * corresponding local directory.
 *
 * @internal
 */


var IndexPatternsService =
/*#__PURE__*/
function () {
  function IndexPatternsService() {
    _classCallCheck(this, IndexPatternsService);
  }

  _createClass(IndexPatternsService, [{
    key: "setup",
    value: function setup() {
      return {
        indexPatterns: new _index.IndexPatterns(config, savedObjectsClient)
      };
    }
  }, {
    key: "stop",
    value: function stop() {// nothing to do here yet
    }
  }]);

  return IndexPatternsService;
}(); // static exports


exports.IndexPatternsService = IndexPatternsService;
var constants = {
  INDEX_PATTERN_ILLEGAL_CHARACTERS: _index.INDEX_PATTERN_ILLEGAL_CHARACTERS,
  INDEX_PATTERN_ILLEGAL_CHARACTERS_VISIBLE: _index.INDEX_PATTERN_ILLEGAL_CHARACTERS_VISIBLE
};
exports.constants = constants;
var fixtures = {
  mockFields: _fixtures.mockFields,
  mockIndexPattern: _fixtures.mockIndexPattern
};
exports.fixtures = fixtures;
var ui = {
  IndexPatternSelect: _index.IndexPatternSelect
};
/** @public */

exports.ui = ui;