import { fromEquals } from './Setoid';
import { phantom, toString } from './function';
export const URI = 'Const';
/**
 * @data
 * @constructor Const
 * @since 1.0.0
 */
export class Const {
    constructor(value) {
        this.value = value;
    }
    map(f) {
        return this;
    }
    contramap(f) {
        return this;
    }
    fold(f) {
        return f(this.value);
    }
    inspect() {
        return this.toString();
    }
    toString() {
        return `new Const(${toString(this.value)})`;
    }
}
/**
 * @since 1.17.0
 */
export const getShow = (S) => {
    return {
        show: c => `new Const(${S.show(c.value)})`
    };
};
/**
 * @since 1.0.0
 */
export const getSetoid = (S) => {
    return fromEquals((x, y) => S.equals(x.value, y.value));
};
const map = (fa, f) => {
    return fa.map(f);
};
const contramap = (fa, f) => {
    return fa.contramap(f);
};
const ap = (S) => (fab, fa) => {
    return new Const(S.concat(fab.value, fa.value));
};
/**
 * @since 1.0.0
 */
export const getApply = (S) => {
    return {
        URI,
        _L: phantom,
        map,
        ap: ap(S)
    };
};
const of = (M) => (a) => {
    return new Const(M.empty);
};
/**
 * @since 1.0.0
 */
export const getApplicative = (M) => {
    return Object.assign({}, getApply(M), { of: of(M) });
};
/**
 * @since 1.0.0
 */
export const const_ = {
    URI,
    map,
    contramap
};
