"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var mobx_react_1 = require("mobx-react");
var react_1 = __importStar(require("react"));
var theme_1 = require("../lib/themes/theme");
var ids_1 = require("../lib/utils/ids");
var LineAnnotationSpecComponent = /** @class */ (function (_super) {
    __extends(LineAnnotationSpecComponent, _super);
    function LineAnnotationSpecComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.markerRef = react_1.createRef();
        return _this;
    }
    LineAnnotationSpecComponent.prototype.componentDidMount = function () {
        var _a = this.props, chartStore = _a.chartStore, children = _a.children, config = __rest(_a, ["chartStore", "children"]);
        if (this.markerRef.current) {
            var _b = this.markerRef.current, offsetWidth = _b.offsetWidth, offsetHeight = _b.offsetHeight;
            config.markerDimensions = {
                width: offsetWidth,
                height: offsetHeight,
            };
        }
        chartStore.addAnnotationSpec(__assign({}, config));
    };
    LineAnnotationSpecComponent.prototype.componentDidUpdate = function () {
        var _a = this.props, chartStore = _a.chartStore, children = _a.children, config = __rest(_a, ["chartStore", "children"]);
        if (this.markerRef.current) {
            var _b = this.markerRef.current, offsetWidth = _b.offsetWidth, offsetHeight = _b.offsetHeight;
            config.markerDimensions = {
                width: offsetWidth,
                height: offsetHeight,
            };
        }
        chartStore.addAnnotationSpec(__assign({}, config));
    };
    LineAnnotationSpecComponent.prototype.componentWillUnmount = function () {
        var _a = this.props, chartStore = _a.chartStore, annotationId = _a.annotationId;
        chartStore.removeAnnotationSpec(annotationId);
    };
    LineAnnotationSpecComponent.prototype.render = function () {
        if (!this.props.marker) {
            return null;
        }
        // We need to get the width & height of the marker passed into the spec
        // so we render the marker offscreen if one has been defined & update the config
        // with the width & height.
        var offscreenStyle = {
            position: 'absolute',
            left: -9999,
            opacity: 0,
        };
        return (react_1.default.createElement("div", { ref: this.markerRef, style: __assign({}, offscreenStyle) }, this.props.marker));
    };
    LineAnnotationSpecComponent.defaultProps = {
        groupId: ids_1.getGroupId('__global__'),
        annotationType: 'line',
        style: theme_1.DEFAULT_ANNOTATION_LINE_STYLE,
        hideLines: false,
        hideTooltips: false,
        zIndex: 1,
    };
    return LineAnnotationSpecComponent;
}(react_1.PureComponent));
exports.LineAnnotationSpecComponent = LineAnnotationSpecComponent;
exports.LineAnnotation = mobx_react_1.inject('chartStore')(LineAnnotationSpecComponent);
//# sourceMappingURL=line_annotation.js.map