/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.annotation.Nonnull;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.ProjectExecutionServices;
import org.gradle.internal.service.ServiceRegistry;

public class ProjectExecutionServiceRegistry
implements AutoCloseable {
    private final LoadingCache<ProjectInternal, ProjectExecutionServices> projectRegistries = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ProjectInternal, ProjectExecutionServices>(){

        public ProjectExecutionServices load(@Nonnull ProjectInternal project) {
            return new ProjectExecutionServices(project);
        }
    });

    public <T> T getProjectService(ProjectInternal project, Class<T> serviceType) {
        return (T)this.forProject(project).get(serviceType);
    }

    public ServiceRegistry forProject(ProjectInternal project) {
        return (ServiceRegistry)this.projectRegistries.getUnchecked((Object)project);
    }

    @Override
    public void close() {
        for (ProjectExecutionServices registry : this.projectRegistries.asMap().values()) {
            registry.close();
        }
    }
}

