/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.collections.PendingSource;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.Collector;
import org.gradle.api.internal.provider.Collectors;
import org.gradle.api.internal.provider.ProviderInternal;

public class DefaultPendingSource<T>
implements PendingSource<T> {
    private final List<Collectors.TypedCollector<T>> pending = Lists.newArrayList();
    private Action<T> flushAction;

    @Override
    public void realizePending() {
        if (!this.pending.isEmpty()) {
            ArrayList copied = Lists.newArrayList(this.pending);
            this.realize(copied);
        }
    }

    @Override
    public void realizePending(Class<?> type) {
        if (!this.pending.isEmpty()) {
            ArrayList copied = Lists.newArrayList();
            for (Collectors.TypedCollector<T> collector : this.pending) {
                if (collector.getType() != null && !type.isAssignableFrom(collector.getType())) continue;
                copied.add(collector);
            }
            this.realize(copied);
        }
    }

    private void realize(Iterable<Collectors.TypedCollector<T>> collectors) {
        for (Collectors.TypedCollector<T> collector : collectors) {
            if (this.flushAction != null) {
                this.pending.remove(collector);
                ArrayList realized = Lists.newArrayList();
                collector.collectInto((Collection)realized);
                for (Object element : realized) {
                    this.flushAction.execute(element);
                }
                continue;
            }
            throw new IllegalStateException("Cannot realize pending elements when realize action is not set");
        }
    }

    @Override
    public boolean addPending(ProviderInternal<? extends T> provider) {
        return this.pending.add(new Collectors.TypedCollector(provider.getType(), (Collector)new Collectors.ElementFromProvider(provider)));
    }

    @Override
    public boolean removePending(ProviderInternal<? extends T> provider) {
        return this.removeByProvider(provider);
    }

    private boolean removeByProvider(ProviderInternal<?> provider) {
        Iterator<Collectors.TypedCollector<T>> iterator = this.pending.iterator();
        while (iterator.hasNext()) {
            Collectors.TypedCollector<T> collector = iterator.next();
            if (!collector.isProvidedBy(provider)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean addPendingCollection(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
        return this.pending.add(new Collectors.TypedCollector(provider.getElementType(), (Collector)new Collectors.ElementsFromCollectionProvider(provider)));
    }

    @Override
    public boolean removePendingCollection(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
        return this.removeByProvider((ProviderInternal<?>)provider);
    }

    @Override
    public void onRealize(Action<T> action) {
        this.flushAction = action;
    }

    @Override
    public void realizeExternal(ProviderInternal<? extends T> provider) {
        this.removePending(provider);
    }

    @Override
    public boolean isEmpty() {
        return this.pending.isEmpty();
    }

    @Override
    public int size() {
        int count = 0;
        for (Collectors.TypedCollector<T> collector : this.pending) {
            count += collector.size();
        }
        return count;
    }

    @Override
    public void clear() {
        this.pending.clear();
    }
}

