/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.CommonUtils;

class TransformerSettingsDialog
extends BaseDialog {
    private static final Log log = Log.getLog(TransformerSettingsDialog.class);
    private final ResultSetViewer viewer;
    private final DBVEntity vEntitySrc;
    private final DBVEntity vEntity;
    private DBDAttributeBinding currentAttribute;
    private DBVTransformSettings settings;
    private PropertyTreeViewer propertiesEditor;
    private PropertySourceCustom propertySource;
    private boolean selector;
    private List<? extends DBDAttributeTransformerDescriptor> transformerList;
    private Text infoText;
    private DBDAttributeTransformerDescriptor transformer;
    private Combo transformerCombo;
    private Table attributeTable;

    TransformerSettingsDialog(ResultSetViewer viewer) {
        this(viewer, null, null, false);
    }

    TransformerSettingsDialog(ResultSetViewer viewer, DBDAttributeBinding currentAttribute, DBVTransformSettings settings, boolean selector) {
        super(viewer.getControl().getShell(), "Transformer settings", null);
        this.viewer = viewer;
        this.currentAttribute = currentAttribute;
        this.settings = settings;
        this.selector = selector;
        this.vEntitySrc = DBVUtils.getVirtualEntity((DBSDataContainer)viewer.getDataContainer(), (boolean)true);
        this.vEntity = new DBVEntity(this.vEntitySrc.getContainer(), this.vEntitySrc);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite;
        Composite panel = composite = super.createDialogArea(parent);
        if (this.selector) {
            SashForm divider = new SashForm(composite, 256);
            divider.setSashWidth(10);
            divider.setLayoutData((Object)new GridData(1808));
            panel = divider;
            this.createAttributeSelectorArea(panel);
        } else if (this.currentAttribute != null) {
            this.detectTransformers();
        }
        this.createTransformSettingsArea(panel);
        if (this.currentAttribute != null) {
            this.updateTransformerInfo();
        }
        return parent;
    }

    private void createAttributeSelectorArea(Composite composite) {
        Composite panel = UIUtils.createComposite((Composite)composite, (int)1);
        this.attributeTable = new Table(panel, 67584);
        this.attributeTable.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        this.attributeTable.setLayoutData((Object)gd);
        UIUtils.executeOnResize((Control)this.attributeTable, () -> UIUtils.packColumns((Table)this.attributeTable, (boolean)true));
        UIUtils.createTableColumn((Table)this.attributeTable, (int)16384, (String)"Name");
        UIUtils.createTableColumn((Table)this.attributeTable, (int)16384, (String)"Transforms");
        for (DBDAttributeBinding attr : this.viewer.getModel().getVisibleAttributes()) {
            TableItem attrItem = new TableItem(this.attributeTable, 0);
            attrItem.setData((Object)attr);
            attrItem.setText(0, attr.getName());
            attrItem.setImage(0, DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)attr, (boolean)true)));
            this.updateTransformItem(attrItem);
            if (this.currentAttribute != attr) continue;
            this.attributeTable.setSelection(attrItem);
        }
        this.attributeTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransformerSettingsDialog.this.updateAttributeSelection();
            }
        });
    }

    private void updateTransformItem(TableItem attrItem) {
        DBVTransformSettings settings;
        DBDAttributeBinding attr = (DBDAttributeBinding)attrItem.getData();
        String transformStr = "";
        DBVEntityAttribute vAttr = this.vEntity.getVirtualAttribute(attr, false);
        if (vAttr != null && (settings = vAttr.getTransformSettings()) != null) {
            DBDAttributeTransformerDescriptor td;
            if (!CommonUtils.isEmpty((Collection)settings.getIncludedTransformers())) {
                transformStr = String.join((CharSequence)",", settings.getIncludedTransformers());
            } else if (!CommonUtils.isEmpty((String)settings.getCustomTransformer()) && (td = DBWorkbench.getPlatform().getValueHandlerRegistry().getTransformer(settings.getCustomTransformer())) != null) {
                transformStr = td.getName();
            }
        }
        attrItem.setText(1, transformStr);
    }

    private void updateAttributeSelection() {
        if (this.currentAttribute != null) {
            this.saveTransformerSettings();
            TableItem[] tableItemArray = this.attributeTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getData() == this.currentAttribute) {
                    this.updateTransformItem(item);
                    break;
                }
                ++n2;
            }
        }
        if (this.attributeTable.getSelectionIndex() < 0) {
            this.currentAttribute = null;
        } else {
            this.currentAttribute = (DBDAttributeBinding)this.attributeTable.getItem(this.attributeTable.getSelectionIndex()).getData();
            this.detectTransformers();
            this.updateTransformerInfo();
        }
    }

    private void detectTransformers() {
        DBPDataSource dataSource = this.viewer.getDataSource();
        DBVEntityAttribute vAttr = this.vEntity.getVirtualAttribute(this.currentAttribute, false);
        this.settings = vAttr == null ? null : DBVUtils.getTransformSettings((DBVEntityAttribute)vAttr, (boolean)false);
        this.transformer = dataSource != null && this.settings != null && !CommonUtils.isEmpty((String)this.settings.getCustomTransformer()) ? dataSource.getContainer().getPlatform().getValueHandlerRegistry().getTransformer(this.settings.getCustomTransformer()) : null;
        this.transformerList = DBWorkbench.getPlatform().getValueHandlerRegistry().findTransformers(this.currentAttribute.getDataSource(), (DBSTypedObject)this.currentAttribute, null);
    }

    private void updateTransformerInfo() {
        if (this.selector) {
            this.transformerCombo.removeAll();
            this.transformerCombo.add("Default");
            if (this.transformerList != null && this.selector) {
                for (DBDAttributeTransformerDescriptor dBDAttributeTransformerDescriptor : this.transformerList) {
                    this.transformerCombo.add(dBDAttributeTransformerDescriptor.getName());
                    if (dBDAttributeTransformerDescriptor != this.transformer) continue;
                    this.transformerCombo.select(this.transformerCombo.getItemCount() - 1);
                }
            }
            if (this.transformerCombo.getSelectionIndex() < 0) {
                this.transformerCombo.select(0);
            }
        }
        if (this.transformer != null && this.transformer.getDescription() != null) {
            this.infoText.setText(this.transformer.getDescription());
        } else {
            this.infoText.setText("");
        }
        if (this.transformer != null) {
            List list = this.transformer.getProperties();
            this.loadTransformerSettings(list);
        } else {
            this.loadTransformerSettings(Collections.emptyList());
        }
    }

    private void saveTransformerSettings() {
        if (this.currentAttribute == null || this.settings == null && this.transformer == null) {
            return;
        }
        if (this.settings == null) {
            this.settings = DBVUtils.getTransformSettings((DBVEntityAttribute)this.vEntity.getVirtualAttribute(this.currentAttribute, true), (boolean)true);
        }
        if (this.selector) {
            this.settings.setCustomTransformer(this.transformer == null ? null : this.transformer.getId());
        }
        if (this.transformer == null) {
            this.settings.setTransformOptions(new LinkedHashMap());
        } else {
            Map properties = this.propertySource.getPropertiesWithDefaults();
            for (Map.Entry prop : properties.entrySet()) {
                if (prop.getValue() == null) continue;
                this.settings.setTransformOption(prop.getKey().toString(), prop.getValue().toString());
            }
        }
    }

    private void createTransformSettingsArea(final Composite composite) {
        Composite settingsPanel = UIUtils.createComposite((Composite)composite, (int)1);
        if (this.selector || this.transformer != null) {
            Group placeholder = UIUtils.createControlGroup((Composite)settingsPanel, (String)"Transformer", (int)2, (int)768, (int)-1);
            if (!this.selector) {
                UIUtils.createLabelText((Composite)placeholder, (String)"Name", (String)this.transformer.getName(), (int)8);
            } else {
                this.transformerCombo = UIUtils.createLabelCombo((Composite)placeholder, (String)"Name", (int)12);
                this.transformerCombo.setLayoutData((Object)new GridData(768));
                this.transformerCombo.add("Default");
                this.transformerCombo.select(0);
                this.transformerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int selectionIndex = TransformerSettingsDialog.this.transformerCombo.getSelectionIndex();
                        if (selectionIndex == 0) {
                            TransformerSettingsDialog.this.transformer = null;
                            TransformerSettingsDialog.this.infoText.setText("N/A");
                            TransformerSettingsDialog.this.loadTransformerSettings(Collections.emptyList());
                        } else {
                            TransformerSettingsDialog.this.transformer = (DBDAttributeTransformerDescriptor)TransformerSettingsDialog.this.transformerList.get(selectionIndex - 1);
                            TransformerSettingsDialog.this.infoText.setText(CommonUtils.notEmpty((String)TransformerSettingsDialog.this.transformer.getDescription()));
                            TransformerSettingsDialog.this.loadTransformerSettings(TransformerSettingsDialog.this.transformer.getProperties());
                        }
                        composite.layout(true, true);
                    }
                });
            }
            Label infoLabel = UIUtils.createControlLabel((Composite)settingsPanel, (String)"Info");
            infoLabel.setLayoutData((Object)new GridData(2));
            this.infoText = new Text(settingsPanel, 72);
            GridData gd = new GridData(768);
            gd.widthHint = 300;
            this.infoText.setLayoutData((Object)gd);
        }
        this.propertiesEditor = new PropertyTreeViewer(settingsPanel, 2048);
        this.propertiesEditor.getControl().setFocus();
    }

    private void loadTransformerSettings(Collection<? extends DBPPropertyDescriptor> properties) {
        Map transformOptions;
        Map map = transformOptions = this.settings == null ? null : this.settings.getTransformOptions();
        if (transformOptions == null) {
            transformOptions = Collections.emptyMap();
        }
        this.propertySource = new PropertySourceCustom(properties, transformOptions);
        this.propertiesEditor.loadProperties((DBPPropertySource)this.propertySource);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.saveTransformerSettings();
        this.vEntitySrc.copyFrom(this.vEntity);
        this.vEntitySrc.persistConfiguration();
        super.okPressed();
    }
}

