"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _moment = _interopRequireDefault(require("moment"));

var _classnames = _interopRequireDefault(require("classnames"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

_moment["default"].defineLocale('en-shortdiff', {
  parentLocale: 'en',
  relativeTime: {
    future: 'in %s',
    past: '%s ago',
    s: 'Now',
    ss: '<1m',
    m: '1m',
    mm: '%dm',
    h: '1h',
    hh: '%dh',
    d: '1d',
    dd: '%dd',
    M: '1M',
    MM: '%dM',
    y: '1y',
    yy: '%dy'
  }
});

_moment["default"].locale('en');

class Timeago extends _react["default"].Component {
  static getTimeDisplay(time, now, style) {
    const m = (0, _moment["default"])(time);

    if (style === 'short') {
      m.locale('en-shortdiff');
      return m.from(now, true);
    } else {
      const diff = m.diff(now, 'months', true);

      if (Math.abs(diff) <= 1) {
        m.locale('en');
        return m.from(now);
      } else {
        const format = m.format('MMM Do, YYYY');
        return `on ${format}`;
      }
    }
  }

  componentDidMount() {
    this.timer = setInterval(() => this.forceUpdate(), 60000);
  }

  componentWillUnmount() {
    clearInterval(this.timer);
  }

  render() {
    const _this$props = this.props,
          {
      type,
      time,
      displayStyle
    } = _this$props,
          others = _objectWithoutProperties(_this$props, ["type", "time", "displayStyle"]);

    const display = Timeago.getTimeDisplay(time, (0, _moment["default"])(), displayStyle);
    const Type = type;
    const className = (0, _classnames["default"])('timeago', others.className);
    return _react["default"].createElement(Type, _extends({}, others, {
      className: className
    }), display);
  }

}

exports["default"] = Timeago;

_defineProperty(Timeago, "propTypes", {
  time: _propTypes["default"].any.isRequired,
  type: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].func]),
  displayStyle: _propTypes["default"].oneOf(['short', 'long'])
});

_defineProperty(Timeago, "defaultProps", {
  type: 'span',
  displayStyle: 'long'
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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