"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _commitPreviewContainer = _interopRequireDefault(require("../containers/commit-preview-container"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommitPreviewItem extends _react["default"].Component {
  static buildURI(workingDirectory) {
    return `atom-github://commit-preview?workdir=${encodeURIComponent(workingDirectory)}`;
  }

  constructor(props) {
    super(props);

    _defineProperty(this, "destroy", () => {
      /* istanbul ignore else */
      if (!this.isDestroyed) {
        this.emitter.emit('did-destroy');
        this.isDestroyed = true;
      }
    });

    this.emitter = new _eventKit.Emitter();
    this.isDestroyed = false;
    this.hasTerminatedPendingState = false;
    this.refInitialFocus = new _refHolder["default"]();
    this.refEditor = new _refHolder["default"]();
    this.refEditor.observe(editor => {
      if (editor.isAlive()) {
        this.emitter.emit('did-change-embedded-text-editor', editor);
      }
    });
  }

  terminatePendingState() {
    if (!this.hasTerminatedPendingState) {
      this.emitter.emit('did-terminate-pending-state');
      this.hasTerminatedPendingState = true;
    }
  }

  onDidTerminatePendingState(callback) {
    return this.emitter.on('did-terminate-pending-state', callback);
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  render() {
    const repository = this.props.workdirContextPool.getContext(this.props.workingDirectory).getRepository();
    return _react["default"].createElement(_commitPreviewContainer["default"], _extends({
      itemType: this.constructor,
      repository: repository
    }, this.props, {
      destroy: this.destroy,
      refEditor: this.refEditor,
      refInitialFocus: this.refInitialFocus
    }));
  }

  getTitle() {
    return 'Staged Changes';
  }

  getIconName() {
    return 'tasklist';
  }

  observeEmbeddedTextEditor(cb) {
    this.refEditor.map(editor => editor.isAlive() && cb(editor));
    return this.emitter.on('did-change-embedded-text-editor', cb);
  }

  getWorkingDirectory() {
    return this.props.workingDirectory;
  }

  serialize() {
    return {
      deserializer: 'CommitPreviewStub',
      uri: CommitPreviewItem.buildURI(this.props.workingDirectory)
    };
  }

  focus() {
    this.refInitialFocus.map(focusable => focusable.focus());
  }

}

exports["default"] = CommitPreviewItem;

_defineProperty(CommitPreviewItem, "propTypes", {
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  workingDirectory: _propTypes["default"].string.isRequired,
  discardLines: _propTypes["default"].func.isRequired,
  undoLastDiscard: _propTypes["default"].func.isRequired,
  surfaceToCommitPreviewButton: _propTypes["default"].func.isRequired
});

_defineProperty(CommitPreviewItem, "uriPattern", 'atom-github://commit-preview?workdir={workingDirectory}');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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