"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _multiFilePatchController = _interopRequireDefault(require("./multi-file-patch-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ChangedFileController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "surface", () => this.props.surfaceFileAtPath(this.props.relPath, this.props.stagingStatus));
  }

  render() {
    return _react["default"].createElement(_multiFilePatchController["default"], _extends({
      surface: this.surface
    }, this.props));
  }

}

exports["default"] = ChangedFileController;

_defineProperty(ChangedFileController, "propTypes", {
  repository: _propTypes["default"].object.isRequired,
  stagingStatus: _propTypes["default"].oneOf(['staged', 'unstaged']),
  relPath: _propTypes["default"].string.isRequired,
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  destroy: _propTypes["default"].func.isRequired,
  undoLastDiscard: _propTypes["default"].func.isRequired,
  surfaceFileAtPath: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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