/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.StringTokenizer;

public class TracedEventQueue
extends EventQueue {
    static boolean trace = false;
    static int[] suppressedIDs = null;

    @Override
    public void postEvent(AWTEvent theEvent) {
        boolean printEvent = true;
        int id = theEvent.getID();
        for (int i = 0; i < suppressedIDs.length; ++i) {
            if (id != suppressedIDs[i]) continue;
            printEvent = false;
            break;
        }
        if (printEvent) {
            System.out.println(Thread.currentThread().getName() + ": " + theEvent);
        }
        super.postEvent(theEvent);
    }

    static {
        String s = Toolkit.getProperty("AWT.IgnoreEventIDs", "");
        if (s.length() > 0) {
            StringTokenizer st = new StringTokenizer(s, ",");
            int nIDs = st.countTokens();
            suppressedIDs = new int[nIDs];
            for (int i = 0; i < nIDs; ++i) {
                String idString = st.nextToken();
                try {
                    TracedEventQueue.suppressedIDs[i] = Integer.parseInt(idString);
                    continue;
                }
                catch (NumberFormatException e) {
                    System.err.println("Bad ID listed in AWT.IgnoreEventIDs in awt.properties: \"" + idString + "\" -- skipped");
                    TracedEventQueue.suppressedIDs[i] = 0;
                }
            }
        } else {
            suppressedIDs = new int[0];
        }
    }
}

