/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.snaptracer.PackageStateHandler;
import org.netbeans.modules.profiler.snaptracer.ProbeStateHandler;
import org.netbeans.modules.profiler.snaptracer.SessionInitializationException;
import org.netbeans.modules.profiler.snaptracer.TracerPackage;
import org.netbeans.modules.profiler.snaptracer.TracerProbe;
import org.netbeans.modules.profiler.snaptracer.TracerProgressObject;
import org.netbeans.modules.profiler.snaptracer.impl.Bundle;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.openide.util.RequestProcessor;

public final class TracerController {
    private static final Logger LOGGER = Logger.getLogger(TracerController.class.getName());
    private static final String PROPERTY_STATE = "state";
    static final int STATE_SESSION_INACTIVE = 0;
    static final int STATE_SESSION_RUNNING = 1;
    static final int STATE_SESSION_IMPOSSIBLE = -1;
    static final int STATE_SESSION_STARTING = Integer.MAX_VALUE;
    static final int STATE_SESSION_STOPPING = Integer.MIN_VALUE;
    private final TracerModel model;
    private final PropertyChangeSupport changeSupport;
    private int state;
    private TracerProgressObject progress;
    private String error;
    private boolean wasNegativeValue;
    private RequestProcessor processor;

    public TracerController(TracerModel tracerModel) {
        this.model = tracerModel;
        this.changeSupport = new PropertyChangeSupport(this);
        this.state = 0;
    }

    private void setState(final int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (TracerController.this.state == -1) {
                    return;
                }
                int n2 = TracerController.this.state;
                TracerController.this.state = n;
                TracerController.this.changeSupport.firePropertyChange(TracerController.PROPERTY_STATE, n2, n);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    int getState() {
        return this.state;
    }

    TracerProgressObject getProgress() {
        return this.progress;
    }

    String getErrorMessage() {
        return this.error;
    }

    void addListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null && this.state != -1) {
            this.changeSupport.addPropertyChangeListener(PROPERTY_STATE, propertyChangeListener);
        }
    }

    void removeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(PROPERTY_STATE, propertyChangeListener);
        }
    }

    void performSession() {
        this.startSession();
        this.doPerformSession();
        this.stopSession();
    }

    void performAfterSession(Runnable runnable) {
        this.getProcessor().post(runnable);
    }

    private void startSession() {
        if (!this.model.areProbesDefined()) {
            return;
        }
        if (this.doStartSession()) {
            this.setState(1);
        } else {
            this.setState(0);
        }
    }

    private void stopSession() {
        if (this.state == 1) {
            this.setState(Integer.MIN_VALUE);
        }
        this.doStopSession();
        this.setState(0);
    }

    private boolean doStartSession() {
        this.wasNegativeValue = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TracerController.this.model.getTimelineSupport().resetValues();
            }
        });
        Set<Map.Entry<TracerPackage, List<TracerProbe>>> set = this.model.getDefinedProbeSets();
        this.notifySessionInitializing(set);
        this.setState(Integer.MAX_VALUE);
        if (!this.notifySessionStarting(set)) {
            return false;
        }
        this.notifySessionRunning(set);
        return true;
    }

    private void doPerformSession() {
        int n = this.model.getSamplesCount();
        for (int i = 0; i < n; ++i) {
            this.fetchData(i);
        }
    }

    private void doStopSession() {
        Set<Map.Entry<TracerPackage, List<TracerProbe>>> set = this.model.getDefinedProbeSets();
        this.notifySessionStopping(set);
        this.notifySessionFinished(set);
    }

    private void notifySessionInitializing(Set<Map.Entry<TracerPackage, List<TracerProbe>>> set) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        for (Map.Entry<TracerPackage, List<TracerProbe>> object : set) {
            Object throwable;
            List<TracerProbe> list = object.getValue();
            Object object2 = list.toArray(new TracerProbe[0]);
            PackageStateHandler packageStateHandler = object.getKey().getStateHandler();
            if (packageStateHandler != null) {
                try {
                    throwable = packageStateHandler.sessionInitializing((TracerProbe[])object2, null, -1);
                    if (throwable != null) {
                        n += ((TracerProgressObject)throwable).getSteps();
                        arrayList.add(throwable);
                    }
                }
                catch (Throwable throwable2) {
                    LOGGER.log(Level.INFO, "Package exception in sessionInitializing", throwable2);
                }
            }
            throwable = list.iterator();
            while (throwable.hasNext()) {
                TracerProbe tracerProbe = (TracerProbe)throwable.next();
                ProbeStateHandler probeStateHandler = tracerProbe.getStateHandler();
                if (probeStateHandler == null) continue;
                try {
                    TracerProgressObject throwable3 = probeStateHandler.sessionInitializing(null, -1);
                    if (throwable3 == null) continue;
                    n += throwable3.getSteps();
                    arrayList.add(throwable3);
                }
                catch (Throwable throwable4) {
                    LOGGER.log(Level.INFO, "Probe exception in sessionInitializing", throwable4);
                }
            }
        }
        if (n == 0) {
            this.progress = null;
        } else {
            this.progress = new TracerProgressObject(n, "Starting session...");
            TracerProgressObject.Listener listener = new TracerProgressObject.Listener(){

                @Override
                public void progressChanged(int n, int n2, String string) {
                    TracerController.this.progress.addSteps(n, string);
                }
            };
            for (Object object2 : arrayList) {
                ((TracerProgressObject)object2).addListener(listener);
            }
        }
        this.error = null;
    }

    private boolean notifySessionStarting(Set<Map.Entry<TracerPackage, List<TracerProbe>>> set) {
        Iterator<Map.Entry<TracerPackage, List<TracerProbe>>> iterator = set.iterator();
        HashMap hashMap = new HashMap();
        String string = null;
        try {
            while (iterator.hasNext()) {
                Map.Entry<TracerPackage, List<TracerProbe>> entry = iterator.next();
                TracerPackage tracerPackage = entry.getKey();
                string = tracerPackage.getName();
                List<TracerProbe> list = entry.getValue();
                TracerProbe[] tracerProbeArray = list.toArray(new TracerProbe[0]);
                PackageStateHandler packageStateHandler = tracerPackage.getStateHandler();
                if (packageStateHandler != null) {
                    packageStateHandler.sessionStarting(tracerProbeArray, null);
                }
                ArrayList<TracerProbe> arrayList = new ArrayList<TracerProbe>();
                hashMap.put(tracerPackage, arrayList);
                for (TracerProbe tracerProbe : list) {
                    string = this.model.getDescriptor(tracerProbe).getProbeName();
                    ProbeStateHandler probeStateHandler = tracerProbe.getStateHandler();
                    if (probeStateHandler != null) {
                        probeStateHandler.sessionStarting(null);
                    }
                    arrayList.add(tracerProbe);
                }
            }
            return true;
        }
        catch (SessionInitializationException sessionInitializationException) {
            LOGGER.log(Level.INFO, "Package or probe failed to start Tracer session", sessionInitializationException);
            this.error = sessionInitializationException.getUserMessage();
            if (this.error == null) {
                this.error = string + " failed to start";
            }
            Set<Map.Entry<TracerPackage, List<TracerProbe>>> set2 = hashMap.entrySet();
            this.notifySessionStopping(set2);
            this.setState(Integer.MIN_VALUE);
            this.notifySessionFinished(set2);
            return false;
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.INFO, "Package or probe exception in sessionStarting", throwable);
            return true;
        }
    }

    private void notifySessionRunning(Set<Map.Entry<TracerPackage, List<TracerProbe>>> set) {
        for (Map.Entry<TracerPackage, List<TracerProbe>> entry : set) {
            List<TracerProbe> list = entry.getValue();
            TracerProbe[] tracerProbeArray = list.toArray(new TracerProbe[0]);
            PackageStateHandler packageStateHandler = entry.getKey().getStateHandler();
            if (packageStateHandler != null) {
                try {
                    packageStateHandler.sessionRunning(tracerProbeArray, null);
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.INFO, "Package exception in sessionRunning", throwable);
                }
            }
            for (TracerProbe tracerProbe : list) {
                ProbeStateHandler probeStateHandler = tracerProbe.getStateHandler();
                if (probeStateHandler == null) continue;
                try {
                    probeStateHandler.sessionRunning(null);
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.INFO, "Probe exception in sessionRunning", throwable);
                }
            }
        }
    }

    private void notifySessionStopping(Set<Map.Entry<TracerPackage, List<TracerProbe>>> set) {
        for (Map.Entry<TracerPackage, List<TracerProbe>> entry : set) {
            List<TracerProbe> list = entry.getValue();
            TracerProbe[] tracerProbeArray = list.toArray(new TracerProbe[0]);
            PackageStateHandler packageStateHandler = entry.getKey().getStateHandler();
            if (packageStateHandler != null) {
                try {
                    packageStateHandler.sessionStopping(tracerProbeArray, null);
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.INFO, "Package exception in sessionStopping", throwable);
                }
            }
            for (TracerProbe tracerProbe : list) {
                ProbeStateHandler probeStateHandler = tracerProbe.getStateHandler();
                if (probeStateHandler == null) continue;
                try {
                    probeStateHandler.sessionStopping(null);
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.INFO, "Probe exception in sessionStopping", throwable);
                }
            }
        }
    }

    private void notifySessionFinished(Set<Map.Entry<TracerPackage, List<TracerProbe>>> set) {
        for (Map.Entry<TracerPackage, List<TracerProbe>> entry : set) {
            List<TracerProbe> list = entry.getValue();
            TracerProbe[] tracerProbeArray = list.toArray(new TracerProbe[0]);
            PackageStateHandler packageStateHandler = entry.getKey().getStateHandler();
            if (packageStateHandler != null) {
                try {
                    packageStateHandler.sessionFinished(tracerProbeArray, null);
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.INFO, "Package exception in sessionFinished", throwable);
                }
            }
            for (TracerProbe tracerProbe : list) {
                ProbeStateHandler probeStateHandler = tracerProbe.getStateHandler();
                if (probeStateHandler == null) continue;
                try {
                    probeStateHandler.sessionFinished(null);
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.INFO, "Probe exception in sessionFinished", throwable);
                }
            }
        }
    }

    private void notifyRefreshRateChanged(Set<Map.Entry<TracerPackage, List<TracerProbe>>> set) {
        for (Map.Entry<TracerPackage, List<TracerProbe>> entry : set) {
            List<TracerProbe> list = entry.getValue();
            TracerProbe[] tracerProbeArray = list.toArray(new TracerProbe[0]);
            PackageStateHandler packageStateHandler = entry.getKey().getStateHandler();
            if (packageStateHandler != null) {
                try {
                    packageStateHandler.refreshRateChanged(tracerProbeArray, null, -1);
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.INFO, "Package exception in refreshRateChanged", throwable);
                }
            }
            for (TracerProbe tracerProbe : list) {
                ProbeStateHandler probeStateHandler = tracerProbe.getStateHandler();
                if (probeStateHandler == null) continue;
                try {
                    probeStateHandler.refreshRateChanged(null, -1);
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.INFO, "Probe exception in refreshRateChanged", throwable);
                }
            }
        }
    }

    private synchronized RequestProcessor getProcessor() {
        if (this.processor == null) {
            this.processor = new RequestProcessor("Tracer Processor for " + this.model.getSnapshot().toString());
        }
        return this.processor;
    }

    private void fetchData(final int n) {
        final List<TracerProbe> list = this.model.getDefinedProbes();
        if (list.isEmpty()) {
            return;
        }
        final int n2 = this.model.getTimelineSupport().getItemsCount();
        this.getProcessor().post(new Runnable(){

            @Override
            public void run() {
                TracerController.this.fetchDataImpl(list, n2, n);
            }
        });
    }

    private void fetchDataImpl(List<TracerProbe> list, int n, int n2) {
        final long[] lArray = new long[n];
        int n3 = 0;
        final long l = this.model.getTimestamp(n2);
        for (TracerProbe tracerProbe : list) {
            long[] lArray2;
            try {
                lArray2 = tracerProbe.getItemValues(n2);
            }
            catch (Throwable throwable) {
                lArray2 = new long[tracerProbe.getItemsCount()];
                Arrays.fill(lArray2, Long.MAX_VALUE);
                LOGGER.log(Level.INFO, "Probe exception in getItemValues", throwable);
            }
            for (int i = 0; i < lArray2.length; ++i) {
                long l2 = lArray2[i];
                if (l2 < 0L) {
                    if (!this.wasNegativeValue) {
                        ProfilerDialogs.displayWarning((String)Bundle.Warning_NegativeValue());
                        LOGGER.info("Probe " + this.model.getDescriptor(tracerProbe).getProbeName() + " returned negative value: " + l2);
                        this.wasNegativeValue = true;
                    }
                    l2 = 0L;
                }
                lArray[n3++] = l2;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TracerController.this.model.getTimelineSupport().addValues(l, lArray);
            }
        });
    }

    void viewRemoved() {
        this.stopSession();
        this.setState(-1);
    }
}

