/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.CommandMerger;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FocusBasedCurrentEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="IdeDocumentHistory", storages={@Storage(value="$WORKSPACE_FILE$")})
public class IdeDocumentHistoryImpl
extends IdeDocumentHistory
implements Disposable,
PersistentStateComponent<RecentlyChangedFilesState> {
    private static final Logger LOG = Logger.getInstance(IdeDocumentHistoryImpl.class);
    private static final int BACK_QUEUE_LIMIT = Registry.intValue((String)"editor.navigation.history.stack.size");
    private static final int CHANGE_QUEUE_LIMIT = Registry.intValue((String)"editor.navigation.history.stack.size");
    private final Project myProject;
    private FileDocumentManager myFileDocumentManager;
    private FileEditorManagerEx myFileEditorManager;
    private final LinkedList<PlaceInfo> myBackPlaces;
    private final LinkedList<PlaceInfo> myForwardPlaces;
    private boolean myBackInProgress;
    private boolean myForwardInProgress;
    private Object myLastGroupId;
    private boolean myRegisteredBackPlaceInLastGroup;
    private final LinkedList<PlaceInfo> myChangePlaces;
    private int myCurrentIndex;
    private PlaceInfo myCurrentChangePlace;
    private PlaceInfo myCommandStartPlace;
    private boolean myCurrentCommandIsNavigation;
    private boolean myCurrentCommandHasChanges;
    private final Set<VirtualFile> myChangedFilesInCurrentCommand;
    private boolean myCurrentCommandHasMoves;
    private RecentlyChangedFilesState myRecentlyChangedFiles;

    public IdeDocumentHistoryImpl(@NotNull Project project, @NotNull FileEditorManagerEx fileEditorManager) {
        if (project == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(0);
        }
        if (fileEditorManager == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(1);
        }
        this.myBackPlaces = new LinkedList();
        this.myForwardPlaces = new LinkedList();
        this.myChangePlaces = new LinkedList();
        this.myChangedFilesInCurrentCommand = new THashSet();
        this.myRecentlyChangedFiles = new RecentlyChangedFilesState();
        this.myProject = project;
        this.myFileEditorManager = fileEditorManager;
        MessageBusConnection busConnection = project.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                IdeDocumentHistoryImpl.this.onSelectionChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$1", "selectionChanged"));
            }
        });
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    IdeDocumentHistoryImpl.this.removeInvalidFilesFromStacks();
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$2", "after"));
            }
        });
        busConnection.subscribe(CommandListener.TOPIC, (Object)new CommandListener(){

            public void commandStarted(@NotNull CommandEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                IdeDocumentHistoryImpl.this.onCommandStarted();
            }

            public void commandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                IdeDocumentHistoryImpl.this.onCommandFinished(event.getProject(), event.getCommandGroupId());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        EditorEventListener listener2 = new EditorEventListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                Document document = e.getDocument();
                VirtualFile file2 = IdeDocumentHistoryImpl.this.getFileDocumentManager().getFile(document);
                if (file2 != null && !(file2 instanceof LightVirtualFile) && !ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.class)) {
                    if (!ApplicationManager.getApplication().isDispatchThread()) {
                        LOG.error("Document update for physical file not in EDT: " + file2);
                    }
                    IdeDocumentHistoryImpl.this.myCurrentCommandHasChanges = true;
                    IdeDocumentHistoryImpl.this.myChangedFilesInCurrentCommand.add(file2);
                }
            }

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (e.getOldPosition().line == e.getNewPosition().line) {
                    return;
                }
                Document document = e.getEditor().getDocument();
                if (IdeDocumentHistoryImpl.this.getFileDocumentManager().getFile(document) != null) {
                    IdeDocumentHistoryImpl.this.myCurrentCommandHasMoves = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "documentChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretPositionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addDocumentListener((DocumentListener)listener2, (Disposable)this);
        multicaster.addCaretListener((CaretListener)listener2, (Disposable)this);
    }

    public void setFileEditorManager(@NotNull FileEditorManagerEx value) {
        if (value == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(2);
        }
        this.myFileEditorManager = value;
    }

    public RecentlyChangedFilesState getState() {
        return this.myRecentlyChangedFiles;
    }

    public void loadState(@NotNull RecentlyChangedFilesState state) {
        if (state == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(3);
        }
        this.myRecentlyChangedFiles = state;
    }

    public final void onSelectionChanged() {
        this.myCurrentCommandIsNavigation = true;
        this.myCurrentCommandHasMoves = true;
    }

    final void onCommandStarted() {
        this.myCommandStartPlace = this.getCurrentPlaceInfo();
        this.myCurrentCommandIsNavigation = false;
        this.myCurrentCommandHasChanges = false;
        this.myCurrentCommandHasMoves = false;
        this.myChangedFilesInCurrentCommand.clear();
    }

    @Nullable
    private PlaceInfo getCurrentPlaceInfo() {
        FileEditorWithProvider selectedEditorWithProvider = this.getSelectedEditor();
        if (selectedEditorWithProvider == null) {
            return null;
        }
        return this.createPlaceInfo(selectedEditorWithProvider.getFileEditor(), selectedEditorWithProvider.getProvider());
    }

    @Nullable
    private static PlaceInfo getPlaceInfoFromFocus() {
        VirtualFile file2;
        FileEditor fileEditor = new FocusBasedCurrentEditorProvider().getCurrentEditor();
        if (fileEditor instanceof TextEditor && fileEditor.isValid() && (file2 = fileEditor.getFile()) != null) {
            return new PlaceInfo(file2, fileEditor.getState(FileEditorStateLevel.NAVIGATION), TextEditorProvider.getInstance().getEditorTypeId(), null);
        }
        return null;
    }

    final void onCommandFinished(Project project, Object commandGroupId) {
        if (!CommandMerger.canMergeGroup(commandGroupId, this.myLastGroupId)) {
            this.myRegisteredBackPlaceInLastGroup = false;
        }
        this.myLastGroupId = commandGroupId;
        if (this.myCommandStartPlace != null && this.myCurrentCommandIsNavigation && this.myCurrentCommandHasMoves) {
            if (!this.myBackInProgress) {
                if (!this.myRegisteredBackPlaceInLastGroup) {
                    this.myRegisteredBackPlaceInLastGroup = true;
                    IdeDocumentHistoryImpl.putLastOrMerge(this.myBackPlaces, this.myCommandStartPlace);
                }
                if (!this.myForwardInProgress) {
                    this.myForwardPlaces.clear();
                }
            }
            this.removeInvalidFilesFromStacks();
        }
        if (this.myCurrentCommandHasChanges) {
            this.setCurrentChangePlace(project == this.myProject);
        } else if (this.myCurrentCommandHasMoves) {
            this.pushCurrentChangePlace();
        }
    }

    @Override
    public final void includeCurrentCommandAsNavigation() {
        this.myCurrentCommandIsNavigation = true;
    }

    @Override
    public final void includeCurrentPlaceAsChangePlace() {
        this.setCurrentChangePlace(false);
        this.pushCurrentChangePlace();
    }

    private void setCurrentChangePlace(boolean acceptPlaceFromFocus) {
        PlaceInfo lastInfo;
        boolean fromFocus = false;
        PlaceInfo placeInfo = this.getCurrentPlaceInfo();
        if (placeInfo != null && !this.myChangedFilesInCurrentCommand.contains(placeInfo.getFile())) {
            placeInfo = null;
        }
        if (placeInfo == null && acceptPlaceFromFocus) {
            placeInfo = IdeDocumentHistoryImpl.getPlaceInfoFromFocus();
            fromFocus = true;
        }
        if (placeInfo != null && !this.myChangedFilesInCurrentCommand.contains(placeInfo.getFile())) {
            placeInfo = null;
        }
        if (placeInfo == null) {
            return;
        }
        this.myRecentlyChangedFiles.register(placeInfo.getFile());
        this.myCurrentChangePlace = placeInfo;
        if (!this.myChangePlaces.isEmpty() && IdeDocumentHistoryImpl.isSame(placeInfo, lastInfo = this.myChangePlaces.getLast())) {
            this.myChangePlaces.removeLast();
        }
        this.myCurrentIndex = this.myChangePlaces.size();
        if (fromFocus) {
            this.pushCurrentChangePlace();
        }
    }

    private void pushCurrentChangePlace() {
        if (this.myCurrentChangePlace != null) {
            this.myChangePlaces.add(this.myCurrentChangePlace);
            if (this.myChangePlaces.size() > CHANGE_QUEUE_LIMIT) {
                this.myChangePlaces.removeFirst();
            }
            this.myCurrentChangePlace = null;
        }
        this.myCurrentIndex = this.myChangePlaces.size();
    }

    @Override
    public VirtualFile[] getChangedFiles() {
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        List<String> paths = this.myRecentlyChangedFiles.CHANGED_PATHS;
        for (String path : paths) {
            VirtualFile file2 = lfs.findFileByPath(path);
            if (file2 == null) continue;
            files2.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray(files2);
    }

    public boolean isRecentlyChanged(@NotNull VirtualFile file2) {
        if (file2 == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(4);
        }
        return this.myRecentlyChangedFiles.CHANGED_PATHS.contains(file2.getPath());
    }

    @Override
    public final void clearHistory() {
        this.myBackPlaces.clear();
        this.myForwardPlaces.clear();
        this.myChangePlaces.clear();
        this.myLastGroupId = null;
        this.myCurrentIndex = 0;
        this.myCurrentChangePlace = null;
        this.myCommandStartPlace = null;
    }

    @Override
    public final void back() {
        this.removeInvalidFilesFromStacks();
        if (this.myBackPlaces.isEmpty()) {
            return;
        }
        PlaceInfo info = this.myBackPlaces.removeLast();
        PlaceInfo current = this.getCurrentPlaceInfo();
        if (current != null) {
            this.myForwardPlaces.add(current);
        }
        this.myBackInProgress = true;
        try {
            this.executeCommand(() -> this.gotoPlaceInfo(info), "", null);
        }
        finally {
            this.myBackInProgress = false;
        }
    }

    @Override
    public final void forward() {
        this.removeInvalidFilesFromStacks();
        PlaceInfo target2 = this.getTargetForwardInfo();
        if (target2 == null) {
            return;
        }
        this.myForwardInProgress = true;
        try {
            this.executeCommand(() -> this.gotoPlaceInfo(target2), "", null);
        }
        finally {
            this.myForwardInProgress = false;
        }
    }

    private PlaceInfo getTargetForwardInfo() {
        if (this.myForwardPlaces.isEmpty()) {
            return null;
        }
        PlaceInfo target2 = this.myForwardPlaces.removeLast();
        PlaceInfo current = this.getCurrentPlaceInfo();
        while (!this.myForwardPlaces.isEmpty() && current != null && IdeDocumentHistoryImpl.isSame(current, target2)) {
            target2 = this.myForwardPlaces.removeLast();
        }
        return target2;
    }

    @Override
    public final boolean isBackAvailable() {
        return !this.myBackPlaces.isEmpty();
    }

    @Override
    public final boolean isForwardAvailable() {
        return !this.myForwardPlaces.isEmpty();
    }

    @Override
    public final void navigatePreviousChange() {
        this.removeInvalidFilesFromStacks();
        if (this.myCurrentIndex == 0) {
            return;
        }
        int index = this.myCurrentIndex - 1;
        PlaceInfo info = this.myChangePlaces.get(index);
        this.executeCommand(() -> this.gotoPlaceInfo(info), "", null);
        this.myCurrentIndex = index;
    }

    @Override
    public final boolean isNavigatePreviousChangeAvailable() {
        return this.myCurrentIndex > 0;
    }

    void removeInvalidFilesFromStacks() {
        IdeDocumentHistoryImpl.removeInvalidFilesFrom(this.myBackPlaces);
        IdeDocumentHistoryImpl.removeInvalidFilesFrom(this.myForwardPlaces);
        if (IdeDocumentHistoryImpl.removeInvalidFilesFrom(this.myChangePlaces)) {
            this.myCurrentIndex = this.myChangePlaces.size();
        }
    }

    @Override
    public void navigateNextChange() {
        this.removeInvalidFilesFromStacks();
        if (this.myCurrentIndex >= this.myChangePlaces.size() - 1) {
            return;
        }
        int index = this.myCurrentIndex + 1;
        PlaceInfo info = this.myChangePlaces.get(index);
        this.executeCommand(() -> this.gotoPlaceInfo(info), "", null);
        this.myCurrentIndex = index;
    }

    @Override
    public boolean isNavigateNextChangeAvailable() {
        return this.myCurrentIndex < this.myChangePlaces.size() - 1;
    }

    private static boolean removeInvalidFilesFrom(@NotNull List<PlaceInfo> backPlaces) {
        if (backPlaces == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(5);
        }
        boolean removed = false;
        Iterator<PlaceInfo> iterator = backPlaces.iterator();
        while (iterator.hasNext()) {
            PlaceInfo info = iterator.next();
            VirtualFile file2 = info.myFile;
            if (file2.isValid()) continue;
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    private void gotoPlaceInfo(@NotNull PlaceInfo info) {
        if (info == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(6);
        }
        boolean wasActive = ToolWindowManager.getInstance((Project)this.myProject).isEditorComponentActive();
        EditorWindow wnd = info.getWindow();
        FileEditorManagerEx editorManager = this.myFileEditorManager;
        Pair<FileEditor[], FileEditorProvider[]> editorsWithProviders = wnd != null && wnd.isValid() ? editorManager.openFileWithProviders(info.getFile(), wasActive, wnd) : editorManager.openFileWithProviders(info.getFile(), wasActive, false);
        editorManager.setSelectedEditor(info.getFile(), info.getEditorTypeId());
        FileEditor[] editors = (FileEditor[])editorsWithProviders.getFirst();
        FileEditorProvider[] providers = (FileEditorProvider[])editorsWithProviders.getSecond();
        for (int i = 0; i < editors.length; ++i) {
            String typeId = providers[i].getEditorTypeId();
            if (!typeId.equals(info.getEditorTypeId())) continue;
            editors[i].setState(info.getNavigationState());
        }
    }

    @Nullable
    protected FileEditorWithProvider getSelectedEditor() {
        FileEditorManagerEx editorManager = this.myFileEditorManager;
        VirtualFile file2 = editorManager.getCurrentFile();
        return file2 == null ? null : editorManager.getSelectedEditorWithProvider(file2);
    }

    protected PlaceInfo createPlaceInfo(@NotNull FileEditor fileEditor, FileEditorProvider fileProvider) {
        if (fileEditor == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(7);
        }
        if (!fileEditor.isValid()) {
            return null;
        }
        FileEditorManagerEx editorManager = this.myFileEditorManager;
        VirtualFile file2 = editorManager.getFile(fileEditor);
        LOG.assertTrue(file2 != null);
        FileEditorState state = fileEditor.getState(FileEditorStateLevel.NAVIGATION);
        return new PlaceInfo(file2, state, fileProvider.getEditorTypeId(), editorManager.getCurrentWindow());
    }

    private static void putLastOrMerge(@NotNull LinkedList<PlaceInfo> list2, @NotNull PlaceInfo next) {
        PlaceInfo prev2;
        if (list2 == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(8);
        }
        if (next == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(9);
        }
        if (!list2.isEmpty() && IdeDocumentHistoryImpl.isSame(prev2 = list2.getLast(), next)) {
            list2.removeLast();
        }
        list2.add(next);
        if (list2.size() > BACK_QUEUE_LIMIT) {
            list2.removeFirst();
        }
    }

    private FileDocumentManager getFileDocumentManager() {
        if (this.myFileDocumentManager == null) {
            this.myFileDocumentManager = FileDocumentManager.getInstance();
        }
        return this.myFileDocumentManager;
    }

    @NotNull
    List<PlaceInfo> getBackPlaces() {
        LinkedList<PlaceInfo> linkedList = this.myBackPlaces;
        if (linkedList == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(10);
        }
        return linkedList;
    }

    public final void dispose() {
        this.myLastGroupId = null;
    }

    protected void executeCommand(Runnable runnable2, String name, Object groupId) {
        CommandProcessor.getInstance().executeCommand(this.myProject, runnable2, name, groupId);
    }

    private static boolean isSame(@NotNull PlaceInfo first, @NotNull PlaceInfo second) {
        if (first == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(11);
        }
        if (second == null) {
            IdeDocumentHistoryImpl.$$$reportNull$$$0(12);
        }
        if (first.getFile().equals(second.getFile())) {
            FileEditorState secondState;
            FileEditorState firstState = first.getNavigationState();
            return firstState.equals(secondState = second.getNavigationState()) || firstState.canBeMergedWith(secondState, FileEditorStateLevel.NAVIGATION);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backPlaces";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackPlaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setFileEditorManager";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRecentlyChanged";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeInvalidFilesFrom";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "gotoPlaceInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPlaceInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putLastOrMerge";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSame";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class PlaceInfo {
        private final VirtualFile myFile;
        private final FileEditorState myNavigationState;
        private final String myEditorTypeId;
        private final Reference<EditorWindow> myWindow;

        public PlaceInfo(@NotNull VirtualFile file2, @NotNull FileEditorState navigationState, @NotNull String editorTypeId, @Nullable EditorWindow window) {
            if (file2 == null) {
                PlaceInfo.$$$reportNull$$$0(0);
            }
            if (navigationState == null) {
                PlaceInfo.$$$reportNull$$$0(1);
            }
            if (editorTypeId == null) {
                PlaceInfo.$$$reportNull$$$0(2);
            }
            this.myNavigationState = navigationState;
            this.myFile = file2;
            this.myEditorTypeId = editorTypeId;
            this.myWindow = new WeakReference<EditorWindow>(window);
        }

        public EditorWindow getWindow() {
            return this.myWindow.get();
        }

        @NotNull
        private FileEditorState getNavigationState() {
            FileEditorState fileEditorState = this.myNavigationState;
            if (fileEditorState == null) {
                PlaceInfo.$$$reportNull$$$0(3);
            }
            return fileEditorState;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                PlaceInfo.$$$reportNull$$$0(4);
            }
            return virtualFile;
        }

        @NotNull
        public String getEditorTypeId() {
            String string = this.myEditorTypeId;
            if (string == null) {
                PlaceInfo.$$$reportNull$$$0(5);
            }
            return string;
        }

        public String toString() {
            return this.getFile().getName() + " " + this.getNavigationState();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editorTypeId";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationState";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorTypeId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RecentlyChangedFilesState {
        public List<String> CHANGED_PATHS = new ArrayList<String>();

        public void register(VirtualFile file2) {
            String path = file2.getPath();
            this.CHANGED_PATHS.remove(path);
            this.CHANGED_PATHS.add(path);
            this.trimToSize();
        }

        private void trimToSize() {
            int limit = UISettings.getInstance().getRecentFilesLimit() + 1;
            while (this.CHANGED_PATHS.size() > limit) {
                this.CHANGED_PATHS.remove(0);
            }
        }
    }
}

