/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.PlatformModuleRendererFactory;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class SearchEverywherePsiRenderer
extends PsiElementListCellRenderer<PsiElement> {
    private final JList myList;

    public SearchEverywherePsiRenderer(JList list2) {
        this.myList = list2;
        this.setFocusBorderEnabled(false);
        this.setLayout(new BorderLayout(){

            @Override
            public void layoutContainer(Container target2) {
                super.layoutContainer(target2);
                Component right = this.getLayoutComponent("East");
                Component left = this.getLayoutComponent("West");
                if (right != null && left != null && left.getBounds().x + left.getBounds().width > right.getBounds().x) {
                    Rectangle bounds2 = right.getBounds();
                    int newX = left.getBounds().x + left.getBounds().width;
                    right.setBounds(newX, bounds2.y, bounds2.width - (newX - bounds2.x), bounds2.height);
                }
            }
        });
    }

    @Override
    public String getElementText(PsiElement element) {
        VirtualFile file2;
        Object object = element instanceof PsiFile ? PsiUtilCore.getVirtualFile((PsiElement)element) : (file2 = element instanceof VirtualFile ? (VirtualFile)element : null);
        if (file2 != null) {
            return VfsPresentationUtil.getPresentableNameForUI(element.getProject(), file2);
        }
        String name = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : null;
        return StringUtil.notNullize((String)name, (String)"<unnamed>");
    }

    @Override
    protected String getContainerText(PsiElement element, String name) {
        return this.getSymbolContainerText(name, element);
    }

    private String getSymbolContainerText(String name, PsiElement element) {
        boolean in;
        String text = SymbolPresentationUtil.getSymbolContainerText(element);
        if (this.myList.getWidth() == 0) {
            return text;
        }
        if (text == null) {
            return null;
        }
        if (text.startsWith("(") && text.endsWith(")")) {
            text = text.substring(1, text.length() - 1);
        }
        if ((text.contains("/") || text.contains(File.separator)) && element instanceof PsiFileSystemItem) {
            Project project = element.getProject();
            String basePath = Optional.ofNullable(project.getBasePath()).map(FileUtil::toSystemDependentName).orElse(null);
            VirtualFile file2 = ((PsiFileSystemItem)element).getVirtualFile();
            if (file2 != null) {
                text = FileUtil.toSystemDependentName((String)text);
                String filePath = FileUtil.toSystemDependentName((String)file2.getPath());
                if (basePath != null && FileUtil.isAncestor((String)basePath, (String)filePath, (boolean)true)) {
                    text = (String)ObjectUtils.notNull((Object)FileUtil.getRelativePath((String)basePath, (String)text, (char)File.separatorChar), (Object)text);
                } else {
                    String rootPath = Optional.ofNullable(GotoFileCellRenderer.getAnyRoot(file2, project)).map(root -> FileUtil.toSystemDependentName((String)root.getPath())).filter(root -> basePath != null && FileUtil.isAncestor((String)basePath, (String)root, (boolean)true)).orElse(null);
                    String string = text = rootPath != null ? (String)ObjectUtils.notNull((Object)FileUtil.getRelativePath((String)rootPath, (String)text, (char)File.separatorChar), (Object)text) : FileUtil.getLocationRelativeToUserHome((String)text);
                }
            }
        }
        if (in = text.startsWith("in ")) {
            text = text.substring(3);
        }
        FontMetrics fm = this.myList.getFontMetrics(this.myList.getFont());
        int maxWidth = this.myList.getWidth() - fm.stringWidth(name) - 16 - this.myRightComponentWidth - 20;
        String left = in ? "(in " : "(";
        String right = ")";
        String adjustedText = left + text + right;
        int fullWidth = fm.stringWidth(adjustedText);
        if (fullWidth < maxWidth) {
            return adjustedText;
        }
        String separator = text.contains("/") ? "/" : (SystemInfo.isWindows && text.contains("\\") ? "\\" : (text.contains(".") ? "." : (text.contains("-") ? "-" : " ")));
        LinkedList<String> parts = new LinkedList<String>(StringUtil.split((String)text, (String)separator));
        while (parts.size() > 1) {
            int index = parts.size() / 2 - 1;
            parts.remove(index);
            if (fm.stringWidth(StringUtil.join(parts, (String)separator) + "...") >= maxWidth) continue;
            parts.add(index, "...");
            return left + StringUtil.join(parts, (String)separator) + right;
        }
        int adjustedWidth = Math.max(adjustedText.length() * maxWidth / fullWidth - 1, left.length() + right.length() + 3);
        return StringUtil.trimMiddle((String)adjustedText, (int)adjustedWidth);
    }

    @Override
    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value, int index, boolean selected, boolean hasFocus) {
        return GotoFileCellRenderer.doCustomizeNonPsiElementLeftRenderer(renderer, list2, value, this.getNavigationItemAttributes(value));
    }

    @Override
    protected DefaultListCellRenderer getRightCellRenderer(Object value) {
        DefaultListCellRenderer rightRenderer = super.getRightCellRenderer(value);
        if (rightRenderer instanceof PlatformModuleRendererFactory.PlatformModuleRenderer) {
            return null;
        }
        return rightRenderer;
    }

    @Override
    protected int getIconFlags() {
        return 2;
    }
}

