/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.util.CaretVisualPositionKeeper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatCodeProcessor
extends AbstractLayoutCodeProcessor {
    public static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.ReformatCodeProcessor");
    private static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"reformat.progress.common.text", (Object[])new Object[0]);
    private final Collection<TextRange> myRanges;
    private SelectionModel mySelectionModel;

    public ReformatCodeProcessor(Project project, boolean processChangedTextOnly) {
        super(project, COMMAND_NAME, PROGRESS_TEXT, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, @NotNull SelectionModel selectionModel) {
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(0);
        }
        if (selectionModel == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(1);
        }
        super(file2.getProject(), file2, PROGRESS_TEXT, COMMAND_NAME, false);
        this.myRanges = new ArrayList<TextRange>();
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor2, @NotNull SelectionModel selectionModel) {
        if (selectionModel == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(2);
        }
        super(processor2, COMMAND_NAME, PROGRESS_TEXT);
        this.myRanges = new ArrayList<TextRange>();
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor2, boolean processChangedTextOnly) {
        super(processor2, COMMAND_NAME, PROGRESS_TEXT);
        this.myRanges = new ArrayList<TextRange>();
        this.setProcessChangedTextOnly(processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, Module module, boolean processChangedTextOnly) {
        super(project, module, COMMAND_NAME, PROGRESS_TEXT, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project, PsiDirectory directory, boolean includeSubdirs, boolean processChangedTextOnly) {
        super(project, directory, includeSubdirs, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project, PsiFile file2, @Nullable TextRange range2, boolean processChangedTextOnly) {
        super(project, file2, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
        if (range2 != null) {
            this.myRanges.add(range2);
        }
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(3);
        }
        super(file2.getProject(), file2, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project, PsiFile[] files2, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        this(project, files2, COMMAND_NAME, postRunnable, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project, PsiFile[] files2, String commandName, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        super(project, files2, PROGRESS_TEXT, commandName, postRunnable, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) throws IncorrectOperationException {
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(4);
        }
        ReformatCodeProcessor.assertFileIsValid(file2);
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(() -> {
            FormattingProgressTask.FORMATTING_CANCELLED_FLAG.set(false);
            try {
                CharSequence before = null;
                Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2);
                if (this.getInfoCollector() != null) {
                    LOG.assertTrue(document != null);
                    before = document.getImmutableCharSequence();
                }
                CaretVisualPositionKeeper caretPositionKeeper = new CaretVisualPositionKeeper(document);
                if (processChangedTextOnly) {
                    ChangedRangesInfo info = FormatChangedTextUtil.getInstance().getChangedRangesInfo(file2);
                    if (info != null) {
                        ReformatCodeProcessor.assertFileIsValid(file2);
                        CodeStyleManager.getInstance((Project)this.myProject).reformatTextWithContext(file2, info);
                    }
                } else {
                    Collection<TextRange> ranges = this.getRangesToFormat(file2);
                    CodeStyleManager.getInstance((Project)this.myProject).reformatText(file2, ranges);
                }
                caretPositionKeeper.restoreOriginalLocation(true);
                if (before != null) {
                    this.prepareUserNotificationMessage(document, before);
                }
                Boolean bl = FormattingProgressTask.FORMATTING_CANCELLED_FLAG.get() == false;
                return bl;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                Boolean bl = false;
                return bl;
            }
            finally {
                this.myRanges.clear();
            }
        });
        if (futureTask == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(5);
        }
        return futureTask;
    }

    private static void assertFileIsValid(@NotNull PsiFile file2) {
        if (file2 == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(6);
        }
        if (!file2.isValid()) {
            LOG.error("Invalid Psi file, name: " + file2.getName() + " , class: " + file2.getClass().getSimpleName() + " , " + PsiInvalidElementAccessException.findOutInvalidationReason((PsiElement)file2));
        }
    }

    private void prepareUserNotificationMessage(@NotNull Document document, @NotNull CharSequence before) {
        if (document == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(7);
        }
        if (before == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(8);
        }
        LOG.assertTrue(this.getInfoCollector() != null);
        int number = FormatChangedTextUtil.getInstance().calculateChangedLinesNumber(document, before);
        if (number > 0) {
            String message = "formatted " + number + " line" + (number > 1 ? "s" : "");
            this.getInfoCollector().setReformatCodeNotification(message);
        }
    }

    @NotNull
    private Collection<TextRange> getRangesToFormat(PsiFile file2) {
        if (this.mySelectionModel != null) {
            List<TextRange> list2 = ReformatCodeProcessor.getSelectedRanges(this.mySelectionModel);
            if (list2 == null) {
                ReformatCodeProcessor.$$$reportNull$$$0(9);
            }
            return list2;
        }
        ArrayList arrayList = !this.myRanges.isEmpty() ? this.myRanges : ContainerUtil.newArrayList((Object[])new TextRange[]{file2.getTextRange()});
        if (arrayList == null) {
            ReformatCodeProcessor.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/ReformatCodeProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/ReformatCodeProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTask";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesToFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareTask";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertFileIsValid";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareUserNotificationMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

