/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class IncludeExcludeBasedFilter
implements Filter {
    private final IncludeExclude<String> _mimeTypes = new IncludeExclude();
    private final IncludeExclude<String> _httpMethods = new IncludeExclude();
    private final IncludeExclude<String> _paths = new IncludeExclude(PathSpecSet.class);
    private static final Logger LOG = Log.getLogger(IncludeExcludeBasedFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        String included_paths = filterConfig.getInitParameter("includedPaths");
        String excluded_paths = filterConfig.getInitParameter("excludedPaths");
        String included_mime_types = filterConfig.getInitParameter("includedMimeTypes");
        String excluded_mime_types = filterConfig.getInitParameter("excludedMimeTypes");
        String included_http_methods = filterConfig.getInitParameter("includedHttpMethods");
        String excluded_http_methods = filterConfig.getInitParameter("excludedHttpMethods");
        if (included_paths != null) {
            this._paths.include((Object[])StringUtil.csvSplit((String)included_paths));
        }
        if (excluded_paths != null) {
            this._paths.exclude((Object[])StringUtil.csvSplit((String)excluded_paths));
        }
        if (included_mime_types != null) {
            this._mimeTypes.include((Object[])StringUtil.csvSplit((String)included_mime_types));
        }
        if (excluded_mime_types != null) {
            this._mimeTypes.exclude((Object[])StringUtil.csvSplit((String)excluded_mime_types));
        }
        if (included_http_methods != null) {
            this._httpMethods.include((Object[])StringUtil.csvSplit((String)included_http_methods));
        }
        if (excluded_http_methods != null) {
            this._httpMethods.exclude((Object[])StringUtil.csvSplit((String)excluded_http_methods));
        }
    }

    protected String guessMimeType(HttpServletRequest http_request, HttpServletResponse http_response) {
        String content_type = http_response.getContentType();
        LOG.debug("Content Type is: {}", new Object[]{content_type});
        String mime_type = "";
        if (content_type != null) {
            mime_type = MimeTypes.getContentTypeWithoutCharset((String)content_type);
            LOG.debug("Mime Type is: {}", new Object[]{mime_type});
        } else {
            String request_url = http_request.getPathInfo();
            mime_type = MimeTypes.getDefaultMimeByExtension((String)request_url);
            if (mime_type == null) {
                mime_type = "";
            }
            LOG.debug("Guessed mime type is {}", new Object[]{mime_type});
        }
        return mime_type;
    }

    protected boolean shouldFilter(HttpServletRequest http_request, HttpServletResponse http_response) {
        String http_method = http_request.getMethod();
        LOG.debug("HTTP method is: {}", new Object[]{http_method});
        if (!this._httpMethods.test((Object)http_method)) {
            LOG.debug("should not apply filter because HTTP method does not match", new Object[0]);
            return false;
        }
        String mime_type = this.guessMimeType(http_request, http_response);
        if (!this._mimeTypes.test((Object)mime_type)) {
            LOG.debug("should not apply filter because mime type does not match", new Object[0]);
            return false;
        }
        ServletContext context = http_request.getServletContext();
        String path = context == null ? http_request.getRequestURI() : URIUtil.addPaths((String)http_request.getServletPath(), (String)http_request.getPathInfo());
        LOG.debug("Path is: {}", new Object[]{path});
        if (!this._paths.test((Object)path)) {
            LOG.debug("should not apply filter because path does not match", new Object[0]);
            return false;
        }
        return true;
    }

    public void destroy() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("filter configuration:\n");
        sb.append("paths:\n").append(this._paths).append("\n");
        sb.append("mime types:\n").append(this._mimeTypes).append("\n");
        sb.append("http methods:\n").append(this._httpMethods);
        return sb.toString();
    }
}

