/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.Filter;
import co.elastic.logstash.api.Input;
import co.elastic.logstash.api.Output;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.common.AbstractDeadLetterQueueWriterExt;
import org.logstash.common.DLQWriterAdapter;
import org.logstash.common.NullDeadLetterQueueWriter;
import org.logstash.common.io.DeadLetterQueueWriter;
import org.logstash.config.ir.PipelineIR;
import org.logstash.config.ir.compiler.AbstractFilterDelegatorExt;
import org.logstash.config.ir.compiler.AbstractOutputDelegatorExt;
import org.logstash.config.ir.compiler.FilterDelegatorExt;
import org.logstash.config.ir.compiler.JavaCodecDelegator;
import org.logstash.config.ir.compiler.JavaFilterDelegatorExt;
import org.logstash.config.ir.compiler.JavaInputDelegatorExt;
import org.logstash.config.ir.compiler.JavaOutputDelegatorExt;
import org.logstash.config.ir.compiler.OutputDelegatorExt;
import org.logstash.config.ir.compiler.OutputStrategyExt;
import org.logstash.config.ir.compiler.RubyIntegration;
import org.logstash.config.ir.graph.Vertex;
import org.logstash.execution.ExecutionContextExt;
import org.logstash.execution.JavaBasePipelineExt;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.instrument.metrics.NullMetricExt;
import org.logstash.plugins.ConfigurationImpl;
import org.logstash.plugins.ContextImpl;
import org.logstash.plugins.NamespacedMetricImpl;
import org.logstash.plugins.PluginLookup;
import org.logstash.plugins.PluginUtil;

public final class PluginFactoryExt {

    @JRubyClass(name={"PluginMetricFactory"})
    public static final class Metrics
    extends RubyBasicObject {
        private static final long serialVersionUID = 1L;
        private static final RubySymbol PLUGINS = RubyUtil.RUBY.newSymbol("plugins");
        private RubySymbol pipelineId;
        private AbstractMetricExt metric;

        public Metrics(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod
        public Metrics initialize(ThreadContext context, IRubyObject pipelineId, IRubyObject metrics) {
            this.pipelineId = pipelineId.convertToString().intern();
            this.metric = metrics.isNil() ? new NullMetricExt(context.runtime, RubyUtil.NULL_METRIC_CLASS) : (AbstractMetricExt)metrics;
            return this;
        }

        AbstractNamespacedMetricExt getRoot(ThreadContext context) {
            return this.metric.namespace(context, (IRubyObject)RubyArray.newArray((Ruby)context.runtime, Arrays.asList(MetricKeys.STATS_KEY, MetricKeys.PIPELINES_KEY, this.pipelineId, PLUGINS)));
        }

        @JRubyMethod
        public AbstractNamespacedMetricExt create(ThreadContext context, IRubyObject pluginType) {
            return this.getRoot(context).namespace(context, (IRubyObject)RubyUtil.RUBY.newSymbol(String.format("%ss", pluginType.asJavaString())));
        }
    }

    @JRubyClass(name={"ExecutionContextFactory"})
    public static final class ExecutionContext
    extends RubyBasicObject {
        private static final long serialVersionUID = 1L;
        private IRubyObject agent;
        private IRubyObject pipeline;
        private IRubyObject dlqWriter;

        public ExecutionContext(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod
        public ExecutionContext initialize(ThreadContext context, IRubyObject agent, IRubyObject pipeline, IRubyObject dlqWriter) {
            this.agent = agent;
            this.pipeline = pipeline;
            this.dlqWriter = dlqWriter;
            return this;
        }

        @JRubyMethod
        public ExecutionContextExt create(ThreadContext context, IRubyObject id, IRubyObject classConfigName) {
            return new ExecutionContextExt(context.runtime, RubyUtil.EXECUTION_CONTEXT_CLASS).initialize(context, new IRubyObject[]{this.pipeline, this.agent, id, classConfigName, this.dlqWriter});
        }

        public Context toContext(PluginLookup.PluginType pluginType, AbstractNamespacedMetricExt metric) {
            IRubyObject innerWriter;
            co.elastic.logstash.api.DeadLetterQueueWriter dlq = NullDeadLetterQueueWriter.getInstance();
            if (pluginType == PluginLookup.PluginType.OUTPUT && this.dlqWriter instanceof AbstractDeadLetterQueueWriterExt.PluginDeadLetterQueueWriterExt && (innerWriter = ((AbstractDeadLetterQueueWriterExt.PluginDeadLetterQueueWriterExt)this.dlqWriter).innerWriter(RubyUtil.RUBY.getCurrentContext())) != null && DeadLetterQueueWriter.class.isAssignableFrom(innerWriter.getJavaClass())) {
                dlq = new DLQWriterAdapter((DeadLetterQueueWriter)innerWriter.toJava(DeadLetterQueueWriter.class));
            }
            return new ContextImpl(dlq, new NamespacedMetricImpl(RubyUtil.RUBY.getCurrentContext(), metric));
        }
    }

    @JRubyClass(name={"PluginFactory"})
    public static final class Plugins
    extends RubyBasicObject
    implements RubyIntegration.PluginFactory {
        private static final long serialVersionUID = 1L;
        private static final RubyString ID_KEY = RubyUtil.RUBY.newString("id");
        private final Collection<String> pluginsById = new HashSet<String>();
        private PipelineIR lir;
        private ExecutionContext executionContext;
        private Metrics metrics;
        private RubyClass filterClass;

        @JRubyMethod(name={"filter_delegator"}, meta=true, required=5)
        public static IRubyObject filterDelegator(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
            RubyHash arguments = (RubyHash)args[2];
            IRubyObject filterInstance = args[1].callMethod(context, "new", (IRubyObject)arguments);
            RubyString id = (RubyString)arguments.op_aref(context, (IRubyObject)ID_KEY);
            filterInstance.callMethod(context, "metric=", (IRubyObject)((AbstractMetricExt)args[3]).namespace(context, (IRubyObject)id.intern()));
            filterInstance.callMethod(context, "execution_context=", args[4]);
            return new FilterDelegatorExt(context.runtime, RubyUtil.FILTER_DELEGATOR_CLASS).initialize(context, filterInstance, (IRubyObject)id);
        }

        public Plugins(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod(required=4)
        public Plugins initialize(ThreadContext context, IRubyObject[] args) {
            return this.init((PipelineIR)args[0].toJava(PipelineIR.class), (Metrics)args[1], (ExecutionContext)args[2], (RubyClass)args[3]);
        }

        public Plugins init(PipelineIR lir, Metrics metrics, ExecutionContext executionContext, RubyClass filterClass) {
            this.lir = lir;
            this.metrics = metrics;
            this.executionContext = executionContext;
            this.filterClass = filterClass;
            return this;
        }

        @Override
        public IRubyObject buildInput(RubyString name, RubyInteger line, RubyInteger column, IRubyObject args, Map<String, Object> pluginArgs) {
            return this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.INPUT, name.asJavaString(), line.getIntValue(), column.getIntValue(), (Map)args, pluginArgs);
        }

        @JRubyMethod(required=4)
        public IRubyObject buildInput(ThreadContext context, IRubyObject[] args) {
            return this.buildInput((RubyString)args[0], args[1].convertToInteger(), args[2].convertToInteger(), args[3], null);
        }

        @Override
        public AbstractOutputDelegatorExt buildOutput(RubyString name, RubyInteger line, RubyInteger column, IRubyObject args, Map<String, Object> pluginArgs) {
            return (AbstractOutputDelegatorExt)this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.OUTPUT, name.asJavaString(), line.getIntValue(), column.getIntValue(), (Map)args, pluginArgs);
        }

        @JRubyMethod(required=4)
        public AbstractOutputDelegatorExt buildOutput(ThreadContext context, IRubyObject[] args) {
            return this.buildOutput((RubyString)args[0], args[1].convertToInteger(), args[2].convertToInteger(), args[3], null);
        }

        @Override
        public AbstractFilterDelegatorExt buildFilter(RubyString name, RubyInteger line, RubyInteger column, IRubyObject args, Map<String, Object> pluginArgs) {
            return (AbstractFilterDelegatorExt)this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.FILTER, name.asJavaString(), line.getIntValue(), column.getIntValue(), (Map)args, pluginArgs);
        }

        @Override
        public IRubyObject buildCodec(RubyString name, IRubyObject args, Map<String, Object> pluginArgs) {
            return this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.CODEC, name.asJavaString(), 0, 0, (Map)args, pluginArgs);
        }

        @Override
        public Codec buildDefaultCodec(String codecName) {
            return (Codec)JavaUtil.unwrapJavaValue((IRubyObject)this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.CODEC, codecName, 0, 0, Collections.emptyMap(), Collections.emptyMap()));
        }

        @JRubyMethod(required=4, optional=1)
        public IRubyObject plugin(ThreadContext context, IRubyObject[] args) {
            return this.plugin(context, PluginLookup.PluginType.valueOf(args[0].asJavaString().toUpperCase(Locale.ENGLISH)), args[1].asJavaString(), args[2].convertToInteger().getIntValue(), args[3].convertToInteger().getIntValue(), args.length > 4 ? (Map)args[4] : new HashMap(), null);
        }

        private IRubyObject plugin(ThreadContext context, PluginLookup.PluginType type, String name, int line, int column, Map<String, IRubyObject> args, Map<String, Object> pluginArgs) {
            PluginLookup.PluginClass pluginClass = PluginLookup.lookup(type, name);
            String id = type == PluginLookup.PluginType.CODEC ? UUID.randomUUID().toString() : (String)this.lir.getGraph().vertices().filter(v -> v.getSourceWithMetadata() != null && v.getSourceWithMetadata().getLine() == line && v.getSourceWithMetadata().getColumn() == column).findFirst().map(Vertex::getId).orElse(null);
            if (id == null) {
                throw context.runtime.newRaiseException(RubyUtil.CONFIGURATION_ERROR_CLASS, String.format("Could not determine ID for %s/%s", type.rubyLabel().asJavaString(), name));
            }
            if (this.pluginsById.contains(id)) {
                throw context.runtime.newRaiseException(RubyUtil.CONFIGURATION_ERROR_CLASS, String.format("Two plugins have the id '%s', please fix this conflict", id));
            }
            this.pluginsById.add(id);
            AbstractNamespacedMetricExt typeScopedMetric = this.metrics.create(context, (IRubyObject)type.rubyLabel());
            if (pluginClass.language() == PluginLookup.PluginLanguage.RUBY) {
                HashMap<String, IRubyObject> newArgs = new HashMap<String, IRubyObject>(args);
                newArgs.put("id", (IRubyObject)id);
                RubyClass klass = (RubyClass)pluginClass.klass();
                ExecutionContextExt executionCntx = this.executionContext.create(context, (IRubyObject)RubyUtil.RUBY.newString(id), klass.callMethod(context, "config_name"));
                RubyHash rubyArgs = RubyHash.newHash((Ruby)context.runtime);
                rubyArgs.putAll(newArgs);
                if (type == PluginLookup.PluginType.OUTPUT) {
                    return new OutputDelegatorExt(context.runtime, RubyUtil.RUBY_OUTPUT_DELEGATOR_CLASS).initialize(context, new IRubyObject[]{klass, typeScopedMetric, executionCntx, OutputStrategyExt.OutputStrategyRegistryExt.instance(context, null), rubyArgs});
                }
                if (type == PluginLookup.PluginType.FILTER) {
                    return Plugins.filterDelegator(context, null, new IRubyObject[]{this.filterClass, klass, rubyArgs, typeScopedMetric, executionCntx});
                }
                IRubyObject pluginInstance = klass.callMethod(context, "new", (IRubyObject)rubyArgs);
                AbstractNamespacedMetricExt scopedMetric = typeScopedMetric.namespace(context, (IRubyObject)RubyUtil.RUBY.newSymbol(id));
                scopedMetric.gauge(context, (IRubyObject)MetricKeys.NAME_KEY, pluginInstance.callMethod(context, "config_name"));
                pluginInstance.callMethod(context, "metric=", (IRubyObject)scopedMetric);
                pluginInstance.callMethod(context, "execution_context=", (IRubyObject)executionCntx);
                return pluginInstance;
            }
            if (pluginArgs == null) {
                String err = String.format("Cannot start the Java plugin '%s' in the Ruby execution engine. The Java execution engine is required to run Java plugins.", name);
                throw new IllegalStateException(err);
            }
            if (type == PluginLookup.PluginType.OUTPUT) {
                Class cls = (Class)pluginClass.klass();
                Output output = null;
                if (cls != null) {
                    try {
                        Constructor ctor = cls.getConstructor(String.class, Configuration.class, Context.class);
                        ConfigurationImpl config = new ConfigurationImpl(pluginArgs, this);
                        output = (Output)ctor.newInstance(id, config, this.executionContext.toContext(type, this.metrics.getRoot(context)));
                        PluginUtil.validateConfig(output, config);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        if (ex instanceof InvocationTargetException && ex.getCause() != null) {
                            throw new IllegalStateException(ex.getCause());
                        }
                        throw new IllegalStateException(ex);
                    }
                }
                if (output != null) {
                    return JavaOutputDelegatorExt.create(name, id, typeScopedMetric, output);
                }
                throw new IllegalStateException("Unable to instantiate output: " + pluginClass);
            }
            if (type == PluginLookup.PluginType.FILTER) {
                Class cls = (Class)pluginClass.klass();
                Filter filter = null;
                if (cls != null) {
                    try {
                        Constructor ctor = cls.getConstructor(String.class, Configuration.class, Context.class);
                        ConfigurationImpl config = new ConfigurationImpl(pluginArgs);
                        filter = (Filter)ctor.newInstance(id, config, this.executionContext.toContext(type, this.metrics.getRoot(context)));
                        PluginUtil.validateConfig(filter, config);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        if (ex instanceof InvocationTargetException && ex.getCause() != null) {
                            throw new IllegalStateException(ex.getCause());
                        }
                        throw new IllegalStateException(ex);
                    }
                }
                if (filter != null) {
                    return JavaFilterDelegatorExt.create(name, id, typeScopedMetric, filter, pluginArgs);
                }
                throw new IllegalStateException("Unable to instantiate filter: " + pluginClass);
            }
            if (type == PluginLookup.PluginType.INPUT) {
                Class cls = (Class)pluginClass.klass();
                Input input = null;
                if (cls != null) {
                    try {
                        Constructor ctor = cls.getConstructor(String.class, Configuration.class, Context.class);
                        ConfigurationImpl config = new ConfigurationImpl(pluginArgs, this);
                        input = (Input)ctor.newInstance(id, config, this.executionContext.toContext(type, this.metrics.getRoot(context)));
                        PluginUtil.validateConfig(input, config);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        if (ex instanceof InvocationTargetException && ex.getCause() != null) {
                            throw new IllegalStateException(ex.getCause());
                        }
                        throw new IllegalStateException(ex);
                    }
                }
                if (input != null) {
                    return JavaInputDelegatorExt.create((JavaBasePipelineExt)this.executionContext.pipeline, typeScopedMetric, input, pluginArgs);
                }
                throw new IllegalStateException("Unable to instantiate input: " + pluginClass);
            }
            if (type == PluginLookup.PluginType.CODEC) {
                Class cls = (Class)pluginClass.klass();
                if (cls != null) {
                    try {
                        Constructor ctor = cls.getConstructor(Configuration.class, Context.class);
                        ConfigurationImpl config = new ConfigurationImpl(pluginArgs);
                        Context pluginContext = this.executionContext.toContext(type, this.metrics.getRoot(context));
                        Codec codec = (Codec)ctor.newInstance(config, pluginContext);
                        PluginUtil.validateConfig(codec, config);
                        return JavaUtil.convertJavaToRuby((Ruby)RubyUtil.RUBY, (Object)new JavaCodecDelegator(pluginContext, codec));
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        if (ex instanceof InvocationTargetException && ex.getCause() != null) {
                            throw new IllegalStateException(ex.getCause());
                        }
                        throw new IllegalStateException(ex);
                    }
                }
                throw new IllegalStateException("Unable to instantiate codec: " + pluginClass);
            }
            throw new IllegalStateException("Unable to create plugin: " + pluginClass.toReadableString());
        }
    }
}

