"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSampleDashboardInput = getSampleDashboardInput;
exports.getSampleDashboardPanel = getSampleDashboardPanel;

var _public = require("../../../embeddable_api/public");

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function getSampleDashboardInput(overrides) {
  return _objectSpread({
    id: '123',
    filters: [],
    useMargins: false,
    isFullScreenMode: false,
    title: 'My Dashboard',
    query: {
      language: 'kuery',
      query: 'hi'
    },
    timeRange: {
      to: 'now',
      from: 'now-15m'
    },
    viewMode: _public.ViewMode.VIEW,
    panels: {}
  }, overrides);
}

function getSampleDashboardPanel(overrides) {
  return _objectSpread({
    gridData: {
      h: 15,
      w: 15,
      x: 0,
      y: 0,
      i: overrides.explicitInput.id
    },
    type: overrides.type,
    explicitInput: overrides.explicitInput
  }, overrides);
}