"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var globals_1 = require("../globals");
function buildAreaPointProps(_a) {
    var areaIndex = _a.areaIndex, pointIndex = _a.pointIndex, x = _a.x, y = _a.y, color = _a.color, pointStyleProps = _a.pointStyleProps;
    return __assign({ key: "area-point-" + areaIndex + "-" + pointIndex, x: x,
        y: y, stroke: color }, pointStyleProps, globals_1.GlobalKonvaElementProps);
}
exports.buildAreaPointProps = buildAreaPointProps;
function buildPointStyleProps(_a) {
    var radius = _a.radius, strokeWidth = _a.strokeWidth, opacity = _a.opacity, seriesPointStyle = _a.seriesPointStyle;
    var pointStrokeWidth = seriesPointStyle ? seriesPointStyle.strokeWidth : strokeWidth;
    return {
        radius: seriesPointStyle ? seriesPointStyle.radius : radius,
        strokeWidth: pointStrokeWidth,
        strokeEnabled: pointStrokeWidth !== 0,
        fill: 'white',
        opacity: seriesPointStyle ? seriesPointStyle.opacity : opacity,
    };
}
exports.buildPointStyleProps = buildPointStyleProps;
function buildAreaProps(_a) {
    var index = _a.index, areaPath = _a.areaPath, xTransform = _a.xTransform, color = _a.color, opacity = _a.opacity, seriesAreaStyle = _a.seriesAreaStyle;
    return __assign({ key: "area-" + index, data: areaPath, x: xTransform, fill: color, lineCap: 'round', lineJoin: 'round', opacity: seriesAreaStyle ? seriesAreaStyle.opacity : opacity }, globals_1.GlobalKonvaElementProps);
}
exports.buildAreaProps = buildAreaProps;
function buildAreaLineProps(_a) {
    var areaIndex = _a.areaIndex, lineIndex = _a.lineIndex, xTransform = _a.xTransform, linePath = _a.linePath, color = _a.color, strokeWidth = _a.strokeWidth, geometryStyle = _a.geometryStyle, seriesAreaLineStyle = _a.seriesAreaLineStyle;
    return __assign({ key: "area-" + areaIndex + "-line-" + lineIndex, data: linePath, x: xTransform, stroke: color, strokeWidth: seriesAreaLineStyle ? seriesAreaLineStyle.strokeWidth : strokeWidth, lineCap: 'round', lineJoin: 'round' }, geometryStyle, globals_1.GlobalKonvaElementProps);
}
exports.buildAreaLineProps = buildAreaLineProps;
function buildBarProps(_a) {
    var index = _a.index, x = _a.x, y = _a.y, width = _a.width, height = _a.height, fill = _a.fill, stroke = _a.stroke, strokeWidth = _a.strokeWidth, borderEnabled = _a.borderEnabled, geometryStyle = _a.geometryStyle;
    return __assign({ key: "bar-" + index, x: x,
        y: y,
        width: width,
        height: height,
        fill: fill,
        strokeWidth: strokeWidth,
        stroke: stroke, strokeEnabled: borderEnabled }, globals_1.GlobalKonvaElementProps, geometryStyle);
}
exports.buildBarProps = buildBarProps;
function rotateBarValueProps(chartRotation, chartDimensions, barDimensions, displayValueDimensions, displayValue, props) {
    var chartWidth = chartDimensions.width;
    var chartHeight = chartDimensions.height;
    var barWidth = barDimensions.width;
    var barHeight = barDimensions.height;
    var x = barDimensions.left;
    var y = barDimensions.top;
    var displayValueWidth = displayValueDimensions.width;
    var displayValueHeight = displayValueDimensions.height;
    var displayValueX = displayValueDimensions.left;
    var displayValueY = displayValueDimensions.top;
    var rotatedDisplayValueX = displayValueHeight > barWidth
        ? x - Math.abs(barWidth - displayValueHeight) / 2
        : x + Math.abs(barWidth - displayValueHeight) / 2;
    switch (chartRotation) {
        case 0:
            props.x = displayValueX;
            props.y = displayValueY;
            break;
        case 180:
            props.x = chartWidth - displayValueX - displayValueWidth;
            props.y = chartHeight - displayValueY - displayValueHeight;
            props.verticalAlign = 'bottom';
            break;
        case 90:
            props.x =
                barHeight >= displayValueWidth ? chartWidth - displayValueY - displayValueWidth : chartWidth - displayValueY;
            props.y = rotatedDisplayValueX;
            props.verticalAlign = 'middle';
            if (displayValue.isValueContainedInElement) {
                props.x = chartWidth - y - barHeight;
                props.y = x;
                props.width = barHeight >= displayValueWidth ? barHeight : 0;
                props.height = displayValue.height <= barWidth ? barWidth : 0;
                props.align = 'right';
            }
            break;
        case -90:
            props.x = barHeight >= displayValueWidth ? displayValueY : displayValueY - displayValueWidth;
            props.y = chartHeight - rotatedDisplayValueX - displayValueHeight;
            props.verticalAlign = 'middle';
            if (displayValue.isValueContainedInElement) {
                props.x = y;
                props.y = chartHeight - x - barWidth;
                props.width = barHeight >= displayValueWidth ? barHeight : 0;
                props.height = displayValue.height <= barWidth ? barWidth : 0;
                props.align = 'left';
            }
            break;
    }
    return props;
}
exports.rotateBarValueProps = rotateBarValueProps;
function getBarValueClipDimensions(displayValue, computedDimensions, barHeight, chartRotation) {
    var height = displayValue.isValueContainedInElement ? displayValue.height : computedDimensions.height;
    var width = displayValue.isValueContainedInElement ? displayValue.width : computedDimensions.width;
    var offsetY = chartRotation === 180 ? barHeight - displayValue.height : 0;
    var offsetX = chartRotation === 90 ? barHeight - displayValue.width : 0;
    return { height: height, width: width, offsetX: offsetX, offsetY: offsetY };
}
exports.getBarValueClipDimensions = getBarValueClipDimensions;
function isBarValueOverflow(chartDimensions, clip, valuePosition, hideClippedValue) {
    var chartHeight = chartDimensions.height;
    var chartWidth = chartDimensions.width;
    var isOverflowX = valuePosition.x + clip.width - valuePosition.offsetX > chartWidth ||
        valuePosition.x + clip.offsetX - valuePosition.offsetX < 0;
    var isOverflowY = valuePosition.y + clip.height - valuePosition.offsetY > chartHeight ||
        valuePosition.y + clip.offsetY - valuePosition.offsetY < 0;
    return !!hideClippedValue && (isOverflowX || isOverflowY);
}
exports.isBarValueOverflow = isBarValueOverflow;
function buildBarValueProps(_a) {
    var x = _a.x, y = _a.y, barHeight = _a.barHeight, barWidth = _a.barWidth, displayValueStyle = _a.displayValueStyle, displayValue = _a.displayValue, chartRotation = _a.chartRotation, chartDimensions = _a.chartDimensions;
    var padding = displayValueStyle.padding;
    var elementHeight = displayValue.isValueContainedInElement ? barHeight : displayValue.height;
    var displayValueHeight = elementHeight + padding;
    var displayValueWidth = displayValue.width + padding;
    var displayValueY = barHeight >= displayValueHeight ? y : y - displayValueHeight;
    var displayValueX = displayValueWidth > barWidth
        ? x - Math.abs(barWidth - displayValueWidth) / 2
        : x + Math.abs(barWidth - displayValueWidth) / 2;
    var displayValueOffsetY = displayValueStyle.offsetY || 0;
    var displayValueOffsetX = displayValueStyle.offsetX || 0;
    var baseProps = __assign({ align: 'center', verticalAlign: 'top' }, displayValueStyle, { text: displayValue.text, width: displayValueWidth, height: displayValueHeight, offsetY: displayValueOffsetY, x: displayValueX, y: displayValueY });
    var barDimensions = {
        width: barWidth,
        height: barHeight,
        left: x,
        top: y,
    };
    var displayValueDimensions = {
        width: displayValueWidth,
        height: displayValueHeight,
        left: displayValueX,
        top: displayValueY,
    };
    var props = rotateBarValueProps(chartRotation, chartDimensions, barDimensions, displayValueDimensions, displayValue, baseProps);
    var clip = getBarValueClipDimensions(displayValue, props, barHeight, chartRotation);
    var hideOverflow = isBarValueOverflow(chartDimensions, clip, { x: props.x, y: props.y, offsetX: displayValueOffsetX, offsetY: displayValueOffsetY }, displayValue.hideClippedValue);
    if (hideOverflow) {
        props.width = 0;
        props.height = 0;
    }
    return props;
}
exports.buildBarValueProps = buildBarValueProps;
function buildLinePointProps(_a) {
    var lineIndex = _a.lineIndex, pointIndex = _a.pointIndex, x = _a.x, y = _a.y, color = _a.color, pointStyleProps = _a.pointStyleProps;
    return __assign({ key: "line-point-" + lineIndex + "-" + pointIndex, x: x,
        y: y, stroke: color }, pointStyleProps, globals_1.GlobalKonvaElementProps);
}
exports.buildLinePointProps = buildLinePointProps;
function buildLineProps(_a) {
    var index = _a.index, xTransform = _a.xTransform, linePath = _a.linePath, color = _a.color, strokeWidth = _a.strokeWidth, geometryStyle = _a.geometryStyle, seriesLineStyle = _a.seriesLineStyle;
    return __assign({ key: "line-" + index, x: xTransform, data: linePath, stroke: color, strokeWidth: seriesLineStyle ? seriesLineStyle.strokeWidth : strokeWidth, lineCap: 'round', lineJoin: 'round' }, geometryStyle, globals_1.GlobalKonvaElementProps);
}
exports.buildLineProps = buildLineProps;
//# sourceMappingURL=rendering_props_utils.js.map