"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var mobx_react_1 = require("mobx-react");
var react_1 = __importDefault(require("react"));
var rendering_1 = require("../lib/series/rendering");
var HighlighterComponent = /** @class */ (function (_super) {
    __extends(HighlighterComponent, _super);
    function HighlighterComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    HighlighterComponent.prototype.render = function () {
        var _a = this.props.chartStore, highlightedGeometries = _a.highlightedGeometries, chartTransform = _a.chartTransform, chartDimensions = _a.chartDimensions, chartRotation = _a.chartRotation;
        var left = chartDimensions.left + chartTransform.x;
        var top = chartDimensions.top + chartTransform.y;
        return (react_1.default.createElement("svg", { className: "echHighlighter" },
            react_1.default.createElement("g", { transform: "translate(" + left + ", " + top + ") rotate(" + chartRotation + ")" }, highlightedGeometries.map(function (geom, i) {
                var color = geom.color, x = geom.x, y = geom.y;
                if (rendering_1.isPointGeometry(geom)) {
                    return (react_1.default.createElement("circle", { key: i, cx: x + geom.transform.x, cy: y, r: geom.radius, stroke: color, strokeWidth: 4, fill: "transparent" }));
                }
                return react_1.default.createElement("rect", { key: i, x: x, y: y, width: geom.width, height: geom.height, fill: "white", opacity: 0.4 });
            }))));
    };
    HighlighterComponent.displayName = 'Highlighter';
    return HighlighterComponent;
}(react_1.default.Component));
exports.Highlighter = mobx_react_1.inject('chartStore')(mobx_react_1.observer(HighlighterComponent));
//# sourceMappingURL=highlighter.js.map