/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class RectSelectWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        RectSelectWidget rectSelectWidget = new RectSelectWidget(view);
        return rectSelectWidget;
    }

    private static class RectSelectWidget
    implements Widget {
        private final JLabel rectSelect = new ToolTipLabel();
        private final View view;

        RectSelectWidget(final View view) {
            this.rectSelect.setHorizontalAlignment(0);
            this.rectSelect.setToolTipText(jEdit.getProperty("view.status.rect-tooltip"));
            this.view = view;
            this.rectSelect.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    JEditTextArea jEditTextArea = view.getTextArea();
                    if (jEditTextArea != null) {
                        jEditTextArea.toggleRectangularSelectionEnabled();
                    }
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.rectSelect;
        }

        @Override
        public void update() {
            JEditTextArea jEditTextArea = this.view.getTextArea();
            if (jEditTextArea != null) {
                if (jEditTextArea.isRectangularSelectionEnabled()) {
                    this.rectSelect.setText("R");
                    this.rectSelect.setEnabled(true);
                } else {
                    this.rectSelect.setText("r");
                    this.rectSelect.setEnabled(false);
                }
            }
        }

        @Override
        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fontMetrics = this.rectSelect.getFontMetrics(font);
            Dimension dimension = new Dimension(Math.max(fontMetrics.charWidth('r'), fontMetrics.charWidth('R')) + 1, fontMetrics.getHeight());
            this.rectSelect.setPreferredSize(dimension);
            this.rectSelect.setMaximumSize(dimension);
        }
    }
}

