/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo.geometry;

import java.util.Arrays;
import org.elasticsearch.geo.geometry.Geometry;
import org.elasticsearch.geo.geometry.GeometryVisitor;
import org.elasticsearch.geo.geometry.ShapeType;

public class Line
implements Geometry {
    public static final Line EMPTY = new Line();
    private final double[] lats;
    private final double[] lons;
    private final double[] alts;

    protected Line() {
        this.lats = new double[0];
        this.lons = new double[0];
        this.alts = null;
    }

    public Line(double[] lats, double[] lons) {
        this(lats, lons, null);
    }

    public Line(double[] lats, double[] lons, double[] alts) {
        this.lats = lats;
        this.lons = lons;
        this.alts = alts;
        if (lats == null) {
            throw new IllegalArgumentException("lats must not be null");
        }
        if (lons == null) {
            throw new IllegalArgumentException("lons must not be null");
        }
        if (lats.length != lons.length) {
            throw new IllegalArgumentException("lats and lons must be equal length");
        }
        if (lats.length < 2) {
            throw new IllegalArgumentException("at least two points in the line is required");
        }
        if (alts != null && alts.length != lats.length) {
            throw new IllegalArgumentException("alts and lats must be equal length");
        }
    }

    public int length() {
        return this.lats.length;
    }

    public double getLat(int i) {
        return this.lats[i];
    }

    public double getLon(int i) {
        return this.lons[i];
    }

    public double getAlt(int i) {
        if (this.alts != null) {
            return this.alts[i];
        }
        return Double.NaN;
    }

    public double[] getLats() {
        return (double[])this.lats.clone();
    }

    public double[] getLons() {
        return (double[])this.lons.clone();
    }

    public double[] getAlts() {
        return this.alts == null ? null : (double[])this.alts.clone();
    }

    @Override
    public ShapeType type() {
        return ShapeType.LINESTRING;
    }

    @Override
    public <T, E extends Exception> T visit(GeometryVisitor<T, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public boolean isEmpty() {
        return this.lats.length == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Line line = (Line)o;
        return Arrays.equals(this.lats, line.lats) && Arrays.equals(this.lons, line.lons) && Arrays.equals(this.alts, line.alts);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.lats);
        result = 31 * result + Arrays.hashCode(this.lons);
        result = 31 * result + Arrays.hashCode(this.alts);
        return result;
    }

    @Override
    public boolean hasAlt() {
        return this.alts != null;
    }

    public String toString() {
        return "lats=" + Arrays.toString(this.lats) + ", lons=" + Arrays.toString(this.lons) + (this.hasAlt() ? ", alts=" + Arrays.toString(this.alts) : "");
    }
}

