/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.CompletionCompanion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.format.PHPHeuristicScanner;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public abstract class AbstractCompletionContext
implements ICompletionContext {
    public static final int NONE = 0;
    public static final int TRAIT_NAME = 1;
    public static final int TRAIT_KEYWORD = 2;
    private CompletionCompanion companion;
    private CompletionRequestor requestor;
    private ISourceModule sourceModule;
    private int offset;
    private boolean namesCalculated = false;
    private String memberName = null;
    private String namespaceName = null;
    private String resolvedNamespaceName = null;
    private boolean absolute = false;
    private List<String> useTypes;

    @Override
    public void init(CompletionCompanion companion) {
        this.companion = companion;
    }

    public CompletionCompanion getCompanion() {
        return this.companion;
    }

    @Override
    public boolean isValid(@NonNull ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        this.requestor = requestor;
        this.sourceModule = sourceModule;
        this.offset = offset;
        try {
            if (this.companion.getPartitionType() != null) {
                return true;
            }
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
        }
        return false;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    public boolean hasWhitespaceBeforeCursor() {
        int statementEnd;
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        return statementLength != (statementEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength));
    }

    public boolean hasSpaceAtPosition(int offset) {
        try {
            return offset >= 0 && offset < this.companion.getDocument().getLength() && this.companion.getDocument().getChar(offset) == ' ';
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public final CompletionRequestor getCompletionRequestor() {
        return this.requestor;
    }

    public String getPreviousWord() throws BadLocationException {
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        int wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
        int wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.companion.getPHPVersion(), statementText, wordEnd, true);
        if (wordStart < 0 || wordEnd < 0) {
            return "";
        }
        String previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        if (this.hasWhitespaceBeforeCursor()) {
            return previousWord;
        }
        wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, wordStart - 1);
        wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.companion.getPHPVersion(), statementText, wordEnd, true);
        if (wordStart < 0 || wordEnd < 0) {
            return "";
        }
        previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        return previousWord;
    }

    public String getPreviousWord(int times) throws BadLocationException {
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        int wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
        int wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.companion.getPHPVersion(), statementText, wordEnd, true);
        int i = 0;
        while (i < times - 1) {
            statementLength = wordStart;
            wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
            wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.companion.getPHPVersion(), statementText, wordEnd, true);
            ++i;
        }
        if (wordStart < 0 || wordEnd < 0) {
            return "";
        }
        String previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        if (this.hasWhitespaceBeforeCursor()) {
            return previousWord;
        }
        wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, wordStart - 1);
        wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.companion.getPHPVersion(), statementText, wordEnd, true);
        if (wordStart < 0 || wordEnd < 0) {
            return "";
        }
        previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        return previousWord;
    }

    public int getPreviousWordOffset(int times) throws BadLocationException {
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        int wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
        int wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.companion.getPHPVersion(), statementText, wordEnd, true);
        int i = 0;
        while (i < times - 1) {
            statementLength = wordStart;
            wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
            wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.companion.getPHPVersion(), statementText, wordEnd, true);
            ++i;
        }
        if (wordStart < 0 || wordEnd < 0) {
            return wordStart;
        }
        if (this.hasWhitespaceBeforeCursor()) {
            return wordStart;
        }
        wordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, wordStart - 1);
        wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.companion.getPHPVersion(), statementText, wordEnd, true);
        return wordStart;
    }

    public String getPrefix() throws BadLocationException {
        if (this.hasWhitespaceBeforeCursor()) {
            return "";
        }
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        int prefixEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
        int prefixStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.companion.getPHPVersion(), statementText, prefixEnd, true);
        return prefixStart < 0 ? "" : statementText.subSequence(prefixStart, prefixEnd).toString();
    }

    public int getReplacementStart() throws BadLocationException {
        return this.offset - this.getPrefix().length();
    }

    public int getReplacementEnd() throws BadLocationException {
        ITextRegion phpToken = this.companion.getPHPToken();
        int endOffset = this.companion.getRegionCollection().getStartOffset() + this.companion.getPHPScriptRegion().getStart() + phpToken.getTextEnd();
        if (PHPPartitionTypes.isPHPQuotesState(phpToken.getType())) {
            int index = this.offset;
            while (index < endOffset) {
                char charAt = this.companion.getDocument().getChar(index);
                if (Character.isWhitespace(charAt) || charAt == '\'' || charAt == '\"') {
                    return index;
                }
                ++index;
            }
        }
        return endOffset;
    }

    public ITextRegion getNextPHPToken() throws BadLocationException {
        ITextRegion phpToken = this.companion.getPHPToken();
        while ((PHPPartitionTypes.isPHPCommentState((phpToken = this.companion.getPHPScriptRegion().getPHPToken(phpToken.getEnd())).getType()) || phpToken.getType() == "WHITESPACE") && phpToken.getEnd() < this.companion.getPHPScriptRegion().getLength()) {
        }
        return phpToken;
    }

    public ITextRegion getNextPHPToken(int times) throws BadLocationException {
        ITextRegion phpToken = null;
        int offset = this.offset;
        while (times-- > 0) {
            phpToken = this.companion.getPHPToken(offset);
            while ((PHPPartitionTypes.isPHPCommentState((phpToken = this.companion.getPHPScriptRegion().getPHPToken(phpToken.getEnd())).getType()) || phpToken.getType() == "WHITESPACE") && phpToken.getEnd() < this.companion.getPHPScriptRegion().getLength()) {
            }
            if (phpToken == null) {
                return null;
            }
            offset = this.companion.getRegionCollection().getStartOffset() + this.companion.getPHPScriptRegion().getStart() + phpToken.getEnd();
        }
        return phpToken;
    }

    public String getNextWord() throws BadLocationException {
        ITextRegion nextPHPToken = this.getNextPHPToken();
        return this.companion.getDocument().get(this.companion.getRegionCollection().getStartOffset() + this.companion.getPHPScriptRegion().getStart() + nextPHPToken.getStart(), nextPHPToken.getTextLength());
    }

    public String getNextWord(int times) throws BadLocationException {
        ITextRegion nextPHPToken = this.getNextPHPToken(times);
        return this.companion.getDocument().get(this.companion.getRegionCollection().getStartOffset() + this.companion.getPHPScriptRegion().getStart() + nextPHPToken.getStart(), nextPHPToken.getTextLength());
    }

    public char getNextChar() throws BadLocationException {
        return this.getChar(this.offset);
    }

    public char getChar(int offset) throws BadLocationException {
        if (this.companion.getDocument().getLength() == offset) {
            return ' ';
        }
        return this.companion.getDocument().getChar(offset);
    }

    public int getUseTraitStatementContext() {
        return this.getUseTraitStatementContext(this.offset, this.companion.getStructuredDocumentRegion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getUseTraitStatementContext(int offset, IStructuredDocumentRegion sdRegion) {
        String type2;
        String type;
        int documentOffset;
        ArrayList<String> types = new ArrayList<String>();
        if (sdRegion == null) {
            sdRegion = this.companion.getStructuredDocumentRegion();
        }
        if ((documentOffset = offset) == sdRegion.getEndOffset()) {
            --documentOffset;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(documentOffset);
        IStructuredDocumentRegion container = sdRegion;
        if (tRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CLOSE") {
            tRegion = container.getRegionAtCharacterOffset(container.getStartOffset() + tRegion.getStart() - 1);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
            IPHPScriptRegion phpScriptRegion = (IPHPScriptRegion)tRegion;
            try {
                int startOffset = container.getStartOffset() + phpScriptRegion.getStart();
                ITextRegion startTokenRegion = documentOffset == startOffset ? phpScriptRegion.getPHPToken(0) : phpScriptRegion.getPHPToken(offset - startOffset - 1);
                while (true) {
                    if (startTokenRegion.getStart() == 0) {
                        return 0;
                    }
                    if (!PHPPartitionTypes.isPHPCommentState(startTokenRegion.getType()) && startTokenRegion.getType() != "WHITESPACE") {
                        types.add(startTokenRegion.getType());
                    }
                    if (startTokenRegion.getType() != "PHP_CURLY_OPEN" && startTokenRegion.getType() != "PHP_INSTEADOF" && startTokenRegion.getType() != "PHP_SEMICOLON" && startTokenRegion.getType() != "PHP_AS") {
                        startTokenRegion = phpScriptRegion.getPHPToken(startTokenRegion.getStart() - 1);
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        if (types.size() == 1) {
            type = (String)types.get(0);
            if (type == "PHP_CURLY_OPEN" || type == "PHP_INSTEADOF" || type == "PHP_SEMICOLON") {
                return 1;
            }
            if (type == "PHP_AS") {
                return 2;
            }
            if (type != "PHP_INSTEADOF") return 0;
            return 2;
        }
        if (types.size() == 2) {
            String type1 = (String)types.get(0);
            String type3 = (String)types.get(1);
            try {
                if (type3 == "PHP_SEMICOLON" && type1 == "PHP_LABEL" && Character.isWhitespace(this.companion.getDocument().getChar(offset - 1))) {
                    return 2;
                }
            }
            catch (BadLocationException badLocationException) {}
            if (type3 != "PHP_CURLY_OPEN" && type3 != "PHP_INSTEADOF" && type3 != "PHP_SEMICOLON" && type1 != "PHP_LABEL") return 0;
            return 1;
        }
        if (types.size() == 3) {
            type = (String)types.get(0);
            String type1 = (String)types.get(1);
            type2 = (String)types.get(2);
            if (type != "PHP_LABEL" || type1 != "PHP_LABEL" || type2 != "PHP_SEMICOLON") return 0;
            return 2;
        } else {
            if (types.size() != 4) return 0;
            type = (String)types.get(0);
            String type1 = (String)types.get(1);
            type2 = (String)types.get(2);
            if (type != "PHP_LABEL" || type1 != "PHP_PAAMAYIM_NEKUDOTAYIM" || type2 != "PHP_LABEL") return 0;
            return 2;
        }
    }

    public boolean isInUseTraitStatement() {
        return this.isInUseTraitStatement(this.offset, this.companion.getStructuredDocumentRegion());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isInUseTraitStatement(int offset, IStructuredDocumentRegion sdRegion) {
        int documentOffset;
        if (this.companion.getPHPVersion().isLessThan(PHPVersion.PHP5_4)) {
            return false;
        }
        if (this.useTypes != null) {
            return true;
        }
        if (sdRegion == null) {
            sdRegion = this.companion.getStructuredDocumentRegion();
        }
        if ((documentOffset = offset) == sdRegion.getEndOffset()) {
            --documentOffset;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(documentOffset);
        IStructuredDocumentRegion container = sdRegion;
        if (tRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CLOSE") {
            tRegion = container.getRegionAtCharacterOffset(container.getStartOffset() + tRegion.getStart() - 1);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
            IPHPScriptRegion phpScriptRegion = (IPHPScriptRegion)tRegion;
            try {
                int startOffset = container.getStartOffset() + phpScriptRegion.getStart();
                ITextRegion startTokenRegion = documentOffset == startOffset ? phpScriptRegion.getPHPToken(0) : phpScriptRegion.getPHPToken(offset - startOffset - 1);
                while (true) {
                    if (startTokenRegion.getStart() == 0) {
                        return false;
                    }
                    if (startTokenRegion.getType() == "PHP_CURLY_OPEN") {
                        TextSequence statementText1 = PHPTextSequenceUtilities.getStatement(startOffset + startTokenRegion.getStart() - 1, this.companion.getStructuredDocumentRegion(), true);
                        if ((startTokenRegion = phpScriptRegion.getPHPToken(startTokenRegion.getStart() - statementText1.length())).getType() == "PHP_USE") {
                            String[] types = statementText1.toString().trim().substring(3).trim().split(",");
                            this.useTypes = new ArrayList<String>();
                            String[] stringArray = types;
                            int n = types.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String type = stringArray[n2];
                                this.useTypes.add(type.trim());
                                ++n2;
                            }
                            return true;
                        }
                        return false;
                    }
                    if (startTokenRegion.getType() == "PHP_CURLY_CLOSE") {
                        return false;
                    }
                    startTokenRegion = phpScriptRegion.getPHPToken(startTokenRegion.getStart() - 1);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected IModelElement getEnclosingElement() {
        try {
            TextSequence statementText;
            int statementStart;
            int close;
            int open;
            int offset = this.offset;
            PHPHeuristicScanner heuristicScanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)this.companion.getDocument(), offset, true);
            if (offset >= this.companion.getDocument().getLength()) {
                offset = this.companion.getDocument().getLength() - 1;
            }
            if ((open = heuristicScanner.findOpeningPeer(offset, -2, '{', '}')) > -1 && (close = heuristicScanner.findOpeningPeer(offset, -2, '}', '{')) > open && open == heuristicScanner.findOpeningPeer(close - 1, -2, '{', '}')) {
                open = heuristicScanner.findOpeningPeer(open - 1, -2, '{', '}');
            }
            int n = statementStart = (statementText = this.getStatementText()).length() > 0 ? statementText.getOriginalOffset(0) + 1 : -1;
            if (open < 0 && statementStart < 0) {
                return this.sourceModule.getElementAt(offset);
            }
            IModelElement elementAt = this.sourceModule.getElementAt(open);
            IModelElement elementAt2 = this.sourceModule.getElementAt(statementStart);
            if (elementAt == null && elementAt2 == null) {
                return this.sourceModule.getElementAt(offset);
            }
            if (elementAt instanceof ISourceReference && elementAt2 instanceof ISourceReference) {
                if (((ISourceReference)elementAt).getSourceRange().getOffset() > ((ISourceReference)elementAt2).getSourceRange().getOffset()) {
                    return elementAt;
                }
                return elementAt2;
            }
            if (elementAt != null) {
                return elementAt;
            }
            return elementAt2;
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        catch (ModelException e) {
            Logger.logException(e);
        }
        return null;
    }

    public List<String> getUseTypes() {
        return this.useTypes;
    }

    private void calculateNames() throws BadLocationException {
        if (this.namesCalculated) {
            return;
        }
        this.namesCalculated = true;
        String prefix = this.getPrefix();
        this.namespaceName = this.extractNamespace(prefix);
        this.memberName = this.extractMemberName(prefix);
        this.resolvedNamespaceName = null;
        this.absolute = prefix.length() > 0 && prefix.charAt(0) == '\\';
        if (this.absolute || this.isAbsolute()) {
            this.resolvedNamespaceName = this.namespaceName;
        } else if (this.namespaceName != null) {
            this.resolvedNamespaceName = this.resolveNamespace(this.namespaceName);
        }
    }

    @Nullable
    private String extractNamespace(String prefix) {
        int pos = (prefix = this.realPrefix(prefix)).lastIndexOf("\\");
        if (pos == -1) {
            return null;
        }
        String name = prefix.substring(0, pos);
        if (name.length() == 0) {
            return null;
        }
        return name;
    }

    @NonNull
    private String extractMemberName(String prefix) {
        int pos = (prefix = this.realPrefix(prefix)).lastIndexOf("\\");
        if (pos == -1) {
            return prefix;
        }
        return prefix.substring(pos + 1);
    }

    public String getMemberName() throws BadLocationException {
        this.calculateNames();
        return this.memberName;
    }

    public String getNamespaceName() throws BadLocationException {
        this.calculateNames();
        return this.namespaceName;
    }

    public String getResolvedNamespaceName() throws BadLocationException {
        this.calculateNames();
        return this.resolvedNamespaceName;
    }

    public boolean isAbsoluteName() throws BadLocationException {
        this.calculateNames();
        return this.absolute;
    }

    @Nullable
    public String getQualifier(boolean useGlobal) throws BadLocationException {
        if (this.isAbsoluteName() || this.isAbsolute()) {
            if (this.resolvedNamespaceName == null && useGlobal) {
                return "<g>";
            }
            return this.resolvedNamespaceName;
        }
        return this.resolvedNamespaceName;
    }

    public boolean isAbsolute() {
        return false;
    }

    private String resolveNamespace(String name) throws BadLocationException {
        if (name == null) {
            return this.companion.getCurrentNamespace();
        }
        ISourceModule sourceModule = this.companion.getSourceModule();
        ISourceRange validRange = this.companion.getCurrentNamespaceRange();
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        try {
            int searchEnd = name.indexOf(92);
            String search = searchEnd < 1 ? name : name.substring(0, searchEnd);
            if ("namespace".equalsIgnoreCase(search)) {
                search = this.companion.getCurrentNamespace();
                if (searchEnd < 1) {
                    return search;
                }
                return String.valueOf(search) + '\\' + name.substring(searchEnd + 1);
            }
            AliasResolver aliasResolver = new AliasResolver(validRange, search);
            moduleDeclaration.traverse((ASTVisitor)aliasResolver);
            if (aliasResolver.stop) {
                name = searchEnd < 1 ? aliasResolver.found : String.valueOf(aliasResolver.found) + '\\' + name.substring(searchEnd + 1);
                return name;
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        String current = this.companion.getCurrentNamespace();
        if (current != null) {
            return current + '\\' + name;
        }
        return name;
    }

    private String realPrefix(String prefix) {
        if ((prefix = prefix.replaceAll("\\p{javaWhitespace}+", "")).length() > 0 && prefix.charAt(0) == '\\') {
            return prefix.substring(1);
        }
        return prefix;
    }

    @NonNull
    public TextSequence getStatementText() {
        return PHPTextSequenceUtilities.getStatement(this.offset, this.companion.getStructuredDocumentRegion(), true);
    }

    @Deprecated
    public final int getOffset() {
        return this.getCompanion().getOffset();
    }

    @Deprecated
    public final ISourceModule getSourceModule() {
        return this.getCompanion().getSourceModule();
    }

    @Deprecated
    public final IStructuredDocument getDocument() {
        return this.getCompanion().getDocument();
    }

    @Deprecated
    public final PHPVersion getPHPVersion() {
        return this.getCompanion().getPHPVersion();
    }

    @Deprecated
    public final IPHPScriptRegion getPHPScriptRegion() {
        return this.getCompanion().getPHPScriptRegion();
    }

    @Deprecated
    public final ITextRegion getPHPToken() throws BadLocationException {
        return this.getCompanion().getPHPToken();
    }

    @Deprecated
    public final ITextRegion getPHPToken(int offset) throws BadLocationException {
        return this.getCompanion().getPHPToken(offset);
    }

    @Deprecated
    public final String getCurrentNamespace() {
        return this.getCompanion().getCurrentNamespace();
    }

    @Deprecated
    public final boolean isGlobalNamespace() {
        return this.getCompanion().isGlobalNamespace();
    }

    @Deprecated
    public final ISourceRange getCurrentNamespaceRange() {
        return this.getCompanion().getCurrentNamespaceRange();
    }

    @Deprecated
    public final String getPartitionType() {
        return this.getCompanion().getPartitionType();
    }

    @Deprecated
    public final IStructuredDocumentRegion getStructuredDocumentRegion() {
        return this.getCompanion().getStructuredDocumentRegion();
    }

    class AliasResolver
    extends PHPASTVisitor {
        boolean stop = false;
        String found = null;
        ISourceRange validRange;
        String search;

        public AliasResolver(ISourceRange validRange, String search) {
            this.validRange = validRange;
            this.search = search;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            if (this.stop || node.sourceEnd() < this.validRange.getOffset() || node.sourceStart() > this.validRange.getOffset() + this.validRange.getLength()) {
                return false;
            }
            return super.visitGeneral(node);
        }

        @Override
        public boolean visit(UseStatement s) throws Exception {
            if (s.getStatementType() != 0) {
                return false;
            }
            for (UsePart part : s.getParts()) {
                String name;
                if (part.getStatementType() != 0) continue;
                String string = name = part.getAlias() != null ? part.getAlias().getName() : part.getNamespace().getName();
                if (!name.equalsIgnoreCase(this.search)) continue;
                this.stop = true;
                this.found = part.getFullUseStatementName();
                break;
            }
            return false;
        }
    }
}

