/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.editor.formatter.XmlDocumentFormatter;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class AntAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    private AntModel fModel;
    private int fAccumulatedChange = 0;

    public AntAutoEditStrategy(AntModel model) {
        this.fModel = model;
    }

    private synchronized void autoIndentAfterNewLine(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0 || this.fModel.getProjectNode(false) == null) {
            return;
        }
        int position = c.offset == d.getLength() ? c.offset - 1 : c.offset;
        AntElementNode node = this.fModel.getProjectNode(false).getNode(position - this.fAccumulatedChange);
        if (node == null) {
            return;
        }
        try {
            StringBuffer correct = XmlDocumentFormatter.getLeadingWhitespace(node.getOffset(), d);
            if (!this.nextNodeIsEndTag(c.offset, d)) {
                correct.append(XmlDocumentFormatter.createIndent());
            }
            StringBuffer buf = new StringBuffer(c.text);
            buf.append(correct);
            this.fAccumulatedChange += buf.length();
            int line = d.getLineOfOffset(position);
            IRegion reg = d.getLineInformation(line);
            int lineEnd = reg.getOffset() + reg.getLength();
            int contentStart = this.findEndOfWhiteSpace(d, c.offset, lineEnd);
            c.length = Math.max(contentStart - c.offset, 0);
            c.caretOffset = c.offset + buf.length();
            c.shiftsCaret = false;
            c.text = buf.toString();
        }
        catch (BadLocationException e) {
            AntUIPlugin.log(e);
        }
    }

    private boolean nextNodeIsEndTag(int offset, IDocument document) {
        if (offset + 1 > document.getLength()) {
            return false;
        }
        try {
            IRegion lineRegion = document.getLineInformationOfOffset(offset);
            offset = this.findEndOfWhiteSpace(document, offset, lineRegion.getOffset() + lineRegion.getLength());
            String nextChars = document.get(offset, 2).trim();
            if ("</".equals(nextChars) || "/>".equals(nextChars)) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && this.isLineDelimiter(d, c.text)) {
            this.autoIndentAfterNewLine(d, c);
        } else if (c.text.length() > 1) {
            this.smartPaste(d, c);
        }
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    public synchronized void reconciled() {
        this.fAccumulatedChange = 0;
    }

    private void smartPaste(IDocument document, DocumentCommand command) {
        try {
            if (command.offset == -1 || document.getLength() == 0 || this.fModel.getProjectNode(false) == null) {
                return;
            }
            String origChange = command.text;
            int position = command.offset == document.getLength() ? command.offset - 1 : command.offset;
            AntElementNode node = this.fModel.getProjectNode(false).getNode(position - this.fAccumulatedChange);
            if (node == null) {
                return;
            }
            int firstLine = 1;
            IRegion line = document.getLineInformationOfOffset(command.offset);
            String notSelected = document.get(line.getOffset(), command.offset - line.getOffset());
            if (notSelected.trim().length() == 0) {
                command.length += notSelected.length();
                command.offset = line.getOffset();
                firstLine = 0;
            }
            Document temp = new Document(command.text);
            boolean isIndentDetected = false;
            StringBuffer addition = new StringBuffer();
            int insertLength = 0;
            int lines = temp.getNumberOfLines();
            int l = firstLine;
            while (l < lines) {
                IRegion r = temp.getLineInformation(l);
                int lineOffset = r.getOffset();
                int lineLength = r.getLength();
                if (lineLength != 0) {
                    if (!isIndentDetected) {
                        StringBuffer current = XmlDocumentFormatter.getLeadingWhitespace(lineOffset, (IDocument)temp);
                        StringBuffer correct = XmlDocumentFormatter.getLeadingWhitespace(node.getOffset(), document);
                        correct.append(XmlDocumentFormatter.createIndent());
                        insertLength = this.subtractIndent(correct, current, addition);
                        isIndentDetected = true;
                    }
                    if (insertLength > 0) {
                        this.addIndent(temp, l, addition);
                    } else if (insertLength < 0) {
                        this.cutIndent(temp, l, -insertLength);
                    }
                }
                ++l;
            }
            if (!origChange.equals(temp.get())) {
                this.fAccumulatedChange += temp.getLength();
                command.text = temp.get();
            }
        }
        catch (BadLocationException e) {
            AntUIPlugin.log(e);
        }
    }

    private void addIndent(Document document, int line, CharSequence indent) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int insert = region.getOffset();
        document.replace(insert, 0, indent.toString());
    }

    private void cutIndent(Document document, int line, int toDelete) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        int to = from;
        while (toDelete > 0 && to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch) || (toDelete -= this.computeVisualLength(ch)) < 0) break;
            ++to;
        }
        document.replace(from, to - from, null);
    }

    private int computeVisualLength(char ch) {
        if (ch == '\t') {
            return this.getVisualTabLengthPreference();
        }
        return 1;
    }

    private int computeVisualLength(CharSequence seq) {
        int size = 0;
        int tablen = this.getVisualTabLengthPreference();
        int i = 0;
        while (i < seq.length()) {
            char ch = seq.charAt(i);
            size = ch == '\t' ? (size += tablen - size % tablen) : ++size;
            ++i;
        }
        return size;
    }

    private int subtractIndent(CharSequence correct, CharSequence current, StringBuffer difference) {
        int c2;
        int c1 = this.computeVisualLength(correct);
        int diff = c1 - (c2 = this.computeVisualLength(current));
        if (diff <= 0) {
            return diff;
        }
        difference.setLength(0);
        int len = 0;
        int i = 0;
        while (len < diff) {
            char c = correct.charAt(i++);
            difference.append(c);
            len += this.computeVisualLength(c);
        }
        return diff;
    }

    private int getVisualTabLengthPreference() {
        return AntUIPlugin.getDefault().getCombinedPreferenceStore().getInt("tabWidth");
    }
}

