/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.File;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.context.IndexingContext;
import org.codehaus.plexus.util.StringUtils;

public class ScanningRequest {
    private final IndexingContext context;
    private final ArtifactScanningListener artifactScanningListener;
    private final String startingPath;

    public ScanningRequest(IndexingContext context, ArtifactScanningListener artifactScanningListener) {
        this(context, artifactScanningListener, null);
    }

    public ScanningRequest(IndexingContext context, ArtifactScanningListener artifactScanningListener, String startingPath) {
        this.context = context;
        this.artifactScanningListener = artifactScanningListener;
        this.startingPath = startingPath;
    }

    public IndexingContext getIndexingContext() {
        return this.context;
    }

    public ArtifactScanningListener getArtifactScanningListener() {
        return this.artifactScanningListener;
    }

    public String getStartingPath() {
        return this.startingPath;
    }

    public File getStartingDirectory() {
        if (StringUtils.isBlank((String)this.startingPath)) {
            return this.getIndexingContext().getRepository();
        }
        return new File(this.getIndexingContext().getRepository(), this.startingPath);
    }
}

