/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.coverageview;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.eclemma.internal.ui.coverageview.ViewSettings;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;

class CellTextConverter {
    private static final NumberFormat COVERAGE_VALUE = new DecimalFormat(UIMessages.CoverageView_columnCoverageValue);
    private static final NumberFormat COUNTER_VALUE = DecimalFormat.getIntegerInstance();
    private final ViewSettings settings;
    private final ILabelProvider workbenchLabelProvider;

    CellTextConverter(ViewSettings settings) {
        this.settings = settings;
        this.workbenchLabelProvider = new WorkbenchLabelProvider();
    }

    String getElementName(Object element) {
        String text = this.getSimpleTextForJavaElement(element);
        if (element instanceof IPackageFragmentRoot && ICoverageNode.ElementType.BUNDLE.equals((Object)this.settings.getRootType())) {
            text = String.valueOf(text) + " - " + this.getElementName(((IPackageFragmentRoot)element).getJavaProject());
        }
        return text;
    }

    private String getSimpleTextForJavaElement(Object element) {
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            if (root.getElementName().length() == 0) {
                element = root.getJavaProject();
            }
            try {
                if (root.getKind() == 2) {
                    return root.getPath().lastSegment();
                }
            }
            catch (JavaModelException e) {
                EclEmmaUIPlugin.log(e);
            }
        }
        return this.workbenchLabelProvider.getText(element);
    }

    String getRatio(Object element) {
        ICounter counter = this.getCounter(element);
        if (counter.getTotalCount() == 0) {
            return "";
        }
        return COVERAGE_VALUE.format(counter.getCoveredRatio());
    }

    String getCovered(Object element) {
        return COUNTER_VALUE.format(this.getCounter(element).getCoveredCount());
    }

    String getMissed(Object element) {
        return COUNTER_VALUE.format(this.getCounter(element).getMissedCount());
    }

    String getTotal(Object element) {
        return COUNTER_VALUE.format(this.getCounter(element).getTotalCount());
    }

    private ICounter getCounter(Object element) {
        return CoverageTools.getCoverageInfo((Object)element).getCounter(this.settings.getCounters());
    }
}

