/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import org.eclipse.tm4e.core.internal.rule.ICompilePatternsResult;
import org.eclipse.tm4e.core.internal.rule.ICompiledRule;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.RegExpSourceList;
import org.eclipse.tm4e.core.internal.rule.Rule;

public class IncludeOnlyRule
extends Rule {
    public boolean hasMissingPatterns;
    public Integer[] patterns;
    private RegExpSourceList _cachedCompiledPatterns;

    public IncludeOnlyRule(int id, String name, String contentName, ICompilePatternsResult patterns) {
        super(id, name, contentName);
        this.patterns = patterns.patterns;
        this.hasMissingPatterns = patterns.hasMissingPatterns;
        this._cachedCompiledPatterns = null;
    }

    @Override
    public void collectPatternsRecursive(IRuleRegistry grammar, RegExpSourceList out, boolean isFirst) {
        int i = 0;
        int len = this.patterns.length;
        while (i < len) {
            Rule rule = grammar.getRule(this.patterns[i]);
            rule.collectPatternsRecursive(grammar, out, false);
            ++i;
        }
    }

    @Override
    public ICompiledRule compile(IRuleRegistry grammar, String endRegexSource, boolean allowA, boolean allowG) {
        if (this._cachedCompiledPatterns == null) {
            this._cachedCompiledPatterns = new RegExpSourceList();
            this.collectPatternsRecursive(grammar, this._cachedCompiledPatterns, true);
        }
        return this._cachedCompiledPatterns.compile(grammar, allowA, allowG);
    }
}

