/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.daemon;

import java.util.HashSet;
import java.util.Set;

public class OpUnitMask {
    public static final int SET_DEFAULT_MASK = -1;
    public static final int INVALID = -1;
    public static final int MANDATORY = 1;
    public static final int EXCLUSIVE = 2;
    public static final int BITMASK = 3;
    private int mask;
    private String maskName = "";
    private int defaultMask;
    private int maskType;
    private String[] maskOptionDescriptions = new String[0];
    private int[] maskOptionValues;
    private String[] maskOptionNames = new String[0];
    Set<Integer> nonUniqueValues = new HashSet<Integer>();

    public void setMaskDescriptions(MaskInfo[] masks) {
        this.maskOptionDescriptions = new String[masks.length];
        this.maskOptionValues = new int[masks.length];
        this.maskOptionNames = new String[masks.length];
        HashSet<Integer> values = new HashSet<Integer>();
        int i = 0;
        while (i < masks.length) {
            Integer val = new Integer(masks[i].value);
            if (values.contains(new Integer(val))) {
                this.nonUniqueValues.add(new Integer(val));
            }
            values.add(new Integer(val));
            this.maskOptionDescriptions[i] = masks[i].description;
            this.maskOptionValues[i] = masks[i].value;
            this.maskOptionNames[i] = masks[i].name;
            ++i;
        }
    }

    public void setDefault(int theDefault) {
        this.defaultMask = theDefault;
        this.setDefaultMaskValue();
    }

    public void setType(int type) {
        this.maskType = type;
    }

    public int getMaskValue() {
        return this.mask;
    }

    public String getMaskName() {
        if (this.nonUniqueValues.contains(new Integer(this.mask))) {
            return this.maskName;
        }
        return null;
    }

    public boolean isMaskSetFromIndex(int index) {
        boolean result = false;
        if (index >= 0 && index < this.maskOptionValues.length) {
            switch (this.maskType) {
                case 2: {
                    result = this.mask == this.maskOptionValues[index] && (this.maskName.isEmpty() || this.maskName.equals(this.maskOptionNames[index]));
                    break;
                }
                case 3: {
                    result = (this.mask & this.maskOptionValues[index]) != 0;
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    public void setMaskValue(int newValue) {
        this.mask = newValue == -1 ? this.defaultMask : newValue;
    }

    public void setMaskName(String newName) {
        this.maskName = newName;
    }

    public void setMaskFromIndex(int index) {
        if (index >= 0 && index < this.maskOptionValues.length) {
            if (this.maskType == 3) {
                this.mask |= this.maskOptionValues[index];
            } else if (this.maskType == 2) {
                this.mask = this.maskOptionValues[index];
                this.maskName = this.maskOptionNames[index];
            }
        }
    }

    public int getMaskFromIndex(int index) {
        if (this.maskType == 3) {
            if (index >= 0 && index < this.maskOptionValues.length) {
                return this.maskOptionValues[index];
            }
        } else if (this.maskType == 2) {
            if (index >= 0 && index < this.maskOptionValues.length) {
                return this.maskOptionValues[index];
            }
        } else if (this.maskType == 1) {
            return this.defaultMask;
        }
        return -1;
    }

    public void unSetMaskFromIndex(int index) {
        if (index >= 0 && index < this.maskOptionValues.length && this.maskType == 3) {
            this.mask &= ~this.maskOptionValues[index];
        }
    }

    public void setDefaultMaskValue() {
        this.mask = this.defaultMask;
    }

    public String getText(int num) {
        if (num >= 0 && num < this.maskOptionDescriptions.length) {
            return this.maskOptionDescriptions[num];
        }
        return null;
    }

    public int getNumMasks() {
        return this.maskOptionDescriptions.length;
    }

    public int getType() {
        return this.maskType;
    }

    public static class MaskInfo {
        public int value;
        public String name;
        public String description;
    }
}

