/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs;

import com.google.common.collect.Collections2;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.util.TimeGraphStyleUtil;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;

public class TimeGraphLegend
extends TitleAreaDialog {
    private static final ImageDescriptor RESET_IMAGE = Activator.getDefault().getImageDescripterFromPath("icons/ovr16/undo_edit.gif");
    private final ITimeGraphPresentationProvider fProvider;
    private final LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

    public static void open(Shell parent, ITimeGraphPresentationProvider provider) {
        new TimeGraphLegend(parent, provider).open();
    }

    public TimeGraphLegend(Shell parent, ITimeGraphPresentationProvider provider) {
        super(parent);
        this.fProvider = provider;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected final ITimeGraphPresentationProvider getPresentationProvider() {
        return this.fProvider;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dlgArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dlgArea, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        this.addStateGroups(composite);
        this.setTitle(Messages.TmfTimeLegend_LEGEND);
        TimeGraphLegend.setDialogHelpAvailable((boolean)false);
        this.setHelpAvailable(false);
        dlgArea.getShell().setMinimumSize(150, 150);
        composite.addDisposeListener(e -> this.fResourceManager.dispose());
        return composite;
    }

    private void addStateGroups(Composite composite) {
        StateItem[] stateTable = this.fProvider.getStateTable();
        if (stateTable == null) {
            return;
        }
        List<StateItem> stateItems = Arrays.asList(stateTable);
        Collection linkStates = Collections2.filter(stateItems, TimeGraphLegend::isLinkState);
        int numColumn = linkStates.isEmpty() ? 1 : 2;
        ScrolledComposite sc = new ScrolledComposite(composite, 768);
        Composite innerComposite = new Composite((Composite)sc, 0);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        GridData gd = new GridData(4, 4, true, true);
        sc.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(20, 0).create());
        sc.setLayoutData((Object)gd);
        GridLayout gridLayout = GridLayoutFactory.swtDefaults().margins(0, 0).create();
        gridLayout.numColumns = numColumn;
        gridLayout.makeColumnsEqualWidth = false;
        innerComposite.setLayout((Layout)gridLayout);
        innerComposite.setLayoutData((Object)gd);
        sc.setContent((Control)innerComposite);
        this.createStatesGroup(innerComposite);
        this.createLinkGroup(linkStates, innerComposite);
        sc.setMinSize(innerComposite.computeSize(-1, -1));
    }

    protected void createStatesGroup(Composite composite) {
        Group gs = new Group(composite, 0);
        String stateTypeName = this.fProvider.getStateTypeName();
        StringBuilder buffer = new StringBuilder();
        if (!stateTypeName.isEmpty()) {
            buffer.append(stateTypeName);
            buffer.append(" ");
        }
        buffer.append(Messages.TmfTimeLegend_StateTypeName);
        gs.setText(buffer.toString());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 20;
        layout.marginBottom = 10;
        gs.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        gs.setLayoutData((Object)gridData);
        StateItem[] stateTable = this.fProvider.getStateTable();
        List<Object> stateItems = stateTable != null ? Arrays.asList(stateTable) : Collections.emptyList();
        stateItems.forEach(si -> {
            if (!TimeGraphLegend.isLinkState(si)) {
                new LegendEntry((Composite)gs, (StateItem)si);
            }
        });
    }

    private void createLinkGroup(Collection<StateItem> linkStates, Composite innerComposite) {
        if (linkStates.isEmpty()) {
            return;
        }
        Group gs = new Group(innerComposite, 0);
        gs.setText(this.fProvider.getLinkTypeName());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 20;
        layout.marginBottom = 10;
        gs.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        gs.setLayoutData((Object)gridData);
        linkStates.forEach(si -> {
            LegendEntry legendEntry = new LegendEntry((Composite)gs, (StateItem)si);
        });
    }

    protected static boolean isLinkState(StateItem si) {
        Object itemType = si.getStyleMap().getOrDefault(ITimeEventStyleStrings.itemTypeProperty(), ITimeEventStyleStrings.stateType());
        return itemType instanceof String && ((String)itemType).equals(ITimeEventStyleStrings.linkType());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.TmfTimeLegend_LEGEND);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected class LegendEntry
    extends Composite {
        private static final String LEGEND_ENTRY_KEY = "legend.entry.key";
        private final Swatch fBar;
        private final Scale fScale;
        private final Button fReset;

        public LegendEntry(final Composite parent, final StateItem si) {
            super(parent, 0);
            final String fillColorKey = TimeGraphStyleUtil.getPreferenceName(TimeGraphLegend.this.fProvider, si, ITimeEventStyleStrings.fillColor());
            final String heightFactorKey = TimeGraphStyleUtil.getPreferenceName(TimeGraphLegend.this.fProvider, si, ITimeEventStyleStrings.heightFactor());
            final IPreferenceStore store = TimeGraphStyleUtil.getStore();
            TimeGraphStyleUtil.loadValue(TimeGraphLegend.this.fProvider, si);
            String name = si.getStateString();
            this.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
            this.fBar = new Swatch(this, si.getStateColor());
            this.fBar.setData(LEGEND_ENTRY_KEY, name);
            this.fBar.setToolTipText(Messages.TimeGraphLegend_swatchClick);
            this.fBar.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    Shell shell = new Shell();
                    ColorDialog cd = new ColorDialog(shell, 0);
                    cd.setRGB(LegendEntry.this.fBar.fColor.getRGB());
                    RGB color = cd.open();
                    if (color != null) {
                        store.setValue(fillColorKey, new RGBAColor(color.red, color.green, color.blue, 255).toString());
                        LegendEntry.this.fBar.setColor(color);
                        si.setStateColor(color);
                        TimeGraphLegend.this.fProvider.refresh();
                        LegendEntry.this.fReset.setEnabled(true);
                    }
                }
            });
            this.fBar.addMouseTrackListener(new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                    Shell shell = parent.getShell();
                    Cursor old = shell.getCursor();
                    shell.setCursor(new Cursor((Device)e.display, 0));
                    if (old != null) {
                        old.dispose();
                    }
                }

                public void mouseEnter(MouseEvent e) {
                    Shell shell = parent.getShell();
                    Cursor old = shell.getCursor();
                    shell.setCursor(new Cursor((Device)e.display, 21));
                    if (old != null) {
                        old.dispose();
                    }
                }
            });
            this.fBar.setLayoutData(GridDataFactory.swtDefaults().hint(30, 20).create());
            CLabel label = new CLabel(this, 0){

                protected String shortenText(GC gc, String t, int w) {
                    String text = super.shortenText(gc, t, w);
                    this.setToolTipText(t.equals(text) ? null : t);
                    return text;
                }
            };
            label.setData(LEGEND_ENTRY_KEY, (Object)name);
            label.setText(name);
            label.setLayoutData((Object)GridDataFactory.fillDefaults().hint(160, -1).align(4, 0x1000000).grab(true, false).create());
            this.fScale = new Scale((Composite)this, 0);
            this.fScale.setMaximum(100);
            this.fScale.setMinimum(1);
            this.fScale.setSelection((int)(100.0f * si.getStateHeightFactor()));
            this.fScale.setToolTipText(Messages.TimeGraphLegend_widthTooltip);
            this.fScale.setData(LEGEND_ENTRY_KEY, (Object)name);
            this.fScale.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    float newWidth = (float)LegendEntry.this.fScale.getSelection() * 0.01f;
                    store.setValue(heightFactorKey, newWidth);
                    si.getStyleMap().put(ITimeEventStyleStrings.heightFactor(), Float.valueOf(newWidth));
                    TimeGraphLegend.this.fProvider.refresh();
                    LegendEntry.this.fReset.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.fScale.setLayoutData((Object)GridDataFactory.swtDefaults().hint(120, -1).create());
            this.fReset = new Button((Composite)this, 0x800000);
            this.fReset.setData(LEGEND_ENTRY_KEY, (Object)name);
            this.fReset.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    si.reset();
                    store.setToDefault(heightFactorKey);
                    store.setToDefault(fillColorKey);
                    LegendEntry.this.fBar.setColor(si.getStateColor());
                    LegendEntry.this.fScale.setSelection((int)(100.0f * si.getStateHeightFactor()));
                    TimeGraphLegend.this.fProvider.refresh();
                    LegendEntry.this.fReset.setEnabled(false);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.fReset.setToolTipText(Messages.TimeGraphLegend_resetTooltip);
            this.fReset.setImage(RESET_IMAGE.createImage());
            this.fReset.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).create());
            if (store.getString(fillColorKey).equals(store.getDefaultString(fillColorKey)) && store.getFloat(heightFactorKey) == store.getDefaultFloat(heightFactorKey)) {
                this.fReset.setEnabled(false);
            }
        }

        public void dispose() {
            this.fReset.getImage().dispose();
            super.dispose();
        }
    }

    private class Swatch
    extends Canvas {
        private Color fColor;

        public Swatch(Composite parent, RGB rgb) {
            super(parent, 0x800000);
            this.fColor = TimeGraphLegend.this.fResourceManager.createColor(rgb);
            this.setForeground(this.fColor);
            this.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Swatch.this.draw(event.gc);
                }
            });
        }

        public void setColor(RGB rgb) {
            if (rgb != null) {
                this.fColor = TimeGraphLegend.this.fResourceManager.createColor(rgb);
                this.setForeground(this.fColor);
                this.redraw();
            }
        }

        private void draw(GC gc) {
            Rectangle r = this.getClientArea();
            gc.setBackground(this.fColor);
            gc.fillRectangle(r);
            gc.setForeground(Display.getDefault().getSystemColor(2));
            gc.setLineWidth(2);
            gc.drawRectangle(1, 1, r.width - 2, r.height - 2);
        }
    }
}

