/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.StashApplyFailureException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;

public class StashApplyCommand
extends GitCommand<ObjectId> {
    private static final String DEFAULT_REF = "stash@{0}";
    private String stashRef;
    private boolean applyIndex = true;
    private boolean applyUntracked = true;
    private boolean ignoreRepositoryState;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;

    public StashApplyCommand(Repository repo) {
        super(repo);
    }

    public StashApplyCommand setStashRef(String stashRef) {
        this.stashRef = stashRef;
        return this;
    }

    public StashApplyCommand ignoreRepositoryState(boolean willIgnoreRepositoryState) {
        this.ignoreRepositoryState = willIgnoreRepositoryState;
        return this;
    }

    private ObjectId getStashId() throws GitAPIException {
        ObjectId stashId;
        String revision = this.stashRef != null ? this.stashRef : DEFAULT_REF;
        try {
            stashId = this.repo.resolve(revision);
        }
        catch (IOException e2) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, revision), e2);
        }
        if (stashId == null) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, revision));
        }
        return stashId;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ObjectId call() throws GitAPIException, WrongRepositoryStateException, NoHeadException, StashApplyFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setApplyIndex(boolean applyIndex) {
        this.applyIndex = applyIndex;
    }

    public StashApplyCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public void setApplyUntracked(boolean applyUntracked) {
        this.applyUntracked = applyUntracked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIndex(RevTree tree) throws IOException {
        DirCache dc = this.repo.lockDirCache();
        try (TreeWalk walk2 = new TreeWalk(this.repo);){
            DirCacheBuilder builder = dc.builder();
            walk2.addTree(tree);
            walk2.addTree(new DirCacheIterator(dc));
            walk2.setRecursive(true);
            while (walk2.next()) {
                AbstractTreeIterator cIter = walk2.getTree(0, AbstractTreeIterator.class);
                if (cIter == null) continue;
                DirCacheEntry entry = new DirCacheEntry(walk2.getRawPath());
                entry.setFileMode(cIter.getEntryFileMode());
                entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                DirCacheIterator dcIter = walk2.getTree(1, DirCacheIterator.class);
                if (dcIter != null && dcIter.idEqual(cIter)) {
                    DirCacheEntry indexEntry = dcIter.getDirCacheEntry();
                    entry.setLastModified(indexEntry.getLastModified());
                    entry.setLength(indexEntry.getLength());
                }
                builder.add(entry);
            }
            builder.commit();
        }
        finally {
            dc.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetUntracked(RevTree tree) throws CheckoutConflictException, IOException {
        HashSet<String> actuallyModifiedPaths = new HashSet<String>();
        try (TreeWalk walk2 = new TreeWalk(this.repo);){
            walk2.addTree(tree);
            walk2.addTree(new FileTreeIterator(this.repo));
            walk2.setRecursive(true);
            ObjectReader reader2 = walk2.getObjectReader();
            while (walk2.next()) {
                AbstractTreeIterator cIter = walk2.getTree(0, AbstractTreeIterator.class);
                if (cIter == null) continue;
                CoreConfig.EolStreamType eolStreamType = walk2.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP);
                DirCacheEntry entry = new DirCacheEntry(walk2.getRawPath());
                entry.setFileMode(cIter.getEntryFileMode());
                entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                FileTreeIterator fIter = walk2.getTree(1, FileTreeIterator.class);
                if (fIter != null && fIter.isModified(entry, true, reader2)) {
                    throw new CheckoutConflictException(entry.getPathString());
                }
                this.checkoutPath(entry, reader2, new DirCacheCheckout.CheckoutMetadata(eolStreamType, null));
                actuallyModifiedPaths.add(entry.getPathString());
            }
        }
        finally {
            if (!actuallyModifiedPaths.isEmpty()) {
                this.repo.fireEvent(new WorkingTreeModifiedEvent(actuallyModifiedPaths, null));
            }
        }
    }

    private void checkoutPath(DirCacheEntry entry, ObjectReader reader2, DirCacheCheckout.CheckoutMetadata checkoutMetadata) {
        try {
            DirCacheCheckout.checkoutEntry(this.repo, entry, reader2, true, checkoutMetadata);
        }
        catch (IOException e2) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutConflictWithFile, entry.getPathString()), e2);
        }
    }
}

