(function() {
  var AddDialog, Dialog, fs, path, repoForPath,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  path = require('path');

  fs = require('fs-plus');

  Dialog = require('./dialog');

  repoForPath = require('./helpers').repoForPath;

  module.exports = AddDialog = (function(superClass) {
    extend(AddDialog, superClass);

    function AddDialog(initialPath, isCreatingFile) {
      var directoryPath, ref, relativeDirectoryPath;
      this.isCreatingFile = isCreatingFile;
      if (fs.isFileSync(initialPath)) {
        directoryPath = path.dirname(initialPath);
      } else {
        directoryPath = initialPath;
      }
      relativeDirectoryPath = directoryPath;
      ref = atom.project.relativizePath(directoryPath), this.rootProjectPath = ref[0], relativeDirectoryPath = ref[1];
      if (relativeDirectoryPath.length > 0) {
        relativeDirectoryPath += path.sep;
      }
      AddDialog.__super__.constructor.call(this, {
        prompt: "Enter the path for the new " + (isCreatingFile ? "file." : "folder."),
        initialPath: relativeDirectoryPath,
        select: false,
        iconClass: isCreatingFile ? 'icon-file-add' : 'icon-file-directory-create'
      });
    }

    AddDialog.prototype.onDidCreateFile = function(callback) {
      return this.emitter.on('did-create-file', callback);
    };

    AddDialog.prototype.onDidCreateDirectory = function(callback) {
      return this.emitter.on('did-create-directory', callback);
    };

    AddDialog.prototype.onConfirm = function(newPath) {
      var endsWithDirectorySeparator, error, ref;
      newPath = newPath.replace(/\s+$/, '');
      endsWithDirectorySeparator = newPath[newPath.length - 1] === path.sep;
      if (!path.isAbsolute(newPath)) {
        if (this.rootProjectPath == null) {
          this.showError("You must open a directory to create a file with a relative path");
          return;
        }
        newPath = path.join(this.rootProjectPath, newPath);
      }
      if (!newPath) {
        return;
      }
      try {
        if (fs.existsSync(newPath)) {
          return this.showError("'" + newPath + "' already exists.");
        } else if (this.isCreatingFile) {
          if (endsWithDirectorySeparator) {
            return this.showError("File names must not end with a '" + path.sep + "' character.");
          } else {
            fs.writeFileSync(newPath, '');
            if ((ref = repoForPath(newPath)) != null) {
              ref.getPathStatus(newPath);
            }
            this.emitter.emit('did-create-file', newPath);
            return this.close();
          }
        } else {
          fs.makeTreeSync(newPath);
          this.emitter.emit('did-create-directory', newPath);
          return this.cancel();
        }
      } catch (error1) {
        error = error1;
        return this.showError(error.message + ".");
      }
    };

    return AddDialog;

  })(Dialog);

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
