Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.activate = activate;
exports.deactivate = deactivate;
exports.consumeStatusBar = consumeStatusBar;
exports.deserializeIncompatiblePackagesComponent = deserializeIncompatiblePackagesComponent;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/** @babel */

var _atom = require('atom');

var _viewUri = require('./view-uri');

var _viewUri2 = _interopRequireDefault(_viewUri);

var disposables = null;

function activate() {
  disposables = new _atom.CompositeDisposable();

  disposables.add(atom.workspace.addOpener(function (uri) {
    if (uri === _viewUri2['default']) {
      return deserializeIncompatiblePackagesComponent();
    }
  }));

  disposables.add(atom.commands.add('atom-workspace', {
    'incompatible-packages:view': function incompatiblePackagesView() {
      atom.workspace.open(_viewUri2['default']);
    }
  }));
}

function deactivate() {
  disposables.dispose();
}

function consumeStatusBar(statusBar) {
  var incompatibleCount = 0;
  for (var pack of atom.packages.getLoadedPackages()) {
    if (!pack.isCompatible()) incompatibleCount++;
  }

  if (incompatibleCount > 0) {
    (function () {
      var icon = createIcon(incompatibleCount);
      var tile = statusBar.addRightTile({ item: icon, priority: 200 });
      icon.element.addEventListener('click', function () {
        atom.commands.dispatch(icon.element, 'incompatible-packages:view');
      });
      disposables.add(new _atom.Disposable(function () {
        return tile.destroy();
      }));
    })();
  }
}

function deserializeIncompatiblePackagesComponent() {
  var IncompatiblePackagesComponent = require('./incompatible-packages-component');
  return new IncompatiblePackagesComponent(atom.packages);
}

function createIcon(count) {
  var StatusIconComponent = require('./status-icon-component');
  return new StatusIconComponent({ count: count });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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