"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareIssueDetailView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _issueTimelineController = _interopRequireDefault(require("../controllers/issue-timeline-controller"));

var _emojiReactionsController = _interopRequireDefault(require("../controllers/emoji-reactions-controller"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _issueishBadge = _interopRequireDefault(require("../views/issueish-badge"));

var _githubDotcomMarkdown = _interopRequireDefault(require("../views/github-dotcom-markdown"));

var _periodicRefresher = _interopRequireDefault(require("../periodic-refresher"));

var _reporterProxy = require("../reporter-proxy");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareIssueDetailView extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      refreshing: false
    });

    _defineProperty(this, "handleRefreshClick", e => {
      e.preventDefault();
      this.refresher.refreshNow(true);
    });

    _defineProperty(this, "recordOpenInBrowserEvent", () => {
      (0, _reporterProxy.addEvent)('open-issue-in-browser', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "refresh", () => {
      if (this.state.refreshing) {
        return;
      }

      this.setState({
        refreshing: true
      });
      this.props.relay.refetch({
        repoId: this.props.repository.id,
        issueishId: this.props.issue.id,
        timelineCount: 100,
        timelineCursor: null
      }, null, () => {
        this.setState({
          refreshing: false
        });
      }, {
        force: true
      });
    });
  }

  componentDidMount() {
    this.refresher = new _periodicRefresher["default"](BareIssueDetailView, {
      interval: () => 5 * 60 * 1000,
      getCurrentId: () => this.props.issue.id,
      refresh: this.refresh,
      minimumIntervalPerId: 2 * 60 * 1000
    }); // auto-refresh disabled for now until pagination is handled
    // this.refresher.start();
  }

  componentWillUnmount() {
    this.refresher.destroy();
  }

  renderIssueBody(issue) {
    return _react["default"].createElement("div", {
      className: "github-IssueishDetailView-issueBody"
    }, _react["default"].createElement(_githubDotcomMarkdown["default"], {
      html: issue.bodyHTML || '<em>No description provided.</em>',
      switchToIssueish: this.props.switchToIssueish
    }), _react["default"].createElement(_emojiReactionsController["default"], {
      reactable: issue,
      tooltips: this.props.tooltips,
      reportMutationErrors: this.props.reportMutationErrors
    }), _react["default"].createElement(_issueTimelineController["default"], {
      issue: issue,
      switchToIssueish: this.props.switchToIssueish
    }));
  }

  render() {
    const repo = this.props.repository;
    const issue = this.props.issue;
    const author = issue.author || _helpers.GHOST_USER;
    return _react["default"].createElement("div", {
      className: "github-IssueishDetailView native-key-bindings"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-container"
    }, _react["default"].createElement("header", {
      className: "github-IssueishDetailView-header"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerColumn"
    }, _react["default"].createElement("a", {
      className: "github-IssueishDetailView-avatar",
      href: author.url
    }, _react["default"].createElement("img", {
      className: "github-IssueishDetailView-avatarImage",
      src: author.avatarUrl,
      title: author.login,
      alt: author.login
    }))), _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerColumn is-flexible"
    }, _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerRow is-fullwidth"
    }, _react["default"].createElement("a", {
      className: "github-IssueishDetailView-title",
      href: issue.url
    }, issue.title)), _react["default"].createElement("div", {
      className: "github-IssueishDetailView-headerRow"
    }, _react["default"].createElement(_issueishBadge["default"], {
      className: "github-IssueishDetailView-headerBadge",
      type: issue.__typename,
      state: issue.state
    }), _react["default"].createElement(_octicon["default"], {
      icon: "repo-sync",
      className: (0, _classnames["default"])('github-IssueishDetailView-headerRefreshButton', {
        refreshing: this.state.refreshing
      }),
      onClick: this.handleRefreshClick
    }), _react["default"].createElement("a", {
      className: "github-IssueishDetailView-headerLink",
      title: "open on GitHub.com",
      href: issue.url,
      onClick: this.recordOpenInBrowserEvent
    }, repo.owner.login, "/", repo.name, "#", issue.number)))), this.renderIssueBody(issue), _react["default"].createElement("footer", {
      className: "github-IssueishDetailView-footer"
    }, _react["default"].createElement("a", {
      className: "github-IssueishDetailView-footerLink icon icon-mark-github",
      href: issue.url
    }, repo.owner.login, "/", repo.name, "#", issue.number))));
  }

}

exports.BareIssueDetailView = BareIssueDetailView;

_defineProperty(BareIssueDetailView, "propTypes", {
  // Relay response
  relay: _propTypes["default"].shape({
    refetch: _propTypes["default"].func.isRequired
  }),
  switchToIssueish: _propTypes["default"].func.isRequired,
  repository: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    name: _propTypes["default"].string.isRequired,
    owner: _propTypes["default"].shape({
      login: _propTypes["default"].string
    })
  }),
  issue: _propTypes["default"].shape({
    __typename: _propTypes["default"].string.isRequired,
    id: _propTypes["default"].string.isRequired,
    title: _propTypes["default"].string,
    url: _propTypes["default"].string.isRequired,
    bodyHTML: _propTypes["default"].string,
    number: _propTypes["default"].number,
    state: _propTypes["default"].oneOf(['OPEN', 'CLOSED']).isRequired,
    author: _propTypes["default"].shape({
      login: _propTypes["default"].string.isRequired,
      avatarUrl: _propTypes["default"].string.isRequired,
      url: _propTypes["default"].string.isRequired
    }).isRequired,
    reactionGroups: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      content: _propTypes["default"].string.isRequired,
      users: _propTypes["default"].shape({
        totalCount: _propTypes["default"].number.isRequired
      }).isRequired
    })).isRequired
  }).isRequired,
  // Atom environment
  tooltips: _propTypes["default"].object.isRequired,
  // Action methods
  reportMutationErrors: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createRefetchContainer)(BareIssueDetailView, {
  repository: function () {
    const node = require("./__generated__/issueDetailView_repository.graphql");

    if (node.hash && node.hash !== "295a60f53b25b6fdb07a1539cda447f2") {
      console.error("The definition of 'issueDetailView_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueDetailView_repository.graphql");
  },
  issue: function () {
    const node = require("./__generated__/issueDetailView_issue.graphql");

    if (node.hash && node.hash !== "f7adc2e75c1d55df78481fd359bf7180") {
      console.error("The definition of 'issueDetailView_issue' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueDetailView_issue.graphql");
  }
}, function () {
  const node = require("./__generated__/issueDetailViewRefetchQuery.graphql");

  if (node.hash && node.hash !== "82666b2748036545eb131b3e34f48e72") {
    console.error("The definition of 'issueDetailViewRefetchQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/issueDetailViewRefetchQuery.graphql");
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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