"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _reporterProxy = require("../reporter-proxy");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ChangedFilesCountView extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'handleClick');
  }

  handleClick() {
    (0, _reporterProxy.addEvent)('click', {
      "package": 'github',
      component: 'ChangedFileCountView'
    });
    this.props.didClick();
  }

  render() {
    return _react["default"].createElement("button", {
      ref: "changedFiles",
      className: "github-ChangedFilesCount inline-block",
      onClick: this.handleClick
    }, _react["default"].createElement(_octicon["default"], {
      icon: "git-commit"
    }), `Git (${this.props.changedFilesCount})`, this.props.mergeConflictsPresent && _react["default"].createElement(_octicon["default"], {
      icon: "alert"
    }));
  }

}

exports["default"] = ChangedFilesCountView;

_defineProperty(ChangedFilesCountView, "propTypes", {
  changedFilesCount: _propTypes["default"].number.isRequired,
  didClick: _propTypes["default"].func.isRequired,
  mergeConflictsPresent: _propTypes["default"].bool
});

_defineProperty(ChangedFilesCountView, "defaultProps", {
  changedFilesCount: 0,
  mergeConflictsPresent: false,
  didClick: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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