Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _selectorKit = require('selector-kit');

var _scopeHelpers = require('./scope-helpers');

'use babel';

var ProviderMetadata = (function () {
  function ProviderMetadata(provider, apiVersion) {
    _classCallCheck(this, ProviderMetadata);

    this.provider = provider;
    this.apiVersion = apiVersion;

    // TODO API: remove this when 2.0 support is removed
    if (this.provider.selector != null) {
      this.scopeSelectors = _selectorKit.Selector.create(this.provider.selector);
    } else {
      this.scopeSelectors = _selectorKit.Selector.create(this.provider.scopeSelector);
    }

    // TODO API: remove this when 2.0 support is removed
    if (this.provider.disableForSelector != null) {
      this.disableForScopeSelectors = _selectorKit.Selector.create(this.provider.disableForSelector);
    } else if (this.provider.disableForScopeSelector != null) {
      this.disableForScopeSelectors = _selectorKit.Selector.create(this.provider.disableForScopeSelector);
    }

    // TODO API: remove this when 1.0 support is removed
    var providerBlacklist = undefined;
    if (this.provider.providerblacklist && this.provider.providerblacklist['autocomplete-plus-fuzzyprovider']) {
      providerBlacklist = this.provider.providerblacklist['autocomplete-plus-fuzzyprovider'];
    }
    if (providerBlacklist) {
      this.disableDefaultProviderSelectors = _selectorKit.Selector.create(providerBlacklist);
    }
  }

  _createClass(ProviderMetadata, [{
    key: 'getLabels',
    value: function getLabels() {
      // The default label will let the provider be used for
      // the main text editors of the workspace.
      return this.provider.labels || ['workspace-center'];
    }
  }, {
    key: 'matchesScopeChain',
    value: function matchesScopeChain(scopeChain) {
      if (this.disableForScopeSelectors != null) {
        if ((0, _scopeHelpers.selectorsMatchScopeChain)(this.disableForScopeSelectors, scopeChain)) {
          return false;
        }
      }

      if ((0, _scopeHelpers.selectorsMatchScopeChain)(this.scopeSelectors, scopeChain)) {
        return true;
      } else {
        return false;
      }
    }
  }, {
    key: 'shouldDisableDefaultProvider',
    value: function shouldDisableDefaultProvider(scopeChain) {
      if (this.disableDefaultProviderSelectors != null) {
        return (0, _scopeHelpers.selectorsMatchScopeChain)(this.disableDefaultProviderSelectors, scopeChain);
      } else {
        return false;
      }
    }
  }, {
    key: 'getSpecificity',
    value: function getSpecificity(scopeChain) {
      var selector = (0, _scopeHelpers.selectorForScopeChain)(this.scopeSelectors, scopeChain);
      if (selector) {
        return selector.getSpecificity();
      } else {
        return 0;
      }
    }
  }]);

  return ProviderMetadata;
})();

exports['default'] = ProviderMetadata;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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