/*
 * This declarations of the PIC16F18345 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:24 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16F18345_H__
#define __PIC16F18345_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTB_ADDR              0x000D
#define PORTC_ADDR              0x000E
#define PIR0_ADDR               0x0010
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define PIR3_ADDR               0x0013
#define PIR4_ADDR               0x0014
#define TMR0L_ADDR              0x0015
#define TMR0H_ADDR              0x0016
#define T0CON0_ADDR             0x0017
#define T0CON1_ADDR             0x0018
#define TMR1_ADDR               0x0019
#define TMR1L_ADDR              0x0019
#define TMR1H_ADDR              0x001A
#define T1CON_ADDR              0x001B
#define T1GCON_ADDR             0x001C
#define TMR2_ADDR               0x001D
#define PR2_ADDR                0x001E
#define T2CON_ADDR              0x001F
#define TRISA_ADDR              0x008C
#define TRISB_ADDR              0x008D
#define TRISC_ADDR              0x008E
#define PIE0_ADDR               0x0090
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define PIE3_ADDR               0x0093
#define PIE4_ADDR               0x0094
#define WDTCON_ADDR             0x0097
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define ADACT_ADDR              0x009F
#define LATA_ADDR               0x010C
#define LATB_ADDR               0x010D
#define LATC_ADDR               0x010E
#define CM1CON0_ADDR            0x0111
#define CM1CON1_ADDR            0x0112
#define CM2CON0_ADDR            0x0113
#define CM2CON1_ADDR            0x0114
#define CMOUT_ADDR              0x0115
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define DACCON0_ADDR            0x0118
#define DACCON1_ADDR            0x0119
#define ANSELA_ADDR             0x018C
#define ANSELB_ADDR             0x018D
#define ANSELC_ADDR             0x018E
#define VREGCON_ADDR            0x0197
#define RC1REG_ADDR             0x0199
#define RCREG_ADDR              0x0199
#define RCREG1_ADDR             0x0199
#define TX1REG_ADDR             0x019A
#define TXREG_ADDR              0x019A
#define TXREG1_ADDR             0x019A
#define SP1BRG_ADDR             0x019B
#define SP1BRGL_ADDR            0x019B
#define SPBRG_ADDR              0x019B
#define SPBRG1_ADDR             0x019B
#define SPBRGL_ADDR             0x019B
#define SP1BRGH_ADDR            0x019C
#define SPBRGH_ADDR             0x019C
#define SPBRGH1_ADDR            0x019C
#define RC1STA_ADDR             0x019D
#define RCSTA_ADDR              0x019D
#define RCSTA1_ADDR             0x019D
#define TX1STA_ADDR             0x019E
#define TXSTA_ADDR              0x019E
#define TXSTA1_ADDR             0x019E
#define BAUD1CON_ADDR           0x019F
#define BAUDCON_ADDR            0x019F
#define BAUDCON1_ADDR           0x019F
#define BAUDCTL_ADDR            0x019F
#define BAUDCTL1_ADDR           0x019F
#define WPUA_ADDR               0x020C
#define WPUB_ADDR               0x020D
#define WPUC_ADDR               0x020E
#define SSP1BUF_ADDR            0x0211
#define SSPBUF_ADDR             0x0211
#define SSP1ADD_ADDR            0x0212
#define SSPADD_ADDR             0x0212
#define SSP1MSK_ADDR            0x0213
#define SSPMSK_ADDR             0x0213
#define SSP1STAT_ADDR           0x0214
#define SSPSTAT_ADDR            0x0214
#define SSP1CON_ADDR            0x0215
#define SSP1CON1_ADDR           0x0215
#define SSPCON_ADDR             0x0215
#define SSPCON1_ADDR            0x0215
#define SSP1CON2_ADDR           0x0216
#define SSPCON2_ADDR            0x0216
#define SSP1CON3_ADDR           0x0217
#define SSPCON3_ADDR            0x0217
#define SSP2BUF_ADDR            0x0219
#define SSP2ADD_ADDR            0x021A
#define SSP2MSK_ADDR            0x021B
#define SSP2STAT_ADDR           0x021C
#define SSP2CON_ADDR            0x021D
#define SSP2CON1_ADDR           0x021D
#define SSP2CON2_ADDR           0x021E
#define SSP2CON3_ADDR           0x021F
#define ODCONA_ADDR             0x028C
#define ODCONB_ADDR             0x028D
#define ODCONC_ADDR             0x028E
#define CCPR1_ADDR              0x0291
#define CCPR1L_ADDR             0x0291
#define CCPR1H_ADDR             0x0292
#define CCP1CON_ADDR            0x0293
#define CCP1CAP_ADDR            0x0294
#define CCPR2_ADDR              0x0295
#define CCPR2L_ADDR             0x0295
#define CCPR2H_ADDR             0x0296
#define CCP2CON_ADDR            0x0297
#define CCP2CAP_ADDR            0x0298
#define CCPTMRS_ADDR            0x029F
#define SLRCONA_ADDR            0x030C
#define SLRCONB_ADDR            0x030D
#define SLRCONC_ADDR            0x030E
#define CCPR3_ADDR              0x0311
#define CCPR3L_ADDR             0x0311
#define CCPR3H_ADDR             0x0312
#define CCP3CON_ADDR            0x0313
#define CCP3CAP_ADDR            0x0314
#define CCPR4_ADDR              0x0315
#define CCPR4L_ADDR             0x0315
#define CCPR4H_ADDR             0x0316
#define CCP4CON_ADDR            0x0317
#define CCP4CAP_ADDR            0x0318
#define INLVLA_ADDR             0x038C
#define INLVLB_ADDR             0x038D
#define INLVLC_ADDR             0x038E
#define IOCAP_ADDR              0x0391
#define IOCAN_ADDR              0x0392
#define IOCAF_ADDR              0x0393
#define IOCBP_ADDR              0x0394
#define IOCBN_ADDR              0x0395
#define IOCBF_ADDR              0x0396
#define IOCCP_ADDR              0x0397
#define IOCCN_ADDR              0x0398
#define IOCCF_ADDR              0x0399
#define CLKRCON_ADDR            0x039A
#define MDCON_ADDR              0x039C
#define MDSRC_ADDR              0x039D
#define MDCARH_ADDR             0x039E
#define MDCARL_ADDR             0x039F
#define CCDNA_ADDR              0x040C
#define CCDNB_ADDR              0x040D
#define CCDNC_ADDR              0x040E
#define TMR3_ADDR               0x0411
#define TMR3L_ADDR              0x0411
#define TMR3H_ADDR              0x0412
#define T3CON_ADDR              0x0413
#define T3GCON_ADDR             0x0414
#define TMR4_ADDR               0x0415
#define PR4_ADDR                0x0416
#define T4CON_ADDR              0x0417
#define TMR5_ADDR               0x0418
#define TMR5L_ADDR              0x0418
#define TMR5H_ADDR              0x0419
#define T5CON_ADDR              0x041A
#define T5GCON_ADDR             0x041B
#define TMR6_ADDR               0x041C
#define PR6_ADDR                0x041D
#define T6CON_ADDR              0x041E
#define CCDCON_ADDR             0x041F
#define CCDPA_ADDR              0x048C
#define CCDPB_ADDR              0x048D
#define CCDPC_ADDR              0x048E
#define NCO1ACC_ADDR            0x0498
#define NCO1ACCL_ADDR           0x0498
#define NCO1ACCH_ADDR           0x0499
#define NCO1ACCU_ADDR           0x049A
#define NCO1INC_ADDR            0x049B
#define NCO1INCL_ADDR           0x049B
#define NCO1INCH_ADDR           0x049C
#define NCO1INCU_ADDR           0x049D
#define NCO1CON_ADDR            0x049E
#define NCO1CLK_ADDR            0x049F
#define PWM5DCL_ADDR            0x0617
#define PWM5DCH_ADDR            0x0618
#define PWM5CON_ADDR            0x0619
#define PWM5CON0_ADDR           0x0619
#define PWM6DCL_ADDR            0x061A
#define PWM6DCH_ADDR            0x061B
#define PWM6CON_ADDR            0x061C
#define PWM6CON0_ADDR           0x061C
#define PWMTMRS_ADDR            0x061F
#define CWG1CLKCON_ADDR         0x0691
#define CWG1DAT_ADDR            0x0692
#define CWG1DBR_ADDR            0x0693
#define CWG1DBF_ADDR            0x0694
#define CWG1CON0_ADDR           0x0695
#define CWG1CON1_ADDR           0x0696
#define CWG1AS0_ADDR            0x0697
#define CWG1AS1_ADDR            0x0698
#define CWG1STR_ADDR            0x0699
#define CWG2CLKCON_ADDR         0x0711
#define CWG2DAT_ADDR            0x0712
#define CWG2DBR_ADDR            0x0713
#define CWG2DBF_ADDR            0x0714
#define CWG2CON0_ADDR           0x0715
#define CWG2CON1_ADDR           0x0716
#define CWG2AS0_ADDR            0x0717
#define CWG2AS1_ADDR            0x0718
#define CWG2STR_ADDR            0x0719
#define NVMADR_ADDR             0x0891
#define NVMADRL_ADDR            0x0891
#define NVMADRH_ADDR            0x0892
#define NVMDAT_ADDR             0x0893
#define NVMDATL_ADDR            0x0893
#define NVMDATH_ADDR            0x0894
#define NVMCON1_ADDR            0x0895
#define NVMCON2_ADDR            0x0896
#define PCON0_ADDR              0x089B
#define PMD0_ADDR               0x0911
#define PMD1_ADDR               0x0912
#define PMD2_ADDR               0x0913
#define PMD3_ADDR               0x0914
#define PMD4_ADDR               0x0915
#define PMD5_ADDR               0x0916
#define CPUDOZE_ADDR            0x0918
#define OSCCON1_ADDR            0x0919
#define OSCCON2_ADDR            0x091A
#define OSCCON3_ADDR            0x091B
#define OSCSTAT1_ADDR           0x091C
#define OSCEN_ADDR              0x091D
#define OSCTUNE_ADDR            0x091E
#define OSCFRQ_ADDR             0x091F
#define PPSLOCK_ADDR            0x0E0F
#define INTPPS_ADDR             0x0E10
#define T0CKIPPS_ADDR           0x0E11
#define T1CKIPPS_ADDR           0x0E12
#define T1GPPS_ADDR             0x0E13
#define CCP1PPS_ADDR            0x0E14
#define CCP2PPS_ADDR            0x0E15
#define CCP3PPS_ADDR            0x0E16
#define CCP4PPS_ADDR            0x0E17
#define CWG1PPS_ADDR            0x0E18
#define CWG2PPS_ADDR            0x0E19
#define MDCIN1PPS_ADDR          0x0E1A
#define MDCIN2PPS_ADDR          0x0E1B
#define MDMINPPS_ADDR           0x0E1C
#define SSP2CLKPPS_ADDR         0x0E1D
#define SSP2DATPPS_ADDR         0x0E1E
#define SSP2SSPPS_ADDR          0x0E1F
#define SSP1CLKPPS_ADDR         0x0E20
#define SSP1DATPPS_ADDR         0x0E21
#define SSP1SSPPS_ADDR          0x0E22
#define RXPPS_ADDR              0x0E24
#define TXPPS_ADDR              0x0E25
#define CLCIN0PPS_ADDR          0x0E28
#define CLCIN1PPS_ADDR          0x0E29
#define CLCIN2PPS_ADDR          0x0E2A
#define CLCIN3PPS_ADDR          0x0E2B
#define T3CKIPPS_ADDR           0x0E2C
#define T3GPPS_ADDR             0x0E2D
#define T5CKIPPS_ADDR           0x0E2E
#define T5GPPS_ADDR             0x0E2F
#define RA0PPS_ADDR             0x0E90
#define RA1PPS_ADDR             0x0E91
#define RA2PPS_ADDR             0x0E92
#define RA4PPS_ADDR             0x0E94
#define RA5PPS_ADDR             0x0E95
#define RB4PPS_ADDR             0x0E9C
#define RB5PPS_ADDR             0x0E9D
#define RB6PPS_ADDR             0x0E9E
#define RB7PPS_ADDR             0x0E9F
#define RC0PPS_ADDR             0x0EA0
#define RC1PPS_ADDR             0x0EA1
#define RC2PPS_ADDR             0x0EA2
#define RC3PPS_ADDR             0x0EA3
#define RC4PPS_ADDR             0x0EA4
#define RC5PPS_ADDR             0x0EA5
#define RC6PPS_ADDR             0x0EA6
#define RC7PPS_ADDR             0x0EA7
#define CLCDATA_ADDR            0x0F0F
#define CLC1CON_ADDR            0x0F10
#define CLC1POL_ADDR            0x0F11
#define CLC1SEL0_ADDR           0x0F12
#define CLC1SEL1_ADDR           0x0F13
#define CLC1SEL2_ADDR           0x0F14
#define CLC1SEL3_ADDR           0x0F15
#define CLC1GLS0_ADDR           0x0F16
#define CLC1GLS1_ADDR           0x0F17
#define CLC1GLS2_ADDR           0x0F18
#define CLC1GLS3_ADDR           0x0F19
#define CLC2CON_ADDR            0x0F1A
#define CLC2POL_ADDR            0x0F1B
#define CLC2SEL0_ADDR           0x0F1C
#define CLC2SEL1_ADDR           0x0F1D
#define CLC2SEL2_ADDR           0x0F1E
#define CLC2SEL3_ADDR           0x0F1F
#define CLC2GLS0_ADDR           0x0F20
#define CLC2GLS1_ADDR           0x0F21
#define CLC2GLS2_ADDR           0x0F22
#define CLC2GLS3_ADDR           0x0F23
#define CLC3CON_ADDR            0x0F24
#define CLC3POL_ADDR            0x0F25
#define CLC3SEL0_ADDR           0x0F26
#define CLC3SEL1_ADDR           0x0F27
#define CLC3SEL2_ADDR           0x0F28
#define CLC3SEL3_ADDR           0x0F29
#define CLC3GLS0_ADDR           0x0F2A
#define CLC3GLS1_ADDR           0x0F2B
#define CLC3GLS2_ADDR           0x0F2C
#define CLC3GLS3_ADDR           0x0F2D
#define CLC4CON_ADDR            0x0F2E
#define CLC4POL_ADDR            0x0F2F
#define CLC4SEL0_ADDR           0x0F30
#define CLC4SEL1_ADDR           0x0F31
#define CLC4SEL2_ADDR           0x0F32
#define CLC4SEL3_ADDR           0x0F33
#define CLC4GLS0_ADDR           0x0F34
#define CLC4GLS1_ADDR           0x0F35
#define CLC4GLS2_ADDR           0x0F36
#define CLC4GLS3_ADDR           0x0F37
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef struct
  {
  unsigned INTEDG               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PEIE                 : 1;
  unsigned GIE                  : 1;
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _INTEDG                 0x01
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 6;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x000D) __sfr PORTB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x000D) volatile __PORTBbits_t PORTBbits;

#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PIR0 Bits

extern __at(0x0010) __sfr PIR0;

typedef struct
  {
  unsigned INTF                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCIF                : 1;
  unsigned TMR0IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR0bits_t;

extern __at(0x0010) volatile __PIR0bits_t PIR0bits;

#define _INTF                   0x01
#define _IOCIF                  0x10
#define _TMR0IF                 0x20

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned BCL1IF               : 1;
  unsigned SSP1IF               : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned ADIF                 : 1;
  unsigned TMR1GIF              : 1;
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _BCL1IF                 0x04
#define _SSP1IF                 0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned NCO1IF               : 1;
  unsigned TMR4IF               : 1;
  unsigned BCL2IF               : 1;
  unsigned SSP2IF               : 1;
  unsigned NVMIF                : 1;
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned TMR6IF               : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _NCO1IF                 0x01
#define _TMR4IF                 0x02
#define _BCL2IF                 0x04
#define _SSP2IF                 0x08
#define _NVMIF                  0x10
#define _C1IF                   0x20
#define _C2IF                   0x40
#define _TMR6IF                 0x80

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0013) __sfr PIR3;

typedef struct
  {
  unsigned CLC1IF               : 1;
  unsigned CLC2IF               : 1;
  unsigned CLC3IF               : 1;
  unsigned CLC4IF               : 1;
  unsigned TMR3IF               : 1;
  unsigned TMR3GIF              : 1;
  unsigned CSWIF                : 1;
  unsigned OSFIF                : 1;
  } __PIR3bits_t;

extern __at(0x0013) volatile __PIR3bits_t PIR3bits;

#define _CLC1IF                 0x01
#define _CLC2IF                 0x02
#define _CLC3IF                 0x04
#define _CLC4IF                 0x08
#define _TMR3IF                 0x10
#define _TMR3GIF                0x20
#define _CSWIF                  0x40
#define _OSFIF                  0x80

//==============================================================================


//==============================================================================
//        PIR4 Bits

extern __at(0x0014) __sfr PIR4;

typedef struct
  {
  unsigned CCP1IF               : 1;
  unsigned CCP2IF               : 1;
  unsigned CCP3IF               : 1;
  unsigned CCP4IF               : 1;
  unsigned TMR5IF               : 1;
  unsigned TMR5GIF              : 1;
  unsigned CWG1IF               : 1;
  unsigned CWG2IF               : 1;
  } __PIR4bits_t;

extern __at(0x0014) volatile __PIR4bits_t PIR4bits;

#define _CCP1IF                 0x01
#define _CCP2IF                 0x02
#define _CCP3IF                 0x04
#define _CCP4IF                 0x08
#define _TMR5IF                 0x10
#define _TMR5GIF                0x20
#define _CWG1IF                 0x40
#define _CWG2IF                 0x80

//==============================================================================


//==============================================================================
//        TMR0L Bits

extern __at(0x0015) __sfr TMR0L;

typedef struct
  {
  unsigned TMR00                : 1;
  unsigned TMR01                : 1;
  unsigned TMR02                : 1;
  unsigned TMR03                : 1;
  unsigned TMR04                : 1;
  unsigned TMR05                : 1;
  unsigned TMR06                : 1;
  unsigned TMR07                : 1;
  } __TMR0Lbits_t;

extern __at(0x0015) volatile __TMR0Lbits_t TMR0Lbits;

#define _TMR00                  0x01
#define _TMR01                  0x02
#define _TMR02                  0x04
#define _TMR03                  0x08
#define _TMR04                  0x10
#define _TMR05                  0x20
#define _TMR06                  0x40
#define _TMR07                  0x80

//==============================================================================


//==============================================================================
//        TMR0H Bits

extern __at(0x0016) __sfr TMR0H;

typedef struct
  {
  unsigned TMR08                : 1;
  unsigned TMR09                : 1;
  unsigned TMR010               : 1;
  unsigned TMR011               : 1;
  unsigned TMR012               : 1;
  unsigned TMR013               : 1;
  unsigned TMR014               : 1;
  unsigned TMR015               : 1;
  } __TMR0Hbits_t;

extern __at(0x0016) volatile __TMR0Hbits_t TMR0Hbits;

#define _TMR08                  0x01
#define _TMR09                  0x02
#define _TMR010                 0x04
#define _TMR011                 0x08
#define _TMR012                 0x10
#define _TMR013                 0x20
#define _TMR014                 0x40
#define _TMR015                 0x80

//==============================================================================


//==============================================================================
//        T0CON0 Bits

extern __at(0x0017) __sfr T0CON0;

typedef union
  {
  struct
    {
    unsigned T0OUTPS0           : 1;
    unsigned T0OUTPS1           : 1;
    unsigned T0OUTPS2           : 1;
    unsigned T0OUTPS3           : 1;
    unsigned T016BIT            : 1;
    unsigned T0OUT              : 1;
    unsigned                    : 1;
    unsigned T0EN               : 1;
    };

  struct
    {
    unsigned T0OUTPS            : 4;
    unsigned                    : 4;
    };
  } __T0CON0bits_t;

extern __at(0x0017) volatile __T0CON0bits_t T0CON0bits;

#define _T0OUTPS0               0x01
#define _T0OUTPS1               0x02
#define _T0OUTPS2               0x04
#define _T0OUTPS3               0x08
#define _T016BIT                0x10
#define _T0OUT                  0x20
#define _T0EN                   0x80

//==============================================================================


//==============================================================================
//        T0CON1 Bits

extern __at(0x0018) __sfr T0CON1;

typedef union
  {
  struct
    {
    unsigned T0CKPS0            : 1;
    unsigned T0CKPS1            : 1;
    unsigned T0CKPS2            : 1;
    unsigned T0CKPS3            : 1;
    unsigned T0ASYNC            : 1;
    unsigned T0CS0              : 1;
    unsigned T0CS1              : 1;
    unsigned T0CS2              : 1;
    };

  struct
    {
    unsigned T0CKPS             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned T0CS               : 3;
    };
  } __T0CON1bits_t;

extern __at(0x0018) volatile __T0CON1bits_t T0CON1bits;

#define _T0CKPS0                0x01
#define _T0CKPS1                0x02
#define _T0CKPS2                0x04
#define _T0CKPS3                0x08
#define _T0ASYNC                0x10
#define _T0CS0                  0x20
#define _T0CS1                  0x40
#define _T0CS2                  0x80

//==============================================================================

extern __at(0x0019) __sfr TMR1;
extern __at(0x0019) __sfr TMR1L;
extern __at(0x001A) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x001B) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned T1SYNC             : 1;
    unsigned T1SOSC             : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x001B) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _T1SYNC                 0x04
#define _T1SOSC                 0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x001C) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x001C) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_DONE         0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x001D) __sfr TMR2;
extern __at(0x001E) __sfr PR2;

//==============================================================================
//        T2CON Bits

extern __at(0x001F) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001F) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned                      : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x008D) __sfr TRISB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x008D) volatile __TRISBbits_t TRISBbits;

#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        PIE0 Bits

extern __at(0x0090) __sfr PIE0;

typedef struct
  {
  unsigned INTE                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCIE                : 1;
  unsigned TMR0IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE0bits_t;

extern __at(0x0090) volatile __PIE0bits_t PIE0bits;

#define _INTE                   0x01
#define _IOCIE                  0x10
#define _TMR0IE                 0x20

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned BCL1IE               : 1;
  unsigned SSP1IE               : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned ADIE                 : 1;
  unsigned TMR1GIE              : 1;
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _BCL1IE                 0x04
#define _SSP1IE                 0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned NCO1IE               : 1;
  unsigned TMR4IE               : 1;
  unsigned BCL2IE               : 1;
  unsigned SSP2IE               : 1;
  unsigned NVMIE                : 1;
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned TMR6IE               : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _NCO1IE                 0x01
#define _TMR4IE                 0x02
#define _BCL2IE                 0x04
#define _SSP2IE                 0x08
#define _NVMIE                  0x10
#define _C1IE                   0x20
#define _C2IE                   0x40
#define _TMR6IE                 0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0093) __sfr PIE3;

typedef struct
  {
  unsigned CLC1IE               : 1;
  unsigned CLC2IE               : 1;
  unsigned CLC3IE               : 1;
  unsigned CLC4IE               : 1;
  unsigned TMR3IE               : 1;
  unsigned TMR3GIE              : 1;
  unsigned CSWIE                : 1;
  unsigned OSFIE                : 1;
  } __PIE3bits_t;

extern __at(0x0093) volatile __PIE3bits_t PIE3bits;

#define _CLC1IE                 0x01
#define _CLC2IE                 0x02
#define _CLC3IE                 0x04
#define _CLC4IE                 0x08
#define _TMR3IE                 0x10
#define _TMR3GIE                0x20
#define _CSWIE                  0x40
#define _OSFIE                  0x80

//==============================================================================


//==============================================================================
//        PIE4 Bits

extern __at(0x0094) __sfr PIE4;

typedef struct
  {
  unsigned CCP1IE               : 1;
  unsigned CCP2IE               : 1;
  unsigned CCP3IE               : 1;
  unsigned CCP4IE               : 1;
  unsigned TMR5IE               : 1;
  unsigned TMR5GIE              : 1;
  unsigned CWG1IE               : 1;
  unsigned CWG2IE               : 1;
  } __PIE4bits_t;

extern __at(0x0094) volatile __PIE4bits_t PIE4bits;

#define _CCP1IE                 0x01
#define _CCP2IE                 0x02
#define _CCP3IE                 0x04
#define _CCP4IE                 0x08
#define _TMR5IE                 0x10
#define _TMR5GIE                0x20
#define _CWG1IE                 0x40
#define _CWG2IE                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned CHS5               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 6;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _ADGO                   0x02
#define _GO                     0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40
#define _CHS5                   0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned ADNREF             : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _ADNREF                 0x04
#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADACT Bits

extern __at(0x009F) __sfr ADACT;

typedef union
  {
  struct
    {
    unsigned ADACT0             : 1;
    unsigned ADACT1             : 1;
    unsigned ADACT2             : 1;
    unsigned ADACT3             : 1;
    unsigned ADACT4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACT              : 5;
    unsigned                    : 3;
    };
  } __ADACTbits_t;

extern __at(0x009F) volatile __ADACTbits_t ADACTbits;

#define _ADACT0                 0x01
#define _ADACT1                 0x02
#define _ADACT2                 0x04
#define _ADACT3                 0x08
#define _ADACT4                 0x10

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned                      : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA4                  0x10
#define _LATA5                  0x20

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x010D) __sfr LATB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x010D) volatile __LATBbits_t LATBbits;

#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0111) __sfr CM1CON0;

typedef struct
  {
  unsigned C1SYNC               : 1;
  unsigned C1HYS                : 1;
  unsigned C1SP                 : 1;
  unsigned                      : 1;
  unsigned C1POL                : 1;
  unsigned                      : 1;
  unsigned C1OUT                : 1;
  unsigned C1ON                 : 1;
  } __CM1CON0bits_t;

extern __at(0x0111) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1SYNC                 0x01
#define _C1HYS                  0x02
#define _C1SP                   0x04
#define _C1POL                  0x10
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x0112) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned C1NCH0             : 1;
    unsigned C1NCH1             : 1;
    unsigned C1NCH2             : 1;
    unsigned C1PCH0             : 1;
    unsigned C1PCH1             : 1;
    unsigned C1PCH2             : 1;
    unsigned C1INTN             : 1;
    unsigned C1INTP             : 1;
    };

  struct
    {
    unsigned C1NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned C1PCH              : 3;
    unsigned                    : 2;
    };
  } __CM1CON1bits_t;

extern __at(0x0112) volatile __CM1CON1bits_t CM1CON1bits;

#define _C1NCH0                 0x01
#define _C1NCH1                 0x02
#define _C1NCH2                 0x04
#define _C1PCH0                 0x08
#define _C1PCH1                 0x10
#define _C1PCH2                 0x20
#define _C1INTN                 0x40
#define _C1INTP                 0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x0113) __sfr CM2CON0;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned C2HYS                : 1;
  unsigned C2SP                 : 1;
  unsigned                      : 1;
  unsigned C2POL                : 1;
  unsigned                      : 1;
  unsigned C2OUT                : 1;
  unsigned C2ON                 : 1;
  } __CM2CON0bits_t;

extern __at(0x0113) volatile __CM2CON0bits_t CM2CON0bits;

#define _C2SYNC                 0x01
#define _C2HYS                  0x02
#define _C2SP                   0x04
#define _C2POL                  0x10
#define _C2OUT                  0x40
#define _C2ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0114) __sfr CM2CON1;

typedef union
  {
  struct
    {
    unsigned C2NCH0             : 1;
    unsigned C2NCH1             : 1;
    unsigned C2NCH2             : 1;
    unsigned C2PCH0             : 1;
    unsigned C2PCH1             : 1;
    unsigned C2PCH2             : 1;
    unsigned C2INTN             : 1;
    unsigned C2INTP             : 1;
    };

  struct
    {
    unsigned C2NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned C2PCH              : 3;
    unsigned                    : 2;
    };
  } __CM2CON1bits_t;

extern __at(0x0114) volatile __CM2CON1bits_t CM2CON1bits;

#define _C2NCH0                 0x01
#define _C2NCH1                 0x02
#define _C2NCH2                 0x04
#define _C2PCH0                 0x08
#define _C2PCH1                 0x10
#define _C2PCH2                 0x20
#define _C2INTN                 0x40
#define _C2INTP                 0x80

//==============================================================================


//==============================================================================
//        CMOUT Bits

extern __at(0x0115) __sfr CMOUT;

typedef struct
  {
  unsigned MC1OUT               : 1;
  unsigned MC2OUT               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CMOUTbits_t;

extern __at(0x0115) volatile __CMOUTbits_t CMOUTbits;

#define _MC1OUT                 0x01
#define _MC2OUT                 0x02

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned CDAFVR0            : 1;
    unsigned CDAFVR1            : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CDAFVR             : 2;
    unsigned                    : 4;
    };
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _CDAFVR0                0x04
#define _CDAFVR1                0x08
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        DACCON0 Bits

extern __at(0x0118) __sfr DACCON0;

typedef union
  {
  struct
    {
    unsigned DAC1NSS            : 1;
    unsigned                    : 1;
    unsigned DAC1PSS0           : 1;
    unsigned DAC1PSS1           : 1;
    unsigned                    : 1;
    unsigned DAC1OE             : 1;
    unsigned                    : 1;
    unsigned DAC1EN             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DAC1PSS            : 2;
    unsigned                    : 4;
    };
  } __DACCON0bits_t;

extern __at(0x0118) volatile __DACCON0bits_t DACCON0bits;

#define _DAC1NSS                0x01
#define _DAC1PSS0               0x04
#define _DAC1PSS1               0x08
#define _DAC1OE                 0x20
#define _DAC1EN                 0x80

//==============================================================================


//==============================================================================
//        DACCON1 Bits

extern __at(0x0119) __sfr DACCON1;

typedef union
  {
  struct
    {
    unsigned DAC1R0             : 1;
    unsigned DAC1R1             : 1;
    unsigned DAC1R2             : 1;
    unsigned DAC1R3             : 1;
    unsigned DAC1R4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC1R              : 5;
    unsigned                    : 3;
    };
  } __DACCON1bits_t;

extern __at(0x0119) volatile __DACCON1bits_t DACCON1bits;

#define _DAC1R0                 0x01
#define _DAC1R1                 0x02
#define _DAC1R2                 0x04
#define _DAC1R3                 0x08
#define _DAC1R4                 0x10

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned                      : 1;
  unsigned ANSA4                : 1;
  unsigned ANSA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA4                  0x10
#define _ANSA5                  0x20

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x018D) __sfr ANSELB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSB4                : 1;
  unsigned ANSB5                : 1;
  unsigned ANSB6                : 1;
  unsigned ANSB7                : 1;
  } __ANSELBbits_t;

extern __at(0x018D) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB4                  0x10
#define _ANSB5                  0x20
#define _ANSB6                  0x40
#define _ANSB7                  0x80

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x018E) __sfr ANSELC;

typedef struct
  {
  unsigned ANSC0                : 1;
  unsigned ANSC1                : 1;
  unsigned ANSC2                : 1;
  unsigned ANSC3                : 1;
  unsigned ANSC4                : 1;
  unsigned ANSC5                : 1;
  unsigned ANSC6                : 1;
  unsigned ANSC7                : 1;
  } __ANSELCbits_t;

extern __at(0x018E) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC0                  0x01
#define _ANSC1                  0x02
#define _ANSC2                  0x04
#define _ANSC3                  0x08
#define _ANSC4                  0x10
#define _ANSC5                  0x20
#define _ANSC6                  0x40
#define _ANSC7                  0x80

//==============================================================================


//==============================================================================
//        VREGCON Bits

extern __at(0x0197) __sfr VREGCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned VREGPM               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __VREGCONbits_t;

extern __at(0x0197) volatile __VREGCONbits_t VREGCONbits;

#define _VREGPM                 0x02

//==============================================================================

extern __at(0x0199) __sfr RC1REG;
extern __at(0x0199) __sfr RCREG;
extern __at(0x0199) __sfr RCREG1;
extern __at(0x019A) __sfr TX1REG;
extern __at(0x019A) __sfr TXREG;
extern __at(0x019A) __sfr TXREG1;
extern __at(0x019B) __sfr SP1BRG;
extern __at(0x019B) __sfr SP1BRGL;
extern __at(0x019B) __sfr SPBRG;
extern __at(0x019B) __sfr SPBRG1;
extern __at(0x019B) __sfr SPBRGL;
extern __at(0x019C) __sfr SP1BRGH;
extern __at(0x019C) __sfr SPBRGH;
extern __at(0x019C) __sfr SPBRGH1;

//==============================================================================
//        RC1STA Bits

extern __at(0x019D) __sfr RC1STA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RC1STAbits_t;

extern __at(0x019D) volatile __RC1STAbits_t RC1STAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x019D) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x019D) volatile __RCSTAbits_t RCSTAbits;

#define _RCSTA_RX9D             0x01
#define _RCSTA_OERR             0x02
#define _RCSTA_FERR             0x04
#define _RCSTA_ADDEN            0x08
#define _RCSTA_CREN             0x10
#define _RCSTA_SREN             0x20
#define _RCSTA_RX9              0x40
#define _RCSTA_SPEN             0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x019D) __sfr RCSTA1;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTA1bits_t;

extern __at(0x019D) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_SPEN            0x80

//==============================================================================


//==============================================================================
//        TX1STA Bits

extern __at(0x019E) __sfr TX1STA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TX1STAbits_t;

extern __at(0x019E) volatile __TX1STAbits_t TX1STAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x019E) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x019E) volatile __TXSTAbits_t TXSTAbits;

#define _TXSTA_TX9D             0x01
#define _TXSTA_TRMT             0x02
#define _TXSTA_BRGH             0x04
#define _TXSTA_SENDB            0x08
#define _TXSTA_SYNC             0x10
#define _TXSTA_TXEN             0x20
#define _TXSTA_TX9              0x40
#define _TXSTA_CSRC             0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x019E) __sfr TXSTA1;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTA1bits_t;

extern __at(0x019E) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_CSRC            0x80

//==============================================================================


//==============================================================================
//        BAUD1CON Bits

extern __at(0x019F) __sfr BAUD1CON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUD1CONbits_t;

extern __at(0x019F) volatile __BAUD1CONbits_t BAUD1CONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x019F) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x019F) volatile __BAUDCONbits_t BAUDCONbits;

#define _BAUDCON_ABDEN          0x01
#define _BAUDCON_WUE            0x02
#define _BAUDCON_BRG16          0x08
#define _BAUDCON_SCKP           0x10
#define _BAUDCON_RCIDL          0x40
#define _BAUDCON_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x019F) __sfr BAUDCON1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCON1bits_t;

extern __at(0x019F) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _BAUDCON1_ABDEN         0x01
#define _BAUDCON1_WUE           0x02
#define _BAUDCON1_BRG16         0x08
#define _BAUDCON1_SCKP          0x10
#define _BAUDCON1_RCIDL         0x40
#define _BAUDCON1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x019F) __sfr BAUDCTL;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTLbits_t;

extern __at(0x019F) volatile __BAUDCTLbits_t BAUDCTLbits;

#define _BAUDCTL_ABDEN          0x01
#define _BAUDCTL_WUE            0x02
#define _BAUDCTL_BRG16          0x08
#define _BAUDCTL_SCKP           0x10
#define _BAUDCTL_RCIDL          0x40
#define _BAUDCTL_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCTL1 Bits

extern __at(0x019F) __sfr BAUDCTL1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTL1bits_t;

extern __at(0x019F) volatile __BAUDCTL1bits_t BAUDCTL1bits;

#define _BAUDCTL1_ABDEN         0x01
#define _BAUDCTL1_WUE           0x02
#define _BAUDCTL1_BRG16         0x08
#define _BAUDCTL1_SCKP          0x10
#define _BAUDCTL1_RCIDL         0x40
#define _BAUDCTL1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x020C) __sfr WPUA;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned WPUA3              : 1;
    unsigned WPUA4              : 1;
    unsigned WPUA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUA               : 6;
    unsigned                    : 2;
    };
  } __WPUAbits_t;

extern __at(0x020C) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x020D) __sfr WPUB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x020D) volatile __WPUBbits_t WPUBbits;

#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        WPUC Bits

extern __at(0x020E) __sfr WPUC;

typedef struct
  {
  unsigned WPUC0                : 1;
  unsigned WPUC1                : 1;
  unsigned WPUC2                : 1;
  unsigned WPUC3                : 1;
  unsigned WPUC4                : 1;
  unsigned WPUC5                : 1;
  unsigned WPUC6                : 1;
  unsigned WPUC7                : 1;
  } __WPUCbits_t;

extern __at(0x020E) volatile __WPUCbits_t WPUCbits;

#define _WPUC0                  0x01
#define _WPUC1                  0x02
#define _WPUC2                  0x04
#define _WPUC3                  0x08
#define _WPUC4                  0x10
#define _WPUC5                  0x20
#define _WPUC6                  0x40
#define _WPUC7                  0x80

//==============================================================================


//==============================================================================
//        SSP1BUF Bits

extern __at(0x0211) __sfr SSP1BUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSP1BUFbits_t;

extern __at(0x0211) volatile __SSP1BUFbits_t SSP1BUFbits;

#define _SSP1BUF0               0x01
#define _BUF0                   0x01
#define _SSP1BUF1               0x02
#define _BUF1                   0x02
#define _SSP1BUF2               0x04
#define _BUF2                   0x04
#define _SSP1BUF3               0x08
#define _BUF3                   0x08
#define _SSP1BUF4               0x10
#define _BUF4                   0x10
#define _SSP1BUF5               0x20
#define _BUF5                   0x20
#define _SSP1BUF6               0x40
#define _BUF6                   0x40
#define _SSP1BUF7               0x80
#define _BUF7                   0x80

//==============================================================================


//==============================================================================
//        SSPBUF Bits

extern __at(0x0211) __sfr SSPBUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSPBUFbits_t;

extern __at(0x0211) volatile __SSPBUFbits_t SSPBUFbits;

#define _SSPBUF_SSP1BUF0        0x01
#define _SSPBUF_BUF0            0x01
#define _SSPBUF_SSP1BUF1        0x02
#define _SSPBUF_BUF1            0x02
#define _SSPBUF_SSP1BUF2        0x04
#define _SSPBUF_BUF2            0x04
#define _SSPBUF_SSP1BUF3        0x08
#define _SSPBUF_BUF3            0x08
#define _SSPBUF_SSP1BUF4        0x10
#define _SSPBUF_BUF4            0x10
#define _SSPBUF_SSP1BUF5        0x20
#define _SSPBUF_BUF5            0x20
#define _SSPBUF_SSP1BUF6        0x40
#define _SSPBUF_BUF6            0x40
#define _SSPBUF_SSP1BUF7        0x80
#define _SSPBUF_BUF7            0x80

//==============================================================================


//==============================================================================
//        SSP1ADD Bits

extern __at(0x0212) __sfr SSP1ADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSP1ADDbits_t;

extern __at(0x0212) volatile __SSP1ADDbits_t SSP1ADDbits;

#define _SSP1ADD0               0x01
#define _ADD0                   0x01
#define _SSP1ADD1               0x02
#define _ADD1                   0x02
#define _SSP1ADD2               0x04
#define _ADD2                   0x04
#define _SSP1ADD3               0x08
#define _ADD3                   0x08
#define _SSP1ADD4               0x10
#define _ADD4                   0x10
#define _SSP1ADD5               0x20
#define _ADD5                   0x20
#define _SSP1ADD6               0x40
#define _ADD6                   0x40
#define _SSP1ADD7               0x80
#define _ADD7                   0x80

//==============================================================================


//==============================================================================
//        SSPADD Bits

extern __at(0x0212) __sfr SSPADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSPADDbits_t;

extern __at(0x0212) volatile __SSPADDbits_t SSPADDbits;

#define _SSPADD_SSP1ADD0        0x01
#define _SSPADD_ADD0            0x01
#define _SSPADD_SSP1ADD1        0x02
#define _SSPADD_ADD1            0x02
#define _SSPADD_SSP1ADD2        0x04
#define _SSPADD_ADD2            0x04
#define _SSPADD_SSP1ADD3        0x08
#define _SSPADD_ADD3            0x08
#define _SSPADD_SSP1ADD4        0x10
#define _SSPADD_ADD4            0x10
#define _SSPADD_SSP1ADD5        0x20
#define _SSPADD_ADD5            0x20
#define _SSPADD_SSP1ADD6        0x40
#define _SSPADD_ADD6            0x40
#define _SSPADD_SSP1ADD7        0x80
#define _SSPADD_ADD7            0x80

//==============================================================================


//==============================================================================
//        SSP1MSK Bits

extern __at(0x0213) __sfr SSP1MSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSP1MSKbits_t;

extern __at(0x0213) volatile __SSP1MSKbits_t SSP1MSKbits;

#define _SSP1MSK0               0x01
#define _MSK0                   0x01
#define _SSP1MSK1               0x02
#define _MSK1                   0x02
#define _SSP1MSK2               0x04
#define _MSK2                   0x04
#define _SSP1MSK3               0x08
#define _MSK3                   0x08
#define _SSP1MSK4               0x10
#define _MSK4                   0x10
#define _SSP1MSK5               0x20
#define _MSK5                   0x20
#define _SSP1MSK6               0x40
#define _MSK6                   0x40
#define _SSP1MSK7               0x80
#define _MSK7                   0x80

//==============================================================================


//==============================================================================
//        SSPMSK Bits

extern __at(0x0213) __sfr SSPMSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSPMSKbits_t;

extern __at(0x0213) volatile __SSPMSKbits_t SSPMSKbits;

#define _SSPMSK_SSP1MSK0        0x01
#define _SSPMSK_MSK0            0x01
#define _SSPMSK_SSP1MSK1        0x02
#define _SSPMSK_MSK1            0x02
#define _SSPMSK_SSP1MSK2        0x04
#define _SSPMSK_MSK2            0x04
#define _SSPMSK_SSP1MSK3        0x08
#define _SSPMSK_MSK3            0x08
#define _SSPMSK_SSP1MSK4        0x10
#define _SSPMSK_MSK4            0x10
#define _SSPMSK_SSP1MSK5        0x20
#define _SSPMSK_MSK5            0x20
#define _SSPMSK_SSP1MSK6        0x40
#define _SSPMSK_MSK6            0x40
#define _SSPMSK_SSP1MSK7        0x80
#define _SSPMSK_MSK7            0x80

//==============================================================================


//==============================================================================
//        SSP1STAT Bits

extern __at(0x0214) __sfr SSP1STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP1STATbits_t;

extern __at(0x0214) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0214) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0214) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1CON Bits

extern __at(0x0215) __sfr SSP1CON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CONbits_t;

extern __at(0x0215) volatile __SSP1CONbits_t SSP1CONbits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0215) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0215) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSP1CON1_SSPM0         0x01
#define _SSP1CON1_SSPM1         0x02
#define _SSP1CON1_SSPM2         0x04
#define _SSP1CON1_SSPM3         0x08
#define _SSP1CON1_CKP           0x10
#define _SSP1CON1_SSPEN         0x20
#define _SSP1CON1_SSPOV         0x40
#define _SSP1CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSPCON Bits

extern __at(0x0215) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0215) volatile __SSPCONbits_t SSPCONbits;

#define _SSPCON_SSPM0           0x01
#define _SSPCON_SSPM1           0x02
#define _SSPCON_SSPM2           0x04
#define _SSPCON_SSPM3           0x08
#define _SSPCON_CKP             0x10
#define _SSPCON_SSPEN           0x20
#define _SSPCON_SSPOV           0x40
#define _SSPCON_WCOL            0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0215) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0215) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0216) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0216) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0216) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0216) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0217) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0217) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0217) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0217) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================


//==============================================================================
//        SSP2BUF Bits

extern __at(0x0219) __sfr SSP2BUF;

typedef union
  {
  struct
    {
    unsigned SSP2BUF0           : 1;
    unsigned SSP2BUF1           : 1;
    unsigned SSP2BUF2           : 1;
    unsigned SSP2BUF3           : 1;
    unsigned SSP2BUF4           : 1;
    unsigned SSP2BUF5           : 1;
    unsigned SSP2BUF6           : 1;
    unsigned SSP2BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSP2BUFbits_t;

extern __at(0x0219) volatile __SSP2BUFbits_t SSP2BUFbits;

#define _SSP2BUF_SSP2BUF0       0x01
#define _SSP2BUF_BUF0           0x01
#define _SSP2BUF_SSP2BUF1       0x02
#define _SSP2BUF_BUF1           0x02
#define _SSP2BUF_SSP2BUF2       0x04
#define _SSP2BUF_BUF2           0x04
#define _SSP2BUF_SSP2BUF3       0x08
#define _SSP2BUF_BUF3           0x08
#define _SSP2BUF_SSP2BUF4       0x10
#define _SSP2BUF_BUF4           0x10
#define _SSP2BUF_SSP2BUF5       0x20
#define _SSP2BUF_BUF5           0x20
#define _SSP2BUF_SSP2BUF6       0x40
#define _SSP2BUF_BUF6           0x40
#define _SSP2BUF_SSP2BUF7       0x80
#define _SSP2BUF_BUF7           0x80

//==============================================================================


//==============================================================================
//        SSP2ADD Bits

extern __at(0x021A) __sfr SSP2ADD;

typedef union
  {
  struct
    {
    unsigned SSP2ADD0           : 1;
    unsigned SSP2ADD1           : 1;
    unsigned SSP2ADD2           : 1;
    unsigned SSP2ADD3           : 1;
    unsigned SSP2ADD4           : 1;
    unsigned SSP2ADD5           : 1;
    unsigned SSP2ADD6           : 1;
    unsigned SSP2ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSP2ADDbits_t;

extern __at(0x021A) volatile __SSP2ADDbits_t SSP2ADDbits;

#define _SSP2ADD_SSP2ADD0       0x01
#define _SSP2ADD_ADD0           0x01
#define _SSP2ADD_SSP2ADD1       0x02
#define _SSP2ADD_ADD1           0x02
#define _SSP2ADD_SSP2ADD2       0x04
#define _SSP2ADD_ADD2           0x04
#define _SSP2ADD_SSP2ADD3       0x08
#define _SSP2ADD_ADD3           0x08
#define _SSP2ADD_SSP2ADD4       0x10
#define _SSP2ADD_ADD4           0x10
#define _SSP2ADD_SSP2ADD5       0x20
#define _SSP2ADD_ADD5           0x20
#define _SSP2ADD_SSP2ADD6       0x40
#define _SSP2ADD_ADD6           0x40
#define _SSP2ADD_SSP2ADD7       0x80
#define _SSP2ADD_ADD7           0x80

//==============================================================================


//==============================================================================
//        SSP2MSK Bits

extern __at(0x021B) __sfr SSP2MSK;

typedef union
  {
  struct
    {
    unsigned SSP2MSK0           : 1;
    unsigned SSP2MSK1           : 1;
    unsigned SSP2MSK2           : 1;
    unsigned SSP2MSK3           : 1;
    unsigned SSP2MSK4           : 1;
    unsigned SSP2MSK5           : 1;
    unsigned SSP2MSK6           : 1;
    unsigned SSP2MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSP2MSKbits_t;

extern __at(0x021B) volatile __SSP2MSKbits_t SSP2MSKbits;

#define _SSP2MSK_SSP2MSK0       0x01
#define _SSP2MSK_MSK0           0x01
#define _SSP2MSK_SSP2MSK1       0x02
#define _SSP2MSK_MSK1           0x02
#define _SSP2MSK_SSP2MSK2       0x04
#define _SSP2MSK_MSK2           0x04
#define _SSP2MSK_SSP2MSK3       0x08
#define _SSP2MSK_MSK3           0x08
#define _SSP2MSK_SSP2MSK4       0x10
#define _SSP2MSK_MSK4           0x10
#define _SSP2MSK_SSP2MSK5       0x20
#define _SSP2MSK_MSK5           0x20
#define _SSP2MSK_SSP2MSK6       0x40
#define _SSP2MSK_MSK6           0x40
#define _SSP2MSK_SSP2MSK7       0x80
#define _SSP2MSK_MSK7           0x80

//==============================================================================


//==============================================================================
//        SSP2STAT Bits

extern __at(0x021C) __sfr SSP2STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP2STATbits_t;

extern __at(0x021C) volatile __SSP2STATbits_t SSP2STATbits;

#define _SSP2STAT_BF            0x01
#define _SSP2STAT_UA            0x02
#define _SSP2STAT_R_NOT_W       0x04
#define _SSP2STAT_S             0x08
#define _SSP2STAT_P             0x10
#define _SSP2STAT_D_NOT_A       0x20
#define _SSP2STAT_CKE           0x40
#define _SSP2STAT_SMP           0x80

//==============================================================================


//==============================================================================
//        SSP2CON Bits

extern __at(0x021D) __sfr SSP2CON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP2CONbits_t;

extern __at(0x021D) volatile __SSP2CONbits_t SSP2CONbits;

#define _SSP2CON_SSPM0          0x01
#define _SSP2CON_SSPM1          0x02
#define _SSP2CON_SSPM2          0x04
#define _SSP2CON_SSPM3          0x08
#define _SSP2CON_CKP            0x10
#define _SSP2CON_SSPEN          0x20
#define _SSP2CON_SSPOV          0x40
#define _SSP2CON_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP2CON1 Bits

extern __at(0x021D) __sfr SSP2CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP2CON1bits_t;

extern __at(0x021D) volatile __SSP2CON1bits_t SSP2CON1bits;

#define _SSP2CON1_SSPM0         0x01
#define _SSP2CON1_SSPM1         0x02
#define _SSP2CON1_SSPM2         0x04
#define _SSP2CON1_SSPM3         0x08
#define _SSP2CON1_CKP           0x10
#define _SSP2CON1_SSPEN         0x20
#define _SSP2CON1_SSPOV         0x40
#define _SSP2CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSP2CON2 Bits

extern __at(0x021E) __sfr SSP2CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP2CON2bits_t;

extern __at(0x021E) volatile __SSP2CON2bits_t SSP2CON2bits;

#define _SSP2CON2_SEN           0x01
#define _SSP2CON2_RSEN          0x02
#define _SSP2CON2_PEN           0x04
#define _SSP2CON2_RCEN          0x08
#define _SSP2CON2_ACKEN         0x10
#define _SSP2CON2_ACKDT         0x20
#define _SSP2CON2_ACKSTAT       0x40
#define _SSP2CON2_GCEN          0x80

//==============================================================================


//==============================================================================
//        SSP2CON3 Bits

extern __at(0x021F) __sfr SSP2CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP2CON3bits_t;

extern __at(0x021F) volatile __SSP2CON3bits_t SSP2CON3bits;

#define _SSP2CON3_DHEN          0x01
#define _SSP2CON3_AHEN          0x02
#define _SSP2CON3_SBCDE         0x04
#define _SSP2CON3_SDAHT         0x08
#define _SSP2CON3_BOEN          0x10
#define _SSP2CON3_SCIE          0x20
#define _SSP2CON3_PCIE          0x40
#define _SSP2CON3_ACKTIM        0x80

//==============================================================================


//==============================================================================
//        ODCONA Bits

extern __at(0x028C) __sfr ODCONA;

typedef struct
  {
  unsigned ODCA0                : 1;
  unsigned ODCA1                : 1;
  unsigned ODCA2                : 1;
  unsigned                      : 1;
  unsigned ODCA4                : 1;
  unsigned ODCA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ODCONAbits_t;

extern __at(0x028C) volatile __ODCONAbits_t ODCONAbits;

#define _ODCA0                  0x01
#define _ODCA1                  0x02
#define _ODCA2                  0x04
#define _ODCA4                  0x10
#define _ODCA5                  0x20

//==============================================================================


//==============================================================================
//        ODCONB Bits

extern __at(0x028D) __sfr ODCONB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ODCB4                : 1;
  unsigned ODCB5                : 1;
  unsigned ODCB6                : 1;
  unsigned ODCB7                : 1;
  } __ODCONBbits_t;

extern __at(0x028D) volatile __ODCONBbits_t ODCONBbits;

#define _ODCB4                  0x10
#define _ODCB5                  0x20
#define _ODCB6                  0x40
#define _ODCB7                  0x80

//==============================================================================


//==============================================================================
//        ODCONC Bits

extern __at(0x028E) __sfr ODCONC;

typedef struct
  {
  unsigned ODCC0                : 1;
  unsigned ODCC1                : 1;
  unsigned ODCC2                : 1;
  unsigned ODCC3                : 1;
  unsigned ODCC4                : 1;
  unsigned ODCC5                : 1;
  unsigned ODCC6                : 1;
  unsigned ODCC7                : 1;
  } __ODCONCbits_t;

extern __at(0x028E) volatile __ODCONCbits_t ODCONCbits;

#define _ODCC0                  0x01
#define _ODCC1                  0x02
#define _ODCC2                  0x04
#define _ODCC3                  0x08
#define _ODCC4                  0x10
#define _ODCC5                  0x20
#define _ODCC6                  0x40
#define _ODCC7                  0x80

//==============================================================================

extern __at(0x0291) __sfr CCPR1;
extern __at(0x0291) __sfr CCPR1L;
extern __at(0x0292) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0293) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1MODE0          : 1;
    unsigned CCP1MODE1          : 1;
    unsigned CCP1MODE2          : 1;
    unsigned CCP1MODE3          : 1;
    unsigned CCP1FMT            : 1;
    unsigned CCP1OUT            : 1;
    unsigned                    : 1;
    unsigned CCP1EN             : 1;
    };

  struct
    {
    unsigned CCP1MODE           : 4;
    unsigned                    : 4;
    };
  } __CCP1CONbits_t;

extern __at(0x0293) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1MODE0              0x01
#define _CCP1MODE1              0x02
#define _CCP1MODE2              0x04
#define _CCP1MODE3              0x08
#define _CCP1FMT                0x10
#define _CCP1OUT                0x20
#define _CCP1EN                 0x80

//==============================================================================


//==============================================================================
//        CCP1CAP Bits

extern __at(0x0294) __sfr CCP1CAP;

typedef union
  {
  struct
    {
    unsigned CCP1CTS0           : 1;
    unsigned CCP1CTS1           : 1;
    unsigned CCP1CTS2           : 1;
    unsigned CCP1CTS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1CTS            : 4;
    unsigned                    : 4;
    };
  } __CCP1CAPbits_t;

extern __at(0x0294) volatile __CCP1CAPbits_t CCP1CAPbits;

#define _CCP1CTS0               0x01
#define _CCP1CTS1               0x02
#define _CCP1CTS2               0x04
#define _CCP1CTS3               0x08

//==============================================================================

extern __at(0x0295) __sfr CCPR2;
extern __at(0x0295) __sfr CCPR2L;
extern __at(0x0296) __sfr CCPR2H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x0297) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2MODE0          : 1;
    unsigned CCP2MODE1          : 1;
    unsigned CCP2MODE2          : 1;
    unsigned CCP2MODE3          : 1;
    unsigned CCP2FMT            : 1;
    unsigned CCP2OUT            : 1;
    unsigned                    : 1;
    unsigned CCP2EN             : 1;
    };

  struct
    {
    unsigned CCP2MODE           : 4;
    unsigned                    : 4;
    };
  } __CCP2CONbits_t;

extern __at(0x0297) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2MODE0              0x01
#define _CCP2MODE1              0x02
#define _CCP2MODE2              0x04
#define _CCP2MODE3              0x08
#define _CCP2FMT                0x10
#define _CCP2OUT                0x20
#define _CCP2EN                 0x80

//==============================================================================


//==============================================================================
//        CCP2CAP Bits

extern __at(0x0298) __sfr CCP2CAP;

typedef union
  {
  struct
    {
    unsigned CCP2CTS0           : 1;
    unsigned CCP2CTS1           : 1;
    unsigned CCP2CTS2           : 1;
    unsigned CCP2CTS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2CTS            : 4;
    unsigned                    : 4;
    };
  } __CCP2CAPbits_t;

extern __at(0x0298) volatile __CCP2CAPbits_t CCP2CAPbits;

#define _CCP2CTS0               0x01
#define _CCP2CTS1               0x02
#define _CCP2CTS2               0x04
#define _CCP2CTS3               0x08

//==============================================================================


//==============================================================================
//        CCPTMRS Bits

extern __at(0x029F) __sfr CCPTMRS;

typedef union
  {
  struct
    {
    unsigned C1TSEL0            : 1;
    unsigned C1TSEL1            : 1;
    unsigned C2TSEL0            : 1;
    unsigned C2TSEL1            : 1;
    unsigned C3TSEL0            : 1;
    unsigned C3TSEL1            : 1;
    unsigned C4TSEL0            : 1;
    unsigned C4TSEL1            : 1;
    };

  struct
    {
    unsigned C1TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned C2TSEL             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C3TSEL             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned C4TSEL             : 2;
    };
  } __CCPTMRSbits_t;

extern __at(0x029F) volatile __CCPTMRSbits_t CCPTMRSbits;

#define _C1TSEL0                0x01
#define _C1TSEL1                0x02
#define _C2TSEL0                0x04
#define _C2TSEL1                0x08
#define _C3TSEL0                0x10
#define _C3TSEL1                0x20
#define _C4TSEL0                0x40
#define _C4TSEL1                0x80

//==============================================================================


//==============================================================================
//        SLRCONA Bits

extern __at(0x030C) __sfr SLRCONA;

typedef struct
  {
  unsigned SLRA0                : 1;
  unsigned SLRA1                : 1;
  unsigned SLRA2                : 1;
  unsigned                      : 1;
  unsigned SLRA4                : 1;
  unsigned SLRA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __SLRCONAbits_t;

extern __at(0x030C) volatile __SLRCONAbits_t SLRCONAbits;

#define _SLRA0                  0x01
#define _SLRA1                  0x02
#define _SLRA2                  0x04
#define _SLRA4                  0x10
#define _SLRA5                  0x20

//==============================================================================


//==============================================================================
//        SLRCONB Bits

extern __at(0x030D) __sfr SLRCONB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned SLRB4                : 1;
  unsigned SLRB5                : 1;
  unsigned SLRB6                : 1;
  unsigned SLRB7                : 1;
  } __SLRCONBbits_t;

extern __at(0x030D) volatile __SLRCONBbits_t SLRCONBbits;

#define _SLRB4                  0x10
#define _SLRB5                  0x20
#define _SLRB6                  0x40
#define _SLRB7                  0x80

//==============================================================================


//==============================================================================
//        SLRCONC Bits

extern __at(0x030E) __sfr SLRCONC;

typedef struct
  {
  unsigned SLRC0                : 1;
  unsigned SLRC1                : 1;
  unsigned SLRC2                : 1;
  unsigned SLRC3                : 1;
  unsigned SLRC4                : 1;
  unsigned SLRC5                : 1;
  unsigned SLRC6                : 1;
  unsigned SLRC7                : 1;
  } __SLRCONCbits_t;

extern __at(0x030E) volatile __SLRCONCbits_t SLRCONCbits;

#define _SLRC0                  0x01
#define _SLRC1                  0x02
#define _SLRC2                  0x04
#define _SLRC3                  0x08
#define _SLRC4                  0x10
#define _SLRC5                  0x20
#define _SLRC6                  0x40
#define _SLRC7                  0x80

//==============================================================================

extern __at(0x0311) __sfr CCPR3;
extern __at(0x0311) __sfr CCPR3L;
extern __at(0x0312) __sfr CCPR3H;

//==============================================================================
//        CCP3CON Bits

extern __at(0x0313) __sfr CCP3CON;

typedef union
  {
  struct
    {
    unsigned CCP3MODE0          : 1;
    unsigned CCP3MODE1          : 1;
    unsigned CCP3MODE2          : 1;
    unsigned CCP3MODE3          : 1;
    unsigned CCP3FMT            : 1;
    unsigned CCP3OUT            : 1;
    unsigned                    : 1;
    unsigned CCP3EN             : 1;
    };

  struct
    {
    unsigned CCP3MODE           : 4;
    unsigned                    : 4;
    };
  } __CCP3CONbits_t;

extern __at(0x0313) volatile __CCP3CONbits_t CCP3CONbits;

#define _CCP3MODE0              0x01
#define _CCP3MODE1              0x02
#define _CCP3MODE2              0x04
#define _CCP3MODE3              0x08
#define _CCP3FMT                0x10
#define _CCP3OUT                0x20
#define _CCP3EN                 0x80

//==============================================================================


//==============================================================================
//        CCP3CAP Bits

extern __at(0x0314) __sfr CCP3CAP;

typedef union
  {
  struct
    {
    unsigned CCP3CTS0           : 1;
    unsigned CCP3CTS1           : 1;
    unsigned CCP3CTS2           : 1;
    unsigned CCP3CTS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP3CTS            : 4;
    unsigned                    : 4;
    };
  } __CCP3CAPbits_t;

extern __at(0x0314) volatile __CCP3CAPbits_t CCP3CAPbits;

#define _CCP3CTS0               0x01
#define _CCP3CTS1               0x02
#define _CCP3CTS2               0x04
#define _CCP3CTS3               0x08

//==============================================================================

extern __at(0x0315) __sfr CCPR4;
extern __at(0x0315) __sfr CCPR4L;
extern __at(0x0316) __sfr CCPR4H;

//==============================================================================
//        CCP4CON Bits

extern __at(0x0317) __sfr CCP4CON;

typedef union
  {
  struct
    {
    unsigned CCP4MODE0          : 1;
    unsigned CCP4MODE1          : 1;
    unsigned CCP4MODE2          : 1;
    unsigned CCP4MODE3          : 1;
    unsigned CCP4FMT            : 1;
    unsigned CCP4OUT            : 1;
    unsigned                    : 1;
    unsigned CCP4EN             : 1;
    };

  struct
    {
    unsigned CCP4MODE           : 4;
    unsigned                    : 4;
    };
  } __CCP4CONbits_t;

extern __at(0x0317) volatile __CCP4CONbits_t CCP4CONbits;

#define _CCP4MODE0              0x01
#define _CCP4MODE1              0x02
#define _CCP4MODE2              0x04
#define _CCP4MODE3              0x08
#define _CCP4FMT                0x10
#define _CCP4OUT                0x20
#define _CCP4EN                 0x80

//==============================================================================


//==============================================================================
//        CCP4CAP Bits

extern __at(0x0318) __sfr CCP4CAP;

typedef union
  {
  struct
    {
    unsigned CCP4CTS0           : 1;
    unsigned CCP4CTS1           : 1;
    unsigned CCP4CTS2           : 1;
    unsigned CCP4CTS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP4CTS            : 4;
    unsigned                    : 4;
    };
  } __CCP4CAPbits_t;

extern __at(0x0318) volatile __CCP4CAPbits_t CCP4CAPbits;

#define _CCP4CTS0               0x01
#define _CCP4CTS1               0x02
#define _CCP4CTS2               0x04
#define _CCP4CTS3               0x08

//==============================================================================


//==============================================================================
//        INLVLA Bits

extern __at(0x038C) __sfr INLVLA;

typedef union
  {
  struct
    {
    unsigned INLVLA0            : 1;
    unsigned INLVLA1            : 1;
    unsigned INLVLA2            : 1;
    unsigned INLVLA3            : 1;
    unsigned INLVLA4            : 1;
    unsigned INLVLA5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INLVLA             : 6;
    unsigned                    : 2;
    };
  } __INLVLAbits_t;

extern __at(0x038C) volatile __INLVLAbits_t INLVLAbits;

#define _INLVLA0                0x01
#define _INLVLA1                0x02
#define _INLVLA2                0x04
#define _INLVLA3                0x08
#define _INLVLA4                0x10
#define _INLVLA5                0x20

//==============================================================================


//==============================================================================
//        INLVLB Bits

extern __at(0x038D) __sfr INLVLB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned INLVLB4              : 1;
  unsigned INLVLB5              : 1;
  unsigned INLVLB6              : 1;
  unsigned INLVLB7              : 1;
  } __INLVLBbits_t;

extern __at(0x038D) volatile __INLVLBbits_t INLVLBbits;

#define _INLVLB4                0x10
#define _INLVLB5                0x20
#define _INLVLB6                0x40
#define _INLVLB7                0x80

//==============================================================================


//==============================================================================
//        INLVLC Bits

extern __at(0x038E) __sfr INLVLC;

typedef struct
  {
  unsigned INLVLC0              : 1;
  unsigned INLVLC1              : 1;
  unsigned INLVLC2              : 1;
  unsigned INLVLC3              : 1;
  unsigned INLVLC4              : 1;
  unsigned INLVLC5              : 1;
  unsigned INLVLC6              : 1;
  unsigned INLVLC7              : 1;
  } __INLVLCbits_t;

extern __at(0x038E) volatile __INLVLCbits_t INLVLCbits;

#define _INLVLC0                0x01
#define _INLVLC1                0x02
#define _INLVLC2                0x04
#define _INLVLC3                0x08
#define _INLVLC4                0x10
#define _INLVLC5                0x20
#define _INLVLC6                0x40
#define _INLVLC7                0x80

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x0391) __sfr IOCAP;

typedef union
  {
  struct
    {
    unsigned IOCAP0             : 1;
    unsigned IOCAP1             : 1;
    unsigned IOCAP2             : 1;
    unsigned IOCAP3             : 1;
    unsigned IOCAP4             : 1;
    unsigned IOCAP5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAP              : 6;
    unsigned                    : 2;
    };
  } __IOCAPbits_t;

extern __at(0x0391) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP2                 0x04
#define _IOCAP3                 0x08
#define _IOCAP4                 0x10
#define _IOCAP5                 0x20

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x0392) __sfr IOCAN;

typedef union
  {
  struct
    {
    unsigned IOCAN0             : 1;
    unsigned IOCAN1             : 1;
    unsigned IOCAN2             : 1;
    unsigned IOCAN3             : 1;
    unsigned IOCAN4             : 1;
    unsigned IOCAN5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAN              : 6;
    unsigned                    : 2;
    };
  } __IOCANbits_t;

extern __at(0x0392) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN2                 0x04
#define _IOCAN3                 0x08
#define _IOCAN4                 0x10
#define _IOCAN5                 0x20

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x0393) __sfr IOCAF;

typedef union
  {
  struct
    {
    unsigned IOCAF0             : 1;
    unsigned IOCAF1             : 1;
    unsigned IOCAF2             : 1;
    unsigned IOCAF3             : 1;
    unsigned IOCAF4             : 1;
    unsigned IOCAF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAF              : 6;
    unsigned                    : 2;
    };
  } __IOCAFbits_t;

extern __at(0x0393) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF2                 0x04
#define _IOCAF3                 0x08
#define _IOCAF4                 0x10
#define _IOCAF5                 0x20

//==============================================================================


//==============================================================================
//        IOCBP Bits

extern __at(0x0394) __sfr IOCBP;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBP4               : 1;
  unsigned IOCBP5               : 1;
  unsigned IOCBP6               : 1;
  unsigned IOCBP7               : 1;
  } __IOCBPbits_t;

extern __at(0x0394) volatile __IOCBPbits_t IOCBPbits;

#define _IOCBP4                 0x10
#define _IOCBP5                 0x20
#define _IOCBP6                 0x40
#define _IOCBP7                 0x80

//==============================================================================


//==============================================================================
//        IOCBN Bits

extern __at(0x0395) __sfr IOCBN;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBN4               : 1;
  unsigned IOCBN5               : 1;
  unsigned IOCBN6               : 1;
  unsigned IOCBN7               : 1;
  } __IOCBNbits_t;

extern __at(0x0395) volatile __IOCBNbits_t IOCBNbits;

#define _IOCBN4                 0x10
#define _IOCBN5                 0x20
#define _IOCBN6                 0x40
#define _IOCBN7                 0x80

//==============================================================================


//==============================================================================
//        IOCBF Bits

extern __at(0x0396) __sfr IOCBF;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBF4               : 1;
  unsigned IOCBF5               : 1;
  unsigned IOCBF6               : 1;
  unsigned IOCBF7               : 1;
  } __IOCBFbits_t;

extern __at(0x0396) volatile __IOCBFbits_t IOCBFbits;

#define _IOCBF4                 0x10
#define _IOCBF5                 0x20
#define _IOCBF6                 0x40
#define _IOCBF7                 0x80

//==============================================================================


//==============================================================================
//        IOCCP Bits

extern __at(0x0397) __sfr IOCCP;

typedef struct
  {
  unsigned IOCCP0               : 1;
  unsigned IOCCP1               : 1;
  unsigned IOCCP2               : 1;
  unsigned IOCCP3               : 1;
  unsigned IOCCP4               : 1;
  unsigned IOCCP5               : 1;
  unsigned IOCCP6               : 1;
  unsigned IOCCP7               : 1;
  } __IOCCPbits_t;

extern __at(0x0397) volatile __IOCCPbits_t IOCCPbits;

#define _IOCCP0                 0x01
#define _IOCCP1                 0x02
#define _IOCCP2                 0x04
#define _IOCCP3                 0x08
#define _IOCCP4                 0x10
#define _IOCCP5                 0x20
#define _IOCCP6                 0x40
#define _IOCCP7                 0x80

//==============================================================================


//==============================================================================
//        IOCCN Bits

extern __at(0x0398) __sfr IOCCN;

typedef struct
  {
  unsigned IOCCN0               : 1;
  unsigned IOCCN1               : 1;
  unsigned IOCCN2               : 1;
  unsigned IOCCN3               : 1;
  unsigned IOCCN4               : 1;
  unsigned IOCCN5               : 1;
  unsigned IOCCN6               : 1;
  unsigned IOCCN7               : 1;
  } __IOCCNbits_t;

extern __at(0x0398) volatile __IOCCNbits_t IOCCNbits;

#define _IOCCN0                 0x01
#define _IOCCN1                 0x02
#define _IOCCN2                 0x04
#define _IOCCN3                 0x08
#define _IOCCN4                 0x10
#define _IOCCN5                 0x20
#define _IOCCN6                 0x40
#define _IOCCN7                 0x80

//==============================================================================


//==============================================================================
//        IOCCF Bits

extern __at(0x0399) __sfr IOCCF;

typedef struct
  {
  unsigned IOCCF0               : 1;
  unsigned IOCCF1               : 1;
  unsigned IOCCF2               : 1;
  unsigned IOCCF3               : 1;
  unsigned IOCCF4               : 1;
  unsigned IOCCF5               : 1;
  unsigned IOCCF6               : 1;
  unsigned IOCCF7               : 1;
  } __IOCCFbits_t;

extern __at(0x0399) volatile __IOCCFbits_t IOCCFbits;

#define _IOCCF0                 0x01
#define _IOCCF1                 0x02
#define _IOCCF2                 0x04
#define _IOCCF3                 0x08
#define _IOCCF4                 0x10
#define _IOCCF5                 0x20
#define _IOCCF6                 0x40
#define _IOCCF7                 0x80

//==============================================================================


//==============================================================================
//        CLKRCON Bits

extern __at(0x039A) __sfr CLKRCON;

typedef union
  {
  struct
    {
    unsigned CLKRDIV0           : 1;
    unsigned CLKRDIV1           : 1;
    unsigned CLKRDIV2           : 1;
    unsigned CLKRDC0            : 1;
    unsigned CLKRDC1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CLKREN             : 1;
    };

  struct
    {
    unsigned CLKRDIV            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned CLKRDC             : 2;
    unsigned                    : 3;
    };
  } __CLKRCONbits_t;

extern __at(0x039A) volatile __CLKRCONbits_t CLKRCONbits;

#define _CLKRDIV0               0x01
#define _CLKRDIV1               0x02
#define _CLKRDIV2               0x04
#define _CLKRDC0                0x08
#define _CLKRDC1                0x10
#define _CLKREN                 0x80

//==============================================================================


//==============================================================================
//        MDCON Bits

extern __at(0x039C) __sfr MDCON;

typedef struct
  {
  unsigned MDBIT                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned MDOUT                : 1;
  unsigned MDOPOL               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned MDEN                 : 1;
  } __MDCONbits_t;

extern __at(0x039C) volatile __MDCONbits_t MDCONbits;

#define _MDBIT                  0x01
#define _MDOUT                  0x08
#define _MDOPOL                 0x10
#define _MDEN                   0x80

//==============================================================================


//==============================================================================
//        MDSRC Bits

extern __at(0x039D) __sfr MDSRC;

typedef union
  {
  struct
    {
    unsigned MDMS0              : 1;
    unsigned MDMS1              : 1;
    unsigned MDMS2              : 1;
    unsigned MDMS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MDMS               : 4;
    unsigned                    : 4;
    };
  } __MDSRCbits_t;

extern __at(0x039D) volatile __MDSRCbits_t MDSRCbits;

#define _MDMS0                  0x01
#define _MDMS1                  0x02
#define _MDMS2                  0x04
#define _MDMS3                  0x08

//==============================================================================


//==============================================================================
//        MDCARH Bits

extern __at(0x039E) __sfr MDCARH;

typedef union
  {
  struct
    {
    unsigned MDCH0              : 1;
    unsigned MDCH1              : 1;
    unsigned MDCH2              : 1;
    unsigned MDCH3              : 1;
    unsigned                    : 1;
    unsigned MDCHSYNC           : 1;
    unsigned MDCHPOL            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MDCH               : 4;
    unsigned                    : 4;
    };
  } __MDCARHbits_t;

extern __at(0x039E) volatile __MDCARHbits_t MDCARHbits;

#define _MDCH0                  0x01
#define _MDCH1                  0x02
#define _MDCH2                  0x04
#define _MDCH3                  0x08
#define _MDCHSYNC               0x20
#define _MDCHPOL                0x40

//==============================================================================


//==============================================================================
//        MDCARL Bits

extern __at(0x039F) __sfr MDCARL;

typedef union
  {
  struct
    {
    unsigned MDCL0              : 1;
    unsigned MDCL1              : 1;
    unsigned MDCL2              : 1;
    unsigned MDCL3              : 1;
    unsigned                    : 1;
    unsigned MDCLSYNC           : 1;
    unsigned MDCLPOL            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MDCL               : 4;
    unsigned                    : 4;
    };
  } __MDCARLbits_t;

extern __at(0x039F) volatile __MDCARLbits_t MDCARLbits;

#define _MDCL0                  0x01
#define _MDCL1                  0x02
#define _MDCL2                  0x04
#define _MDCL3                  0x08
#define _MDCLSYNC               0x20
#define _MDCLPOL                0x40

//==============================================================================


//==============================================================================
//        CCDNA Bits

extern __at(0x040C) __sfr CCDNA;

typedef struct
  {
  unsigned CCDNA0               : 1;
  unsigned CCDNA1               : 1;
  unsigned CCDNA2               : 1;
  unsigned                      : 1;
  unsigned CCDNA4               : 1;
  unsigned CCDNA5               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CCDNAbits_t;

extern __at(0x040C) volatile __CCDNAbits_t CCDNAbits;

#define _CCDNA0                 0x01
#define _CCDNA1                 0x02
#define _CCDNA2                 0x04
#define _CCDNA4                 0x10
#define _CCDNA5                 0x20

//==============================================================================


//==============================================================================
//        CCDNB Bits

extern __at(0x040D) __sfr CCDNB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CCDNB4               : 1;
  unsigned CCDNB5               : 1;
  unsigned CCDNB6               : 1;
  unsigned CCDNB7               : 1;
  } __CCDNBbits_t;

extern __at(0x040D) volatile __CCDNBbits_t CCDNBbits;

#define _CCDNB4                 0x10
#define _CCDNB5                 0x20
#define _CCDNB6                 0x40
#define _CCDNB7                 0x80

//==============================================================================


//==============================================================================
//        CCDNC Bits

extern __at(0x040E) __sfr CCDNC;

typedef struct
  {
  unsigned CCDNC0               : 1;
  unsigned CCDNC1               : 1;
  unsigned CCDNC2               : 1;
  unsigned CCDNC3               : 1;
  unsigned CCDNC4               : 1;
  unsigned CCDNC5               : 1;
  unsigned CCDNC6               : 1;
  unsigned CCDNC7               : 1;
  } __CCDNCbits_t;

extern __at(0x040E) volatile __CCDNCbits_t CCDNCbits;

#define _CCDNC0                 0x01
#define _CCDNC1                 0x02
#define _CCDNC2                 0x04
#define _CCDNC3                 0x08
#define _CCDNC4                 0x10
#define _CCDNC5                 0x20
#define _CCDNC6                 0x40
#define _CCDNC7                 0x80

//==============================================================================

extern __at(0x0411) __sfr TMR3;
extern __at(0x0411) __sfr TMR3L;
extern __at(0x0412) __sfr TMR3H;

//==============================================================================
//        T3CON Bits

extern __at(0x0413) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned TMR3ON             : 1;
    unsigned                    : 1;
    unsigned T3SYNC             : 1;
    unsigned T3SOSC             : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned TMR3CS0            : 1;
    unsigned TMR3CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR3CS             : 2;
    };
  } __T3CONbits_t;

extern __at(0x0413) volatile __T3CONbits_t T3CONbits;

#define _TMR3ON                 0x01
#define _T3SYNC                 0x04
#define _T3SOSC                 0x08
#define _T3CKPS0                0x10
#define _T3CKPS1                0x20
#define _TMR3CS0                0x40
#define _TMR3CS1                0x80

//==============================================================================


//==============================================================================
//        T3GCON Bits

extern __at(0x0414) __sfr T3GCON;

typedef union
  {
  struct
    {
    unsigned T3GSS0             : 1;
    unsigned T3GSS1             : 1;
    unsigned T3GVAL             : 1;
    unsigned T3GGO_NOT_DONE     : 1;
    unsigned T3GSPM             : 1;
    unsigned T3GTM              : 1;
    unsigned T3GPOL             : 1;
    unsigned TMR3GE             : 1;
    };

  struct
    {
    unsigned T3GSS              : 2;
    unsigned                    : 6;
    };
  } __T3GCONbits_t;

extern __at(0x0414) volatile __T3GCONbits_t T3GCONbits;

#define _T3GSS0                 0x01
#define _T3GSS1                 0x02
#define _T3GVAL                 0x04
#define _T3GGO_NOT_DONE         0x08
#define _T3GSPM                 0x10
#define _T3GTM                  0x20
#define _T3GPOL                 0x40
#define _TMR3GE                 0x80

//==============================================================================

extern __at(0x0415) __sfr TMR4;
extern __at(0x0416) __sfr PR4;

//==============================================================================
//        T4CON Bits

extern __at(0x0417) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned TMR4ON             : 1;
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T4OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0417) volatile __T4CONbits_t T4CONbits;

#define _T4CKPS0                0x01
#define _T4CKPS1                0x02
#define _TMR4ON                 0x04
#define _T4OUTPS0               0x08
#define _T4OUTPS1               0x10
#define _T4OUTPS2               0x20
#define _T4OUTPS3               0x40

//==============================================================================

extern __at(0x0418) __sfr TMR5;
extern __at(0x0418) __sfr TMR5L;
extern __at(0x0419) __sfr TMR5H;

//==============================================================================
//        T5CON Bits

extern __at(0x041A) __sfr T5CON;

typedef union
  {
  struct
    {
    unsigned TMR5ON             : 1;
    unsigned                    : 1;
    unsigned T5SYNC             : 1;
    unsigned T5SOSC             : 1;
    unsigned T5CKPS0            : 1;
    unsigned T5CKPS1            : 1;
    unsigned TMR5CS0            : 1;
    unsigned TMR5CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T5CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR5CS             : 2;
    };
  } __T5CONbits_t;

extern __at(0x041A) volatile __T5CONbits_t T5CONbits;

#define _TMR5ON                 0x01
#define _T5SYNC                 0x04
#define _T5SOSC                 0x08
#define _T5CKPS0                0x10
#define _T5CKPS1                0x20
#define _TMR5CS0                0x40
#define _TMR5CS1                0x80

//==============================================================================


//==============================================================================
//        T5GCON Bits

extern __at(0x041B) __sfr T5GCON;

typedef union
  {
  struct
    {
    unsigned T5GSS0             : 1;
    unsigned T5GSS1             : 1;
    unsigned T5GVAL             : 1;
    unsigned T5GGO_NOT_DONE     : 1;
    unsigned T5GSPM             : 1;
    unsigned T5GTM              : 1;
    unsigned T5GPOL             : 1;
    unsigned TMR5GE             : 1;
    };

  struct
    {
    unsigned T5GSS              : 2;
    unsigned                    : 6;
    };
  } __T5GCONbits_t;

extern __at(0x041B) volatile __T5GCONbits_t T5GCONbits;

#define _T5GSS0                 0x01
#define _T5GSS1                 0x02
#define _T5GVAL                 0x04
#define _T5GGO_NOT_DONE         0x08
#define _T5GSPM                 0x10
#define _T5GTM                  0x20
#define _T5GPOL                 0x40
#define _TMR5GE                 0x80

//==============================================================================

extern __at(0x041C) __sfr TMR6;
extern __at(0x041D) __sfr PR6;

//==============================================================================
//        T6CON Bits

extern __at(0x041E) __sfr T6CON;

typedef union
  {
  struct
    {
    unsigned T6CKPS0            : 1;
    unsigned T6CKPS1            : 1;
    unsigned TMR6ON             : 1;
    unsigned T6OUTPS0           : 1;
    unsigned T6OUTPS1           : 1;
    unsigned T6OUTPS2           : 1;
    unsigned T6OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T6OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T6CONbits_t;

extern __at(0x041E) volatile __T6CONbits_t T6CONbits;

#define _T6CKPS0                0x01
#define _T6CKPS1                0x02
#define _TMR6ON                 0x04
#define _T6OUTPS0               0x08
#define _T6OUTPS1               0x10
#define _T6OUTPS2               0x20
#define _T6OUTPS3               0x40

//==============================================================================


//==============================================================================
//        CCDCON Bits

extern __at(0x041F) __sfr CCDCON;

typedef union
  {
  struct
    {
    unsigned CCDS0              : 1;
    unsigned CCDS1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCDEN              : 1;
    };

  struct
    {
    unsigned CCDS               : 2;
    unsigned                    : 6;
    };
  } __CCDCONbits_t;

extern __at(0x041F) volatile __CCDCONbits_t CCDCONbits;

#define _CCDS0                  0x01
#define _CCDS1                  0x02
#define _CCDEN                  0x80

//==============================================================================


//==============================================================================
//        CCDPA Bits

extern __at(0x048C) __sfr CCDPA;

typedef struct
  {
  unsigned CCDPA0               : 1;
  unsigned CCDPA1               : 1;
  unsigned CCDPA2               : 1;
  unsigned                      : 1;
  unsigned CCDPA4               : 1;
  unsigned CCDPA5               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CCDPAbits_t;

extern __at(0x048C) volatile __CCDPAbits_t CCDPAbits;

#define _CCDPA0                 0x01
#define _CCDPA1                 0x02
#define _CCDPA2                 0x04
#define _CCDPA4                 0x10
#define _CCDPA5                 0x20

//==============================================================================


//==============================================================================
//        CCDPB Bits

extern __at(0x048D) __sfr CCDPB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CCDPB4               : 1;
  unsigned CCDPB5               : 1;
  unsigned CCDPB6               : 1;
  unsigned CCDPB7               : 1;
  } __CCDPBbits_t;

extern __at(0x048D) volatile __CCDPBbits_t CCDPBbits;

#define _CCDPB4                 0x10
#define _CCDPB5                 0x20
#define _CCDPB6                 0x40
#define _CCDPB7                 0x80

//==============================================================================


//==============================================================================
//        CCDPC Bits

extern __at(0x048E) __sfr CCDPC;

typedef struct
  {
  unsigned CCDPC0               : 1;
  unsigned CCDPC1               : 1;
  unsigned CCDPC2               : 1;
  unsigned CCDPC3               : 1;
  unsigned CCDPC4               : 1;
  unsigned CCDPC5               : 1;
  unsigned CCDPC6               : 1;
  unsigned CCDPC7               : 1;
  } __CCDPCbits_t;

extern __at(0x048E) volatile __CCDPCbits_t CCDPCbits;

#define _CCDPC0                 0x01
#define _CCDPC1                 0x02
#define _CCDPC2                 0x04
#define _CCDPC3                 0x08
#define _CCDPC4                 0x10
#define _CCDPC5                 0x20
#define _CCDPC6                 0x40
#define _CCDPC7                 0x80

//==============================================================================

extern __at(0x0498) __sfr NCO1ACC;
extern __at(0x0498) __sfr NCO1ACCL;
extern __at(0x0499) __sfr NCO1ACCH;
extern __at(0x049A) __sfr NCO1ACCU;
extern __at(0x049B) __sfr NCO1INC;
extern __at(0x049B) __sfr NCO1INCL;
extern __at(0x049C) __sfr NCO1INCH;
extern __at(0x049D) __sfr NCO1INCU;

//==============================================================================
//        NCO1CON Bits

extern __at(0x049E) __sfr NCO1CON;

typedef struct
  {
  unsigned N1PFM                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned N1POL                : 1;
  unsigned N1OUT                : 1;
  unsigned                      : 1;
  unsigned N1EN                 : 1;
  } __NCO1CONbits_t;

extern __at(0x049E) volatile __NCO1CONbits_t NCO1CONbits;

#define _N1PFM                  0x01
#define _N1POL                  0x10
#define _N1OUT                  0x20
#define _N1EN                   0x80

//==============================================================================

extern __at(0x049F) __sfr NCO1CLK;

//==============================================================================
//        PWM5DCL Bits

extern __at(0x0617) __sfr PWM5DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM5DCL0           : 1;
    unsigned PWM5DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM5DCL            : 2;
    };
  } __PWM5DCLbits_t;

extern __at(0x0617) volatile __PWM5DCLbits_t PWM5DCLbits;

#define _PWM5DCL0               0x40
#define _PWM5DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM5DCH Bits

extern __at(0x0618) __sfr PWM5DCH;

typedef struct
  {
  unsigned PWM5DCH0             : 1;
  unsigned PWM5DCH1             : 1;
  unsigned PWM5DCH2             : 1;
  unsigned PWM5DCH3             : 1;
  unsigned PWM5DCH4             : 1;
  unsigned PWM5DCH5             : 1;
  unsigned PWM5DCH6             : 1;
  unsigned PWM5DCH7             : 1;
  } __PWM5DCHbits_t;

extern __at(0x0618) volatile __PWM5DCHbits_t PWM5DCHbits;

#define _PWM5DCH0               0x01
#define _PWM5DCH1               0x02
#define _PWM5DCH2               0x04
#define _PWM5DCH3               0x08
#define _PWM5DCH4               0x10
#define _PWM5DCH5               0x20
#define _PWM5DCH6               0x40
#define _PWM5DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM5CON Bits

extern __at(0x0619) __sfr PWM5CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM5POL              : 1;
  unsigned PWM5OUT              : 1;
  unsigned                      : 1;
  unsigned PWM5EN               : 1;
  } __PWM5CONbits_t;

extern __at(0x0619) volatile __PWM5CONbits_t PWM5CONbits;

#define _PWM5POL                0x10
#define _PWM5OUT                0x20
#define _PWM5EN                 0x80

//==============================================================================


//==============================================================================
//        PWM5CON0 Bits

extern __at(0x0619) __sfr PWM5CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM5POL              : 1;
  unsigned PWM5OUT              : 1;
  unsigned                      : 1;
  unsigned PWM5EN               : 1;
  } __PWM5CON0bits_t;

extern __at(0x0619) volatile __PWM5CON0bits_t PWM5CON0bits;

#define _PWM5CON0_PWM5POL       0x10
#define _PWM5CON0_PWM5OUT       0x20
#define _PWM5CON0_PWM5EN        0x80

//==============================================================================


//==============================================================================
//        PWM6DCL Bits

extern __at(0x061A) __sfr PWM6DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM6DCL0           : 1;
    unsigned PWM6DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM6DCL            : 2;
    };
  } __PWM6DCLbits_t;

extern __at(0x061A) volatile __PWM6DCLbits_t PWM6DCLbits;

#define _PWM6DCL0               0x40
#define _PWM6DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM6DCH Bits

extern __at(0x061B) __sfr PWM6DCH;

typedef struct
  {
  unsigned PWM6DCH0             : 1;
  unsigned PWM6DCH1             : 1;
  unsigned PWM6DCH2             : 1;
  unsigned PWM6DCH3             : 1;
  unsigned PWM6DCH4             : 1;
  unsigned PWM6DCH5             : 1;
  unsigned PWM6DCH6             : 1;
  unsigned PWM6DCH7             : 1;
  } __PWM6DCHbits_t;

extern __at(0x061B) volatile __PWM6DCHbits_t PWM6DCHbits;

#define _PWM6DCH0               0x01
#define _PWM6DCH1               0x02
#define _PWM6DCH2               0x04
#define _PWM6DCH3               0x08
#define _PWM6DCH4               0x10
#define _PWM6DCH5               0x20
#define _PWM6DCH6               0x40
#define _PWM6DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM6CON Bits

extern __at(0x061C) __sfr PWM6CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM6POL              : 1;
  unsigned PWM6OUT              : 1;
  unsigned                      : 1;
  unsigned PWM6EN               : 1;
  } __PWM6CONbits_t;

extern __at(0x061C) volatile __PWM6CONbits_t PWM6CONbits;

#define _PWM6POL                0x10
#define _PWM6OUT                0x20
#define _PWM6EN                 0x80

//==============================================================================


//==============================================================================
//        PWM6CON0 Bits

extern __at(0x061C) __sfr PWM6CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM6POL              : 1;
  unsigned PWM6OUT              : 1;
  unsigned                      : 1;
  unsigned PWM6EN               : 1;
  } __PWM6CON0bits_t;

extern __at(0x061C) volatile __PWM6CON0bits_t PWM6CON0bits;

#define _PWM6CON0_PWM6POL       0x10
#define _PWM6CON0_PWM6OUT       0x20
#define _PWM6CON0_PWM6EN        0x80

//==============================================================================


//==============================================================================
//        PWMTMRS Bits

extern __at(0x061F) __sfr PWMTMRS;

typedef union
  {
  struct
    {
    unsigned P5TSEL0            : 1;
    unsigned P5TSEL1            : 1;
    unsigned P6TSEL0            : 1;
    unsigned P6TSEL1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P5TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned P6TSEL             : 2;
    unsigned                    : 4;
    };
  } __PWMTMRSbits_t;

extern __at(0x061F) volatile __PWMTMRSbits_t PWMTMRSbits;

#define _P5TSEL0                0x01
#define _P5TSEL1                0x02
#define _P6TSEL0                0x04
#define _P6TSEL1                0x08

//==============================================================================


//==============================================================================
//        CWG1CLKCON Bits

extern __at(0x0691) __sfr CWG1CLKCON;

typedef union
  {
  struct
    {
    unsigned CS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1CS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG1CLKCONbits_t;

extern __at(0x0691) volatile __CWG1CLKCONbits_t CWG1CLKCONbits;

#define _CS                     0x01
#define _CWG1CS                 0x01

//==============================================================================


//==============================================================================
//        CWG1DAT Bits

extern __at(0x0692) __sfr CWG1DAT;

typedef union
  {
  struct
    {
    unsigned CWG1DAT0           : 1;
    unsigned CWG1DAT1           : 1;
    unsigned CWG1DAT2           : 1;
    unsigned CWG1DAT3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DAT            : 4;
    unsigned                    : 4;
    };
  } __CWG1DATbits_t;

extern __at(0x0692) volatile __CWG1DATbits_t CWG1DATbits;

#define _CWG1DAT0               0x01
#define _CWG1DAT1               0x02
#define _CWG1DAT2               0x04
#define _CWG1DAT3               0x08

//==============================================================================


//==============================================================================
//        CWG1DBR Bits

extern __at(0x0693) __sfr CWG1DBR;

typedef union
  {
  struct
    {
    unsigned DBR0               : 1;
    unsigned DBR1               : 1;
    unsigned DBR2               : 1;
    unsigned DBR3               : 1;
    unsigned DBR4               : 1;
    unsigned DBR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBR0           : 1;
    unsigned CWG1DBR1           : 1;
    unsigned CWG1DBR2           : 1;
    unsigned CWG1DBR3           : 1;
    unsigned CWG1DBR4           : 1;
    unsigned CWG1DBR5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBR            : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DBR                : 6;
    unsigned                    : 2;
    };
  } __CWG1DBRbits_t;

extern __at(0x0693) volatile __CWG1DBRbits_t CWG1DBRbits;

#define _DBR0                   0x01
#define _CWG1DBR0               0x01
#define _DBR1                   0x02
#define _CWG1DBR1               0x02
#define _DBR2                   0x04
#define _CWG1DBR2               0x04
#define _DBR3                   0x08
#define _CWG1DBR3               0x08
#define _DBR4                   0x10
#define _CWG1DBR4               0x10
#define _DBR5                   0x20
#define _CWG1DBR5               0x20

//==============================================================================


//==============================================================================
//        CWG1DBF Bits

extern __at(0x0694) __sfr CWG1DBF;

typedef union
  {
  struct
    {
    unsigned DBF0               : 1;
    unsigned DBF1               : 1;
    unsigned DBF2               : 1;
    unsigned DBF3               : 1;
    unsigned DBF4               : 1;
    unsigned DBF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBF0           : 1;
    unsigned CWG1DBF1           : 1;
    unsigned CWG1DBF2           : 1;
    unsigned CWG1DBF3           : 1;
    unsigned CWG1DBF4           : 1;
    unsigned CWG1DBF5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBF            : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DBF                : 6;
    unsigned                    : 2;
    };
  } __CWG1DBFbits_t;

extern __at(0x0694) volatile __CWG1DBFbits_t CWG1DBFbits;

#define _DBF0                   0x01
#define _CWG1DBF0               0x01
#define _DBF1                   0x02
#define _CWG1DBF1               0x02
#define _DBF2                   0x04
#define _CWG1DBF2               0x04
#define _DBF3                   0x08
#define _CWG1DBF3               0x08
#define _DBF4                   0x10
#define _CWG1DBF4               0x10
#define _DBF5                   0x20
#define _CWG1DBF5               0x20

//==============================================================================


//==============================================================================
//        CWG1CON0 Bits

extern __at(0x0695) __sfr CWG1CON0;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LD                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CWG1MODE0          : 1;
    unsigned CWG1MODE1          : 1;
    unsigned CWG1MODE2          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG1LD             : 1;
    unsigned G1EN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG1EN             : 1;
    };

  struct
    {
    unsigned CWG1MODE           : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CWG1CON0bits_t;

extern __at(0x0695) volatile __CWG1CON0bits_t CWG1CON0bits;

#define _CWG1CON0_MODE0         0x01
#define _CWG1CON0_CWG1MODE0     0x01
#define _CWG1CON0_MODE1         0x02
#define _CWG1CON0_CWG1MODE1     0x02
#define _CWG1CON0_MODE2         0x04
#define _CWG1CON0_CWG1MODE2     0x04
#define _CWG1CON0_LD            0x40
#define _CWG1CON0_CWG1LD        0x40
#define _CWG1CON0_EN            0x80
#define _CWG1CON0_G1EN          0x80
#define _CWG1CON0_CWG1EN        0x80

//==============================================================================


//==============================================================================
//        CWG1CON1 Bits

extern __at(0x0696) __sfr CWG1CON1;

typedef union
  {
  struct
    {
    unsigned POLA               : 1;
    unsigned POLB               : 1;
    unsigned POLC               : 1;
    unsigned POLD               : 1;
    unsigned                    : 1;
    unsigned IN                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1POLA           : 1;
    unsigned CWG1POLB           : 1;
    unsigned CWG1POLC           : 1;
    unsigned CWG1POLD           : 1;
    unsigned                    : 1;
    unsigned CWG1IN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG1CON1bits_t;

extern __at(0x0696) volatile __CWG1CON1bits_t CWG1CON1bits;

#define _POLA                   0x01
#define _CWG1POLA               0x01
#define _POLB                   0x02
#define _CWG1POLB               0x02
#define _POLC                   0x04
#define _CWG1POLC               0x04
#define _POLD                   0x08
#define _CWG1POLD               0x08
#define _IN                     0x20
#define _CWG1IN                 0x20

//==============================================================================


//==============================================================================
//        CWG1AS0 Bits

extern __at(0x0697) __sfr CWG1AS0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LSAC0              : 1;
    unsigned LSAC1              : 1;
    unsigned LSBD0              : 1;
    unsigned LSBD1              : 1;
    unsigned REN                : 1;
    unsigned SHUTDOWN           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG1LSAC0          : 1;
    unsigned CWG1LSAC1          : 1;
    unsigned CWG1LSBD0          : 1;
    unsigned CWG1LSBD1          : 1;
    unsigned CWG1REN            : 1;
    unsigned CWG1SHUTDOWN       : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned LSAC               : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CWG1LSAC           : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CWG1LSBD           : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LSBD               : 2;
    unsigned                    : 2;
    };
  } __CWG1AS0bits_t;

extern __at(0x0697) volatile __CWG1AS0bits_t CWG1AS0bits;

#define _LSAC0                  0x04
#define _CWG1LSAC0              0x04
#define _LSAC1                  0x08
#define _CWG1LSAC1              0x08
#define _LSBD0                  0x10
#define _CWG1LSBD0              0x10
#define _LSBD1                  0x20
#define _CWG1LSBD1              0x20
#define _REN                    0x40
#define _CWG1REN                0x40
#define _SHUTDOWN               0x80
#define _CWG1SHUTDOWN           0x80

//==============================================================================


//==============================================================================
//        CWG1AS1 Bits

extern __at(0x0698) __sfr CWG1AS1;

typedef struct
  {
  unsigned AS0E                 : 1;
  unsigned AS1E                 : 1;
  unsigned AS2E                 : 1;
  unsigned AS3E                 : 1;
  unsigned AS4E                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CWG1AS1bits_t;

extern __at(0x0698) volatile __CWG1AS1bits_t CWG1AS1bits;

#define _AS0E                   0x01
#define _AS1E                   0x02
#define _AS2E                   0x04
#define _AS3E                   0x08
#define _AS4E                   0x10

//==============================================================================


//==============================================================================
//        CWG1STR Bits

extern __at(0x0699) __sfr CWG1STR;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned OVRA               : 1;
    unsigned OVRB               : 1;
    unsigned OVRC               : 1;
    unsigned OVRD               : 1;
    };

  struct
    {
    unsigned CWG1STRA           : 1;
    unsigned CWG1STRB           : 1;
    unsigned CWG1STRC           : 1;
    unsigned CWG1STRD           : 1;
    unsigned CWG1OVRA           : 1;
    unsigned CWG1OVRB           : 1;
    unsigned CWG1OVRC           : 1;
    unsigned CWG1OVRD           : 1;
    };
  } __CWG1STRbits_t;

extern __at(0x0699) volatile __CWG1STRbits_t CWG1STRbits;

#define _STRA                   0x01
#define _CWG1STRA               0x01
#define _STRB                   0x02
#define _CWG1STRB               0x02
#define _STRC                   0x04
#define _CWG1STRC               0x04
#define _STRD                   0x08
#define _CWG1STRD               0x08
#define _OVRA                   0x10
#define _CWG1OVRA               0x10
#define _OVRB                   0x20
#define _CWG1OVRB               0x20
#define _OVRC                   0x40
#define _CWG1OVRC               0x40
#define _OVRD                   0x80
#define _CWG1OVRD               0x80

//==============================================================================


//==============================================================================
//        CWG2CLKCON Bits

extern __at(0x0711) __sfr CWG2CLKCON;

typedef union
  {
  struct
    {
    unsigned CS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG2CS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG2CLKCONbits_t;

extern __at(0x0711) volatile __CWG2CLKCONbits_t CWG2CLKCONbits;

#define _CWG2CLKCON_CS          0x01
#define _CWG2CLKCON_CWG2CS      0x01

//==============================================================================


//==============================================================================
//        CWG2DAT Bits

extern __at(0x0712) __sfr CWG2DAT;

typedef union
  {
  struct
    {
    unsigned CWG2DAT0           : 1;
    unsigned CWG2DAT1           : 1;
    unsigned CWG2DAT2           : 1;
    unsigned CWG2DAT3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG2DAT            : 4;
    unsigned                    : 4;
    };
  } __CWG2DATbits_t;

extern __at(0x0712) volatile __CWG2DATbits_t CWG2DATbits;

#define _CWG2DAT0               0x01
#define _CWG2DAT1               0x02
#define _CWG2DAT2               0x04
#define _CWG2DAT3               0x08

//==============================================================================


//==============================================================================
//        CWG2DBR Bits

extern __at(0x0713) __sfr CWG2DBR;

typedef union
  {
  struct
    {
    unsigned DBR0               : 1;
    unsigned DBR1               : 1;
    unsigned DBR2               : 1;
    unsigned DBR3               : 1;
    unsigned DBR4               : 1;
    unsigned DBR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG2DBR0           : 1;
    unsigned CWG2DBR1           : 1;
    unsigned CWG2DBR2           : 1;
    unsigned CWG2DBR3           : 1;
    unsigned CWG2DBR4           : 1;
    unsigned CWG2DBR5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DBR                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned CWG2DBR            : 6;
    unsigned                    : 2;
    };
  } __CWG2DBRbits_t;

extern __at(0x0713) volatile __CWG2DBRbits_t CWG2DBRbits;

#define _CWG2DBR_DBR0           0x01
#define _CWG2DBR_CWG2DBR0       0x01
#define _CWG2DBR_DBR1           0x02
#define _CWG2DBR_CWG2DBR1       0x02
#define _CWG2DBR_DBR2           0x04
#define _CWG2DBR_CWG2DBR2       0x04
#define _CWG2DBR_DBR3           0x08
#define _CWG2DBR_CWG2DBR3       0x08
#define _CWG2DBR_DBR4           0x10
#define _CWG2DBR_CWG2DBR4       0x10
#define _CWG2DBR_DBR5           0x20
#define _CWG2DBR_CWG2DBR5       0x20

//==============================================================================


//==============================================================================
//        CWG2DBF Bits

extern __at(0x0714) __sfr CWG2DBF;

typedef union
  {
  struct
    {
    unsigned DBF0               : 1;
    unsigned DBF1               : 1;
    unsigned DBF2               : 1;
    unsigned DBF3               : 1;
    unsigned DBF4               : 1;
    unsigned DBF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG2DBF0           : 1;
    unsigned CWG2DBF1           : 1;
    unsigned CWG2DBF2           : 1;
    unsigned CWG2DBF3           : 1;
    unsigned CWG2DBF4           : 1;
    unsigned CWG2DBF5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DBF                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned CWG2DBF            : 6;
    unsigned                    : 2;
    };
  } __CWG2DBFbits_t;

extern __at(0x0714) volatile __CWG2DBFbits_t CWG2DBFbits;

#define _CWG2DBF_DBF0           0x01
#define _CWG2DBF_CWG2DBF0       0x01
#define _CWG2DBF_DBF1           0x02
#define _CWG2DBF_CWG2DBF1       0x02
#define _CWG2DBF_DBF2           0x04
#define _CWG2DBF_CWG2DBF2       0x04
#define _CWG2DBF_DBF3           0x08
#define _CWG2DBF_CWG2DBF3       0x08
#define _CWG2DBF_DBF4           0x10
#define _CWG2DBF_CWG2DBF4       0x10
#define _CWG2DBF_DBF5           0x20
#define _CWG2DBF_CWG2DBF5       0x20

//==============================================================================


//==============================================================================
//        CWG2CON0 Bits

extern __at(0x0715) __sfr CWG2CON0;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LD                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CWG2MODE0          : 1;
    unsigned CWG2MODE1          : 1;
    unsigned CWG2MODE2          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG2LD             : 1;
    unsigned G2EN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG2EN             : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CWG2MODE           : 3;
    unsigned                    : 5;
    };
  } __CWG2CON0bits_t;

extern __at(0x0715) volatile __CWG2CON0bits_t CWG2CON0bits;

#define _CWG2CON0_MODE0         0x01
#define _CWG2CON0_CWG2MODE0     0x01
#define _CWG2CON0_MODE1         0x02
#define _CWG2CON0_CWG2MODE1     0x02
#define _CWG2CON0_MODE2         0x04
#define _CWG2CON0_CWG2MODE2     0x04
#define _CWG2CON0_LD            0x40
#define _CWG2CON0_CWG2LD        0x40
#define _CWG2CON0_EN            0x80
#define _CWG2CON0_G2EN          0x80
#define _CWG2CON0_CWG2EN        0x80

//==============================================================================


//==============================================================================
//        CWG2CON1 Bits

extern __at(0x0716) __sfr CWG2CON1;

typedef union
  {
  struct
    {
    unsigned POLA               : 1;
    unsigned POLB               : 1;
    unsigned POLC               : 1;
    unsigned POLD               : 1;
    unsigned                    : 1;
    unsigned IN                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG2POLA           : 1;
    unsigned CWG2POLB           : 1;
    unsigned CWG2POLC           : 1;
    unsigned CWG2POLD           : 1;
    unsigned                    : 1;
    unsigned CWG2IN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CWG2CON1bits_t;

extern __at(0x0716) volatile __CWG2CON1bits_t CWG2CON1bits;

#define _CWG2CON1_POLA          0x01
#define _CWG2CON1_CWG2POLA      0x01
#define _CWG2CON1_POLB          0x02
#define _CWG2CON1_CWG2POLB      0x02
#define _CWG2CON1_POLC          0x04
#define _CWG2CON1_CWG2POLC      0x04
#define _CWG2CON1_POLD          0x08
#define _CWG2CON1_CWG2POLD      0x08
#define _CWG2CON1_IN            0x20
#define _CWG2CON1_CWG2IN        0x20

//==============================================================================


//==============================================================================
//        CWG2AS0 Bits

extern __at(0x0717) __sfr CWG2AS0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LSAC0              : 1;
    unsigned LSAC1              : 1;
    unsigned LSBD0              : 1;
    unsigned LSBD1              : 1;
    unsigned REN                : 1;
    unsigned SHUTDOWN           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CWG2LSAC0          : 1;
    unsigned CWG2LSAC1          : 1;
    unsigned CWG2LSBD0          : 1;
    unsigned CWG2LSBD1          : 1;
    unsigned CWG2REN            : 1;
    unsigned CWG2SHUTDOWN       : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CWG2LSAC           : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned LSAC               : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CWG2LSBD           : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LSBD               : 2;
    unsigned                    : 2;
    };
  } __CWG2AS0bits_t;

extern __at(0x0717) volatile __CWG2AS0bits_t CWG2AS0bits;

#define _CWG2AS0_LSAC0          0x04
#define _CWG2AS0_CWG2LSAC0      0x04
#define _CWG2AS0_LSAC1          0x08
#define _CWG2AS0_CWG2LSAC1      0x08
#define _CWG2AS0_LSBD0          0x10
#define _CWG2AS0_CWG2LSBD0      0x10
#define _CWG2AS0_LSBD1          0x20
#define _CWG2AS0_CWG2LSBD1      0x20
#define _CWG2AS0_REN            0x40
#define _CWG2AS0_CWG2REN        0x40
#define _CWG2AS0_SHUTDOWN       0x80
#define _CWG2AS0_CWG2SHUTDOWN   0x80

//==============================================================================


//==============================================================================
//        CWG2AS1 Bits

extern __at(0x0718) __sfr CWG2AS1;

typedef struct
  {
  unsigned AS0E                 : 1;
  unsigned AS1E                 : 1;
  unsigned AS2E                 : 1;
  unsigned AS3E                 : 1;
  unsigned AS4E                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CWG2AS1bits_t;

extern __at(0x0718) volatile __CWG2AS1bits_t CWG2AS1bits;

#define _CWG2AS1_AS0E           0x01
#define _CWG2AS1_AS1E           0x02
#define _CWG2AS1_AS2E           0x04
#define _CWG2AS1_AS3E           0x08
#define _CWG2AS1_AS4E           0x10

//==============================================================================


//==============================================================================
//        CWG2STR Bits

extern __at(0x0719) __sfr CWG2STR;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned OVRA               : 1;
    unsigned OVRB               : 1;
    unsigned OVRC               : 1;
    unsigned OVRD               : 1;
    };

  struct
    {
    unsigned CWG2STRA           : 1;
    unsigned CWG2STRB           : 1;
    unsigned CWG2STRC           : 1;
    unsigned CWG2STRD           : 1;
    unsigned CWG2OVRA           : 1;
    unsigned CWG2OVRB           : 1;
    unsigned CWG2OVRC           : 1;
    unsigned CWG2OVRD           : 1;
    };
  } __CWG2STRbits_t;

extern __at(0x0719) volatile __CWG2STRbits_t CWG2STRbits;

#define _CWG2STR_STRA           0x01
#define _CWG2STR_CWG2STRA       0x01
#define _CWG2STR_STRB           0x02
#define _CWG2STR_CWG2STRB       0x02
#define _CWG2STR_STRC           0x04
#define _CWG2STR_CWG2STRC       0x04
#define _CWG2STR_STRD           0x08
#define _CWG2STR_CWG2STRD       0x08
#define _CWG2STR_OVRA           0x10
#define _CWG2STR_CWG2OVRA       0x10
#define _CWG2STR_OVRB           0x20
#define _CWG2STR_CWG2OVRB       0x20
#define _CWG2STR_OVRC           0x40
#define _CWG2STR_CWG2OVRC       0x40
#define _CWG2STR_OVRD           0x80
#define _CWG2STR_CWG2OVRD       0x80

//==============================================================================

extern __at(0x0891) __sfr NVMADR;

//==============================================================================
//        NVMADRL Bits

extern __at(0x0891) __sfr NVMADRL;

typedef struct
  {
  unsigned NVMADR0              : 1;
  unsigned NVMADR1              : 1;
  unsigned NVMADR2              : 1;
  unsigned NVMADR3              : 1;
  unsigned NVMADR4              : 1;
  unsigned NVMADR5              : 1;
  unsigned NVMADR6              : 1;
  unsigned NVMADR7              : 1;
  } __NVMADRLbits_t;

extern __at(0x0891) volatile __NVMADRLbits_t NVMADRLbits;

#define _NVMADR0                0x01
#define _NVMADR1                0x02
#define _NVMADR2                0x04
#define _NVMADR3                0x08
#define _NVMADR4                0x10
#define _NVMADR5                0x20
#define _NVMADR6                0x40
#define _NVMADR7                0x80

//==============================================================================


//==============================================================================
//        NVMADRH Bits

extern __at(0x0892) __sfr NVMADRH;

typedef struct
  {
  unsigned NVMADR8              : 1;
  unsigned NVMADR9              : 1;
  unsigned NVMADR10             : 1;
  unsigned NVMADR11             : 1;
  unsigned NVMADR12             : 1;
  unsigned NVMADR13             : 1;
  unsigned NVMADR14             : 1;
  unsigned                      : 1;
  } __NVMADRHbits_t;

extern __at(0x0892) volatile __NVMADRHbits_t NVMADRHbits;

#define _NVMADR8                0x01
#define _NVMADR9                0x02
#define _NVMADR10               0x04
#define _NVMADR11               0x08
#define _NVMADR12               0x10
#define _NVMADR13               0x20
#define _NVMADR14               0x40

//==============================================================================

extern __at(0x0893) __sfr NVMDAT;

//==============================================================================
//        NVMDATL Bits

extern __at(0x0893) __sfr NVMDATL;

typedef struct
  {
  unsigned NVMDAT0              : 1;
  unsigned NVMDAT1              : 1;
  unsigned NVMDAT2              : 1;
  unsigned NVMDAT3              : 1;
  unsigned NVMDAT4              : 1;
  unsigned NVMDAT5              : 1;
  unsigned NVMDAT6              : 1;
  unsigned NVMDAT7              : 1;
  } __NVMDATLbits_t;

extern __at(0x0893) volatile __NVMDATLbits_t NVMDATLbits;

#define _NVMDAT0                0x01
#define _NVMDAT1                0x02
#define _NVMDAT2                0x04
#define _NVMDAT3                0x08
#define _NVMDAT4                0x10
#define _NVMDAT5                0x20
#define _NVMDAT6                0x40
#define _NVMDAT7                0x80

//==============================================================================


//==============================================================================
//        NVMDATH Bits

extern __at(0x0894) __sfr NVMDATH;

typedef struct
  {
  unsigned NVMDAT8              : 1;
  unsigned NVMDAT9              : 1;
  unsigned NVMDAT10             : 1;
  unsigned NVMDAT11             : 1;
  unsigned NVMDAT12             : 1;
  unsigned NVMDAT13             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __NVMDATHbits_t;

extern __at(0x0894) volatile __NVMDATHbits_t NVMDATHbits;

#define _NVMDAT8                0x01
#define _NVMDAT9                0x02
#define _NVMDAT10               0x04
#define _NVMDAT11               0x08
#define _NVMDAT12               0x10
#define _NVMDAT13               0x20

//==============================================================================


//==============================================================================
//        NVMCON1 Bits

extern __at(0x0895) __sfr NVMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned NVMREGS              : 1;
  unsigned                      : 1;
  } __NVMCON1bits_t;

extern __at(0x0895) volatile __NVMCON1bits_t NVMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _NVMREGS                0x40

//==============================================================================

extern __at(0x0896) __sfr NVMCON2;

//==============================================================================
//        PCON0 Bits

extern __at(0x089B) __sfr PCON0;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCON0bits_t;

extern __at(0x089B) volatile __PCON0bits_t PCON0bits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        PMD0 Bits

extern __at(0x0911) __sfr PMD0;

typedef struct
  {
  unsigned IOCMD                : 1;
  unsigned CLKRMD               : 1;
  unsigned NVMMD                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned FVRMD                : 1;
  unsigned SYSCMD               : 1;
  } __PMD0bits_t;

extern __at(0x0911) volatile __PMD0bits_t PMD0bits;

#define _IOCMD                  0x01
#define _CLKRMD                 0x02
#define _NVMMD                  0x04
#define _FVRMD                  0x40
#define _SYSCMD                 0x80

//==============================================================================


//==============================================================================
//        PMD1 Bits

extern __at(0x0912) __sfr PMD1;

typedef struct
  {
  unsigned TMR0MD               : 1;
  unsigned TMR1MD               : 1;
  unsigned TMR2MD               : 1;
  unsigned TMR3MD               : 1;
  unsigned TMR4MD               : 1;
  unsigned TMR5MD               : 1;
  unsigned TMR6MD               : 1;
  unsigned NCOMD                : 1;
  } __PMD1bits_t;

extern __at(0x0912) volatile __PMD1bits_t PMD1bits;

#define _TMR0MD                 0x01
#define _TMR1MD                 0x02
#define _TMR2MD                 0x04
#define _TMR3MD                 0x08
#define _TMR4MD                 0x10
#define _TMR5MD                 0x20
#define _TMR6MD                 0x40
#define _NCOMD                  0x80

//==============================================================================


//==============================================================================
//        PMD2 Bits

extern __at(0x0913) __sfr PMD2;

typedef struct
  {
  unsigned                      : 1;
  unsigned CMP1MD               : 1;
  unsigned CMP2MD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADCMD                : 1;
  unsigned DACMD                : 1;
  unsigned                      : 1;
  } __PMD2bits_t;

extern __at(0x0913) volatile __PMD2bits_t PMD2bits;

#define _CMP1MD                 0x02
#define _CMP2MD                 0x04
#define _ADCMD                  0x20
#define _DACMD                  0x40

//==============================================================================


//==============================================================================
//        PMD3 Bits

extern __at(0x0914) __sfr PMD3;

typedef struct
  {
  unsigned CCP1MD               : 1;
  unsigned CCP2MD               : 1;
  unsigned CCP3MD               : 1;
  unsigned CCP4MD               : 1;
  unsigned PWM5MD               : 1;
  unsigned PWM6MD               : 1;
  unsigned CWG1MD               : 1;
  unsigned CWG2MD               : 1;
  } __PMD3bits_t;

extern __at(0x0914) volatile __PMD3bits_t PMD3bits;

#define _CCP1MD                 0x01
#define _CCP2MD                 0x02
#define _CCP3MD                 0x04
#define _CCP4MD                 0x08
#define _PWM5MD                 0x10
#define _PWM6MD                 0x20
#define _CWG1MD                 0x40
#define _CWG2MD                 0x80

//==============================================================================


//==============================================================================
//        PMD4 Bits

extern __at(0x0915) __sfr PMD4;

typedef struct
  {
  unsigned                      : 1;
  unsigned MSSP1MD              : 1;
  unsigned MSSP2MD              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned UART1MD              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PMD4bits_t;

extern __at(0x0915) volatile __PMD4bits_t PMD4bits;

#define _MSSP1MD                0x02
#define _MSSP2MD                0x04
#define _UART1MD                0x20

//==============================================================================


//==============================================================================
//        PMD5 Bits

extern __at(0x0916) __sfr PMD5;

typedef struct
  {
  unsigned DSMMD                : 1;
  unsigned CLC1MD               : 1;
  unsigned CLC2MD               : 1;
  unsigned CLC3MD               : 1;
  unsigned CLC4MD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PMD5bits_t;

extern __at(0x0916) volatile __PMD5bits_t PMD5bits;

#define _DSMMD                  0x01
#define _CLC1MD                 0x02
#define _CLC2MD                 0x04
#define _CLC3MD                 0x08
#define _CLC4MD                 0x10

//==============================================================================


//==============================================================================
//        CPUDOZE Bits

extern __at(0x0918) __sfr CPUDOZE;

typedef union
  {
  struct
    {
    unsigned DOZE0              : 1;
    unsigned DOZE1              : 1;
    unsigned DOZE2              : 1;
    unsigned                    : 1;
    unsigned DOE                : 1;
    unsigned ROI                : 1;
    unsigned DOZEN              : 1;
    unsigned IDLEN              : 1;
    };

  struct
    {
    unsigned DOZE               : 3;
    unsigned                    : 5;
    };
  } __CPUDOZEbits_t;

extern __at(0x0918) volatile __CPUDOZEbits_t CPUDOZEbits;

#define _DOZE0                  0x01
#define _DOZE1                  0x02
#define _DOZE2                  0x04
#define _DOE                    0x10
#define _ROI                    0x20
#define _DOZEN                  0x40
#define _IDLEN                  0x80

//==============================================================================


//==============================================================================
//        OSCCON1 Bits

extern __at(0x0919) __sfr OSCCON1;

typedef union
  {
  struct
    {
    unsigned NDIV0              : 1;
    unsigned NDIV1              : 1;
    unsigned NDIV2              : 1;
    unsigned NDIV3              : 1;
    unsigned NOSC0              : 1;
    unsigned NOSC1              : 1;
    unsigned NOSC2              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NDIV               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned NOSC               : 3;
    unsigned                    : 1;
    };
  } __OSCCON1bits_t;

extern __at(0x0919) volatile __OSCCON1bits_t OSCCON1bits;

#define _NDIV0                  0x01
#define _NDIV1                  0x02
#define _NDIV2                  0x04
#define _NDIV3                  0x08
#define _NOSC0                  0x10
#define _NOSC1                  0x20
#define _NOSC2                  0x40

//==============================================================================


//==============================================================================
//        OSCCON2 Bits

extern __at(0x091A) __sfr OSCCON2;

typedef union
  {
  struct
    {
    unsigned CDIV0              : 1;
    unsigned CDIV1              : 1;
    unsigned CDIV2              : 1;
    unsigned CDIV3              : 1;
    unsigned COSC0              : 1;
    unsigned COSC1              : 1;
    unsigned COSC2              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CDIV               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned COSC               : 3;
    unsigned                    : 1;
    };
  } __OSCCON2bits_t;

extern __at(0x091A) volatile __OSCCON2bits_t OSCCON2bits;

#define _CDIV0                  0x01
#define _CDIV1                  0x02
#define _CDIV2                  0x04
#define _CDIV3                  0x08
#define _COSC0                  0x10
#define _COSC1                  0x20
#define _COSC2                  0x40

//==============================================================================


//==============================================================================
//        OSCCON3 Bits

extern __at(0x091B) __sfr OSCCON3;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned NOSCR                : 1;
  unsigned ORDY                 : 1;
  unsigned SOSCBE               : 1;
  unsigned SOSCPWR              : 1;
  unsigned CSWHOLD              : 1;
  } __OSCCON3bits_t;

extern __at(0x091B) volatile __OSCCON3bits_t OSCCON3bits;

#define _NOSCR                  0x08
#define _ORDY                   0x10
#define _SOSCBE                 0x20
#define _SOSCPWR                0x40
#define _CSWHOLD                0x80

//==============================================================================


//==============================================================================
//        OSCSTAT1 Bits

extern __at(0x091C) __sfr OSCSTAT1;

typedef struct
  {
  unsigned PLLR                 : 1;
  unsigned                      : 1;
  unsigned ADOR                 : 1;
  unsigned SOR                  : 1;
  unsigned LFOR                 : 1;
  unsigned                      : 1;
  unsigned HFOR                 : 1;
  unsigned EXTOR                : 1;
  } __OSCSTAT1bits_t;

extern __at(0x091C) volatile __OSCSTAT1bits_t OSCSTAT1bits;

#define _PLLR                   0x01
#define _ADOR                   0x04
#define _SOR                    0x08
#define _LFOR                   0x10
#define _HFOR                   0x40
#define _EXTOR                  0x80

//==============================================================================


//==============================================================================
//        OSCEN Bits

extern __at(0x091D) __sfr OSCEN;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADOEN                : 1;
  unsigned SOSCEN               : 1;
  unsigned LFOEN                : 1;
  unsigned                      : 1;
  unsigned HFOEN                : 1;
  unsigned EXTOEN               : 1;
  } __OSCENbits_t;

extern __at(0x091D) volatile __OSCENbits_t OSCENbits;

#define _ADOEN                  0x04
#define _SOSCEN                 0x08
#define _LFOEN                  0x10
#define _HFOEN                  0x40
#define _EXTOEN                 0x80

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x091E) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned HFTUN0             : 1;
    unsigned HFTUN1             : 1;
    unsigned HFTUN2             : 1;
    unsigned HFTUN3             : 1;
    unsigned HFTUN4             : 1;
    unsigned HFTUN5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned HFTUN              : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x091E) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _HFTUN0                 0x01
#define _HFTUN1                 0x02
#define _HFTUN2                 0x04
#define _HFTUN3                 0x08
#define _HFTUN4                 0x10
#define _HFTUN5                 0x20

//==============================================================================


//==============================================================================
//        OSCFRQ Bits

extern __at(0x091F) __sfr OSCFRQ;

typedef union
  {
  struct
    {
    unsigned HFFRQ0             : 1;
    unsigned HFFRQ1             : 1;
    unsigned HFFRQ2             : 1;
    unsigned HFFRQ3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned HFFRQ              : 4;
    unsigned                    : 4;
    };
  } __OSCFRQbits_t;

extern __at(0x091F) volatile __OSCFRQbits_t OSCFRQbits;

#define _HFFRQ0                 0x01
#define _HFFRQ1                 0x02
#define _HFFRQ2                 0x04
#define _HFFRQ3                 0x08

//==============================================================================


//==============================================================================
//        PPSLOCK Bits

extern __at(0x0E0F) __sfr PPSLOCK;

typedef struct
  {
  unsigned PPSLOCKED            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PPSLOCKbits_t;

extern __at(0x0E0F) volatile __PPSLOCKbits_t PPSLOCKbits;

#define _PPSLOCKED              0x01

//==============================================================================


//==============================================================================
//        INTPPS Bits

extern __at(0x0E10) __sfr INTPPS;

typedef union
  {
  struct
    {
    unsigned INTPPS0            : 1;
    unsigned INTPPS1            : 1;
    unsigned INTPPS2            : 1;
    unsigned INTPPS3            : 1;
    unsigned INTPPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INTPPS             : 5;
    unsigned                    : 3;
    };
  } __INTPPSbits_t;

extern __at(0x0E10) volatile __INTPPSbits_t INTPPSbits;

#define _INTPPS0                0x01
#define _INTPPS1                0x02
#define _INTPPS2                0x04
#define _INTPPS3                0x08
#define _INTPPS4                0x10

//==============================================================================


//==============================================================================
//        T0CKIPPS Bits

extern __at(0x0E11) __sfr T0CKIPPS;

typedef union
  {
  struct
    {
    unsigned T0CKIPPS0          : 1;
    unsigned T0CKIPPS1          : 1;
    unsigned T0CKIPPS2          : 1;
    unsigned T0CKIPPS3          : 1;
    unsigned T0CKIPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T0CKIPPS           : 5;
    unsigned                    : 3;
    };
  } __T0CKIPPSbits_t;

extern __at(0x0E11) volatile __T0CKIPPSbits_t T0CKIPPSbits;

#define _T0CKIPPS0              0x01
#define _T0CKIPPS1              0x02
#define _T0CKIPPS2              0x04
#define _T0CKIPPS3              0x08
#define _T0CKIPPS4              0x10

//==============================================================================


//==============================================================================
//        T1CKIPPS Bits

extern __at(0x0E12) __sfr T1CKIPPS;

typedef union
  {
  struct
    {
    unsigned T1CKIPPS0          : 1;
    unsigned T1CKIPPS1          : 1;
    unsigned T1CKIPPS2          : 1;
    unsigned T1CKIPPS3          : 1;
    unsigned T1CKIPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1CKIPPS           : 5;
    unsigned                    : 3;
    };
  } __T1CKIPPSbits_t;

extern __at(0x0E12) volatile __T1CKIPPSbits_t T1CKIPPSbits;

#define _T1CKIPPS0              0x01
#define _T1CKIPPS1              0x02
#define _T1CKIPPS2              0x04
#define _T1CKIPPS3              0x08
#define _T1CKIPPS4              0x10

//==============================================================================


//==============================================================================
//        T1GPPS Bits

extern __at(0x0E13) __sfr T1GPPS;

typedef union
  {
  struct
    {
    unsigned T1GPPS0            : 1;
    unsigned T1GPPS1            : 1;
    unsigned T1GPPS2            : 1;
    unsigned T1GPPS3            : 1;
    unsigned T1GPPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GPPS             : 5;
    unsigned                    : 3;
    };
  } __T1GPPSbits_t;

extern __at(0x0E13) volatile __T1GPPSbits_t T1GPPSbits;

#define _T1GPPS0                0x01
#define _T1GPPS1                0x02
#define _T1GPPS2                0x04
#define _T1GPPS3                0x08
#define _T1GPPS4                0x10

//==============================================================================


//==============================================================================
//        CCP1PPS Bits

extern __at(0x0E14) __sfr CCP1PPS;

typedef union
  {
  struct
    {
    unsigned CCP1PPS0           : 1;
    unsigned CCP1PPS1           : 1;
    unsigned CCP1PPS2           : 1;
    unsigned CCP1PPS3           : 1;
    unsigned CCP1PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1PPS            : 5;
    unsigned                    : 3;
    };
  } __CCP1PPSbits_t;

extern __at(0x0E14) volatile __CCP1PPSbits_t CCP1PPSbits;

#define _CCP1PPS0               0x01
#define _CCP1PPS1               0x02
#define _CCP1PPS2               0x04
#define _CCP1PPS3               0x08
#define _CCP1PPS4               0x10

//==============================================================================


//==============================================================================
//        CCP2PPS Bits

extern __at(0x0E15) __sfr CCP2PPS;

typedef union
  {
  struct
    {
    unsigned CCP2PPS0           : 1;
    unsigned CCP2PPS1           : 1;
    unsigned CCP2PPS2           : 1;
    unsigned CCP2PPS3           : 1;
    unsigned CCP2PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2PPS            : 5;
    unsigned                    : 3;
    };
  } __CCP2PPSbits_t;

extern __at(0x0E15) volatile __CCP2PPSbits_t CCP2PPSbits;

#define _CCP2PPS0               0x01
#define _CCP2PPS1               0x02
#define _CCP2PPS2               0x04
#define _CCP2PPS3               0x08
#define _CCP2PPS4               0x10

//==============================================================================


//==============================================================================
//        CCP3PPS Bits

extern __at(0x0E16) __sfr CCP3PPS;

typedef union
  {
  struct
    {
    unsigned CCP3PPS0           : 1;
    unsigned CCP3PPS1           : 1;
    unsigned CCP3PPS2           : 1;
    unsigned CCP3PPS3           : 1;
    unsigned CCP3PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP3PPS            : 5;
    unsigned                    : 3;
    };
  } __CCP3PPSbits_t;

extern __at(0x0E16) volatile __CCP3PPSbits_t CCP3PPSbits;

#define _CCP3PPS0               0x01
#define _CCP3PPS1               0x02
#define _CCP3PPS2               0x04
#define _CCP3PPS3               0x08
#define _CCP3PPS4               0x10

//==============================================================================


//==============================================================================
//        CCP4PPS Bits

extern __at(0x0E17) __sfr CCP4PPS;

typedef union
  {
  struct
    {
    unsigned CCP4PPS0           : 1;
    unsigned CCP4PPS1           : 1;
    unsigned CCP4PPS2           : 1;
    unsigned CCP4PPS3           : 1;
    unsigned CCP4PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP4PPS            : 5;
    unsigned                    : 3;
    };
  } __CCP4PPSbits_t;

extern __at(0x0E17) volatile __CCP4PPSbits_t CCP4PPSbits;

#define _CCP4PPS0               0x01
#define _CCP4PPS1               0x02
#define _CCP4PPS2               0x04
#define _CCP4PPS3               0x08
#define _CCP4PPS4               0x10

//==============================================================================


//==============================================================================
//        CWG1PPS Bits

extern __at(0x0E18) __sfr CWG1PPS;

typedef union
  {
  struct
    {
    unsigned CWG1PPS0           : 1;
    unsigned CWG1PPS1           : 1;
    unsigned CWG1PPS2           : 1;
    unsigned CWG1PPS3           : 1;
    unsigned CWG1PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1PPS            : 5;
    unsigned                    : 3;
    };
  } __CWG1PPSbits_t;

extern __at(0x0E18) volatile __CWG1PPSbits_t CWG1PPSbits;

#define _CWG1PPS0               0x01
#define _CWG1PPS1               0x02
#define _CWG1PPS2               0x04
#define _CWG1PPS3               0x08
#define _CWG1PPS4               0x10

//==============================================================================


//==============================================================================
//        CWG2PPS Bits

extern __at(0x0E19) __sfr CWG2PPS;

typedef union
  {
  struct
    {
    unsigned CWG2PPS0           : 1;
    unsigned CWG2PPS1           : 1;
    unsigned CWG2PPS2           : 1;
    unsigned CWG2PPS3           : 1;
    unsigned CWG2PPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG2PPS            : 5;
    unsigned                    : 3;
    };
  } __CWG2PPSbits_t;

extern __at(0x0E19) volatile __CWG2PPSbits_t CWG2PPSbits;

#define _CWG2PPS0               0x01
#define _CWG2PPS1               0x02
#define _CWG2PPS2               0x04
#define _CWG2PPS3               0x08
#define _CWG2PPS4               0x10

//==============================================================================


//==============================================================================
//        MDCIN1PPS Bits

extern __at(0x0E1A) __sfr MDCIN1PPS;

typedef union
  {
  struct
    {
    unsigned MDCIN1PPS0         : 1;
    unsigned MDCIN1PPS1         : 1;
    unsigned MDCIN1PPS2         : 1;
    unsigned MDCIN1PPS3         : 1;
    unsigned MDCIN1PPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MDCIN1PPS          : 5;
    unsigned                    : 3;
    };
  } __MDCIN1PPSbits_t;

extern __at(0x0E1A) volatile __MDCIN1PPSbits_t MDCIN1PPSbits;

#define _MDCIN1PPS0             0x01
#define _MDCIN1PPS1             0x02
#define _MDCIN1PPS2             0x04
#define _MDCIN1PPS3             0x08
#define _MDCIN1PPS4             0x10

//==============================================================================


//==============================================================================
//        MDCIN2PPS Bits

extern __at(0x0E1B) __sfr MDCIN2PPS;

typedef union
  {
  struct
    {
    unsigned MDCIN2PPS0         : 1;
    unsigned MDCIN2PPS1         : 1;
    unsigned MDCIN2PPS2         : 1;
    unsigned MDCIN2PPS3         : 1;
    unsigned MDCIN2PPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MDCIN2PPS          : 5;
    unsigned                    : 3;
    };
  } __MDCIN2PPSbits_t;

extern __at(0x0E1B) volatile __MDCIN2PPSbits_t MDCIN2PPSbits;

#define _MDCIN2PPS0             0x01
#define _MDCIN2PPS1             0x02
#define _MDCIN2PPS2             0x04
#define _MDCIN2PPS3             0x08
#define _MDCIN2PPS4             0x10

//==============================================================================


//==============================================================================
//        MDMINPPS Bits

extern __at(0x0E1C) __sfr MDMINPPS;

typedef union
  {
  struct
    {
    unsigned MDMINPPS0          : 1;
    unsigned MDMINPPS1          : 1;
    unsigned MDMINPPS2          : 1;
    unsigned MDMINPPS3          : 1;
    unsigned MDMINPPS4          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MDMINPPS           : 5;
    unsigned                    : 3;
    };
  } __MDMINPPSbits_t;

extern __at(0x0E1C) volatile __MDMINPPSbits_t MDMINPPSbits;

#define _MDMINPPS0              0x01
#define _MDMINPPS1              0x02
#define _MDMINPPS2              0x04
#define _MDMINPPS3              0x08
#define _MDMINPPS4              0x10

//==============================================================================


//==============================================================================
//        SSP2CLKPPS Bits

extern __at(0x0E1D) __sfr SSP2CLKPPS;

typedef union
  {
  struct
    {
    unsigned SSP2CLKPPS0        : 1;
    unsigned SSP2CLKPPS1        : 1;
    unsigned SSP2CLKPPS2        : 1;
    unsigned SSP2CLKPPS3        : 1;
    unsigned SSP2CLKPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP2CLKPPS         : 5;
    unsigned                    : 3;
    };
  } __SSP2CLKPPSbits_t;

extern __at(0x0E1D) volatile __SSP2CLKPPSbits_t SSP2CLKPPSbits;

#define _SSP2CLKPPS0            0x01
#define _SSP2CLKPPS1            0x02
#define _SSP2CLKPPS2            0x04
#define _SSP2CLKPPS3            0x08
#define _SSP2CLKPPS4            0x10

//==============================================================================


//==============================================================================
//        SSP2DATPPS Bits

extern __at(0x0E1E) __sfr SSP2DATPPS;

typedef union
  {
  struct
    {
    unsigned SSP2DATPPS0        : 1;
    unsigned SSP2DATPPS1        : 1;
    unsigned SSP2DATPPS2        : 1;
    unsigned SSP2DATPPS3        : 1;
    unsigned SSP2DATPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP2DATPPS         : 5;
    unsigned                    : 3;
    };
  } __SSP2DATPPSbits_t;

extern __at(0x0E1E) volatile __SSP2DATPPSbits_t SSP2DATPPSbits;

#define _SSP2DATPPS0            0x01
#define _SSP2DATPPS1            0x02
#define _SSP2DATPPS2            0x04
#define _SSP2DATPPS3            0x08
#define _SSP2DATPPS4            0x10

//==============================================================================


//==============================================================================
//        SSP2SSPPS Bits

extern __at(0x0E1F) __sfr SSP2SSPPS;

typedef union
  {
  struct
    {
    unsigned SSP2SSPPS0         : 1;
    unsigned SSP2SSPPS1         : 1;
    unsigned SSP2SSPPS2         : 1;
    unsigned SSP2SSPPS3         : 1;
    unsigned SSP2SSPPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP2SSPPS          : 5;
    unsigned                    : 3;
    };
  } __SSP2SSPPSbits_t;

extern __at(0x0E1F) volatile __SSP2SSPPSbits_t SSP2SSPPSbits;

#define _SSP2SSPPS0             0x01
#define _SSP2SSPPS1             0x02
#define _SSP2SSPPS2             0x04
#define _SSP2SSPPS3             0x08
#define _SSP2SSPPS4             0x10

//==============================================================================


//==============================================================================
//        SSP1CLKPPS Bits

extern __at(0x0E20) __sfr SSP1CLKPPS;

typedef union
  {
  struct
    {
    unsigned SSP1CLKPPS0        : 1;
    unsigned SSP1CLKPPS1        : 1;
    unsigned SSP1CLKPPS2        : 1;
    unsigned SSP1CLKPPS3        : 1;
    unsigned SSP1CLKPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP1CLKPPS         : 5;
    unsigned                    : 3;
    };
  } __SSP1CLKPPSbits_t;

extern __at(0x0E20) volatile __SSP1CLKPPSbits_t SSP1CLKPPSbits;

#define _SSP1CLKPPS0            0x01
#define _SSP1CLKPPS1            0x02
#define _SSP1CLKPPS2            0x04
#define _SSP1CLKPPS3            0x08
#define _SSP1CLKPPS4            0x10

//==============================================================================


//==============================================================================
//        SSP1DATPPS Bits

extern __at(0x0E21) __sfr SSP1DATPPS;

typedef union
  {
  struct
    {
    unsigned SSP1DATPPS0        : 1;
    unsigned SSP1DATPPS1        : 1;
    unsigned SSP1DATPPS2        : 1;
    unsigned SSP1DATPPS3        : 1;
    unsigned SSP1DATPPS4        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP1DATPPS         : 5;
    unsigned                    : 3;
    };
  } __SSP1DATPPSbits_t;

extern __at(0x0E21) volatile __SSP1DATPPSbits_t SSP1DATPPSbits;

#define _SSP1DATPPS0            0x01
#define _SSP1DATPPS1            0x02
#define _SSP1DATPPS2            0x04
#define _SSP1DATPPS3            0x08
#define _SSP1DATPPS4            0x10

//==============================================================================


//==============================================================================
//        SSP1SSPPS Bits

extern __at(0x0E22) __sfr SSP1SSPPS;

typedef union
  {
  struct
    {
    unsigned SSP1SSPPS0         : 1;
    unsigned SSP1SSPPS1         : 1;
    unsigned SSP1SSPPS2         : 1;
    unsigned SSP1SSPPS3         : 1;
    unsigned SSP1SSPPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SSP1SSPPS          : 5;
    unsigned                    : 3;
    };
  } __SSP1SSPPSbits_t;

extern __at(0x0E22) volatile __SSP1SSPPSbits_t SSP1SSPPSbits;

#define _SSP1SSPPS0             0x01
#define _SSP1SSPPS1             0x02
#define _SSP1SSPPS2             0x04
#define _SSP1SSPPS3             0x08
#define _SSP1SSPPS4             0x10

//==============================================================================


//==============================================================================
//        RXPPS Bits

extern __at(0x0E24) __sfr RXPPS;

typedef union
  {
  struct
    {
    unsigned RXDTPPS0           : 1;
    unsigned RXDTPPS1           : 1;
    unsigned RXDTPPS2           : 1;
    unsigned RXDTPPS3           : 1;
    unsigned RXDTPPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RXDTPPS            : 5;
    unsigned                    : 3;
    };
  } __RXPPSbits_t;

extern __at(0x0E24) volatile __RXPPSbits_t RXPPSbits;

#define _RXDTPPS0               0x01
#define _RXDTPPS1               0x02
#define _RXDTPPS2               0x04
#define _RXDTPPS3               0x08
#define _RXDTPPS4               0x10

//==============================================================================


//==============================================================================
//        TXPPS Bits

extern __at(0x0E25) __sfr TXPPS;

typedef union
  {
  struct
    {
    unsigned TXCKPPS0           : 1;
    unsigned TXCKPPS1           : 1;
    unsigned TXCKPPS2           : 1;
    unsigned TXCKPPS3           : 1;
    unsigned TXCKPPS4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TXCKPPS            : 5;
    unsigned                    : 3;
    };
  } __TXPPSbits_t;

extern __at(0x0E25) volatile __TXPPSbits_t TXPPSbits;

#define _TXCKPPS0               0x01
#define _TXCKPPS1               0x02
#define _TXCKPPS2               0x04
#define _TXCKPPS3               0x08
#define _TXCKPPS4               0x10

//==============================================================================


//==============================================================================
//        CLCIN0PPS Bits

extern __at(0x0E28) __sfr CLCIN0PPS;

typedef union
  {
  struct
    {
    unsigned CLCIN0PPS0         : 1;
    unsigned CLCIN0PPS1         : 1;
    unsigned CLCIN0PPS2         : 1;
    unsigned CLCIN0PPS3         : 1;
    unsigned CLCIN0PPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CLCIN0PPS          : 5;
    unsigned                    : 3;
    };
  } __CLCIN0PPSbits_t;

extern __at(0x0E28) volatile __CLCIN0PPSbits_t CLCIN0PPSbits;

#define _CLCIN0PPS0             0x01
#define _CLCIN0PPS1             0x02
#define _CLCIN0PPS2             0x04
#define _CLCIN0PPS3             0x08
#define _CLCIN0PPS4             0x10

//==============================================================================


//==============================================================================
//        CLCIN1PPS Bits

extern __at(0x0E29) __sfr CLCIN1PPS;

typedef union
  {
  struct
    {
    unsigned CLCIN1PPS0         : 1;
    unsigned CLCIN1PPS1         : 1;
    unsigned CLCIN1PPS2         : 1;
    unsigned CLCIN1PPS3         : 1;
    unsigned CLCIN1PPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CLCIN1PPS          : 5;
    unsigned                    : 3;
    };
  } __CLCIN1PPSbits_t;

extern __at(0x0E29) volatile __CLCIN1PPSbits_t CLCIN1PPSbits;

#define _CLCIN1PPS0             0x01
#define _CLCIN1PPS1             0x02
#define _CLCIN1PPS2             0x04
#define _CLCIN1PPS3             0x08
#define _CLCIN1PPS4             0x10

//==============================================================================


//==============================================================================
//        CLCIN2PPS Bits

extern __at(0x0E2A) __sfr CLCIN2PPS;

typedef union
  {
  struct
    {
    unsigned CLCIN2PPS0         : 1;
    unsigned CLCIN2PPS1         : 1;
    unsigned CLCIN2PPS2         : 1;
    unsigned CLCIN2PPS3         : 1;
    unsigned CLCIN2PPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CLCIN2PPS          : 5;
    unsigned                    : 3;
    };
  } __CLCIN2PPSbits_t;

extern __at(0x0E2A) volatile __CLCIN2PPSbits_t CLCIN2PPSbits;

#define _CLCIN2PPS0             0x01
#define _CLCIN2PPS1             0x02
#define _CLCIN2PPS2             0x04
#define _CLCIN2PPS3             0x08
#define _CLCIN2PPS4             0x10

//==============================================================================


//==============================================================================
//        CLCIN3PPS Bits

extern __at(0x0E2B) __sfr CLCIN3PPS;

typedef union
  {
  struct
    {
    unsigned CLCIN3PPS0         : 1;
    unsigned CLCIN3PPS1         : 1;
    unsigned CLCIN3PPS2         : 1;
    unsigned CLCIN3PPS3         : 1;
    unsigned CLCIN3PPS4         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CLCIN3PPS          : 5;
    unsigned                    : 3;
    };
  } __CLCIN3PPSbits_t;

extern __at(0x0E2B) volatile __CLCIN3PPSbits_t CLCIN3PPSbits;

#define _CLCIN3PPS0             0x01
#define _CLCIN3PPS1             0x02
#define _CLCIN3PPS2             0x04
#define _CLCIN3PPS3             0x08
#define _CLCIN3PPS4             0x10

//==============================================================================

extern __at(0x0E2C) __sfr T3CKIPPS;
extern __at(0x0E2D) __sfr T3GPPS;
extern __at(0x0E2E) __sfr T5CKIPPS;
extern __at(0x0E2F) __sfr T5GPPS;

//==============================================================================
//        RA0PPS Bits

extern __at(0x0E90) __sfr RA0PPS;

typedef union
  {
  struct
    {
    unsigned RA0PPS0            : 1;
    unsigned RA0PPS1            : 1;
    unsigned RA0PPS2            : 1;
    unsigned RA0PPS3            : 1;
    unsigned RA0PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA0PPS             : 5;
    unsigned                    : 3;
    };
  } __RA0PPSbits_t;

extern __at(0x0E90) volatile __RA0PPSbits_t RA0PPSbits;

#define _RA0PPS0                0x01
#define _RA0PPS1                0x02
#define _RA0PPS2                0x04
#define _RA0PPS3                0x08
#define _RA0PPS4                0x10

//==============================================================================


//==============================================================================
//        RA1PPS Bits

extern __at(0x0E91) __sfr RA1PPS;

typedef union
  {
  struct
    {
    unsigned RA1PPS0            : 1;
    unsigned RA1PPS1            : 1;
    unsigned RA1PPS2            : 1;
    unsigned RA1PPS3            : 1;
    unsigned RA1PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA1PPS             : 5;
    unsigned                    : 3;
    };
  } __RA1PPSbits_t;

extern __at(0x0E91) volatile __RA1PPSbits_t RA1PPSbits;

#define _RA1PPS0                0x01
#define _RA1PPS1                0x02
#define _RA1PPS2                0x04
#define _RA1PPS3                0x08
#define _RA1PPS4                0x10

//==============================================================================


//==============================================================================
//        RA2PPS Bits

extern __at(0x0E92) __sfr RA2PPS;

typedef union
  {
  struct
    {
    unsigned RA2PPS0            : 1;
    unsigned RA2PPS1            : 1;
    unsigned RA2PPS2            : 1;
    unsigned RA2PPS3            : 1;
    unsigned RA2PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA2PPS             : 5;
    unsigned                    : 3;
    };
  } __RA2PPSbits_t;

extern __at(0x0E92) volatile __RA2PPSbits_t RA2PPSbits;

#define _RA2PPS0                0x01
#define _RA2PPS1                0x02
#define _RA2PPS2                0x04
#define _RA2PPS3                0x08
#define _RA2PPS4                0x10

//==============================================================================


//==============================================================================
//        RA4PPS Bits

extern __at(0x0E94) __sfr RA4PPS;

typedef union
  {
  struct
    {
    unsigned RA4PPS0            : 1;
    unsigned RA4PPS1            : 1;
    unsigned RA4PPS2            : 1;
    unsigned RA4PPS3            : 1;
    unsigned RA4PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA4PPS             : 5;
    unsigned                    : 3;
    };
  } __RA4PPSbits_t;

extern __at(0x0E94) volatile __RA4PPSbits_t RA4PPSbits;

#define _RA4PPS0                0x01
#define _RA4PPS1                0x02
#define _RA4PPS2                0x04
#define _RA4PPS3                0x08
#define _RA4PPS4                0x10

//==============================================================================


//==============================================================================
//        RA5PPS Bits

extern __at(0x0E95) __sfr RA5PPS;

typedef union
  {
  struct
    {
    unsigned RA5PPS0            : 1;
    unsigned RA5PPS1            : 1;
    unsigned RA5PPS2            : 1;
    unsigned RA5PPS3            : 1;
    unsigned RA5PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA5PPS             : 5;
    unsigned                    : 3;
    };
  } __RA5PPSbits_t;

extern __at(0x0E95) volatile __RA5PPSbits_t RA5PPSbits;

#define _RA5PPS0                0x01
#define _RA5PPS1                0x02
#define _RA5PPS2                0x04
#define _RA5PPS3                0x08
#define _RA5PPS4                0x10

//==============================================================================


//==============================================================================
//        RB4PPS Bits

extern __at(0x0E9C) __sfr RB4PPS;

typedef union
  {
  struct
    {
    unsigned RB4PPS0            : 1;
    unsigned RB4PPS1            : 1;
    unsigned RB4PPS2            : 1;
    unsigned RB4PPS3            : 1;
    unsigned RB4PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB4PPS             : 5;
    unsigned                    : 3;
    };
  } __RB4PPSbits_t;

extern __at(0x0E9C) volatile __RB4PPSbits_t RB4PPSbits;

#define _RB4PPS0                0x01
#define _RB4PPS1                0x02
#define _RB4PPS2                0x04
#define _RB4PPS3                0x08
#define _RB4PPS4                0x10

//==============================================================================


//==============================================================================
//        RB5PPS Bits

extern __at(0x0E9D) __sfr RB5PPS;

typedef union
  {
  struct
    {
    unsigned RB5PPS0            : 1;
    unsigned RB5PPS1            : 1;
    unsigned RB5PPS2            : 1;
    unsigned RB5PPS3            : 1;
    unsigned RB5PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB5PPS             : 5;
    unsigned                    : 3;
    };
  } __RB5PPSbits_t;

extern __at(0x0E9D) volatile __RB5PPSbits_t RB5PPSbits;

#define _RB5PPS0                0x01
#define _RB5PPS1                0x02
#define _RB5PPS2                0x04
#define _RB5PPS3                0x08
#define _RB5PPS4                0x10

//==============================================================================


//==============================================================================
//        RB6PPS Bits

extern __at(0x0E9E) __sfr RB6PPS;

typedef union
  {
  struct
    {
    unsigned RB6PPS0            : 1;
    unsigned RB6PPS1            : 1;
    unsigned RB6PPS2            : 1;
    unsigned RB6PPS3            : 1;
    unsigned RB6PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB6PPS             : 5;
    unsigned                    : 3;
    };
  } __RB6PPSbits_t;

extern __at(0x0E9E) volatile __RB6PPSbits_t RB6PPSbits;

#define _RB6PPS0                0x01
#define _RB6PPS1                0x02
#define _RB6PPS2                0x04
#define _RB6PPS3                0x08
#define _RB6PPS4                0x10

//==============================================================================


//==============================================================================
//        RB7PPS Bits

extern __at(0x0E9F) __sfr RB7PPS;

typedef union
  {
  struct
    {
    unsigned RB7PPS0            : 1;
    unsigned RB7PPS1            : 1;
    unsigned RB7PPS2            : 1;
    unsigned RB7PPS3            : 1;
    unsigned RB7PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RB7PPS             : 5;
    unsigned                    : 3;
    };
  } __RB7PPSbits_t;

extern __at(0x0E9F) volatile __RB7PPSbits_t RB7PPSbits;

#define _RB7PPS0                0x01
#define _RB7PPS1                0x02
#define _RB7PPS2                0x04
#define _RB7PPS3                0x08
#define _RB7PPS4                0x10

//==============================================================================


//==============================================================================
//        RC0PPS Bits

extern __at(0x0EA0) __sfr RC0PPS;

typedef union
  {
  struct
    {
    unsigned RC0PPS0            : 1;
    unsigned RC0PPS1            : 1;
    unsigned RC0PPS2            : 1;
    unsigned RC0PPS3            : 1;
    unsigned RC0PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC0PPS             : 5;
    unsigned                    : 3;
    };
  } __RC0PPSbits_t;

extern __at(0x0EA0) volatile __RC0PPSbits_t RC0PPSbits;

#define _RC0PPS0                0x01
#define _RC0PPS1                0x02
#define _RC0PPS2                0x04
#define _RC0PPS3                0x08
#define _RC0PPS4                0x10

//==============================================================================


//==============================================================================
//        RC1PPS Bits

extern __at(0x0EA1) __sfr RC1PPS;

typedef union
  {
  struct
    {
    unsigned RC1PPS0            : 1;
    unsigned RC1PPS1            : 1;
    unsigned RC1PPS2            : 1;
    unsigned RC1PPS3            : 1;
    unsigned RC1PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC1PPS             : 5;
    unsigned                    : 3;
    };
  } __RC1PPSbits_t;

extern __at(0x0EA1) volatile __RC1PPSbits_t RC1PPSbits;

#define _RC1PPS0                0x01
#define _RC1PPS1                0x02
#define _RC1PPS2                0x04
#define _RC1PPS3                0x08
#define _RC1PPS4                0x10

//==============================================================================


//==============================================================================
//        RC2PPS Bits

extern __at(0x0EA2) __sfr RC2PPS;

typedef union
  {
  struct
    {
    unsigned RC2PPS0            : 1;
    unsigned RC2PPS1            : 1;
    unsigned RC2PPS2            : 1;
    unsigned RC2PPS3            : 1;
    unsigned RC2PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC2PPS             : 5;
    unsigned                    : 3;
    };
  } __RC2PPSbits_t;

extern __at(0x0EA2) volatile __RC2PPSbits_t RC2PPSbits;

#define _RC2PPS0                0x01
#define _RC2PPS1                0x02
#define _RC2PPS2                0x04
#define _RC2PPS3                0x08
#define _RC2PPS4                0x10

//==============================================================================


//==============================================================================
//        RC3PPS Bits

extern __at(0x0EA3) __sfr RC3PPS;

typedef union
  {
  struct
    {
    unsigned RC3PPS0            : 1;
    unsigned RC3PPS1            : 1;
    unsigned RC3PPS2            : 1;
    unsigned RC3PPS3            : 1;
    unsigned RC3PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC3PPS             : 5;
    unsigned                    : 3;
    };
  } __RC3PPSbits_t;

extern __at(0x0EA3) volatile __RC3PPSbits_t RC3PPSbits;

#define _RC3PPS0                0x01
#define _RC3PPS1                0x02
#define _RC3PPS2                0x04
#define _RC3PPS3                0x08
#define _RC3PPS4                0x10

//==============================================================================


//==============================================================================
//        RC4PPS Bits

extern __at(0x0EA4) __sfr RC4PPS;

typedef union
  {
  struct
    {
    unsigned RC4PPS0            : 1;
    unsigned RC4PPS1            : 1;
    unsigned RC4PPS2            : 1;
    unsigned RC4PPS3            : 1;
    unsigned RC4PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC4PPS             : 5;
    unsigned                    : 3;
    };
  } __RC4PPSbits_t;

extern __at(0x0EA4) volatile __RC4PPSbits_t RC4PPSbits;

#define _RC4PPS0                0x01
#define _RC4PPS1                0x02
#define _RC4PPS2                0x04
#define _RC4PPS3                0x08
#define _RC4PPS4                0x10

//==============================================================================


//==============================================================================
//        RC5PPS Bits

extern __at(0x0EA5) __sfr RC5PPS;

typedef union
  {
  struct
    {
    unsigned RC5PPS0            : 1;
    unsigned RC5PPS1            : 1;
    unsigned RC5PPS2            : 1;
    unsigned RC5PPS3            : 1;
    unsigned RC5PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC5PPS             : 5;
    unsigned                    : 3;
    };
  } __RC5PPSbits_t;

extern __at(0x0EA5) volatile __RC5PPSbits_t RC5PPSbits;

#define _RC5PPS0                0x01
#define _RC5PPS1                0x02
#define _RC5PPS2                0x04
#define _RC5PPS3                0x08
#define _RC5PPS4                0x10

//==============================================================================


//==============================================================================
//        RC6PPS Bits

extern __at(0x0EA6) __sfr RC6PPS;

typedef union
  {
  struct
    {
    unsigned RC6PPS0            : 1;
    unsigned RC6PPS1            : 1;
    unsigned RC6PPS2            : 1;
    unsigned RC6PPS3            : 1;
    unsigned RC6PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC6PPS             : 5;
    unsigned                    : 3;
    };
  } __RC6PPSbits_t;

extern __at(0x0EA6) volatile __RC6PPSbits_t RC6PPSbits;

#define _RC6PPS0                0x01
#define _RC6PPS1                0x02
#define _RC6PPS2                0x04
#define _RC6PPS3                0x08
#define _RC6PPS4                0x10

//==============================================================================


//==============================================================================
//        RC7PPS Bits

extern __at(0x0EA7) __sfr RC7PPS;

typedef union
  {
  struct
    {
    unsigned RC7PPS0            : 1;
    unsigned RC7PPS1            : 1;
    unsigned RC7PPS2            : 1;
    unsigned RC7PPS3            : 1;
    unsigned RC7PPS4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC7PPS             : 5;
    unsigned                    : 3;
    };
  } __RC7PPSbits_t;

extern __at(0x0EA7) volatile __RC7PPSbits_t RC7PPSbits;

#define _RC7PPS0                0x01
#define _RC7PPS1                0x02
#define _RC7PPS2                0x04
#define _RC7PPS3                0x08
#define _RC7PPS4                0x10

//==============================================================================


//==============================================================================
//        CLCDATA Bits

extern __at(0x0F0F) __sfr CLCDATA;

typedef struct
  {
  unsigned MLC1OUT              : 1;
  unsigned MLC2OUT              : 1;
  unsigned MLC3OUT              : 1;
  unsigned MLC4OUT              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CLCDATAbits_t;

extern __at(0x0F0F) volatile __CLCDATAbits_t CLCDATAbits;

#define _MLC1OUT                0x01
#define _MLC2OUT                0x02
#define _MLC3OUT                0x04
#define _MLC4OUT                0x08

//==============================================================================


//==============================================================================
//        CLC1CON Bits

extern __at(0x0F10) __sfr CLC1CON;

typedef union
  {
  struct
    {
    unsigned LC1MODE0           : 1;
    unsigned LC1MODE1           : 1;
    unsigned LC1MODE2           : 1;
    unsigned LC1INTN            : 1;
    unsigned LC1INTP            : 1;
    unsigned LC1OUT             : 1;
    unsigned                    : 1;
    unsigned LC1EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC1MODE            : 3;
    unsigned                    : 5;
    };
  } __CLC1CONbits_t;

extern __at(0x0F10) volatile __CLC1CONbits_t CLC1CONbits;

#define _LC1MODE0               0x01
#define _MODE0                  0x01
#define _LC1MODE1               0x02
#define _MODE1                  0x02
#define _LC1MODE2               0x04
#define _MODE2                  0x04
#define _LC1INTN                0x08
#define _INTN                   0x08
#define _LC1INTP                0x10
#define _INTP                   0x10
#define _LC1OUT                 0x20
#define _OUT                    0x20
#define _LC1EN                  0x80
#define _EN                     0x80

//==============================================================================


//==============================================================================
//        CLC1POL Bits

extern __at(0x0F11) __sfr CLC1POL;

typedef union
  {
  struct
    {
    unsigned LC1G1POL           : 1;
    unsigned LC1G2POL           : 1;
    unsigned LC1G3POL           : 1;
    unsigned LC1G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC1POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC1POLbits_t;

extern __at(0x0F11) volatile __CLC1POLbits_t CLC1POLbits;

#define _LC1G1POL               0x01
#define _G1POL                  0x01
#define _LC1G2POL               0x02
#define _G2POL                  0x02
#define _LC1G3POL               0x04
#define _G3POL                  0x04
#define _LC1G4POL               0x08
#define _G4POL                  0x08
#define _LC1POL                 0x80
#define _POL                    0x80

//==============================================================================


//==============================================================================
//        CLC1SEL0 Bits

extern __at(0x0F12) __sfr CLC1SEL0;

typedef union
  {
  struct
    {
    unsigned LC1D1S0            : 1;
    unsigned LC1D1S1            : 1;
    unsigned LC1D1S2            : 1;
    unsigned LC1D1S3            : 1;
    unsigned LC1D1S4            : 1;
    unsigned LC1D1S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC1D1S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D1S                : 6;
    unsigned                    : 2;
    };
  } __CLC1SEL0bits_t;

extern __at(0x0F12) volatile __CLC1SEL0bits_t CLC1SEL0bits;

#define _LC1D1S0                0x01
#define _D1S0                   0x01
#define _LC1D1S1                0x02
#define _D1S1                   0x02
#define _LC1D1S2                0x04
#define _D1S2                   0x04
#define _LC1D1S3                0x08
#define _D1S3                   0x08
#define _LC1D1S4                0x10
#define _D1S4                   0x10
#define _LC1D1S5                0x20
#define _D1S5                   0x20

//==============================================================================


//==============================================================================
//        CLC1SEL1 Bits

extern __at(0x0F13) __sfr CLC1SEL1;

typedef union
  {
  struct
    {
    unsigned LC1D2S0            : 1;
    unsigned LC1D2S1            : 1;
    unsigned LC1D2S2            : 1;
    unsigned LC1D2S3            : 1;
    unsigned LC1D2S4            : 1;
    unsigned LC1D2S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC1D2S             : 6;
    unsigned                    : 2;
    };
  } __CLC1SEL1bits_t;

extern __at(0x0F13) volatile __CLC1SEL1bits_t CLC1SEL1bits;

#define _LC1D2S0                0x01
#define _D2S0                   0x01
#define _LC1D2S1                0x02
#define _D2S1                   0x02
#define _LC1D2S2                0x04
#define _D2S2                   0x04
#define _LC1D2S3                0x08
#define _D2S3                   0x08
#define _LC1D2S4                0x10
#define _D2S4                   0x10
#define _LC1D2S5                0x20
#define _D2S5                   0x20

//==============================================================================


//==============================================================================
//        CLC1SEL2 Bits

extern __at(0x0F14) __sfr CLC1SEL2;

typedef union
  {
  struct
    {
    unsigned LC1D3S0            : 1;
    unsigned LC1D3S1            : 1;
    unsigned LC1D3S2            : 1;
    unsigned LC1D3S3            : 1;
    unsigned LC1D3S4            : 1;
    unsigned LC1D3S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC1D3S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D3S                : 6;
    unsigned                    : 2;
    };
  } __CLC1SEL2bits_t;

extern __at(0x0F14) volatile __CLC1SEL2bits_t CLC1SEL2bits;

#define _LC1D3S0                0x01
#define _D3S0                   0x01
#define _LC1D3S1                0x02
#define _D3S1                   0x02
#define _LC1D3S2                0x04
#define _D3S2                   0x04
#define _LC1D3S3                0x08
#define _D3S3                   0x08
#define _LC1D3S4                0x10
#define _D3S4                   0x10
#define _LC1D3S5                0x20
#define _D3S5                   0x20

//==============================================================================


//==============================================================================
//        CLC1SEL3 Bits

extern __at(0x0F15) __sfr CLC1SEL3;

typedef union
  {
  struct
    {
    unsigned LC1D4S0            : 1;
    unsigned LC1D4S1            : 1;
    unsigned LC1D4S2            : 1;
    unsigned LC1D4S3            : 1;
    unsigned LC1D4S4            : 1;
    unsigned LC1D4S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC1D4S             : 6;
    unsigned                    : 2;
    };
  } __CLC1SEL3bits_t;

extern __at(0x0F15) volatile __CLC1SEL3bits_t CLC1SEL3bits;

#define _LC1D4S0                0x01
#define _D4S0                   0x01
#define _LC1D4S1                0x02
#define _D4S1                   0x02
#define _LC1D4S2                0x04
#define _D4S2                   0x04
#define _LC1D4S3                0x08
#define _D4S3                   0x08
#define _LC1D4S4                0x10
#define _D4S4                   0x10
#define _LC1D4S5                0x20
#define _D4S5                   0x20

//==============================================================================


//==============================================================================
//        CLC1GLS0 Bits

extern __at(0x0F16) __sfr CLC1GLS0;

typedef union
  {
  struct
    {
    unsigned LC1G1D1N           : 1;
    unsigned LC1G1D1T           : 1;
    unsigned LC1G1D2N           : 1;
    unsigned LC1G1D2T           : 1;
    unsigned LC1G1D3N           : 1;
    unsigned LC1G1D3T           : 1;
    unsigned LC1G1D4N           : 1;
    unsigned LC1G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS0bits_t;

extern __at(0x0F16) volatile __CLC1GLS0bits_t CLC1GLS0bits;

#define _LC1G1D1N               0x01
#define _D1N                    0x01
#define _LC1G1D1T               0x02
#define _D1T                    0x02
#define _LC1G1D2N               0x04
#define _D2N                    0x04
#define _LC1G1D2T               0x08
#define _D2T                    0x08
#define _LC1G1D3N               0x10
#define _D3N                    0x10
#define _LC1G1D3T               0x20
#define _D3T                    0x20
#define _LC1G1D4N               0x40
#define _D4N                    0x40
#define _LC1G1D4T               0x80
#define _D4T                    0x80

//==============================================================================


//==============================================================================
//        CLC1GLS1 Bits

extern __at(0x0F17) __sfr CLC1GLS1;

typedef union
  {
  struct
    {
    unsigned LC1G2D1N           : 1;
    unsigned LC1G2D1T           : 1;
    unsigned LC1G2D2N           : 1;
    unsigned LC1G2D2T           : 1;
    unsigned LC1G2D3N           : 1;
    unsigned LC1G2D3T           : 1;
    unsigned LC1G2D4N           : 1;
    unsigned LC1G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS1bits_t;

extern __at(0x0F17) volatile __CLC1GLS1bits_t CLC1GLS1bits;

#define _CLC1GLS1_LC1G2D1N      0x01
#define _CLC1GLS1_D1N           0x01
#define _CLC1GLS1_LC1G2D1T      0x02
#define _CLC1GLS1_D1T           0x02
#define _CLC1GLS1_LC1G2D2N      0x04
#define _CLC1GLS1_D2N           0x04
#define _CLC1GLS1_LC1G2D2T      0x08
#define _CLC1GLS1_D2T           0x08
#define _CLC1GLS1_LC1G2D3N      0x10
#define _CLC1GLS1_D3N           0x10
#define _CLC1GLS1_LC1G2D3T      0x20
#define _CLC1GLS1_D3T           0x20
#define _CLC1GLS1_LC1G2D4N      0x40
#define _CLC1GLS1_D4N           0x40
#define _CLC1GLS1_LC1G2D4T      0x80
#define _CLC1GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS2 Bits

extern __at(0x0F18) __sfr CLC1GLS2;

typedef union
  {
  struct
    {
    unsigned LC1G3D1N           : 1;
    unsigned LC1G3D1T           : 1;
    unsigned LC1G3D2N           : 1;
    unsigned LC1G3D2T           : 1;
    unsigned LC1G3D3N           : 1;
    unsigned LC1G3D3T           : 1;
    unsigned LC1G3D4N           : 1;
    unsigned LC1G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS2bits_t;

extern __at(0x0F18) volatile __CLC1GLS2bits_t CLC1GLS2bits;

#define _CLC1GLS2_LC1G3D1N      0x01
#define _CLC1GLS2_D1N           0x01
#define _CLC1GLS2_LC1G3D1T      0x02
#define _CLC1GLS2_D1T           0x02
#define _CLC1GLS2_LC1G3D2N      0x04
#define _CLC1GLS2_D2N           0x04
#define _CLC1GLS2_LC1G3D2T      0x08
#define _CLC1GLS2_D2T           0x08
#define _CLC1GLS2_LC1G3D3N      0x10
#define _CLC1GLS2_D3N           0x10
#define _CLC1GLS2_LC1G3D3T      0x20
#define _CLC1GLS2_D3T           0x20
#define _CLC1GLS2_LC1G3D4N      0x40
#define _CLC1GLS2_D4N           0x40
#define _CLC1GLS2_LC1G3D4T      0x80
#define _CLC1GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS3 Bits

extern __at(0x0F19) __sfr CLC1GLS3;

typedef union
  {
  struct
    {
    unsigned LC1G4D1N           : 1;
    unsigned LC1G4D1T           : 1;
    unsigned LC1G4D2N           : 1;
    unsigned LC1G4D2T           : 1;
    unsigned LC1G4D3N           : 1;
    unsigned LC1G4D3T           : 1;
    unsigned LC1G4D4N           : 1;
    unsigned LC1G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC1GLS3bits_t;

extern __at(0x0F19) volatile __CLC1GLS3bits_t CLC1GLS3bits;

#define _LC1G4D1N               0x01
#define _G4D1N                  0x01
#define _LC1G4D1T               0x02
#define _G4D1T                  0x02
#define _LC1G4D2N               0x04
#define _G4D2N                  0x04
#define _LC1G4D2T               0x08
#define _G4D2T                  0x08
#define _LC1G4D3N               0x10
#define _G4D3N                  0x10
#define _LC1G4D3T               0x20
#define _G4D3T                  0x20
#define _LC1G4D4N               0x40
#define _G4D4N                  0x40
#define _LC1G4D4T               0x80
#define _G4D4T                  0x80

//==============================================================================


//==============================================================================
//        CLC2CON Bits

extern __at(0x0F1A) __sfr CLC2CON;

typedef union
  {
  struct
    {
    unsigned LC2MODE0           : 1;
    unsigned LC2MODE1           : 1;
    unsigned LC2MODE2           : 1;
    unsigned LC2INTN            : 1;
    unsigned LC2INTP            : 1;
    unsigned LC2OUT             : 1;
    unsigned                    : 1;
    unsigned LC2EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned LC2MODE            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CLC2CONbits_t;

extern __at(0x0F1A) volatile __CLC2CONbits_t CLC2CONbits;

#define _CLC2CON_LC2MODE0       0x01
#define _CLC2CON_MODE0          0x01
#define _CLC2CON_LC2MODE1       0x02
#define _CLC2CON_MODE1          0x02
#define _CLC2CON_LC2MODE2       0x04
#define _CLC2CON_MODE2          0x04
#define _CLC2CON_LC2INTN        0x08
#define _CLC2CON_INTN           0x08
#define _CLC2CON_LC2INTP        0x10
#define _CLC2CON_INTP           0x10
#define _CLC2CON_LC2OUT         0x20
#define _CLC2CON_OUT            0x20
#define _CLC2CON_LC2EN          0x80
#define _CLC2CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC2POL Bits

extern __at(0x0F1B) __sfr CLC2POL;

typedef union
  {
  struct
    {
    unsigned LC2G1POL           : 1;
    unsigned LC2G2POL           : 1;
    unsigned LC2G3POL           : 1;
    unsigned LC2G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC2POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC2POLbits_t;

extern __at(0x0F1B) volatile __CLC2POLbits_t CLC2POLbits;

#define _CLC2POL_LC2G1POL       0x01
#define _CLC2POL_G1POL          0x01
#define _CLC2POL_LC2G2POL       0x02
#define _CLC2POL_G2POL          0x02
#define _CLC2POL_LC2G3POL       0x04
#define _CLC2POL_G3POL          0x04
#define _CLC2POL_LC2G4POL       0x08
#define _CLC2POL_G4POL          0x08
#define _CLC2POL_LC2POL         0x80
#define _CLC2POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC2SEL0 Bits

extern __at(0x0F1C) __sfr CLC2SEL0;

typedef union
  {
  struct
    {
    unsigned LC2D1S0            : 1;
    unsigned LC2D1S1            : 1;
    unsigned LC2D1S2            : 1;
    unsigned LC2D1S3            : 1;
    unsigned LC2D1S4            : 1;
    unsigned LC2D1S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC2D1S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D1S                : 6;
    unsigned                    : 2;
    };
  } __CLC2SEL0bits_t;

extern __at(0x0F1C) volatile __CLC2SEL0bits_t CLC2SEL0bits;

#define _CLC2SEL0_LC2D1S0       0x01
#define _CLC2SEL0_D1S0          0x01
#define _CLC2SEL0_LC2D1S1       0x02
#define _CLC2SEL0_D1S1          0x02
#define _CLC2SEL0_LC2D1S2       0x04
#define _CLC2SEL0_D1S2          0x04
#define _CLC2SEL0_LC2D1S3       0x08
#define _CLC2SEL0_D1S3          0x08
#define _CLC2SEL0_LC2D1S4       0x10
#define _CLC2SEL0_D1S4          0x10
#define _CLC2SEL0_LC2D1S5       0x20
#define _CLC2SEL0_D1S5          0x20

//==============================================================================


//==============================================================================
//        CLC2SEL1 Bits

extern __at(0x0F1D) __sfr CLC2SEL1;

typedef union
  {
  struct
    {
    unsigned LC2D2S0            : 1;
    unsigned LC2D2S1            : 1;
    unsigned LC2D2S2            : 1;
    unsigned LC2D2S3            : 1;
    unsigned LC2D2S4            : 1;
    unsigned LC2D2S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC2D2S             : 6;
    unsigned                    : 2;
    };
  } __CLC2SEL1bits_t;

extern __at(0x0F1D) volatile __CLC2SEL1bits_t CLC2SEL1bits;

#define _CLC2SEL1_LC2D2S0       0x01
#define _CLC2SEL1_D2S0          0x01
#define _CLC2SEL1_LC2D2S1       0x02
#define _CLC2SEL1_D2S1          0x02
#define _CLC2SEL1_LC2D2S2       0x04
#define _CLC2SEL1_D2S2          0x04
#define _CLC2SEL1_LC2D2S3       0x08
#define _CLC2SEL1_D2S3          0x08
#define _CLC2SEL1_LC2D2S4       0x10
#define _CLC2SEL1_D2S4          0x10
#define _CLC2SEL1_LC2D2S5       0x20
#define _CLC2SEL1_D2S5          0x20

//==============================================================================


//==============================================================================
//        CLC2SEL2 Bits

extern __at(0x0F1E) __sfr CLC2SEL2;

typedef union
  {
  struct
    {
    unsigned LC2D3S0            : 1;
    unsigned LC2D3S1            : 1;
    unsigned LC2D3S2            : 1;
    unsigned LC2D3S3            : 1;
    unsigned LC2D3S4            : 1;
    unsigned LC2D3S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC2D3S             : 6;
    unsigned                    : 2;
    };
  } __CLC2SEL2bits_t;

extern __at(0x0F1E) volatile __CLC2SEL2bits_t CLC2SEL2bits;

#define _CLC2SEL2_LC2D3S0       0x01
#define _CLC2SEL2_D3S0          0x01
#define _CLC2SEL2_LC2D3S1       0x02
#define _CLC2SEL2_D3S1          0x02
#define _CLC2SEL2_LC2D3S2       0x04
#define _CLC2SEL2_D3S2          0x04
#define _CLC2SEL2_LC2D3S3       0x08
#define _CLC2SEL2_D3S3          0x08
#define _CLC2SEL2_LC2D3S4       0x10
#define _CLC2SEL2_D3S4          0x10
#define _CLC2SEL2_LC2D3S5       0x20
#define _CLC2SEL2_D3S5          0x20

//==============================================================================


//==============================================================================
//        CLC2SEL3 Bits

extern __at(0x0F1F) __sfr CLC2SEL3;

typedef union
  {
  struct
    {
    unsigned LC2D4S0            : 1;
    unsigned LC2D4S1            : 1;
    unsigned LC2D4S2            : 1;
    unsigned LC2D4S3            : 1;
    unsigned LC2D4S4            : 1;
    unsigned LC2D4S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC2D4S             : 6;
    unsigned                    : 2;
    };
  } __CLC2SEL3bits_t;

extern __at(0x0F1F) volatile __CLC2SEL3bits_t CLC2SEL3bits;

#define _CLC2SEL3_LC2D4S0       0x01
#define _CLC2SEL3_D4S0          0x01
#define _CLC2SEL3_LC2D4S1       0x02
#define _CLC2SEL3_D4S1          0x02
#define _CLC2SEL3_LC2D4S2       0x04
#define _CLC2SEL3_D4S2          0x04
#define _CLC2SEL3_LC2D4S3       0x08
#define _CLC2SEL3_D4S3          0x08
#define _CLC2SEL3_LC2D4S4       0x10
#define _CLC2SEL3_D4S4          0x10
#define _CLC2SEL3_LC2D4S5       0x20
#define _CLC2SEL3_D4S5          0x20

//==============================================================================


//==============================================================================
//        CLC2GLS0 Bits

extern __at(0x0F20) __sfr CLC2GLS0;

typedef union
  {
  struct
    {
    unsigned LC2G1D1N           : 1;
    unsigned LC2G1D1T           : 1;
    unsigned LC2G1D2N           : 1;
    unsigned LC2G1D2T           : 1;
    unsigned LC2G1D3N           : 1;
    unsigned LC2G1D3T           : 1;
    unsigned LC2G1D4N           : 1;
    unsigned LC2G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS0bits_t;

extern __at(0x0F20) volatile __CLC2GLS0bits_t CLC2GLS0bits;

#define _CLC2GLS0_LC2G1D1N      0x01
#define _CLC2GLS0_D1N           0x01
#define _CLC2GLS0_LC2G1D1T      0x02
#define _CLC2GLS0_D1T           0x02
#define _CLC2GLS0_LC2G1D2N      0x04
#define _CLC2GLS0_D2N           0x04
#define _CLC2GLS0_LC2G1D2T      0x08
#define _CLC2GLS0_D2T           0x08
#define _CLC2GLS0_LC2G1D3N      0x10
#define _CLC2GLS0_D3N           0x10
#define _CLC2GLS0_LC2G1D3T      0x20
#define _CLC2GLS0_D3T           0x20
#define _CLC2GLS0_LC2G1D4N      0x40
#define _CLC2GLS0_D4N           0x40
#define _CLC2GLS0_LC2G1D4T      0x80
#define _CLC2GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS1 Bits

extern __at(0x0F21) __sfr CLC2GLS1;

typedef union
  {
  struct
    {
    unsigned LC2G2D1N           : 1;
    unsigned LC2G2D1T           : 1;
    unsigned LC2G2D2N           : 1;
    unsigned LC2G2D2T           : 1;
    unsigned LC2G2D3N           : 1;
    unsigned LC2G2D3T           : 1;
    unsigned LC2G2D4N           : 1;
    unsigned LC2G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS1bits_t;

extern __at(0x0F21) volatile __CLC2GLS1bits_t CLC2GLS1bits;

#define _CLC2GLS1_LC2G2D1N      0x01
#define _CLC2GLS1_D1N           0x01
#define _CLC2GLS1_LC2G2D1T      0x02
#define _CLC2GLS1_D1T           0x02
#define _CLC2GLS1_LC2G2D2N      0x04
#define _CLC2GLS1_D2N           0x04
#define _CLC2GLS1_LC2G2D2T      0x08
#define _CLC2GLS1_D2T           0x08
#define _CLC2GLS1_LC2G2D3N      0x10
#define _CLC2GLS1_D3N           0x10
#define _CLC2GLS1_LC2G2D3T      0x20
#define _CLC2GLS1_D3T           0x20
#define _CLC2GLS1_LC2G2D4N      0x40
#define _CLC2GLS1_D4N           0x40
#define _CLC2GLS1_LC2G2D4T      0x80
#define _CLC2GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS2 Bits

extern __at(0x0F22) __sfr CLC2GLS2;

typedef union
  {
  struct
    {
    unsigned LC2G3D1N           : 1;
    unsigned LC2G3D1T           : 1;
    unsigned LC2G3D2N           : 1;
    unsigned LC2G3D2T           : 1;
    unsigned LC2G3D3N           : 1;
    unsigned LC2G3D3T           : 1;
    unsigned LC2G3D4N           : 1;
    unsigned LC2G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS2bits_t;

extern __at(0x0F22) volatile __CLC2GLS2bits_t CLC2GLS2bits;

#define _CLC2GLS2_LC2G3D1N      0x01
#define _CLC2GLS2_D1N           0x01
#define _CLC2GLS2_LC2G3D1T      0x02
#define _CLC2GLS2_D1T           0x02
#define _CLC2GLS2_LC2G3D2N      0x04
#define _CLC2GLS2_D2N           0x04
#define _CLC2GLS2_LC2G3D2T      0x08
#define _CLC2GLS2_D2T           0x08
#define _CLC2GLS2_LC2G3D3N      0x10
#define _CLC2GLS2_D3N           0x10
#define _CLC2GLS2_LC2G3D3T      0x20
#define _CLC2GLS2_D3T           0x20
#define _CLC2GLS2_LC2G3D4N      0x40
#define _CLC2GLS2_D4N           0x40
#define _CLC2GLS2_LC2G3D4T      0x80
#define _CLC2GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS3 Bits

extern __at(0x0F23) __sfr CLC2GLS3;

typedef union
  {
  struct
    {
    unsigned LC2G4D1N           : 1;
    unsigned LC2G4D1T           : 1;
    unsigned LC2G4D2N           : 1;
    unsigned LC2G4D2T           : 1;
    unsigned LC2G4D3N           : 1;
    unsigned LC2G4D3T           : 1;
    unsigned LC2G4D4N           : 1;
    unsigned LC2G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC2GLS3bits_t;

extern __at(0x0F23) volatile __CLC2GLS3bits_t CLC2GLS3bits;

#define _CLC2GLS3_LC2G4D1N      0x01
#define _CLC2GLS3_G4D1N         0x01
#define _CLC2GLS3_LC2G4D1T      0x02
#define _CLC2GLS3_G4D1T         0x02
#define _CLC2GLS3_LC2G4D2N      0x04
#define _CLC2GLS3_G4D2N         0x04
#define _CLC2GLS3_LC2G4D2T      0x08
#define _CLC2GLS3_G4D2T         0x08
#define _CLC2GLS3_LC2G4D3N      0x10
#define _CLC2GLS3_G4D3N         0x10
#define _CLC2GLS3_LC2G4D3T      0x20
#define _CLC2GLS3_G4D3T         0x20
#define _CLC2GLS3_LC2G4D4N      0x40
#define _CLC2GLS3_G4D4N         0x40
#define _CLC2GLS3_LC2G4D4T      0x80
#define _CLC2GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        CLC3CON Bits

extern __at(0x0F24) __sfr CLC3CON;

typedef union
  {
  struct
    {
    unsigned LC3MODE0           : 1;
    unsigned LC3MODE1           : 1;
    unsigned LC3MODE2           : 1;
    unsigned LC3INTN            : 1;
    unsigned LC3INTP            : 1;
    unsigned LC3OUT             : 1;
    unsigned                    : 1;
    unsigned LC3EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC3MODE            : 3;
    unsigned                    : 5;
    };
  } __CLC3CONbits_t;

extern __at(0x0F24) volatile __CLC3CONbits_t CLC3CONbits;

#define _CLC3CON_LC3MODE0       0x01
#define _CLC3CON_MODE0          0x01
#define _CLC3CON_LC3MODE1       0x02
#define _CLC3CON_MODE1          0x02
#define _CLC3CON_LC3MODE2       0x04
#define _CLC3CON_MODE2          0x04
#define _CLC3CON_LC3INTN        0x08
#define _CLC3CON_INTN           0x08
#define _CLC3CON_LC3INTP        0x10
#define _CLC3CON_INTP           0x10
#define _CLC3CON_LC3OUT         0x20
#define _CLC3CON_OUT            0x20
#define _CLC3CON_LC3EN          0x80
#define _CLC3CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC3POL Bits

extern __at(0x0F25) __sfr CLC3POL;

typedef union
  {
  struct
    {
    unsigned LC3G1POL           : 1;
    unsigned LC3G2POL           : 1;
    unsigned LC3G3POL           : 1;
    unsigned LC3G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC3POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC3POLbits_t;

extern __at(0x0F25) volatile __CLC3POLbits_t CLC3POLbits;

#define _CLC3POL_LC3G1POL       0x01
#define _CLC3POL_G1POL          0x01
#define _CLC3POL_LC3G2POL       0x02
#define _CLC3POL_G2POL          0x02
#define _CLC3POL_LC3G3POL       0x04
#define _CLC3POL_G3POL          0x04
#define _CLC3POL_LC3G4POL       0x08
#define _CLC3POL_G4POL          0x08
#define _CLC3POL_LC3POL         0x80
#define _CLC3POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC3SEL0 Bits

extern __at(0x0F26) __sfr CLC3SEL0;

typedef union
  {
  struct
    {
    unsigned LC3D1S0            : 1;
    unsigned LC3D1S1            : 1;
    unsigned LC3D1S2            : 1;
    unsigned LC3D1S3            : 1;
    unsigned LC3D1S4            : 1;
    unsigned LC3D1S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC3D1S             : 6;
    unsigned                    : 2;
    };
  } __CLC3SEL0bits_t;

extern __at(0x0F26) volatile __CLC3SEL0bits_t CLC3SEL0bits;

#define _CLC3SEL0_LC3D1S0       0x01
#define _CLC3SEL0_D1S0          0x01
#define _CLC3SEL0_LC3D1S1       0x02
#define _CLC3SEL0_D1S1          0x02
#define _CLC3SEL0_LC3D1S2       0x04
#define _CLC3SEL0_D1S2          0x04
#define _CLC3SEL0_LC3D1S3       0x08
#define _CLC3SEL0_D1S3          0x08
#define _CLC3SEL0_LC3D1S4       0x10
#define _CLC3SEL0_D1S4          0x10
#define _CLC3SEL0_LC3D1S5       0x20
#define _CLC3SEL0_D1S5          0x20

//==============================================================================


//==============================================================================
//        CLC3SEL1 Bits

extern __at(0x0F27) __sfr CLC3SEL1;

typedef union
  {
  struct
    {
    unsigned LC3D2S0            : 1;
    unsigned LC3D2S1            : 1;
    unsigned LC3D2S2            : 1;
    unsigned LC3D2S3            : 1;
    unsigned LC3D2S4            : 1;
    unsigned LC3D2S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC3D2S             : 6;
    unsigned                    : 2;
    };
  } __CLC3SEL1bits_t;

extern __at(0x0F27) volatile __CLC3SEL1bits_t CLC3SEL1bits;

#define _CLC3SEL1_LC3D2S0       0x01
#define _CLC3SEL1_D2S0          0x01
#define _CLC3SEL1_LC3D2S1       0x02
#define _CLC3SEL1_D2S1          0x02
#define _CLC3SEL1_LC3D2S2       0x04
#define _CLC3SEL1_D2S2          0x04
#define _CLC3SEL1_LC3D2S3       0x08
#define _CLC3SEL1_D2S3          0x08
#define _CLC3SEL1_LC3D2S4       0x10
#define _CLC3SEL1_D2S4          0x10
#define _CLC3SEL1_LC3D2S5       0x20
#define _CLC3SEL1_D2S5          0x20

//==============================================================================


//==============================================================================
//        CLC3SEL2 Bits

extern __at(0x0F28) __sfr CLC3SEL2;

typedef union
  {
  struct
    {
    unsigned LC3D3S0            : 1;
    unsigned LC3D3S1            : 1;
    unsigned LC3D3S2            : 1;
    unsigned LC3D3S3            : 1;
    unsigned LC3D3S4            : 1;
    unsigned LC3D3S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC3D3S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D3S                : 6;
    unsigned                    : 2;
    };
  } __CLC3SEL2bits_t;

extern __at(0x0F28) volatile __CLC3SEL2bits_t CLC3SEL2bits;

#define _CLC3SEL2_LC3D3S0       0x01
#define _CLC3SEL2_D3S0          0x01
#define _CLC3SEL2_LC3D3S1       0x02
#define _CLC3SEL2_D3S1          0x02
#define _CLC3SEL2_LC3D3S2       0x04
#define _CLC3SEL2_D3S2          0x04
#define _CLC3SEL2_LC3D3S3       0x08
#define _CLC3SEL2_D3S3          0x08
#define _CLC3SEL2_LC3D3S4       0x10
#define _CLC3SEL2_D3S4          0x10
#define _CLC3SEL2_LC3D3S5       0x20
#define _CLC3SEL2_D3S5          0x20

//==============================================================================


//==============================================================================
//        CLC3SEL3 Bits

extern __at(0x0F29) __sfr CLC3SEL3;

typedef union
  {
  struct
    {
    unsigned LC3D4S0            : 1;
    unsigned LC3D4S1            : 1;
    unsigned LC3D4S2            : 1;
    unsigned LC3D4S3            : 1;
    unsigned LC3D4S4            : 1;
    unsigned LC3D4S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC3D4S             : 6;
    unsigned                    : 2;
    };
  } __CLC3SEL3bits_t;

extern __at(0x0F29) volatile __CLC3SEL3bits_t CLC3SEL3bits;

#define _CLC3SEL3_LC3D4S0       0x01
#define _CLC3SEL3_D4S0          0x01
#define _CLC3SEL3_LC3D4S1       0x02
#define _CLC3SEL3_D4S1          0x02
#define _CLC3SEL3_LC3D4S2       0x04
#define _CLC3SEL3_D4S2          0x04
#define _CLC3SEL3_LC3D4S3       0x08
#define _CLC3SEL3_D4S3          0x08
#define _CLC3SEL3_LC3D4S4       0x10
#define _CLC3SEL3_D4S4          0x10
#define _CLC3SEL3_LC3D4S5       0x20
#define _CLC3SEL3_D4S5          0x20

//==============================================================================


//==============================================================================
//        CLC3GLS0 Bits

extern __at(0x0F2A) __sfr CLC3GLS0;

typedef union
  {
  struct
    {
    unsigned LC3G1D1N           : 1;
    unsigned LC3G1D1T           : 1;
    unsigned LC3G1D2N           : 1;
    unsigned LC3G1D2T           : 1;
    unsigned LC3G1D3N           : 1;
    unsigned LC3G1D3T           : 1;
    unsigned LC3G1D4N           : 1;
    unsigned LC3G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS0bits_t;

extern __at(0x0F2A) volatile __CLC3GLS0bits_t CLC3GLS0bits;

#define _CLC3GLS0_LC3G1D1N      0x01
#define _CLC3GLS0_D1N           0x01
#define _CLC3GLS0_LC3G1D1T      0x02
#define _CLC3GLS0_D1T           0x02
#define _CLC3GLS0_LC3G1D2N      0x04
#define _CLC3GLS0_D2N           0x04
#define _CLC3GLS0_LC3G1D2T      0x08
#define _CLC3GLS0_D2T           0x08
#define _CLC3GLS0_LC3G1D3N      0x10
#define _CLC3GLS0_D3N           0x10
#define _CLC3GLS0_LC3G1D3T      0x20
#define _CLC3GLS0_D3T           0x20
#define _CLC3GLS0_LC3G1D4N      0x40
#define _CLC3GLS0_D4N           0x40
#define _CLC3GLS0_LC3G1D4T      0x80
#define _CLC3GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS1 Bits

extern __at(0x0F2B) __sfr CLC3GLS1;

typedef union
  {
  struct
    {
    unsigned LC3G2D1N           : 1;
    unsigned LC3G2D1T           : 1;
    unsigned LC3G2D2N           : 1;
    unsigned LC3G2D2T           : 1;
    unsigned LC3G2D3N           : 1;
    unsigned LC3G2D3T           : 1;
    unsigned LC3G2D4N           : 1;
    unsigned LC3G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS1bits_t;

extern __at(0x0F2B) volatile __CLC3GLS1bits_t CLC3GLS1bits;

#define _CLC3GLS1_LC3G2D1N      0x01
#define _CLC3GLS1_D1N           0x01
#define _CLC3GLS1_LC3G2D1T      0x02
#define _CLC3GLS1_D1T           0x02
#define _CLC3GLS1_LC3G2D2N      0x04
#define _CLC3GLS1_D2N           0x04
#define _CLC3GLS1_LC3G2D2T      0x08
#define _CLC3GLS1_D2T           0x08
#define _CLC3GLS1_LC3G2D3N      0x10
#define _CLC3GLS1_D3N           0x10
#define _CLC3GLS1_LC3G2D3T      0x20
#define _CLC3GLS1_D3T           0x20
#define _CLC3GLS1_LC3G2D4N      0x40
#define _CLC3GLS1_D4N           0x40
#define _CLC3GLS1_LC3G2D4T      0x80
#define _CLC3GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS2 Bits

extern __at(0x0F2C) __sfr CLC3GLS2;

typedef union
  {
  struct
    {
    unsigned LC3G3D1N           : 1;
    unsigned LC3G3D1T           : 1;
    unsigned LC3G3D2N           : 1;
    unsigned LC3G3D2T           : 1;
    unsigned LC3G3D3N           : 1;
    unsigned LC3G3D3T           : 1;
    unsigned LC3G3D4N           : 1;
    unsigned LC3G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS2bits_t;

extern __at(0x0F2C) volatile __CLC3GLS2bits_t CLC3GLS2bits;

#define _CLC3GLS2_LC3G3D1N      0x01
#define _CLC3GLS2_D1N           0x01
#define _CLC3GLS2_LC3G3D1T      0x02
#define _CLC3GLS2_D1T           0x02
#define _CLC3GLS2_LC3G3D2N      0x04
#define _CLC3GLS2_D2N           0x04
#define _CLC3GLS2_LC3G3D2T      0x08
#define _CLC3GLS2_D2T           0x08
#define _CLC3GLS2_LC3G3D3N      0x10
#define _CLC3GLS2_D3N           0x10
#define _CLC3GLS2_LC3G3D3T      0x20
#define _CLC3GLS2_D3T           0x20
#define _CLC3GLS2_LC3G3D4N      0x40
#define _CLC3GLS2_D4N           0x40
#define _CLC3GLS2_LC3G3D4T      0x80
#define _CLC3GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS3 Bits

extern __at(0x0F2D) __sfr CLC3GLS3;

typedef union
  {
  struct
    {
    unsigned LC3G4D1N           : 1;
    unsigned LC3G4D1T           : 1;
    unsigned LC3G4D2N           : 1;
    unsigned LC3G4D2T           : 1;
    unsigned LC3G4D3N           : 1;
    unsigned LC3G4D3T           : 1;
    unsigned LC3G4D4N           : 1;
    unsigned LC3G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC3GLS3bits_t;

extern __at(0x0F2D) volatile __CLC3GLS3bits_t CLC3GLS3bits;

#define _CLC3GLS3_LC3G4D1N      0x01
#define _CLC3GLS3_G4D1N         0x01
#define _CLC3GLS3_LC3G4D1T      0x02
#define _CLC3GLS3_G4D1T         0x02
#define _CLC3GLS3_LC3G4D2N      0x04
#define _CLC3GLS3_G4D2N         0x04
#define _CLC3GLS3_LC3G4D2T      0x08
#define _CLC3GLS3_G4D2T         0x08
#define _CLC3GLS3_LC3G4D3N      0x10
#define _CLC3GLS3_G4D3N         0x10
#define _CLC3GLS3_LC3G4D3T      0x20
#define _CLC3GLS3_G4D3T         0x20
#define _CLC3GLS3_LC3G4D4N      0x40
#define _CLC3GLS3_G4D4N         0x40
#define _CLC3GLS3_LC3G4D4T      0x80
#define _CLC3GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        CLC4CON Bits

extern __at(0x0F2E) __sfr CLC4CON;

typedef union
  {
  struct
    {
    unsigned LC4MODE0           : 1;
    unsigned LC4MODE1           : 1;
    unsigned LC4MODE2           : 1;
    unsigned LC4INTN            : 1;
    unsigned LC4INTP            : 1;
    unsigned LC4OUT             : 1;
    unsigned                    : 1;
    unsigned LC4EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned LC4MODE            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CLC4CONbits_t;

extern __at(0x0F2E) volatile __CLC4CONbits_t CLC4CONbits;

#define _CLC4CON_LC4MODE0       0x01
#define _CLC4CON_MODE0          0x01
#define _CLC4CON_LC4MODE1       0x02
#define _CLC4CON_MODE1          0x02
#define _CLC4CON_LC4MODE2       0x04
#define _CLC4CON_MODE2          0x04
#define _CLC4CON_LC4INTN        0x08
#define _CLC4CON_INTN           0x08
#define _CLC4CON_LC4INTP        0x10
#define _CLC4CON_INTP           0x10
#define _CLC4CON_LC4OUT         0x20
#define _CLC4CON_OUT            0x20
#define _CLC4CON_LC4EN          0x80
#define _CLC4CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC4POL Bits

extern __at(0x0F2F) __sfr CLC4POL;

typedef union
  {
  struct
    {
    unsigned LC4G1POL           : 1;
    unsigned LC4G2POL           : 1;
    unsigned LC4G3POL           : 1;
    unsigned LC4G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC4POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC4POLbits_t;

extern __at(0x0F2F) volatile __CLC4POLbits_t CLC4POLbits;

#define _CLC4POL_LC4G1POL       0x01
#define _CLC4POL_G1POL          0x01
#define _CLC4POL_LC4G2POL       0x02
#define _CLC4POL_G2POL          0x02
#define _CLC4POL_LC4G3POL       0x04
#define _CLC4POL_G3POL          0x04
#define _CLC4POL_LC4G4POL       0x08
#define _CLC4POL_G4POL          0x08
#define _CLC4POL_LC4POL         0x80
#define _CLC4POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC4SEL0 Bits

extern __at(0x0F30) __sfr CLC4SEL0;

typedef union
  {
  struct
    {
    unsigned LC4D1S0            : 1;
    unsigned LC4D1S1            : 1;
    unsigned LC4D1S2            : 1;
    unsigned LC4D1S3            : 1;
    unsigned LC4D1S4            : 1;
    unsigned LC4D1S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC4D1S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D1S                : 6;
    unsigned                    : 2;
    };
  } __CLC4SEL0bits_t;

extern __at(0x0F30) volatile __CLC4SEL0bits_t CLC4SEL0bits;

#define _CLC4SEL0_LC4D1S0       0x01
#define _CLC4SEL0_D1S0          0x01
#define _CLC4SEL0_LC4D1S1       0x02
#define _CLC4SEL0_D1S1          0x02
#define _CLC4SEL0_LC4D1S2       0x04
#define _CLC4SEL0_D1S2          0x04
#define _CLC4SEL0_LC4D1S3       0x08
#define _CLC4SEL0_D1S3          0x08
#define _CLC4SEL0_LC4D1S4       0x10
#define _CLC4SEL0_D1S4          0x10
#define _CLC4SEL0_LC4D1S5       0x20
#define _CLC4SEL0_D1S5          0x20

//==============================================================================


//==============================================================================
//        CLC4SEL1 Bits

extern __at(0x0F31) __sfr CLC4SEL1;

typedef union
  {
  struct
    {
    unsigned LC4D2S0            : 1;
    unsigned LC4D2S1            : 1;
    unsigned LC4D2S2            : 1;
    unsigned LC4D2S3            : 1;
    unsigned LC4D2S4            : 1;
    unsigned LC4D2S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC4D2S             : 6;
    unsigned                    : 2;
    };
  } __CLC4SEL1bits_t;

extern __at(0x0F31) volatile __CLC4SEL1bits_t CLC4SEL1bits;

#define _CLC4SEL1_LC4D2S0       0x01
#define _CLC4SEL1_D2S0          0x01
#define _CLC4SEL1_LC4D2S1       0x02
#define _CLC4SEL1_D2S1          0x02
#define _CLC4SEL1_LC4D2S2       0x04
#define _CLC4SEL1_D2S2          0x04
#define _CLC4SEL1_LC4D2S3       0x08
#define _CLC4SEL1_D2S3          0x08
#define _CLC4SEL1_LC4D2S4       0x10
#define _CLC4SEL1_D2S4          0x10
#define _CLC4SEL1_LC4D2S5       0x20
#define _CLC4SEL1_D2S5          0x20

//==============================================================================


//==============================================================================
//        CLC4SEL2 Bits

extern __at(0x0F32) __sfr CLC4SEL2;

typedef union
  {
  struct
    {
    unsigned LC4D3S0            : 1;
    unsigned LC4D3S1            : 1;
    unsigned LC4D3S2            : 1;
    unsigned LC4D3S3            : 1;
    unsigned LC4D3S4            : 1;
    unsigned LC4D3S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC4D3S             : 6;
    unsigned                    : 2;
    };
  } __CLC4SEL2bits_t;

extern __at(0x0F32) volatile __CLC4SEL2bits_t CLC4SEL2bits;

#define _CLC4SEL2_LC4D3S0       0x01
#define _CLC4SEL2_D3S0          0x01
#define _CLC4SEL2_LC4D3S1       0x02
#define _CLC4SEL2_D3S1          0x02
#define _CLC4SEL2_LC4D3S2       0x04
#define _CLC4SEL2_D3S2          0x04
#define _CLC4SEL2_LC4D3S3       0x08
#define _CLC4SEL2_D3S3          0x08
#define _CLC4SEL2_LC4D3S4       0x10
#define _CLC4SEL2_D3S4          0x10
#define _CLC4SEL2_LC4D3S5       0x20
#define _CLC4SEL2_D3S5          0x20

//==============================================================================


//==============================================================================
//        CLC4SEL3 Bits

extern __at(0x0F33) __sfr CLC4SEL3;

typedef union
  {
  struct
    {
    unsigned LC4D4S0            : 1;
    unsigned LC4D4S1            : 1;
    unsigned LC4D4S2            : 1;
    unsigned LC4D4S3            : 1;
    unsigned LC4D4S4            : 1;
    unsigned LC4D4S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC4D4S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D4S                : 6;
    unsigned                    : 2;
    };
  } __CLC4SEL3bits_t;

extern __at(0x0F33) volatile __CLC4SEL3bits_t CLC4SEL3bits;

#define _CLC4SEL3_LC4D4S0       0x01
#define _CLC4SEL3_D4S0          0x01
#define _CLC4SEL3_LC4D4S1       0x02
#define _CLC4SEL3_D4S1          0x02
#define _CLC4SEL3_LC4D4S2       0x04
#define _CLC4SEL3_D4S2          0x04
#define _CLC4SEL3_LC4D4S3       0x08
#define _CLC4SEL3_D4S3          0x08
#define _CLC4SEL3_LC4D4S4       0x10
#define _CLC4SEL3_D4S4          0x10
#define _CLC4SEL3_LC4D4S5       0x20
#define _CLC4SEL3_D4S5          0x20

//==============================================================================


//==============================================================================
//        CLC4GLS0 Bits

extern __at(0x0F34) __sfr CLC4GLS0;

typedef union
  {
  struct
    {
    unsigned LC4G1D1N           : 1;
    unsigned LC4G1D1T           : 1;
    unsigned LC4G1D2N           : 1;
    unsigned LC4G1D2T           : 1;
    unsigned LC4G1D3N           : 1;
    unsigned LC4G1D3T           : 1;
    unsigned LC4G1D4N           : 1;
    unsigned LC4G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS0bits_t;

extern __at(0x0F34) volatile __CLC4GLS0bits_t CLC4GLS0bits;

#define _CLC4GLS0_LC4G1D1N      0x01
#define _CLC4GLS0_D1N           0x01
#define _CLC4GLS0_LC4G1D1T      0x02
#define _CLC4GLS0_D1T           0x02
#define _CLC4GLS0_LC4G1D2N      0x04
#define _CLC4GLS0_D2N           0x04
#define _CLC4GLS0_LC4G1D2T      0x08
#define _CLC4GLS0_D2T           0x08
#define _CLC4GLS0_LC4G1D3N      0x10
#define _CLC4GLS0_D3N           0x10
#define _CLC4GLS0_LC4G1D3T      0x20
#define _CLC4GLS0_D3T           0x20
#define _CLC4GLS0_LC4G1D4N      0x40
#define _CLC4GLS0_D4N           0x40
#define _CLC4GLS0_LC4G1D4T      0x80
#define _CLC4GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS1 Bits

extern __at(0x0F35) __sfr CLC4GLS1;

typedef union
  {
  struct
    {
    unsigned LC4G2D1N           : 1;
    unsigned LC4G2D1T           : 1;
    unsigned LC4G2D2N           : 1;
    unsigned LC4G2D2T           : 1;
    unsigned LC4G2D3N           : 1;
    unsigned LC4G2D3T           : 1;
    unsigned LC4G2D4N           : 1;
    unsigned LC4G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS1bits_t;

extern __at(0x0F35) volatile __CLC4GLS1bits_t CLC4GLS1bits;

#define _CLC4GLS1_LC4G2D1N      0x01
#define _CLC4GLS1_D1N           0x01
#define _CLC4GLS1_LC4G2D1T      0x02
#define _CLC4GLS1_D1T           0x02
#define _CLC4GLS1_LC4G2D2N      0x04
#define _CLC4GLS1_D2N           0x04
#define _CLC4GLS1_LC4G2D2T      0x08
#define _CLC4GLS1_D2T           0x08
#define _CLC4GLS1_LC4G2D3N      0x10
#define _CLC4GLS1_D3N           0x10
#define _CLC4GLS1_LC4G2D3T      0x20
#define _CLC4GLS1_D3T           0x20
#define _CLC4GLS1_LC4G2D4N      0x40
#define _CLC4GLS1_D4N           0x40
#define _CLC4GLS1_LC4G2D4T      0x80
#define _CLC4GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS2 Bits

extern __at(0x0F36) __sfr CLC4GLS2;

typedef union
  {
  struct
    {
    unsigned LC4G3D1N           : 1;
    unsigned LC4G3D1T           : 1;
    unsigned LC4G3D2N           : 1;
    unsigned LC4G3D2T           : 1;
    unsigned LC4G3D3N           : 1;
    unsigned LC4G3D3T           : 1;
    unsigned LC4G3D4N           : 1;
    unsigned LC4G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS2bits_t;

extern __at(0x0F36) volatile __CLC4GLS2bits_t CLC4GLS2bits;

#define _CLC4GLS2_LC4G3D1N      0x01
#define _CLC4GLS2_D1N           0x01
#define _CLC4GLS2_LC4G3D1T      0x02
#define _CLC4GLS2_D1T           0x02
#define _CLC4GLS2_LC4G3D2N      0x04
#define _CLC4GLS2_D2N           0x04
#define _CLC4GLS2_LC4G3D2T      0x08
#define _CLC4GLS2_D2T           0x08
#define _CLC4GLS2_LC4G3D3N      0x10
#define _CLC4GLS2_D3N           0x10
#define _CLC4GLS2_LC4G3D3T      0x20
#define _CLC4GLS2_D3T           0x20
#define _CLC4GLS2_LC4G3D4N      0x40
#define _CLC4GLS2_D4N           0x40
#define _CLC4GLS2_LC4G3D4T      0x80
#define _CLC4GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS3 Bits

extern __at(0x0F37) __sfr CLC4GLS3;

typedef union
  {
  struct
    {
    unsigned LC4G4D1N           : 1;
    unsigned LC4G4D1T           : 1;
    unsigned LC4G4D2N           : 1;
    unsigned LC4G4D2T           : 1;
    unsigned LC4G4D3N           : 1;
    unsigned LC4G4D3T           : 1;
    unsigned LC4G4D4N           : 1;
    unsigned LC4G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC4GLS3bits_t;

extern __at(0x0F37) volatile __CLC4GLS3bits_t CLC4GLS3bits;

#define _CLC4GLS3_LC4G4D1N      0x01
#define _CLC4GLS3_G4D1N         0x01
#define _CLC4GLS3_LC4G4D1T      0x02
#define _CLC4GLS3_G4D1T         0x02
#define _CLC4GLS3_LC4G4D2N      0x04
#define _CLC4GLS3_G4D2N         0x04
#define _CLC4GLS3_LC4G4D2T      0x08
#define _CLC4GLS3_G4D2T         0x08
#define _CLC4GLS3_LC4G4D3N      0x10
#define _CLC4GLS3_G4D3N         0x10
#define _CLC4GLS3_LC4G4D3T      0x20
#define _CLC4GLS3_G4D3T         0x20
#define _CLC4GLS3_LC4G4D4N      0x40
#define _CLC4GLS3_G4D4N         0x40
#define _CLC4GLS3_LC4G4D4T      0x80
#define _CLC4GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008
#define _CONFIG3                0x8009
#define _CONFIG4                0x800A

//----------------------------- CONFIG1 Options -------------------------------

#define _FEXTOSC_LP             0x3FF8  // LP (crystal oscillator) optimized for 32.768 kHz.
#define _FEXTOSC_XT             0x3FF9  // XT (crystal oscillator) from 100 kHz to 4 MHz.
#define _FEXTOSC_HS             0x3FFA  // HS (crystal oscillator) above 4 MHz.
#define _FEXTOSC_OFF            0x3FFC  // Oscillator not enabled.
#define _FEXTOSC_ECL            0x3FFD  // EC (external clock) below 100 kHz.
#define _FEXTOSC_ECM            0x3FFE  // EC (external clock) for 100 kHz to 8 MHz.
#define _FEXTOSC_ECH            0x3FFF  // EC (external clock) above 8 MHz.
#define _RSTOSC_HFINT32         0x3F8F  // HFINTOSC with 2x PLL (32MHz).
#define _RSTOSC_EXT4X           0x3F9F  // EXTOSC with 4x PLL, with EXTOSC operating per FEXTOSC bits.
#define _RSTOSC_SOSC            0x3FBF  // SOSC (31kHz).
#define _RSTOSC_LFINT           0x3FCF  // LFINTOSC (31kHz).
#define _RSTOSC_HFINT1          0x3FEF  // HFINTOSC (1MHz).
#define _RSTOSC_EXT1X           0x3FFF  // EXTOSC operating per FEXTOSC bits.
#define _CLKOUTEN_ON            0x3EFF  // CLKOUT function is enabled; FOSC/4 clock appears at OSC2.
#define _CLKOUTEN_OFF           0x3FFF  // CLKOUT function is disabled; I/O or oscillator function on OSC2.
#define _CSWEN_OFF              0x37FF  // The NOSC and NDIV bits cannot be changed by user software.
#define _CSWEN_ON               0x3FFF  // Writing to NOSC and NDIV is allowed.
#define _FCMEN_OFF              0x1FFF  // Fail-Safe Clock Monitor is disabled.
#define _FCMEN_ON               0x3FFF  // Fail-Safe Clock Monitor is enabled.

//----------------------------- CONFIG2 Options -------------------------------

#define _MCLRE_OFF              0x3FFE  // MCLR/VPP pin function is digital input; MCLR internally disabled; Weak pull-up under control of port pin's WPU control bit.
#define _MCLRE_ON               0x3FFF  // MCLR/VPP pin function is MCLR; Weak pull-up enabled.
#define _PWRTE_ON               0x3FFD  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _WDTE_OFF               0x3FF3  // WDT disabled; SWDTEN is ignored.
#define _WDTE_SWDTEN            0x3FF7  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_SLEEP             0x3FFB  // WDT enabled while running and disabled in SLEEP/IDLE; SWDTEN is ignored.
#define _WDTE_ON                0x3FFF  // WDT enabled, SWDTEN is ignored.
#define _LPBOREN_ON             0x3FDF  // ULPBOR enabled.
#define _LPBOREN_OFF            0x3FFF  // ULPBOR disabled.
#define _BOREN_OFF              0x3F3F  // Brown-out Reset disabled.
#define _BOREN_SBOREN           0x3F7F  // Brown-out Reset enabled according to SBOREN.
#define _BOREN_SLEEP            0x3FBF  // Brown-out Reset enabled while running, disabled in Sleep; SBOREN is ignored.
#define _BOREN_ON               0x3FFF  // Brown-out Reset enabled, SBOREN bit ignored.
#define _BORV_HIGH              0x3DFF  // Brown-out voltage (Vbor) set to 2.7V.
#define _BORV_LOW               0x3FFF  // Brown-out voltage (Vbor) set to 2.45V.
#define _PPS1WAY_OFF            0x37FF  // The PPSLOCK bit can be set and cleared repeatedly (subject to the unlock sequence).
#define _PPS1WAY_ON             0x3FFF  // The PPSLOCK bit can be cleared and set only once; PPS registers remain locked after one clear/set cycle.
#define _STVREN_OFF             0x2FFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0x3FFF  // Stack Overflow or Underflow will cause a Reset.
#define _DEBUG_ON               0x1FFF  // Background debugger enabled.
#define _DEBUG_OFF              0x3FFF  // Background debugger disabled.

//----------------------------- CONFIG3 Options -------------------------------

#define _WRT_ALL                0x3FFC  // 0000h to 1FFFh write protected, no addresses may be modified.
#define _WRT_HALF               0x3FFD  // 0000h to 03FFh write-protected, 0400h to 1FFFh may be modified.
#define _WRT_BOOT               0x3FFE  // 0000h to 01FFh write-protected, 0200h to 1FFFh may be modified.
#define _WRT_OFF                0x3FFF  // Write protection off.
#define _LVP_OFF                0x1FFF  // High Voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0x3FFF  // Low Voltage programming enabled. MCLR/VPP pin function is MCLR. MCLRE configuration bit is ignored.

//----------------------------- CONFIG4 Options -------------------------------

#define _CP_ON                  0x3FFE  // User NVM code protection enabled.
#define _CP_OFF                 0x3FFF  // User NVM code protection disabled.
#define _CPD_ON                 0x3FFD  // Data NVM code protection enabled.
#define _CPD_OFF                0x3FFF  // Data NVM code protection disabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADACT0                  ADACTbits.ADACT0                // bit 0
#define ADACT1                  ADACTbits.ADACT1                // bit 1
#define ADACT2                  ADACTbits.ADACT2                // bit 2
#define ADACT3                  ADACTbits.ADACT3                // bit 3
#define ADACT4                  ADACTbits.ADACT4                // bit 4

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define ADGO                    ADCON0bits.ADGO                 // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define CHS4                    ADCON0bits.CHS4                 // bit 6
#define CHS5                    ADCON0bits.CHS5                 // bit 7

#define ADPREF0                 ADCON1bits.ADPREF0              // bit 0
#define ADPREF1                 ADCON1bits.ADPREF1              // bit 1
#define ADNREF                  ADCON1bits.ADNREF               // bit 2
#define ADCS0                   ADCON1bits.ADCS0                // bit 4
#define ADCS1                   ADCON1bits.ADCS1                // bit 5
#define ADCS2                   ADCON1bits.ADCS2                // bit 6
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA4                   ANSELAbits.ANSA4                // bit 4
#define ANSA5                   ANSELAbits.ANSA5                // bit 5

#define ANSB4                   ANSELBbits.ANSB4                // bit 4
#define ANSB5                   ANSELBbits.ANSB5                // bit 5
#define ANSB6                   ANSELBbits.ANSB6                // bit 6
#define ANSB7                   ANSELBbits.ANSB7                // bit 7

#define ANSC0                   ANSELCbits.ANSC0                // bit 0
#define ANSC1                   ANSELCbits.ANSC1                // bit 1
#define ANSC2                   ANSELCbits.ANSC2                // bit 2
#define ANSC3                   ANSELCbits.ANSC3                // bit 3
#define ANSC4                   ANSELCbits.ANSC4                // bit 4
#define ANSC5                   ANSELCbits.ANSC5                // bit 5
#define ANSC6                   ANSELCbits.ANSC6                // bit 6
#define ANSC7                   ANSELCbits.ANSC7                // bit 7

#define ABDEN                   BAUD1CONbits.ABDEN              // bit 0
#define WUE                     BAUD1CONbits.WUE                // bit 1
#define BRG16                   BAUD1CONbits.BRG16              // bit 3
#define SCKP                    BAUD1CONbits.SCKP               // bit 4
#define RCIDL                   BAUD1CONbits.RCIDL              // bit 6
#define ABDOVF                  BAUD1CONbits.ABDOVF             // bit 7

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define CCDS0                   CCDCONbits.CCDS0                // bit 0
#define CCDS1                   CCDCONbits.CCDS1                // bit 1
#define CCDEN                   CCDCONbits.CCDEN                // bit 7

#define CCDNA0                  CCDNAbits.CCDNA0                // bit 0
#define CCDNA1                  CCDNAbits.CCDNA1                // bit 1
#define CCDNA2                  CCDNAbits.CCDNA2                // bit 2
#define CCDNA4                  CCDNAbits.CCDNA4                // bit 4
#define CCDNA5                  CCDNAbits.CCDNA5                // bit 5

#define CCDNB4                  CCDNBbits.CCDNB4                // bit 4
#define CCDNB5                  CCDNBbits.CCDNB5                // bit 5
#define CCDNB6                  CCDNBbits.CCDNB6                // bit 6
#define CCDNB7                  CCDNBbits.CCDNB7                // bit 7

#define CCDNC0                  CCDNCbits.CCDNC0                // bit 0
#define CCDNC1                  CCDNCbits.CCDNC1                // bit 1
#define CCDNC2                  CCDNCbits.CCDNC2                // bit 2
#define CCDNC3                  CCDNCbits.CCDNC3                // bit 3
#define CCDNC4                  CCDNCbits.CCDNC4                // bit 4
#define CCDNC5                  CCDNCbits.CCDNC5                // bit 5
#define CCDNC6                  CCDNCbits.CCDNC6                // bit 6
#define CCDNC7                  CCDNCbits.CCDNC7                // bit 7

#define CCDPA0                  CCDPAbits.CCDPA0                // bit 0
#define CCDPA1                  CCDPAbits.CCDPA1                // bit 1
#define CCDPA2                  CCDPAbits.CCDPA2                // bit 2
#define CCDPA4                  CCDPAbits.CCDPA4                // bit 4
#define CCDPA5                  CCDPAbits.CCDPA5                // bit 5

#define CCDPB4                  CCDPBbits.CCDPB4                // bit 4
#define CCDPB5                  CCDPBbits.CCDPB5                // bit 5
#define CCDPB6                  CCDPBbits.CCDPB6                // bit 6
#define CCDPB7                  CCDPBbits.CCDPB7                // bit 7

#define CCDPC0                  CCDPCbits.CCDPC0                // bit 0
#define CCDPC1                  CCDPCbits.CCDPC1                // bit 1
#define CCDPC2                  CCDPCbits.CCDPC2                // bit 2
#define CCDPC3                  CCDPCbits.CCDPC3                // bit 3
#define CCDPC4                  CCDPCbits.CCDPC4                // bit 4
#define CCDPC5                  CCDPCbits.CCDPC5                // bit 5
#define CCDPC6                  CCDPCbits.CCDPC6                // bit 6
#define CCDPC7                  CCDPCbits.CCDPC7                // bit 7

#define CCP1CTS0                CCP1CAPbits.CCP1CTS0            // bit 0
#define CCP1CTS1                CCP1CAPbits.CCP1CTS1            // bit 1
#define CCP1CTS2                CCP1CAPbits.CCP1CTS2            // bit 2
#define CCP1CTS3                CCP1CAPbits.CCP1CTS3            // bit 3

#define CCP1MODE0               CCP1CONbits.CCP1MODE0           // bit 0
#define CCP1MODE1               CCP1CONbits.CCP1MODE1           // bit 1
#define CCP1MODE2               CCP1CONbits.CCP1MODE2           // bit 2
#define CCP1MODE3               CCP1CONbits.CCP1MODE3           // bit 3
#define CCP1FMT                 CCP1CONbits.CCP1FMT             // bit 4
#define CCP1OUT                 CCP1CONbits.CCP1OUT             // bit 5
#define CCP1EN                  CCP1CONbits.CCP1EN              // bit 7

#define CCP1PPS0                CCP1PPSbits.CCP1PPS0            // bit 0
#define CCP1PPS1                CCP1PPSbits.CCP1PPS1            // bit 1
#define CCP1PPS2                CCP1PPSbits.CCP1PPS2            // bit 2
#define CCP1PPS3                CCP1PPSbits.CCP1PPS3            // bit 3
#define CCP1PPS4                CCP1PPSbits.CCP1PPS4            // bit 4

#define CCP2CTS0                CCP2CAPbits.CCP2CTS0            // bit 0
#define CCP2CTS1                CCP2CAPbits.CCP2CTS1            // bit 1
#define CCP2CTS2                CCP2CAPbits.CCP2CTS2            // bit 2
#define CCP2CTS3                CCP2CAPbits.CCP2CTS3            // bit 3

#define CCP2MODE0               CCP2CONbits.CCP2MODE0           // bit 0
#define CCP2MODE1               CCP2CONbits.CCP2MODE1           // bit 1
#define CCP2MODE2               CCP2CONbits.CCP2MODE2           // bit 2
#define CCP2MODE3               CCP2CONbits.CCP2MODE3           // bit 3
#define CCP2FMT                 CCP2CONbits.CCP2FMT             // bit 4
#define CCP2OUT                 CCP2CONbits.CCP2OUT             // bit 5
#define CCP2EN                  CCP2CONbits.CCP2EN              // bit 7

#define CCP2PPS0                CCP2PPSbits.CCP2PPS0            // bit 0
#define CCP2PPS1                CCP2PPSbits.CCP2PPS1            // bit 1
#define CCP2PPS2                CCP2PPSbits.CCP2PPS2            // bit 2
#define CCP2PPS3                CCP2PPSbits.CCP2PPS3            // bit 3
#define CCP2PPS4                CCP2PPSbits.CCP2PPS4            // bit 4

#define CCP3CTS0                CCP3CAPbits.CCP3CTS0            // bit 0
#define CCP3CTS1                CCP3CAPbits.CCP3CTS1            // bit 1
#define CCP3CTS2                CCP3CAPbits.CCP3CTS2            // bit 2
#define CCP3CTS3                CCP3CAPbits.CCP3CTS3            // bit 3

#define CCP3MODE0               CCP3CONbits.CCP3MODE0           // bit 0
#define CCP3MODE1               CCP3CONbits.CCP3MODE1           // bit 1
#define CCP3MODE2               CCP3CONbits.CCP3MODE2           // bit 2
#define CCP3MODE3               CCP3CONbits.CCP3MODE3           // bit 3
#define CCP3FMT                 CCP3CONbits.CCP3FMT             // bit 4
#define CCP3OUT                 CCP3CONbits.CCP3OUT             // bit 5
#define CCP3EN                  CCP3CONbits.CCP3EN              // bit 7

#define CCP3PPS0                CCP3PPSbits.CCP3PPS0            // bit 0
#define CCP3PPS1                CCP3PPSbits.CCP3PPS1            // bit 1
#define CCP3PPS2                CCP3PPSbits.CCP3PPS2            // bit 2
#define CCP3PPS3                CCP3PPSbits.CCP3PPS3            // bit 3
#define CCP3PPS4                CCP3PPSbits.CCP3PPS4            // bit 4

#define CCP4CTS0                CCP4CAPbits.CCP4CTS0            // bit 0
#define CCP4CTS1                CCP4CAPbits.CCP4CTS1            // bit 1
#define CCP4CTS2                CCP4CAPbits.CCP4CTS2            // bit 2
#define CCP4CTS3                CCP4CAPbits.CCP4CTS3            // bit 3

#define CCP4MODE0               CCP4CONbits.CCP4MODE0           // bit 0
#define CCP4MODE1               CCP4CONbits.CCP4MODE1           // bit 1
#define CCP4MODE2               CCP4CONbits.CCP4MODE2           // bit 2
#define CCP4MODE3               CCP4CONbits.CCP4MODE3           // bit 3
#define CCP4FMT                 CCP4CONbits.CCP4FMT             // bit 4
#define CCP4OUT                 CCP4CONbits.CCP4OUT             // bit 5
#define CCP4EN                  CCP4CONbits.CCP4EN              // bit 7

#define CCP4PPS0                CCP4PPSbits.CCP4PPS0            // bit 0
#define CCP4PPS1                CCP4PPSbits.CCP4PPS1            // bit 1
#define CCP4PPS2                CCP4PPSbits.CCP4PPS2            // bit 2
#define CCP4PPS3                CCP4PPSbits.CCP4PPS3            // bit 3
#define CCP4PPS4                CCP4PPSbits.CCP4PPS4            // bit 4

#define C1TSEL0                 CCPTMRSbits.C1TSEL0             // bit 0
#define C1TSEL1                 CCPTMRSbits.C1TSEL1             // bit 1
#define C2TSEL0                 CCPTMRSbits.C2TSEL0             // bit 2
#define C2TSEL1                 CCPTMRSbits.C2TSEL1             // bit 3
#define C3TSEL0                 CCPTMRSbits.C3TSEL0             // bit 4
#define C3TSEL1                 CCPTMRSbits.C3TSEL1             // bit 5
#define C4TSEL0                 CCPTMRSbits.C4TSEL0             // bit 6
#define C4TSEL1                 CCPTMRSbits.C4TSEL1             // bit 7

#define LC1MODE0                CLC1CONbits.LC1MODE0            // bit 0, shadows bit in CLC1CONbits
#define MODE0                   CLC1CONbits.MODE0               // bit 0, shadows bit in CLC1CONbits
#define LC1MODE1                CLC1CONbits.LC1MODE1            // bit 1, shadows bit in CLC1CONbits
#define MODE1                   CLC1CONbits.MODE1               // bit 1, shadows bit in CLC1CONbits
#define LC1MODE2                CLC1CONbits.LC1MODE2            // bit 2, shadows bit in CLC1CONbits
#define MODE2                   CLC1CONbits.MODE2               // bit 2, shadows bit in CLC1CONbits
#define LC1INTN                 CLC1CONbits.LC1INTN             // bit 3, shadows bit in CLC1CONbits
#define INTN                    CLC1CONbits.INTN                // bit 3, shadows bit in CLC1CONbits
#define LC1INTP                 CLC1CONbits.LC1INTP             // bit 4, shadows bit in CLC1CONbits
#define INTP                    CLC1CONbits.INTP                // bit 4, shadows bit in CLC1CONbits
#define LC1OUT                  CLC1CONbits.LC1OUT              // bit 5, shadows bit in CLC1CONbits
#define OUT                     CLC1CONbits.OUT                 // bit 5, shadows bit in CLC1CONbits
#define LC1EN                   CLC1CONbits.LC1EN               // bit 7, shadows bit in CLC1CONbits
#define EN                      CLC1CONbits.EN                  // bit 7, shadows bit in CLC1CONbits

#define LC1G1D1N                CLC1GLS0bits.LC1G1D1N           // bit 0, shadows bit in CLC1GLS0bits
#define D1N                     CLC1GLS0bits.D1N                // bit 0, shadows bit in CLC1GLS0bits
#define LC1G1D1T                CLC1GLS0bits.LC1G1D1T           // bit 1, shadows bit in CLC1GLS0bits
#define D1T                     CLC1GLS0bits.D1T                // bit 1, shadows bit in CLC1GLS0bits
#define LC1G1D2N                CLC1GLS0bits.LC1G1D2N           // bit 2, shadows bit in CLC1GLS0bits
#define D2N                     CLC1GLS0bits.D2N                // bit 2, shadows bit in CLC1GLS0bits
#define LC1G1D2T                CLC1GLS0bits.LC1G1D2T           // bit 3, shadows bit in CLC1GLS0bits
#define D2T                     CLC1GLS0bits.D2T                // bit 3, shadows bit in CLC1GLS0bits
#define LC1G1D3N                CLC1GLS0bits.LC1G1D3N           // bit 4, shadows bit in CLC1GLS0bits
#define D3N                     CLC1GLS0bits.D3N                // bit 4, shadows bit in CLC1GLS0bits
#define LC1G1D3T                CLC1GLS0bits.LC1G1D3T           // bit 5, shadows bit in CLC1GLS0bits
#define D3T                     CLC1GLS0bits.D3T                // bit 5, shadows bit in CLC1GLS0bits
#define LC1G1D4N                CLC1GLS0bits.LC1G1D4N           // bit 6, shadows bit in CLC1GLS0bits
#define D4N                     CLC1GLS0bits.D4N                // bit 6, shadows bit in CLC1GLS0bits
#define LC1G1D4T                CLC1GLS0bits.LC1G1D4T           // bit 7, shadows bit in CLC1GLS0bits
#define D4T                     CLC1GLS0bits.D4T                // bit 7, shadows bit in CLC1GLS0bits

#define LC1G4D1N                CLC1GLS3bits.LC1G4D1N           // bit 0, shadows bit in CLC1GLS3bits
#define G4D1N                   CLC1GLS3bits.G4D1N              // bit 0, shadows bit in CLC1GLS3bits
#define LC1G4D1T                CLC1GLS3bits.LC1G4D1T           // bit 1, shadows bit in CLC1GLS3bits
#define G4D1T                   CLC1GLS3bits.G4D1T              // bit 1, shadows bit in CLC1GLS3bits
#define LC1G4D2N                CLC1GLS3bits.LC1G4D2N           // bit 2, shadows bit in CLC1GLS3bits
#define G4D2N                   CLC1GLS3bits.G4D2N              // bit 2, shadows bit in CLC1GLS3bits
#define LC1G4D2T                CLC1GLS3bits.LC1G4D2T           // bit 3, shadows bit in CLC1GLS3bits
#define G4D2T                   CLC1GLS3bits.G4D2T              // bit 3, shadows bit in CLC1GLS3bits
#define LC1G4D3N                CLC1GLS3bits.LC1G4D3N           // bit 4, shadows bit in CLC1GLS3bits
#define G4D3N                   CLC1GLS3bits.G4D3N              // bit 4, shadows bit in CLC1GLS3bits
#define LC1G4D3T                CLC1GLS3bits.LC1G4D3T           // bit 5, shadows bit in CLC1GLS3bits
#define G4D3T                   CLC1GLS3bits.G4D3T              // bit 5, shadows bit in CLC1GLS3bits
#define LC1G4D4N                CLC1GLS3bits.LC1G4D4N           // bit 6, shadows bit in CLC1GLS3bits
#define G4D4N                   CLC1GLS3bits.G4D4N              // bit 6, shadows bit in CLC1GLS3bits
#define LC1G4D4T                CLC1GLS3bits.LC1G4D4T           // bit 7, shadows bit in CLC1GLS3bits
#define G4D4T                   CLC1GLS3bits.G4D4T              // bit 7, shadows bit in CLC1GLS3bits

#define LC1G1POL                CLC1POLbits.LC1G1POL            // bit 0, shadows bit in CLC1POLbits
#define G1POL                   CLC1POLbits.G1POL               // bit 0, shadows bit in CLC1POLbits
#define LC1G2POL                CLC1POLbits.LC1G2POL            // bit 1, shadows bit in CLC1POLbits
#define G2POL                   CLC1POLbits.G2POL               // bit 1, shadows bit in CLC1POLbits
#define LC1G3POL                CLC1POLbits.LC1G3POL            // bit 2, shadows bit in CLC1POLbits
#define G3POL                   CLC1POLbits.G3POL               // bit 2, shadows bit in CLC1POLbits
#define LC1G4POL                CLC1POLbits.LC1G4POL            // bit 3, shadows bit in CLC1POLbits
#define G4POL                   CLC1POLbits.G4POL               // bit 3, shadows bit in CLC1POLbits
#define LC1POL                  CLC1POLbits.LC1POL              // bit 7, shadows bit in CLC1POLbits
#define POL                     CLC1POLbits.POL                 // bit 7, shadows bit in CLC1POLbits

#define LC1D1S0                 CLC1SEL0bits.LC1D1S0            // bit 0, shadows bit in CLC1SEL0bits
#define D1S0                    CLC1SEL0bits.D1S0               // bit 0, shadows bit in CLC1SEL0bits
#define LC1D1S1                 CLC1SEL0bits.LC1D1S1            // bit 1, shadows bit in CLC1SEL0bits
#define D1S1                    CLC1SEL0bits.D1S1               // bit 1, shadows bit in CLC1SEL0bits
#define LC1D1S2                 CLC1SEL0bits.LC1D1S2            // bit 2, shadows bit in CLC1SEL0bits
#define D1S2                    CLC1SEL0bits.D1S2               // bit 2, shadows bit in CLC1SEL0bits
#define LC1D1S3                 CLC1SEL0bits.LC1D1S3            // bit 3, shadows bit in CLC1SEL0bits
#define D1S3                    CLC1SEL0bits.D1S3               // bit 3, shadows bit in CLC1SEL0bits
#define LC1D1S4                 CLC1SEL0bits.LC1D1S4            // bit 4, shadows bit in CLC1SEL0bits
#define D1S4                    CLC1SEL0bits.D1S4               // bit 4, shadows bit in CLC1SEL0bits
#define LC1D1S5                 CLC1SEL0bits.LC1D1S5            // bit 5, shadows bit in CLC1SEL0bits
#define D1S5                    CLC1SEL0bits.D1S5               // bit 5, shadows bit in CLC1SEL0bits

#define LC1D2S0                 CLC1SEL1bits.LC1D2S0            // bit 0, shadows bit in CLC1SEL1bits
#define D2S0                    CLC1SEL1bits.D2S0               // bit 0, shadows bit in CLC1SEL1bits
#define LC1D2S1                 CLC1SEL1bits.LC1D2S1            // bit 1, shadows bit in CLC1SEL1bits
#define D2S1                    CLC1SEL1bits.D2S1               // bit 1, shadows bit in CLC1SEL1bits
#define LC1D2S2                 CLC1SEL1bits.LC1D2S2            // bit 2, shadows bit in CLC1SEL1bits
#define D2S2                    CLC1SEL1bits.D2S2               // bit 2, shadows bit in CLC1SEL1bits
#define LC1D2S3                 CLC1SEL1bits.LC1D2S3            // bit 3, shadows bit in CLC1SEL1bits
#define D2S3                    CLC1SEL1bits.D2S3               // bit 3, shadows bit in CLC1SEL1bits
#define LC1D2S4                 CLC1SEL1bits.LC1D2S4            // bit 4, shadows bit in CLC1SEL1bits
#define D2S4                    CLC1SEL1bits.D2S4               // bit 4, shadows bit in CLC1SEL1bits
#define LC1D2S5                 CLC1SEL1bits.LC1D2S5            // bit 5, shadows bit in CLC1SEL1bits
#define D2S5                    CLC1SEL1bits.D2S5               // bit 5, shadows bit in CLC1SEL1bits

#define LC1D3S0                 CLC1SEL2bits.LC1D3S0            // bit 0, shadows bit in CLC1SEL2bits
#define D3S0                    CLC1SEL2bits.D3S0               // bit 0, shadows bit in CLC1SEL2bits
#define LC1D3S1                 CLC1SEL2bits.LC1D3S1            // bit 1, shadows bit in CLC1SEL2bits
#define D3S1                    CLC1SEL2bits.D3S1               // bit 1, shadows bit in CLC1SEL2bits
#define LC1D3S2                 CLC1SEL2bits.LC1D3S2            // bit 2, shadows bit in CLC1SEL2bits
#define D3S2                    CLC1SEL2bits.D3S2               // bit 2, shadows bit in CLC1SEL2bits
#define LC1D3S3                 CLC1SEL2bits.LC1D3S3            // bit 3, shadows bit in CLC1SEL2bits
#define D3S3                    CLC1SEL2bits.D3S3               // bit 3, shadows bit in CLC1SEL2bits
#define LC1D3S4                 CLC1SEL2bits.LC1D3S4            // bit 4, shadows bit in CLC1SEL2bits
#define D3S4                    CLC1SEL2bits.D3S4               // bit 4, shadows bit in CLC1SEL2bits
#define LC1D3S5                 CLC1SEL2bits.LC1D3S5            // bit 5, shadows bit in CLC1SEL2bits
#define D3S5                    CLC1SEL2bits.D3S5               // bit 5, shadows bit in CLC1SEL2bits

#define LC1D4S0                 CLC1SEL3bits.LC1D4S0            // bit 0, shadows bit in CLC1SEL3bits
#define D4S0                    CLC1SEL3bits.D4S0               // bit 0, shadows bit in CLC1SEL3bits
#define LC1D4S1                 CLC1SEL3bits.LC1D4S1            // bit 1, shadows bit in CLC1SEL3bits
#define D4S1                    CLC1SEL3bits.D4S1               // bit 1, shadows bit in CLC1SEL3bits
#define LC1D4S2                 CLC1SEL3bits.LC1D4S2            // bit 2, shadows bit in CLC1SEL3bits
#define D4S2                    CLC1SEL3bits.D4S2               // bit 2, shadows bit in CLC1SEL3bits
#define LC1D4S3                 CLC1SEL3bits.LC1D4S3            // bit 3, shadows bit in CLC1SEL3bits
#define D4S3                    CLC1SEL3bits.D4S3               // bit 3, shadows bit in CLC1SEL3bits
#define LC1D4S4                 CLC1SEL3bits.LC1D4S4            // bit 4, shadows bit in CLC1SEL3bits
#define D4S4                    CLC1SEL3bits.D4S4               // bit 4, shadows bit in CLC1SEL3bits
#define LC1D4S5                 CLC1SEL3bits.LC1D4S5            // bit 5, shadows bit in CLC1SEL3bits
#define D4S5                    CLC1SEL3bits.D4S5               // bit 5, shadows bit in CLC1SEL3bits

#define MLC1OUT                 CLCDATAbits.MLC1OUT             // bit 0
#define MLC2OUT                 CLCDATAbits.MLC2OUT             // bit 1
#define MLC3OUT                 CLCDATAbits.MLC3OUT             // bit 2
#define MLC4OUT                 CLCDATAbits.MLC4OUT             // bit 3

#define CLCIN0PPS0              CLCIN0PPSbits.CLCIN0PPS0        // bit 0
#define CLCIN0PPS1              CLCIN0PPSbits.CLCIN0PPS1        // bit 1
#define CLCIN0PPS2              CLCIN0PPSbits.CLCIN0PPS2        // bit 2
#define CLCIN0PPS3              CLCIN0PPSbits.CLCIN0PPS3        // bit 3
#define CLCIN0PPS4              CLCIN0PPSbits.CLCIN0PPS4        // bit 4

#define CLCIN1PPS0              CLCIN1PPSbits.CLCIN1PPS0        // bit 0
#define CLCIN1PPS1              CLCIN1PPSbits.CLCIN1PPS1        // bit 1
#define CLCIN1PPS2              CLCIN1PPSbits.CLCIN1PPS2        // bit 2
#define CLCIN1PPS3              CLCIN1PPSbits.CLCIN1PPS3        // bit 3
#define CLCIN1PPS4              CLCIN1PPSbits.CLCIN1PPS4        // bit 4

#define CLCIN2PPS0              CLCIN2PPSbits.CLCIN2PPS0        // bit 0
#define CLCIN2PPS1              CLCIN2PPSbits.CLCIN2PPS1        // bit 1
#define CLCIN2PPS2              CLCIN2PPSbits.CLCIN2PPS2        // bit 2
#define CLCIN2PPS3              CLCIN2PPSbits.CLCIN2PPS3        // bit 3
#define CLCIN2PPS4              CLCIN2PPSbits.CLCIN2PPS4        // bit 4

#define CLCIN3PPS0              CLCIN3PPSbits.CLCIN3PPS0        // bit 0
#define CLCIN3PPS1              CLCIN3PPSbits.CLCIN3PPS1        // bit 1
#define CLCIN3PPS2              CLCIN3PPSbits.CLCIN3PPS2        // bit 2
#define CLCIN3PPS3              CLCIN3PPSbits.CLCIN3PPS3        // bit 3
#define CLCIN3PPS4              CLCIN3PPSbits.CLCIN3PPS4        // bit 4

#define CLKRDIV0                CLKRCONbits.CLKRDIV0            // bit 0
#define CLKRDIV1                CLKRCONbits.CLKRDIV1            // bit 1
#define CLKRDIV2                CLKRCONbits.CLKRDIV2            // bit 2
#define CLKRDC0                 CLKRCONbits.CLKRDC0             // bit 3
#define CLKRDC1                 CLKRCONbits.CLKRDC1             // bit 4
#define CLKREN                  CLKRCONbits.CLKREN              // bit 7

#define C1SYNC                  CM1CON0bits.C1SYNC              // bit 0
#define C1HYS                   CM1CON0bits.C1HYS               // bit 1
#define C1SP                    CM1CON0bits.C1SP                // bit 2
#define C1POL                   CM1CON0bits.C1POL               // bit 4
#define C1OUT                   CM1CON0bits.C1OUT               // bit 6
#define C1ON                    CM1CON0bits.C1ON                // bit 7

#define C1NCH0                  CM1CON1bits.C1NCH0              // bit 0
#define C1NCH1                  CM1CON1bits.C1NCH1              // bit 1
#define C1NCH2                  CM1CON1bits.C1NCH2              // bit 2
#define C1PCH0                  CM1CON1bits.C1PCH0              // bit 3
#define C1PCH1                  CM1CON1bits.C1PCH1              // bit 4
#define C1PCH2                  CM1CON1bits.C1PCH2              // bit 5
#define C1INTN                  CM1CON1bits.C1INTN              // bit 6
#define C1INTP                  CM1CON1bits.C1INTP              // bit 7

#define C2SYNC                  CM2CON0bits.C2SYNC              // bit 0
#define C2HYS                   CM2CON0bits.C2HYS               // bit 1
#define C2SP                    CM2CON0bits.C2SP                // bit 2
#define C2POL                   CM2CON0bits.C2POL               // bit 4
#define C2OUT                   CM2CON0bits.C2OUT               // bit 6
#define C2ON                    CM2CON0bits.C2ON                // bit 7

#define C2NCH0                  CM2CON1bits.C2NCH0              // bit 0
#define C2NCH1                  CM2CON1bits.C2NCH1              // bit 1
#define C2NCH2                  CM2CON1bits.C2NCH2              // bit 2
#define C2PCH0                  CM2CON1bits.C2PCH0              // bit 3
#define C2PCH1                  CM2CON1bits.C2PCH1              // bit 4
#define C2PCH2                  CM2CON1bits.C2PCH2              // bit 5
#define C2INTN                  CM2CON1bits.C2INTN              // bit 6
#define C2INTP                  CM2CON1bits.C2INTP              // bit 7

#define MC1OUT                  CMOUTbits.MC1OUT                // bit 0
#define MC2OUT                  CMOUTbits.MC2OUT                // bit 1

#define DOZE0                   CPUDOZEbits.DOZE0               // bit 0
#define DOZE1                   CPUDOZEbits.DOZE1               // bit 1
#define DOZE2                   CPUDOZEbits.DOZE2               // bit 2
#define DOE                     CPUDOZEbits.DOE                 // bit 4
#define ROI                     CPUDOZEbits.ROI                 // bit 5
#define DOZEN                   CPUDOZEbits.DOZEN               // bit 6
#define IDLEN                   CPUDOZEbits.IDLEN               // bit 7

#define LSAC0                   CWG1AS0bits.LSAC0               // bit 2, shadows bit in CWG1AS0bits
#define CWG1LSAC0               CWG1AS0bits.CWG1LSAC0           // bit 2, shadows bit in CWG1AS0bits
#define LSAC1                   CWG1AS0bits.LSAC1               // bit 3, shadows bit in CWG1AS0bits
#define CWG1LSAC1               CWG1AS0bits.CWG1LSAC1           // bit 3, shadows bit in CWG1AS0bits
#define LSBD0                   CWG1AS0bits.LSBD0               // bit 4, shadows bit in CWG1AS0bits
#define CWG1LSBD0               CWG1AS0bits.CWG1LSBD0           // bit 4, shadows bit in CWG1AS0bits
#define LSBD1                   CWG1AS0bits.LSBD1               // bit 5, shadows bit in CWG1AS0bits
#define CWG1LSBD1               CWG1AS0bits.CWG1LSBD1           // bit 5, shadows bit in CWG1AS0bits
#define REN                     CWG1AS0bits.REN                 // bit 6, shadows bit in CWG1AS0bits
#define CWG1REN                 CWG1AS0bits.CWG1REN             // bit 6, shadows bit in CWG1AS0bits
#define SHUTDOWN                CWG1AS0bits.SHUTDOWN            // bit 7, shadows bit in CWG1AS0bits
#define CWG1SHUTDOWN            CWG1AS0bits.CWG1SHUTDOWN        // bit 7, shadows bit in CWG1AS0bits

#define AS0E                    CWG1AS1bits.AS0E                // bit 0
#define AS1E                    CWG1AS1bits.AS1E                // bit 1
#define AS2E                    CWG1AS1bits.AS2E                // bit 2
#define AS3E                    CWG1AS1bits.AS3E                // bit 3
#define AS4E                    CWG1AS1bits.AS4E                // bit 4

#define CS                      CWG1CLKCONbits.CS               // bit 0, shadows bit in CWG1CLKCONbits
#define CWG1CS                  CWG1CLKCONbits.CWG1CS           // bit 0, shadows bit in CWG1CLKCONbits

#define POLA                    CWG1CON1bits.POLA               // bit 0, shadows bit in CWG1CON1bits
#define CWG1POLA                CWG1CON1bits.CWG1POLA           // bit 0, shadows bit in CWG1CON1bits
#define POLB                    CWG1CON1bits.POLB               // bit 1, shadows bit in CWG1CON1bits
#define CWG1POLB                CWG1CON1bits.CWG1POLB           // bit 1, shadows bit in CWG1CON1bits
#define POLC                    CWG1CON1bits.POLC               // bit 2, shadows bit in CWG1CON1bits
#define CWG1POLC                CWG1CON1bits.CWG1POLC           // bit 2, shadows bit in CWG1CON1bits
#define POLD                    CWG1CON1bits.POLD               // bit 3, shadows bit in CWG1CON1bits
#define CWG1POLD                CWG1CON1bits.CWG1POLD           // bit 3, shadows bit in CWG1CON1bits
#define IN                      CWG1CON1bits.IN                 // bit 5, shadows bit in CWG1CON1bits
#define CWG1IN                  CWG1CON1bits.CWG1IN             // bit 5, shadows bit in CWG1CON1bits

#define CWG1DAT0                CWG1DATbits.CWG1DAT0            // bit 0
#define CWG1DAT1                CWG1DATbits.CWG1DAT1            // bit 1
#define CWG1DAT2                CWG1DATbits.CWG1DAT2            // bit 2
#define CWG1DAT3                CWG1DATbits.CWG1DAT3            // bit 3

#define DBF0                    CWG1DBFbits.DBF0                // bit 0, shadows bit in CWG1DBFbits
#define CWG1DBF0                CWG1DBFbits.CWG1DBF0            // bit 0, shadows bit in CWG1DBFbits
#define DBF1                    CWG1DBFbits.DBF1                // bit 1, shadows bit in CWG1DBFbits
#define CWG1DBF1                CWG1DBFbits.CWG1DBF1            // bit 1, shadows bit in CWG1DBFbits
#define DBF2                    CWG1DBFbits.DBF2                // bit 2, shadows bit in CWG1DBFbits
#define CWG1DBF2                CWG1DBFbits.CWG1DBF2            // bit 2, shadows bit in CWG1DBFbits
#define DBF3                    CWG1DBFbits.DBF3                // bit 3, shadows bit in CWG1DBFbits
#define CWG1DBF3                CWG1DBFbits.CWG1DBF3            // bit 3, shadows bit in CWG1DBFbits
#define DBF4                    CWG1DBFbits.DBF4                // bit 4, shadows bit in CWG1DBFbits
#define CWG1DBF4                CWG1DBFbits.CWG1DBF4            // bit 4, shadows bit in CWG1DBFbits
#define DBF5                    CWG1DBFbits.DBF5                // bit 5, shadows bit in CWG1DBFbits
#define CWG1DBF5                CWG1DBFbits.CWG1DBF5            // bit 5, shadows bit in CWG1DBFbits

#define DBR0                    CWG1DBRbits.DBR0                // bit 0, shadows bit in CWG1DBRbits
#define CWG1DBR0                CWG1DBRbits.CWG1DBR0            // bit 0, shadows bit in CWG1DBRbits
#define DBR1                    CWG1DBRbits.DBR1                // bit 1, shadows bit in CWG1DBRbits
#define CWG1DBR1                CWG1DBRbits.CWG1DBR1            // bit 1, shadows bit in CWG1DBRbits
#define DBR2                    CWG1DBRbits.DBR2                // bit 2, shadows bit in CWG1DBRbits
#define CWG1DBR2                CWG1DBRbits.CWG1DBR2            // bit 2, shadows bit in CWG1DBRbits
#define DBR3                    CWG1DBRbits.DBR3                // bit 3, shadows bit in CWG1DBRbits
#define CWG1DBR3                CWG1DBRbits.CWG1DBR3            // bit 3, shadows bit in CWG1DBRbits
#define DBR4                    CWG1DBRbits.DBR4                // bit 4, shadows bit in CWG1DBRbits
#define CWG1DBR4                CWG1DBRbits.CWG1DBR4            // bit 4, shadows bit in CWG1DBRbits
#define DBR5                    CWG1DBRbits.DBR5                // bit 5, shadows bit in CWG1DBRbits
#define CWG1DBR5                CWG1DBRbits.CWG1DBR5            // bit 5, shadows bit in CWG1DBRbits

#define CWG1PPS0                CWG1PPSbits.CWG1PPS0            // bit 0
#define CWG1PPS1                CWG1PPSbits.CWG1PPS1            // bit 1
#define CWG1PPS2                CWG1PPSbits.CWG1PPS2            // bit 2
#define CWG1PPS3                CWG1PPSbits.CWG1PPS3            // bit 3
#define CWG1PPS4                CWG1PPSbits.CWG1PPS4            // bit 4

#define STRA                    CWG1STRbits.STRA                // bit 0, shadows bit in CWG1STRbits
#define CWG1STRA                CWG1STRbits.CWG1STRA            // bit 0, shadows bit in CWG1STRbits
#define STRB                    CWG1STRbits.STRB                // bit 1, shadows bit in CWG1STRbits
#define CWG1STRB                CWG1STRbits.CWG1STRB            // bit 1, shadows bit in CWG1STRbits
#define STRC                    CWG1STRbits.STRC                // bit 2, shadows bit in CWG1STRbits
#define CWG1STRC                CWG1STRbits.CWG1STRC            // bit 2, shadows bit in CWG1STRbits
#define STRD                    CWG1STRbits.STRD                // bit 3, shadows bit in CWG1STRbits
#define CWG1STRD                CWG1STRbits.CWG1STRD            // bit 3, shadows bit in CWG1STRbits
#define OVRA                    CWG1STRbits.OVRA                // bit 4, shadows bit in CWG1STRbits
#define CWG1OVRA                CWG1STRbits.CWG1OVRA            // bit 4, shadows bit in CWG1STRbits
#define OVRB                    CWG1STRbits.OVRB                // bit 5, shadows bit in CWG1STRbits
#define CWG1OVRB                CWG1STRbits.CWG1OVRB            // bit 5, shadows bit in CWG1STRbits
#define OVRC                    CWG1STRbits.OVRC                // bit 6, shadows bit in CWG1STRbits
#define CWG1OVRC                CWG1STRbits.CWG1OVRC            // bit 6, shadows bit in CWG1STRbits
#define OVRD                    CWG1STRbits.OVRD                // bit 7, shadows bit in CWG1STRbits
#define CWG1OVRD                CWG1STRbits.CWG1OVRD            // bit 7, shadows bit in CWG1STRbits

#define CWG2DAT0                CWG2DATbits.CWG2DAT0            // bit 0
#define CWG2DAT1                CWG2DATbits.CWG2DAT1            // bit 1
#define CWG2DAT2                CWG2DATbits.CWG2DAT2            // bit 2
#define CWG2DAT3                CWG2DATbits.CWG2DAT3            // bit 3

#define CWG2PPS0                CWG2PPSbits.CWG2PPS0            // bit 0
#define CWG2PPS1                CWG2PPSbits.CWG2PPS1            // bit 1
#define CWG2PPS2                CWG2PPSbits.CWG2PPS2            // bit 2
#define CWG2PPS3                CWG2PPSbits.CWG2PPS3            // bit 3
#define CWG2PPS4                CWG2PPSbits.CWG2PPS4            // bit 4

#define DAC1NSS                 DACCON0bits.DAC1NSS             // bit 0
#define DAC1PSS0                DACCON0bits.DAC1PSS0            // bit 2
#define DAC1PSS1                DACCON0bits.DAC1PSS1            // bit 3
#define DAC1OE                  DACCON0bits.DAC1OE              // bit 5
#define DAC1EN                  DACCON0bits.DAC1EN              // bit 7

#define DAC1R0                  DACCON1bits.DAC1R0              // bit 0
#define DAC1R1                  DACCON1bits.DAC1R1              // bit 1
#define DAC1R2                  DACCON1bits.DAC1R2              // bit 2
#define DAC1R3                  DACCON1bits.DAC1R3              // bit 3
#define DAC1R4                  DACCON1bits.DAC1R4              // bit 4

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define CDAFVR0                 FVRCONbits.CDAFVR0              // bit 2
#define CDAFVR1                 FVRCONbits.CDAFVR1              // bit 3
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define INLVLA0                 INLVLAbits.INLVLA0              // bit 0
#define INLVLA1                 INLVLAbits.INLVLA1              // bit 1
#define INLVLA2                 INLVLAbits.INLVLA2              // bit 2
#define INLVLA3                 INLVLAbits.INLVLA3              // bit 3
#define INLVLA4                 INLVLAbits.INLVLA4              // bit 4
#define INLVLA5                 INLVLAbits.INLVLA5              // bit 5

#define INLVLB4                 INLVLBbits.INLVLB4              // bit 4
#define INLVLB5                 INLVLBbits.INLVLB5              // bit 5
#define INLVLB6                 INLVLBbits.INLVLB6              // bit 6
#define INLVLB7                 INLVLBbits.INLVLB7              // bit 7

#define INLVLC0                 INLVLCbits.INLVLC0              // bit 0
#define INLVLC1                 INLVLCbits.INLVLC1              // bit 1
#define INLVLC2                 INLVLCbits.INLVLC2              // bit 2
#define INLVLC3                 INLVLCbits.INLVLC3              // bit 3
#define INLVLC4                 INLVLCbits.INLVLC4              // bit 4
#define INLVLC5                 INLVLCbits.INLVLC5              // bit 5
#define INLVLC6                 INLVLCbits.INLVLC6              // bit 6
#define INLVLC7                 INLVLCbits.INLVLC7              // bit 7

#define INTEDG                  INTCONbits.INTEDG               // bit 0
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define INTPPS0                 INTPPSbits.INTPPS0              // bit 0
#define INTPPS1                 INTPPSbits.INTPPS1              // bit 1
#define INTPPS2                 INTPPSbits.INTPPS2              // bit 2
#define INTPPS3                 INTPPSbits.INTPPS3              // bit 3
#define INTPPS4                 INTPPSbits.INTPPS4              // bit 4

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF2                  IOCAFbits.IOCAF2                // bit 2
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3
#define IOCAF4                  IOCAFbits.IOCAF4                // bit 4
#define IOCAF5                  IOCAFbits.IOCAF5                // bit 5

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN2                  IOCANbits.IOCAN2                // bit 2
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3
#define IOCAN4                  IOCANbits.IOCAN4                // bit 4
#define IOCAN5                  IOCANbits.IOCAN5                // bit 5

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP2                  IOCAPbits.IOCAP2                // bit 2
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3
#define IOCAP4                  IOCAPbits.IOCAP4                // bit 4
#define IOCAP5                  IOCAPbits.IOCAP5                // bit 5

#define IOCBF4                  IOCBFbits.IOCBF4                // bit 4
#define IOCBF5                  IOCBFbits.IOCBF5                // bit 5
#define IOCBF6                  IOCBFbits.IOCBF6                // bit 6
#define IOCBF7                  IOCBFbits.IOCBF7                // bit 7

#define IOCBN4                  IOCBNbits.IOCBN4                // bit 4
#define IOCBN5                  IOCBNbits.IOCBN5                // bit 5
#define IOCBN6                  IOCBNbits.IOCBN6                // bit 6
#define IOCBN7                  IOCBNbits.IOCBN7                // bit 7

#define IOCBP4                  IOCBPbits.IOCBP4                // bit 4
#define IOCBP5                  IOCBPbits.IOCBP5                // bit 5
#define IOCBP6                  IOCBPbits.IOCBP6                // bit 6
#define IOCBP7                  IOCBPbits.IOCBP7                // bit 7

#define IOCCF0                  IOCCFbits.IOCCF0                // bit 0
#define IOCCF1                  IOCCFbits.IOCCF1                // bit 1
#define IOCCF2                  IOCCFbits.IOCCF2                // bit 2
#define IOCCF3                  IOCCFbits.IOCCF3                // bit 3
#define IOCCF4                  IOCCFbits.IOCCF4                // bit 4
#define IOCCF5                  IOCCFbits.IOCCF5                // bit 5
#define IOCCF6                  IOCCFbits.IOCCF6                // bit 6
#define IOCCF7                  IOCCFbits.IOCCF7                // bit 7

#define IOCCN0                  IOCCNbits.IOCCN0                // bit 0
#define IOCCN1                  IOCCNbits.IOCCN1                // bit 1
#define IOCCN2                  IOCCNbits.IOCCN2                // bit 2
#define IOCCN3                  IOCCNbits.IOCCN3                // bit 3
#define IOCCN4                  IOCCNbits.IOCCN4                // bit 4
#define IOCCN5                  IOCCNbits.IOCCN5                // bit 5
#define IOCCN6                  IOCCNbits.IOCCN6                // bit 6
#define IOCCN7                  IOCCNbits.IOCCN7                // bit 7

#define IOCCP0                  IOCCPbits.IOCCP0                // bit 0
#define IOCCP1                  IOCCPbits.IOCCP1                // bit 1
#define IOCCP2                  IOCCPbits.IOCCP2                // bit 2
#define IOCCP3                  IOCCPbits.IOCCP3                // bit 3
#define IOCCP4                  IOCCPbits.IOCCP4                // bit 4
#define IOCCP5                  IOCCPbits.IOCCP5                // bit 5
#define IOCCP6                  IOCCPbits.IOCCP6                // bit 6
#define IOCCP7                  IOCCPbits.IOCCP7                // bit 7

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5

#define LATB4                   LATBbits.LATB4                  // bit 4
#define LATB5                   LATBbits.LATB5                  // bit 5
#define LATB6                   LATBbits.LATB6                  // bit 6
#define LATB7                   LATBbits.LATB7                  // bit 7

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5
#define LATC6                   LATCbits.LATC6                  // bit 6
#define LATC7                   LATCbits.LATC7                  // bit 7

#define MDCH0                   MDCARHbits.MDCH0                // bit 0
#define MDCH1                   MDCARHbits.MDCH1                // bit 1
#define MDCH2                   MDCARHbits.MDCH2                // bit 2
#define MDCH3                   MDCARHbits.MDCH3                // bit 3
#define MDCHSYNC                MDCARHbits.MDCHSYNC             // bit 5
#define MDCHPOL                 MDCARHbits.MDCHPOL              // bit 6

#define MDCL0                   MDCARLbits.MDCL0                // bit 0
#define MDCL1                   MDCARLbits.MDCL1                // bit 1
#define MDCL2                   MDCARLbits.MDCL2                // bit 2
#define MDCL3                   MDCARLbits.MDCL3                // bit 3
#define MDCLSYNC                MDCARLbits.MDCLSYNC             // bit 5
#define MDCLPOL                 MDCARLbits.MDCLPOL              // bit 6

#define MDCIN1PPS0              MDCIN1PPSbits.MDCIN1PPS0        // bit 0
#define MDCIN1PPS1              MDCIN1PPSbits.MDCIN1PPS1        // bit 1
#define MDCIN1PPS2              MDCIN1PPSbits.MDCIN1PPS2        // bit 2
#define MDCIN1PPS3              MDCIN1PPSbits.MDCIN1PPS3        // bit 3
#define MDCIN1PPS4              MDCIN1PPSbits.MDCIN1PPS4        // bit 4

#define MDCIN2PPS0              MDCIN2PPSbits.MDCIN2PPS0        // bit 0
#define MDCIN2PPS1              MDCIN2PPSbits.MDCIN2PPS1        // bit 1
#define MDCIN2PPS2              MDCIN2PPSbits.MDCIN2PPS2        // bit 2
#define MDCIN2PPS3              MDCIN2PPSbits.MDCIN2PPS3        // bit 3
#define MDCIN2PPS4              MDCIN2PPSbits.MDCIN2PPS4        // bit 4

#define MDBIT                   MDCONbits.MDBIT                 // bit 0
#define MDOUT                   MDCONbits.MDOUT                 // bit 3
#define MDOPOL                  MDCONbits.MDOPOL                // bit 4
#define MDEN                    MDCONbits.MDEN                  // bit 7

#define MDMINPPS0               MDMINPPSbits.MDMINPPS0          // bit 0
#define MDMINPPS1               MDMINPPSbits.MDMINPPS1          // bit 1
#define MDMINPPS2               MDMINPPSbits.MDMINPPS2          // bit 2
#define MDMINPPS3               MDMINPPSbits.MDMINPPS3          // bit 3
#define MDMINPPS4               MDMINPPSbits.MDMINPPS4          // bit 4

#define MDMS0                   MDSRCbits.MDMS0                 // bit 0
#define MDMS1                   MDSRCbits.MDMS1                 // bit 1
#define MDMS2                   MDSRCbits.MDMS2                 // bit 2
#define MDMS3                   MDSRCbits.MDMS3                 // bit 3

#define N1PFM                   NCO1CONbits.N1PFM               // bit 0
#define N1POL                   NCO1CONbits.N1POL               // bit 4
#define N1OUT                   NCO1CONbits.N1OUT               // bit 5
#define N1EN                    NCO1CONbits.N1EN                // bit 7

#define NVMADR8                 NVMADRHbits.NVMADR8             // bit 0
#define NVMADR9                 NVMADRHbits.NVMADR9             // bit 1
#define NVMADR10                NVMADRHbits.NVMADR10            // bit 2
#define NVMADR11                NVMADRHbits.NVMADR11            // bit 3
#define NVMADR12                NVMADRHbits.NVMADR12            // bit 4
#define NVMADR13                NVMADRHbits.NVMADR13            // bit 5
#define NVMADR14                NVMADRHbits.NVMADR14            // bit 6

#define NVMADR0                 NVMADRLbits.NVMADR0             // bit 0
#define NVMADR1                 NVMADRLbits.NVMADR1             // bit 1
#define NVMADR2                 NVMADRLbits.NVMADR2             // bit 2
#define NVMADR3                 NVMADRLbits.NVMADR3             // bit 3
#define NVMADR4                 NVMADRLbits.NVMADR4             // bit 4
#define NVMADR5                 NVMADRLbits.NVMADR5             // bit 5
#define NVMADR6                 NVMADRLbits.NVMADR6             // bit 6
#define NVMADR7                 NVMADRLbits.NVMADR7             // bit 7

#define RD                      NVMCON1bits.RD                  // bit 0
#define WR                      NVMCON1bits.WR                  // bit 1
#define WREN                    NVMCON1bits.WREN                // bit 2
#define WRERR                   NVMCON1bits.WRERR               // bit 3
#define FREE                    NVMCON1bits.FREE                // bit 4
#define LWLO                    NVMCON1bits.LWLO                // bit 5
#define NVMREGS                 NVMCON1bits.NVMREGS             // bit 6

#define NVMDAT8                 NVMDATHbits.NVMDAT8             // bit 0
#define NVMDAT9                 NVMDATHbits.NVMDAT9             // bit 1
#define NVMDAT10                NVMDATHbits.NVMDAT10            // bit 2
#define NVMDAT11                NVMDATHbits.NVMDAT11            // bit 3
#define NVMDAT12                NVMDATHbits.NVMDAT12            // bit 4
#define NVMDAT13                NVMDATHbits.NVMDAT13            // bit 5

#define NVMDAT0                 NVMDATLbits.NVMDAT0             // bit 0
#define NVMDAT1                 NVMDATLbits.NVMDAT1             // bit 1
#define NVMDAT2                 NVMDATLbits.NVMDAT2             // bit 2
#define NVMDAT3                 NVMDATLbits.NVMDAT3             // bit 3
#define NVMDAT4                 NVMDATLbits.NVMDAT4             // bit 4
#define NVMDAT5                 NVMDATLbits.NVMDAT5             // bit 5
#define NVMDAT6                 NVMDATLbits.NVMDAT6             // bit 6
#define NVMDAT7                 NVMDATLbits.NVMDAT7             // bit 7

#define ODCA0                   ODCONAbits.ODCA0                // bit 0
#define ODCA1                   ODCONAbits.ODCA1                // bit 1
#define ODCA2                   ODCONAbits.ODCA2                // bit 2
#define ODCA4                   ODCONAbits.ODCA4                // bit 4
#define ODCA5                   ODCONAbits.ODCA5                // bit 5

#define ODCB4                   ODCONBbits.ODCB4                // bit 4
#define ODCB5                   ODCONBbits.ODCB5                // bit 5
#define ODCB6                   ODCONBbits.ODCB6                // bit 6
#define ODCB7                   ODCONBbits.ODCB7                // bit 7

#define ODCC0                   ODCONCbits.ODCC0                // bit 0
#define ODCC1                   ODCONCbits.ODCC1                // bit 1
#define ODCC2                   ODCONCbits.ODCC2                // bit 2
#define ODCC3                   ODCONCbits.ODCC3                // bit 3
#define ODCC4                   ODCONCbits.ODCC4                // bit 4
#define ODCC5                   ODCONCbits.ODCC5                // bit 5
#define ODCC6                   ODCONCbits.ODCC6                // bit 6
#define ODCC7                   ODCONCbits.ODCC7                // bit 7

#define NDIV0                   OSCCON1bits.NDIV0               // bit 0
#define NDIV1                   OSCCON1bits.NDIV1               // bit 1
#define NDIV2                   OSCCON1bits.NDIV2               // bit 2
#define NDIV3                   OSCCON1bits.NDIV3               // bit 3
#define NOSC0                   OSCCON1bits.NOSC0               // bit 4
#define NOSC1                   OSCCON1bits.NOSC1               // bit 5
#define NOSC2                   OSCCON1bits.NOSC2               // bit 6

#define CDIV0                   OSCCON2bits.CDIV0               // bit 0
#define CDIV1                   OSCCON2bits.CDIV1               // bit 1
#define CDIV2                   OSCCON2bits.CDIV2               // bit 2
#define CDIV3                   OSCCON2bits.CDIV3               // bit 3
#define COSC0                   OSCCON2bits.COSC0               // bit 4
#define COSC1                   OSCCON2bits.COSC1               // bit 5
#define COSC2                   OSCCON2bits.COSC2               // bit 6

#define NOSCR                   OSCCON3bits.NOSCR               // bit 3
#define ORDY                    OSCCON3bits.ORDY                // bit 4
#define SOSCBE                  OSCCON3bits.SOSCBE              // bit 5
#define SOSCPWR                 OSCCON3bits.SOSCPWR             // bit 6
#define CSWHOLD                 OSCCON3bits.CSWHOLD             // bit 7

#define ADOEN                   OSCENbits.ADOEN                 // bit 2
#define SOSCEN                  OSCENbits.SOSCEN                // bit 3
#define LFOEN                   OSCENbits.LFOEN                 // bit 4
#define HFOEN                   OSCENbits.HFOEN                 // bit 6
#define EXTOEN                  OSCENbits.EXTOEN                // bit 7

#define HFFRQ0                  OSCFRQbits.HFFRQ0               // bit 0
#define HFFRQ1                  OSCFRQbits.HFFRQ1               // bit 1
#define HFFRQ2                  OSCFRQbits.HFFRQ2               // bit 2
#define HFFRQ3                  OSCFRQbits.HFFRQ3               // bit 3

#define PLLR                    OSCSTAT1bits.PLLR               // bit 0
#define ADOR                    OSCSTAT1bits.ADOR               // bit 2
#define SOR                     OSCSTAT1bits.SOR                // bit 3
#define LFOR                    OSCSTAT1bits.LFOR               // bit 4
#define HFOR                    OSCSTAT1bits.HFOR               // bit 6
#define EXTOR                   OSCSTAT1bits.EXTOR              // bit 7

#define HFTUN0                  OSCTUNEbits.HFTUN0              // bit 0
#define HFTUN1                  OSCTUNEbits.HFTUN1              // bit 1
#define HFTUN2                  OSCTUNEbits.HFTUN2              // bit 2
#define HFTUN3                  OSCTUNEbits.HFTUN3              // bit 3
#define HFTUN4                  OSCTUNEbits.HFTUN4              // bit 4
#define HFTUN5                  OSCTUNEbits.HFTUN5              // bit 5

#define NOT_BOR                 PCON0bits.NOT_BOR               // bit 0
#define NOT_POR                 PCON0bits.NOT_POR               // bit 1
#define NOT_RI                  PCON0bits.NOT_RI                // bit 2
#define NOT_RMCLR               PCON0bits.NOT_RMCLR             // bit 3
#define NOT_RWDT                PCON0bits.NOT_RWDT              // bit 4
#define STKUNF                  PCON0bits.STKUNF                // bit 6
#define STKOVF                  PCON0bits.STKOVF                // bit 7

#define INTE                    PIE0bits.INTE                   // bit 0
#define IOCIE                   PIE0bits.IOCIE                  // bit 4
#define TMR0IE                  PIE0bits.TMR0IE                 // bit 5

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define BCL1IE                  PIE1bits.BCL1IE                 // bit 2
#define SSP1IE                  PIE1bits.SSP1IE                 // bit 3
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define NCO1IE                  PIE2bits.NCO1IE                 // bit 0
#define TMR4IE                  PIE2bits.TMR4IE                 // bit 1
#define BCL2IE                  PIE2bits.BCL2IE                 // bit 2
#define SSP2IE                  PIE2bits.SSP2IE                 // bit 3
#define NVMIE                   PIE2bits.NVMIE                  // bit 4
#define C1IE                    PIE2bits.C1IE                   // bit 5
#define C2IE                    PIE2bits.C2IE                   // bit 6
#define TMR6IE                  PIE2bits.TMR6IE                 // bit 7

#define CLC1IE                  PIE3bits.CLC1IE                 // bit 0
#define CLC2IE                  PIE3bits.CLC2IE                 // bit 1
#define CLC3IE                  PIE3bits.CLC3IE                 // bit 2
#define CLC4IE                  PIE3bits.CLC4IE                 // bit 3
#define TMR3IE                  PIE3bits.TMR3IE                 // bit 4
#define TMR3GIE                 PIE3bits.TMR3GIE                // bit 5
#define CSWIE                   PIE3bits.CSWIE                  // bit 6
#define OSFIE                   PIE3bits.OSFIE                  // bit 7

#define CCP1IE                  PIE4bits.CCP1IE                 // bit 0
#define CCP2IE                  PIE4bits.CCP2IE                 // bit 1
#define CCP3IE                  PIE4bits.CCP3IE                 // bit 2
#define CCP4IE                  PIE4bits.CCP4IE                 // bit 3
#define TMR5IE                  PIE4bits.TMR5IE                 // bit 4
#define TMR5GIE                 PIE4bits.TMR5GIE                // bit 5
#define CWG1IE                  PIE4bits.CWG1IE                 // bit 6
#define CWG2IE                  PIE4bits.CWG2IE                 // bit 7

#define INTF                    PIR0bits.INTF                   // bit 0
#define IOCIF                   PIR0bits.IOCIF                  // bit 4
#define TMR0IF                  PIR0bits.TMR0IF                 // bit 5

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define BCL1IF                  PIR1bits.BCL1IF                 // bit 2
#define SSP1IF                  PIR1bits.SSP1IF                 // bit 3
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define NCO1IF                  PIR2bits.NCO1IF                 // bit 0
#define TMR4IF                  PIR2bits.TMR4IF                 // bit 1
#define BCL2IF                  PIR2bits.BCL2IF                 // bit 2
#define SSP2IF                  PIR2bits.SSP2IF                 // bit 3
#define NVMIF                   PIR2bits.NVMIF                  // bit 4
#define C1IF                    PIR2bits.C1IF                   // bit 5
#define C2IF                    PIR2bits.C2IF                   // bit 6
#define TMR6IF                  PIR2bits.TMR6IF                 // bit 7

#define CLC1IF                  PIR3bits.CLC1IF                 // bit 0
#define CLC2IF                  PIR3bits.CLC2IF                 // bit 1
#define CLC3IF                  PIR3bits.CLC3IF                 // bit 2
#define CLC4IF                  PIR3bits.CLC4IF                 // bit 3
#define TMR3IF                  PIR3bits.TMR3IF                 // bit 4
#define TMR3GIF                 PIR3bits.TMR3GIF                // bit 5
#define CSWIF                   PIR3bits.CSWIF                  // bit 6
#define OSFIF                   PIR3bits.OSFIF                  // bit 7

#define CCP1IF                  PIR4bits.CCP1IF                 // bit 0
#define CCP2IF                  PIR4bits.CCP2IF                 // bit 1
#define CCP3IF                  PIR4bits.CCP3IF                 // bit 2
#define CCP4IF                  PIR4bits.CCP4IF                 // bit 3
#define TMR5IF                  PIR4bits.TMR5IF                 // bit 4
#define TMR5GIF                 PIR4bits.TMR5GIF                // bit 5
#define CWG1IF                  PIR4bits.CWG1IF                 // bit 6
#define CWG2IF                  PIR4bits.CWG2IF                 // bit 7

#define IOCMD                   PMD0bits.IOCMD                  // bit 0
#define CLKRMD                  PMD0bits.CLKRMD                 // bit 1
#define NVMMD                   PMD0bits.NVMMD                  // bit 2
#define FVRMD                   PMD0bits.FVRMD                  // bit 6
#define SYSCMD                  PMD0bits.SYSCMD                 // bit 7

#define TMR0MD                  PMD1bits.TMR0MD                 // bit 0
#define TMR1MD                  PMD1bits.TMR1MD                 // bit 1
#define TMR2MD                  PMD1bits.TMR2MD                 // bit 2
#define TMR3MD                  PMD1bits.TMR3MD                 // bit 3
#define TMR4MD                  PMD1bits.TMR4MD                 // bit 4
#define TMR5MD                  PMD1bits.TMR5MD                 // bit 5
#define TMR6MD                  PMD1bits.TMR6MD                 // bit 6
#define NCOMD                   PMD1bits.NCOMD                  // bit 7

#define CMP1MD                  PMD2bits.CMP1MD                 // bit 1
#define CMP2MD                  PMD2bits.CMP2MD                 // bit 2
#define ADCMD                   PMD2bits.ADCMD                  // bit 5
#define DACMD                   PMD2bits.DACMD                  // bit 6

#define CCP1MD                  PMD3bits.CCP1MD                 // bit 0
#define CCP2MD                  PMD3bits.CCP2MD                 // bit 1
#define CCP3MD                  PMD3bits.CCP3MD                 // bit 2
#define CCP4MD                  PMD3bits.CCP4MD                 // bit 3
#define PWM5MD                  PMD3bits.PWM5MD                 // bit 4
#define PWM6MD                  PMD3bits.PWM6MD                 // bit 5
#define CWG1MD                  PMD3bits.CWG1MD                 // bit 6
#define CWG2MD                  PMD3bits.CWG2MD                 // bit 7

#define MSSP1MD                 PMD4bits.MSSP1MD                // bit 1
#define MSSP2MD                 PMD4bits.MSSP2MD                // bit 2
#define UART1MD                 PMD4bits.UART1MD                // bit 5

#define DSMMD                   PMD5bits.DSMMD                  // bit 0
#define CLC1MD                  PMD5bits.CLC1MD                 // bit 1
#define CLC2MD                  PMD5bits.CLC2MD                 // bit 2
#define CLC3MD                  PMD5bits.CLC3MD                 // bit 3
#define CLC4MD                  PMD5bits.CLC4MD                 // bit 4

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define PPSLOCKED               PPSLOCKbits.PPSLOCKED           // bit 0

#define PWM5POL                 PWM5CONbits.PWM5POL             // bit 4
#define PWM5OUT                 PWM5CONbits.PWM5OUT             // bit 5
#define PWM5EN                  PWM5CONbits.PWM5EN              // bit 7

#define PWM5DCH0                PWM5DCHbits.PWM5DCH0            // bit 0
#define PWM5DCH1                PWM5DCHbits.PWM5DCH1            // bit 1
#define PWM5DCH2                PWM5DCHbits.PWM5DCH2            // bit 2
#define PWM5DCH3                PWM5DCHbits.PWM5DCH3            // bit 3
#define PWM5DCH4                PWM5DCHbits.PWM5DCH4            // bit 4
#define PWM5DCH5                PWM5DCHbits.PWM5DCH5            // bit 5
#define PWM5DCH6                PWM5DCHbits.PWM5DCH6            // bit 6
#define PWM5DCH7                PWM5DCHbits.PWM5DCH7            // bit 7

#define PWM5DCL0                PWM5DCLbits.PWM5DCL0            // bit 6
#define PWM5DCL1                PWM5DCLbits.PWM5DCL1            // bit 7

#define PWM6POL                 PWM6CONbits.PWM6POL             // bit 4
#define PWM6OUT                 PWM6CONbits.PWM6OUT             // bit 5
#define PWM6EN                  PWM6CONbits.PWM6EN              // bit 7

#define PWM6DCH0                PWM6DCHbits.PWM6DCH0            // bit 0
#define PWM6DCH1                PWM6DCHbits.PWM6DCH1            // bit 1
#define PWM6DCH2                PWM6DCHbits.PWM6DCH2            // bit 2
#define PWM6DCH3                PWM6DCHbits.PWM6DCH3            // bit 3
#define PWM6DCH4                PWM6DCHbits.PWM6DCH4            // bit 4
#define PWM6DCH5                PWM6DCHbits.PWM6DCH5            // bit 5
#define PWM6DCH6                PWM6DCHbits.PWM6DCH6            // bit 6
#define PWM6DCH7                PWM6DCHbits.PWM6DCH7            // bit 7

#define PWM6DCL0                PWM6DCLbits.PWM6DCL0            // bit 6
#define PWM6DCL1                PWM6DCLbits.PWM6DCL1            // bit 7

#define P5TSEL0                 PWMTMRSbits.P5TSEL0             // bit 0
#define P5TSEL1                 PWMTMRSbits.P5TSEL1             // bit 1
#define P6TSEL0                 PWMTMRSbits.P6TSEL0             // bit 2
#define P6TSEL1                 PWMTMRSbits.P6TSEL1             // bit 3

#define RA0PPS0                 RA0PPSbits.RA0PPS0              // bit 0
#define RA0PPS1                 RA0PPSbits.RA0PPS1              // bit 1
#define RA0PPS2                 RA0PPSbits.RA0PPS2              // bit 2
#define RA0PPS3                 RA0PPSbits.RA0PPS3              // bit 3
#define RA0PPS4                 RA0PPSbits.RA0PPS4              // bit 4

#define RA1PPS0                 RA1PPSbits.RA1PPS0              // bit 0
#define RA1PPS1                 RA1PPSbits.RA1PPS1              // bit 1
#define RA1PPS2                 RA1PPSbits.RA1PPS2              // bit 2
#define RA1PPS3                 RA1PPSbits.RA1PPS3              // bit 3
#define RA1PPS4                 RA1PPSbits.RA1PPS4              // bit 4

#define RA2PPS0                 RA2PPSbits.RA2PPS0              // bit 0
#define RA2PPS1                 RA2PPSbits.RA2PPS1              // bit 1
#define RA2PPS2                 RA2PPSbits.RA2PPS2              // bit 2
#define RA2PPS3                 RA2PPSbits.RA2PPS3              // bit 3
#define RA2PPS4                 RA2PPSbits.RA2PPS4              // bit 4

#define RA4PPS0                 RA4PPSbits.RA4PPS0              // bit 0
#define RA4PPS1                 RA4PPSbits.RA4PPS1              // bit 1
#define RA4PPS2                 RA4PPSbits.RA4PPS2              // bit 2
#define RA4PPS3                 RA4PPSbits.RA4PPS3              // bit 3
#define RA4PPS4                 RA4PPSbits.RA4PPS4              // bit 4

#define RA5PPS0                 RA5PPSbits.RA5PPS0              // bit 0
#define RA5PPS1                 RA5PPSbits.RA5PPS1              // bit 1
#define RA5PPS2                 RA5PPSbits.RA5PPS2              // bit 2
#define RA5PPS3                 RA5PPSbits.RA5PPS3              // bit 3
#define RA5PPS4                 RA5PPSbits.RA5PPS4              // bit 4

#define RB4PPS0                 RB4PPSbits.RB4PPS0              // bit 0
#define RB4PPS1                 RB4PPSbits.RB4PPS1              // bit 1
#define RB4PPS2                 RB4PPSbits.RB4PPS2              // bit 2
#define RB4PPS3                 RB4PPSbits.RB4PPS3              // bit 3
#define RB4PPS4                 RB4PPSbits.RB4PPS4              // bit 4

#define RB5PPS0                 RB5PPSbits.RB5PPS0              // bit 0
#define RB5PPS1                 RB5PPSbits.RB5PPS1              // bit 1
#define RB5PPS2                 RB5PPSbits.RB5PPS2              // bit 2
#define RB5PPS3                 RB5PPSbits.RB5PPS3              // bit 3
#define RB5PPS4                 RB5PPSbits.RB5PPS4              // bit 4

#define RB6PPS0                 RB6PPSbits.RB6PPS0              // bit 0
#define RB6PPS1                 RB6PPSbits.RB6PPS1              // bit 1
#define RB6PPS2                 RB6PPSbits.RB6PPS2              // bit 2
#define RB6PPS3                 RB6PPSbits.RB6PPS3              // bit 3
#define RB6PPS4                 RB6PPSbits.RB6PPS4              // bit 4

#define RB7PPS0                 RB7PPSbits.RB7PPS0              // bit 0
#define RB7PPS1                 RB7PPSbits.RB7PPS1              // bit 1
#define RB7PPS2                 RB7PPSbits.RB7PPS2              // bit 2
#define RB7PPS3                 RB7PPSbits.RB7PPS3              // bit 3
#define RB7PPS4                 RB7PPSbits.RB7PPS4              // bit 4

#define RC0PPS0                 RC0PPSbits.RC0PPS0              // bit 0
#define RC0PPS1                 RC0PPSbits.RC0PPS1              // bit 1
#define RC0PPS2                 RC0PPSbits.RC0PPS2              // bit 2
#define RC0PPS3                 RC0PPSbits.RC0PPS3              // bit 3
#define RC0PPS4                 RC0PPSbits.RC0PPS4              // bit 4

#define RC1PPS0                 RC1PPSbits.RC1PPS0              // bit 0
#define RC1PPS1                 RC1PPSbits.RC1PPS1              // bit 1
#define RC1PPS2                 RC1PPSbits.RC1PPS2              // bit 2
#define RC1PPS3                 RC1PPSbits.RC1PPS3              // bit 3
#define RC1PPS4                 RC1PPSbits.RC1PPS4              // bit 4

#define RX9D                    RC1STAbits.RX9D                 // bit 0
#define OERR                    RC1STAbits.OERR                 // bit 1
#define FERR                    RC1STAbits.FERR                 // bit 2
#define ADDEN                   RC1STAbits.ADDEN                // bit 3
#define CREN                    RC1STAbits.CREN                 // bit 4
#define SREN                    RC1STAbits.SREN                 // bit 5
#define RX9                     RC1STAbits.RX9                  // bit 6
#define SPEN                    RC1STAbits.SPEN                 // bit 7

#define RC2PPS0                 RC2PPSbits.RC2PPS0              // bit 0
#define RC2PPS1                 RC2PPSbits.RC2PPS1              // bit 1
#define RC2PPS2                 RC2PPSbits.RC2PPS2              // bit 2
#define RC2PPS3                 RC2PPSbits.RC2PPS3              // bit 3
#define RC2PPS4                 RC2PPSbits.RC2PPS4              // bit 4

#define RC3PPS0                 RC3PPSbits.RC3PPS0              // bit 0
#define RC3PPS1                 RC3PPSbits.RC3PPS1              // bit 1
#define RC3PPS2                 RC3PPSbits.RC3PPS2              // bit 2
#define RC3PPS3                 RC3PPSbits.RC3PPS3              // bit 3
#define RC3PPS4                 RC3PPSbits.RC3PPS4              // bit 4

#define RC4PPS0                 RC4PPSbits.RC4PPS0              // bit 0
#define RC4PPS1                 RC4PPSbits.RC4PPS1              // bit 1
#define RC4PPS2                 RC4PPSbits.RC4PPS2              // bit 2
#define RC4PPS3                 RC4PPSbits.RC4PPS3              // bit 3
#define RC4PPS4                 RC4PPSbits.RC4PPS4              // bit 4

#define RC5PPS0                 RC5PPSbits.RC5PPS0              // bit 0
#define RC5PPS1                 RC5PPSbits.RC5PPS1              // bit 1
#define RC5PPS2                 RC5PPSbits.RC5PPS2              // bit 2
#define RC5PPS3                 RC5PPSbits.RC5PPS3              // bit 3
#define RC5PPS4                 RC5PPSbits.RC5PPS4              // bit 4

#define RC6PPS0                 RC6PPSbits.RC6PPS0              // bit 0
#define RC6PPS1                 RC6PPSbits.RC6PPS1              // bit 1
#define RC6PPS2                 RC6PPSbits.RC6PPS2              // bit 2
#define RC6PPS3                 RC6PPSbits.RC6PPS3              // bit 3
#define RC6PPS4                 RC6PPSbits.RC6PPS4              // bit 4

#define RC7PPS0                 RC7PPSbits.RC7PPS0              // bit 0
#define RC7PPS1                 RC7PPSbits.RC7PPS1              // bit 1
#define RC7PPS2                 RC7PPSbits.RC7PPS2              // bit 2
#define RC7PPS3                 RC7PPSbits.RC7PPS3              // bit 3
#define RC7PPS4                 RC7PPSbits.RC7PPS4              // bit 4

#define RXDTPPS0                RXPPSbits.RXDTPPS0              // bit 0
#define RXDTPPS1                RXPPSbits.RXDTPPS1              // bit 1
#define RXDTPPS2                RXPPSbits.RXDTPPS2              // bit 2
#define RXDTPPS3                RXPPSbits.RXDTPPS3              // bit 3
#define RXDTPPS4                RXPPSbits.RXDTPPS4              // bit 4

#define SLRA0                   SLRCONAbits.SLRA0               // bit 0
#define SLRA1                   SLRCONAbits.SLRA1               // bit 1
#define SLRA2                   SLRCONAbits.SLRA2               // bit 2
#define SLRA4                   SLRCONAbits.SLRA4               // bit 4
#define SLRA5                   SLRCONAbits.SLRA5               // bit 5

#define SLRB4                   SLRCONBbits.SLRB4               // bit 4
#define SLRB5                   SLRCONBbits.SLRB5               // bit 5
#define SLRB6                   SLRCONBbits.SLRB6               // bit 6
#define SLRB7                   SLRCONBbits.SLRB7               // bit 7

#define SLRC0                   SLRCONCbits.SLRC0               // bit 0
#define SLRC1                   SLRCONCbits.SLRC1               // bit 1
#define SLRC2                   SLRCONCbits.SLRC2               // bit 2
#define SLRC3                   SLRCONCbits.SLRC3               // bit 3
#define SLRC4                   SLRCONCbits.SLRC4               // bit 4
#define SLRC5                   SLRCONCbits.SLRC5               // bit 5
#define SLRC6                   SLRCONCbits.SLRC6               // bit 6
#define SLRC7                   SLRCONCbits.SLRC7               // bit 7

#define SSP1ADD0                SSP1ADDbits.SSP1ADD0            // bit 0, shadows bit in SSP1ADDbits
#define ADD0                    SSP1ADDbits.ADD0                // bit 0, shadows bit in SSP1ADDbits
#define SSP1ADD1                SSP1ADDbits.SSP1ADD1            // bit 1, shadows bit in SSP1ADDbits
#define ADD1                    SSP1ADDbits.ADD1                // bit 1, shadows bit in SSP1ADDbits
#define SSP1ADD2                SSP1ADDbits.SSP1ADD2            // bit 2, shadows bit in SSP1ADDbits
#define ADD2                    SSP1ADDbits.ADD2                // bit 2, shadows bit in SSP1ADDbits
#define SSP1ADD3                SSP1ADDbits.SSP1ADD3            // bit 3, shadows bit in SSP1ADDbits
#define ADD3                    SSP1ADDbits.ADD3                // bit 3, shadows bit in SSP1ADDbits
#define SSP1ADD4                SSP1ADDbits.SSP1ADD4            // bit 4, shadows bit in SSP1ADDbits
#define ADD4                    SSP1ADDbits.ADD4                // bit 4, shadows bit in SSP1ADDbits
#define SSP1ADD5                SSP1ADDbits.SSP1ADD5            // bit 5, shadows bit in SSP1ADDbits
#define ADD5                    SSP1ADDbits.ADD5                // bit 5, shadows bit in SSP1ADDbits
#define SSP1ADD6                SSP1ADDbits.SSP1ADD6            // bit 6, shadows bit in SSP1ADDbits
#define ADD6                    SSP1ADDbits.ADD6                // bit 6, shadows bit in SSP1ADDbits
#define SSP1ADD7                SSP1ADDbits.SSP1ADD7            // bit 7, shadows bit in SSP1ADDbits
#define ADD7                    SSP1ADDbits.ADD7                // bit 7, shadows bit in SSP1ADDbits

#define SSP1BUF0                SSP1BUFbits.SSP1BUF0            // bit 0, shadows bit in SSP1BUFbits
#define BUF0                    SSP1BUFbits.BUF0                // bit 0, shadows bit in SSP1BUFbits
#define SSP1BUF1                SSP1BUFbits.SSP1BUF1            // bit 1, shadows bit in SSP1BUFbits
#define BUF1                    SSP1BUFbits.BUF1                // bit 1, shadows bit in SSP1BUFbits
#define SSP1BUF2                SSP1BUFbits.SSP1BUF2            // bit 2, shadows bit in SSP1BUFbits
#define BUF2                    SSP1BUFbits.BUF2                // bit 2, shadows bit in SSP1BUFbits
#define SSP1BUF3                SSP1BUFbits.SSP1BUF3            // bit 3, shadows bit in SSP1BUFbits
#define BUF3                    SSP1BUFbits.BUF3                // bit 3, shadows bit in SSP1BUFbits
#define SSP1BUF4                SSP1BUFbits.SSP1BUF4            // bit 4, shadows bit in SSP1BUFbits
#define BUF4                    SSP1BUFbits.BUF4                // bit 4, shadows bit in SSP1BUFbits
#define SSP1BUF5                SSP1BUFbits.SSP1BUF5            // bit 5, shadows bit in SSP1BUFbits
#define BUF5                    SSP1BUFbits.BUF5                // bit 5, shadows bit in SSP1BUFbits
#define SSP1BUF6                SSP1BUFbits.SSP1BUF6            // bit 6, shadows bit in SSP1BUFbits
#define BUF6                    SSP1BUFbits.BUF6                // bit 6, shadows bit in SSP1BUFbits
#define SSP1BUF7                SSP1BUFbits.SSP1BUF7            // bit 7, shadows bit in SSP1BUFbits
#define BUF7                    SSP1BUFbits.BUF7                // bit 7, shadows bit in SSP1BUFbits

#define SSP1CLKPPS0             SSP1CLKPPSbits.SSP1CLKPPS0      // bit 0
#define SSP1CLKPPS1             SSP1CLKPPSbits.SSP1CLKPPS1      // bit 1
#define SSP1CLKPPS2             SSP1CLKPPSbits.SSP1CLKPPS2      // bit 2
#define SSP1CLKPPS3             SSP1CLKPPSbits.SSP1CLKPPS3      // bit 3
#define SSP1CLKPPS4             SSP1CLKPPSbits.SSP1CLKPPS4      // bit 4

#define SSPM0                   SSP1CONbits.SSPM0               // bit 0
#define SSPM1                   SSP1CONbits.SSPM1               // bit 1
#define SSPM2                   SSP1CONbits.SSPM2               // bit 2
#define SSPM3                   SSP1CONbits.SSPM3               // bit 3
#define CKP                     SSP1CONbits.CKP                 // bit 4
#define SSPEN                   SSP1CONbits.SSPEN               // bit 5
#define SSPOV                   SSP1CONbits.SSPOV               // bit 6
#define WCOL                    SSP1CONbits.WCOL                // bit 7

#define SEN                     SSP1CON2bits.SEN                // bit 0
#define RSEN                    SSP1CON2bits.RSEN               // bit 1
#define PEN                     SSP1CON2bits.PEN                // bit 2
#define RCEN                    SSP1CON2bits.RCEN               // bit 3
#define ACKEN                   SSP1CON2bits.ACKEN              // bit 4
#define ACKDT                   SSP1CON2bits.ACKDT              // bit 5
#define ACKSTAT                 SSP1CON2bits.ACKSTAT            // bit 6
#define GCEN                    SSP1CON2bits.GCEN               // bit 7

#define DHEN                    SSP1CON3bits.DHEN               // bit 0
#define AHEN                    SSP1CON3bits.AHEN               // bit 1
#define SBCDE                   SSP1CON3bits.SBCDE              // bit 2
#define SDAHT                   SSP1CON3bits.SDAHT              // bit 3
#define BOEN                    SSP1CON3bits.BOEN               // bit 4
#define SCIE                    SSP1CON3bits.SCIE               // bit 5
#define PCIE                    SSP1CON3bits.PCIE               // bit 6
#define ACKTIM                  SSP1CON3bits.ACKTIM             // bit 7

#define SSP1DATPPS0             SSP1DATPPSbits.SSP1DATPPS0      // bit 0
#define SSP1DATPPS1             SSP1DATPPSbits.SSP1DATPPS1      // bit 1
#define SSP1DATPPS2             SSP1DATPPSbits.SSP1DATPPS2      // bit 2
#define SSP1DATPPS3             SSP1DATPPSbits.SSP1DATPPS3      // bit 3
#define SSP1DATPPS4             SSP1DATPPSbits.SSP1DATPPS4      // bit 4

#define SSP1MSK0                SSP1MSKbits.SSP1MSK0            // bit 0, shadows bit in SSP1MSKbits
#define MSK0                    SSP1MSKbits.MSK0                // bit 0, shadows bit in SSP1MSKbits
#define SSP1MSK1                SSP1MSKbits.SSP1MSK1            // bit 1, shadows bit in SSP1MSKbits
#define MSK1                    SSP1MSKbits.MSK1                // bit 1, shadows bit in SSP1MSKbits
#define SSP1MSK2                SSP1MSKbits.SSP1MSK2            // bit 2, shadows bit in SSP1MSKbits
#define MSK2                    SSP1MSKbits.MSK2                // bit 2, shadows bit in SSP1MSKbits
#define SSP1MSK3                SSP1MSKbits.SSP1MSK3            // bit 3, shadows bit in SSP1MSKbits
#define MSK3                    SSP1MSKbits.MSK3                // bit 3, shadows bit in SSP1MSKbits
#define SSP1MSK4                SSP1MSKbits.SSP1MSK4            // bit 4, shadows bit in SSP1MSKbits
#define MSK4                    SSP1MSKbits.MSK4                // bit 4, shadows bit in SSP1MSKbits
#define SSP1MSK5                SSP1MSKbits.SSP1MSK5            // bit 5, shadows bit in SSP1MSKbits
#define MSK5                    SSP1MSKbits.MSK5                // bit 5, shadows bit in SSP1MSKbits
#define SSP1MSK6                SSP1MSKbits.SSP1MSK6            // bit 6, shadows bit in SSP1MSKbits
#define MSK6                    SSP1MSKbits.MSK6                // bit 6, shadows bit in SSP1MSKbits
#define SSP1MSK7                SSP1MSKbits.SSP1MSK7            // bit 7, shadows bit in SSP1MSKbits
#define MSK7                    SSP1MSKbits.MSK7                // bit 7, shadows bit in SSP1MSKbits

#define SSP1SSPPS0              SSP1SSPPSbits.SSP1SSPPS0        // bit 0
#define SSP1SSPPS1              SSP1SSPPSbits.SSP1SSPPS1        // bit 1
#define SSP1SSPPS2              SSP1SSPPSbits.SSP1SSPPS2        // bit 2
#define SSP1SSPPS3              SSP1SSPPSbits.SSP1SSPPS3        // bit 3
#define SSP1SSPPS4              SSP1SSPPSbits.SSP1SSPPS4        // bit 4

#define BF                      SSP1STATbits.BF                 // bit 0
#define UA                      SSP1STATbits.UA                 // bit 1
#define R_NOT_W                 SSP1STATbits.R_NOT_W            // bit 2
#define S                       SSP1STATbits.S                  // bit 3
#define P                       SSP1STATbits.P                  // bit 4
#define D_NOT_A                 SSP1STATbits.D_NOT_A            // bit 5
#define CKE                     SSP1STATbits.CKE                // bit 6
#define SMP                     SSP1STATbits.SMP                // bit 7

#define SSP2CLKPPS0             SSP2CLKPPSbits.SSP2CLKPPS0      // bit 0
#define SSP2CLKPPS1             SSP2CLKPPSbits.SSP2CLKPPS1      // bit 1
#define SSP2CLKPPS2             SSP2CLKPPSbits.SSP2CLKPPS2      // bit 2
#define SSP2CLKPPS3             SSP2CLKPPSbits.SSP2CLKPPS3      // bit 3
#define SSP2CLKPPS4             SSP2CLKPPSbits.SSP2CLKPPS4      // bit 4

#define SSP2DATPPS0             SSP2DATPPSbits.SSP2DATPPS0      // bit 0
#define SSP2DATPPS1             SSP2DATPPSbits.SSP2DATPPS1      // bit 1
#define SSP2DATPPS2             SSP2DATPPSbits.SSP2DATPPS2      // bit 2
#define SSP2DATPPS3             SSP2DATPPSbits.SSP2DATPPS3      // bit 3
#define SSP2DATPPS4             SSP2DATPPSbits.SSP2DATPPS4      // bit 4

#define SSP2SSPPS0              SSP2SSPPSbits.SSP2SSPPS0        // bit 0
#define SSP2SSPPS1              SSP2SSPPSbits.SSP2SSPPS1        // bit 1
#define SSP2SSPPS2              SSP2SSPPSbits.SSP2SSPPS2        // bit 2
#define SSP2SSPPS3              SSP2SSPPSbits.SSP2SSPPS3        // bit 3
#define SSP2SSPPS4              SSP2SSPPSbits.SSP2SSPPS4        // bit 4

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define T0CKIPPS0               T0CKIPPSbits.T0CKIPPS0          // bit 0
#define T0CKIPPS1               T0CKIPPSbits.T0CKIPPS1          // bit 1
#define T0CKIPPS2               T0CKIPPSbits.T0CKIPPS2          // bit 2
#define T0CKIPPS3               T0CKIPPSbits.T0CKIPPS3          // bit 3
#define T0CKIPPS4               T0CKIPPSbits.T0CKIPPS4          // bit 4

#define T0OUTPS0                T0CON0bits.T0OUTPS0             // bit 0
#define T0OUTPS1                T0CON0bits.T0OUTPS1             // bit 1
#define T0OUTPS2                T0CON0bits.T0OUTPS2             // bit 2
#define T0OUTPS3                T0CON0bits.T0OUTPS3             // bit 3
#define T016BIT                 T0CON0bits.T016BIT              // bit 4
#define T0OUT                   T0CON0bits.T0OUT                // bit 5
#define T0EN                    T0CON0bits.T0EN                 // bit 7

#define T0CKPS0                 T0CON1bits.T0CKPS0              // bit 0
#define T0CKPS1                 T0CON1bits.T0CKPS1              // bit 1
#define T0CKPS2                 T0CON1bits.T0CKPS2              // bit 2
#define T0CKPS3                 T0CON1bits.T0CKPS3              // bit 3
#define T0ASYNC                 T0CON1bits.T0ASYNC              // bit 4
#define T0CS0                   T0CON1bits.T0CS0                // bit 5
#define T0CS1                   T0CON1bits.T0CS1                // bit 6
#define T0CS2                   T0CON1bits.T0CS2                // bit 7

#define T1CKIPPS0               T1CKIPPSbits.T1CKIPPS0          // bit 0
#define T1CKIPPS1               T1CKIPPSbits.T1CKIPPS1          // bit 1
#define T1CKIPPS2               T1CKIPPSbits.T1CKIPPS2          // bit 2
#define T1CKIPPS3               T1CKIPPSbits.T1CKIPPS3          // bit 3
#define T1CKIPPS4               T1CKIPPSbits.T1CKIPPS4          // bit 4

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define T1SYNC                  T1CONbits.T1SYNC                // bit 2
#define T1SOSC                  T1CONbits.T1SOSC                // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define T1GPPS0                 T1GPPSbits.T1GPPS0              // bit 0
#define T1GPPS1                 T1GPPSbits.T1GPPS1              // bit 1
#define T1GPPS2                 T1GPPSbits.T1GPPS2              // bit 2
#define T1GPPS3                 T1GPPSbits.T1GPPS3              // bit 3
#define T1GPPS4                 T1GPPSbits.T1GPPS4              // bit 4

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define T2OUTPS0                T2CONbits.T2OUTPS0              // bit 3
#define T2OUTPS1                T2CONbits.T2OUTPS1              // bit 4
#define T2OUTPS2                T2CONbits.T2OUTPS2              // bit 5
#define T2OUTPS3                T2CONbits.T2OUTPS3              // bit 6

#define TMR3ON                  T3CONbits.TMR3ON                // bit 0
#define T3SYNC                  T3CONbits.T3SYNC                // bit 2
#define T3SOSC                  T3CONbits.T3SOSC                // bit 3
#define T3CKPS0                 T3CONbits.T3CKPS0               // bit 4
#define T3CKPS1                 T3CONbits.T3CKPS1               // bit 5
#define TMR3CS0                 T3CONbits.TMR3CS0               // bit 6
#define TMR3CS1                 T3CONbits.TMR3CS1               // bit 7

#define T3GSS0                  T3GCONbits.T3GSS0               // bit 0
#define T3GSS1                  T3GCONbits.T3GSS1               // bit 1
#define T3GVAL                  T3GCONbits.T3GVAL               // bit 2
#define T3GGO_NOT_DONE          T3GCONbits.T3GGO_NOT_DONE       // bit 3
#define T3GSPM                  T3GCONbits.T3GSPM               // bit 4
#define T3GTM                   T3GCONbits.T3GTM                // bit 5
#define T3GPOL                  T3GCONbits.T3GPOL               // bit 6
#define TMR3GE                  T3GCONbits.TMR3GE               // bit 7

#define T4CKPS0                 T4CONbits.T4CKPS0               // bit 0
#define T4CKPS1                 T4CONbits.T4CKPS1               // bit 1
#define TMR4ON                  T4CONbits.TMR4ON                // bit 2
#define T4OUTPS0                T4CONbits.T4OUTPS0              // bit 3
#define T4OUTPS1                T4CONbits.T4OUTPS1              // bit 4
#define T4OUTPS2                T4CONbits.T4OUTPS2              // bit 5
#define T4OUTPS3                T4CONbits.T4OUTPS3              // bit 6

#define TMR5ON                  T5CONbits.TMR5ON                // bit 0
#define T5SYNC                  T5CONbits.T5SYNC                // bit 2
#define T5SOSC                  T5CONbits.T5SOSC                // bit 3
#define T5CKPS0                 T5CONbits.T5CKPS0               // bit 4
#define T5CKPS1                 T5CONbits.T5CKPS1               // bit 5
#define TMR5CS0                 T5CONbits.TMR5CS0               // bit 6
#define TMR5CS1                 T5CONbits.TMR5CS1               // bit 7

#define T5GSS0                  T5GCONbits.T5GSS0               // bit 0
#define T5GSS1                  T5GCONbits.T5GSS1               // bit 1
#define T5GVAL                  T5GCONbits.T5GVAL               // bit 2
#define T5GGO_NOT_DONE          T5GCONbits.T5GGO_NOT_DONE       // bit 3
#define T5GSPM                  T5GCONbits.T5GSPM               // bit 4
#define T5GTM                   T5GCONbits.T5GTM                // bit 5
#define T5GPOL                  T5GCONbits.T5GPOL               // bit 6
#define TMR5GE                  T5GCONbits.TMR5GE               // bit 7

#define T6CKPS0                 T6CONbits.T6CKPS0               // bit 0
#define T6CKPS1                 T6CONbits.T6CKPS1               // bit 1
#define TMR6ON                  T6CONbits.TMR6ON                // bit 2
#define T6OUTPS0                T6CONbits.T6OUTPS0              // bit 3
#define T6OUTPS1                T6CONbits.T6OUTPS1              // bit 4
#define T6OUTPS2                T6CONbits.T6OUTPS2              // bit 5
#define T6OUTPS3                T6CONbits.T6OUTPS3              // bit 6

#define TMR08                   TMR0Hbits.TMR08                 // bit 0
#define TMR09                   TMR0Hbits.TMR09                 // bit 1
#define TMR010                  TMR0Hbits.TMR010                // bit 2
#define TMR011                  TMR0Hbits.TMR011                // bit 3
#define TMR012                  TMR0Hbits.TMR012                // bit 4
#define TMR013                  TMR0Hbits.TMR013                // bit 5
#define TMR014                  TMR0Hbits.TMR014                // bit 6
#define TMR015                  TMR0Hbits.TMR015                // bit 7

#define TMR00                   TMR0Lbits.TMR00                 // bit 0
#define TMR01                   TMR0Lbits.TMR01                 // bit 1
#define TMR02                   TMR0Lbits.TMR02                 // bit 2
#define TMR03                   TMR0Lbits.TMR03                 // bit 3
#define TMR04                   TMR0Lbits.TMR04                 // bit 4
#define TMR05                   TMR0Lbits.TMR05                 // bit 5
#define TMR06                   TMR0Lbits.TMR06                 // bit 6
#define TMR07                   TMR0Lbits.TMR07                 // bit 7

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TX9D                    TX1STAbits.TX9D                 // bit 0
#define TRMT                    TX1STAbits.TRMT                 // bit 1
#define BRGH                    TX1STAbits.BRGH                 // bit 2
#define SENDB                   TX1STAbits.SENDB                // bit 3
#define SYNC                    TX1STAbits.SYNC                 // bit 4
#define TXEN                    TX1STAbits.TXEN                 // bit 5
#define TX9                     TX1STAbits.TX9                  // bit 6
#define CSRC                    TX1STAbits.CSRC                 // bit 7

#define TXCKPPS0                TXPPSbits.TXCKPPS0              // bit 0
#define TXCKPPS1                TXPPSbits.TXCKPPS1              // bit 1
#define TXCKPPS2                TXPPSbits.TXCKPPS2              // bit 2
#define TXCKPPS3                TXPPSbits.TXCKPPS3              // bit 3
#define TXCKPPS4                TXPPSbits.TXCKPPS4              // bit 4

#define VREGPM                  VREGCONbits.VREGPM              // bit 1

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5

#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#define WPUC0                   WPUCbits.WPUC0                  // bit 0
#define WPUC1                   WPUCbits.WPUC1                  // bit 1
#define WPUC2                   WPUCbits.WPUC2                  // bit 2
#define WPUC3                   WPUCbits.WPUC3                  // bit 3
#define WPUC4                   WPUCbits.WPUC4                  // bit 4
#define WPUC5                   WPUCbits.WPUC5                  // bit 5
#define WPUC6                   WPUCbits.WPUC6                  // bit 6
#define WPUC7                   WPUCbits.WPUC7                  // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16F18345_H__
